

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetDriveControllerlist.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetDriveControllerlist.sp,v $ $Id: MMS2GetDriveControllerlist.sp,v 1.8.300.2 2018/03/20 19:51:22 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetDriveControllerList <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetDriveControllerList')
	drop procedure MMS2GetDriveControllerList
IF EXISTS (select * from GxQscripts where name='MMS2GetDriveControllerList')
	delete from GxQscripts where name = 'MMS2GetDriveControllerList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetDriveControllerList')
	delete from GXDBVersions where aliasname = 'MMS2GetDriveControllerList'
GO
print '... Creating Procedure: MMS2GetDriveControllerList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetDriveControllerList
  @i_hostName nvarchar(2048),
  @i_DriveId Integer,
  @i_reservedLibraryId Integer,
  @i_getAdditionalDCPs integer,
  @i_getOneDCPPerDrive integer,
  @i_reservedParam integer
-- getting list by library is not yet implemented
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_ErrorCode Integer
  DECLARE @o_DCCount Integer
  DECLARE @o_DriveControllerId integer
  DECLARE @o_DCMMHostId Integer
  DECLARE @o_DCClientId Integer
  DECLARE @o_DCHostName char(255)
  DECLARE @o_DCSoftState integer
  DECLARE @o_IsDCActive integer
  DECLARE @o_DCType integer
  DECLARE @o_DCName char(255)
  DECLARE @o_DCSCSIId char(255)
  DECLARE @o_DriveAccessPath char(255)
  DECLARE @o_DCEnabled integer
  DECLARE @o_DrivePoolId integer
  DECLARE @o_DriveId integer
	create table #TMPMMHostId(ClientId	INTEGER)
	declare @l_DCList TABLE (DriveControllerId		INTEGER)
	declare @l_error INTEGER
	declare @SqlQuery	nvarchar(2048)
	declare @l_tmpRowCount	integer
	set @l_tmpRowCount = 0
	set @l_error = 0
	declare @l_DCCount INTEGER
	set  @l_DCCount = 0
	if(@i_getOneDCPPerDrive = 0)
	BEGIN
		if (len(@i_hostname) > 4)
		BEGIN
			set @SqlQuery = ' insert into #TMPMMHostId
								select Id
								from APP_Client as Cl
								where Cl.net_hostname IN ' + @i_hostname
			EXEC(@SqlQuery)
			set @l_tmpRowCount = (select count(*) from #TMPMMHostId)
			if ( @l_tmpRowCount = 0)
			BEGIN
				-- E_MM_MOUNT_RETRIEVE_HOST_INFO  897
				set @l_error = 897
				goto ERROR_EXIT
			END
		END
		IF (@i_driveId > 0)
		BEGIN
			-- handles DriveId given, HostId not given
			-- handles DriveId given, HostId given
			IF (@l_tmpRowCount > 0)
			BEGIN
				INSERT INTO @l_DCList
				SELECT 	DC.DriveControllerId
				FROM MMDriveController as DC
				where DC.ClientId IN(select ClientId from #TMPMMHostId) AND DC.DriveId = @i_driveId
			END
			ELSE
			BEGIN
				-- seperate query because we want to use seperate indices
				INSERT INTO @l_DCList
				SELECT 	DC.DriveControllerId
				FROM MMDriveController as DC
				where DC.DriveId = @i_driveId
			END
		END ELSE IF (@l_tmpRowCount > 0)
		BEGIN
			-- handle case driveId not given, MMHostId is given
			INSERT INTO @l_DCList
			SELECT 	DC.DriveControllerId
			FROM 	MMDriveController as DC
			where 	DC.ClientId IN(select ClientId from #TMPMMHostId)
		END ELSE
		BEGIN
			-- handle case nothing is given - get everything for entire commcell
			INSERT INTO @l_DCList
			SELECT 	DC.DriveControllerId
			FROM MMDriveController as DC
		END
		IF((len(@i_hostname) > 4) AND (@i_getAdditionalDCPs = 1))
		BEGIN
			--When the flag is true then get the additional DCP for each drive in th CommCell
			--Apart from what we already have in the list
			insert into @l_DCList
			select MAX(DriveControllerId)
			from MMDriveController
			where ClientId not in(select ClientId from #TMPMMHostId)
			group by DriveId
		END
	END
	ELSE
	BEGIN
			insert into @l_DCList
			select MAX(DriveControllerId)
			from MMDriveController
			group by DriveId
	END
	SET @l_DCCount = (select count(*) from @l_DCList)
	IF (@l_DCCount = 0)
	BEGIN
		-- #define E_MM_NO_DRIVECONTROLLER  405
		SET @l_Error = 405
		-- should not really be considered an Error though
		goto ERROR_EXIT
	END
	select 	0 AS ErrorCode, @l_DCCount AS DCCount,
		dc.DriveControllerId, dc.ClientId, C.id, C.net_HostName,
		dc.DriveControllerSoftState, dc.DriveControllerActive, 	dc.DriveControllerType, dc.DriveControllerName,
		dc.SCSIId, dc.AccessPath, dc.DriveControllerEnabled,
		dc.DrivePoolId, dc.driveId
	from 	@l_DCList as dclist
			INNER JOIN MMDriveController AS DC ON DC.DriveControllerId = dclist.DriveControllerId
			INNER JOIN APP_Client C ON C.id = DC.ClientId
	drop table #TMPMMHostId
	goto THE_END
ERROR_EXIT:
	select @l_error AS ErrorCode, 0,
		0, 0, 0, '',
		0, 0, 0, '',
		'', '', 0,
		0, 0
THE_END:
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetDriveControllerlist')
	delete from GxQscripts where name = 'MMS2GetDriveControllerlist'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetDriveControllerlist')
	delete from GXDBVersions where aliasname = 'MMS2GetDriveControllerlist'
GO

insert into GXDBVersions values(2, 'MMS2GetDriveControllerlist',  '00010008030000020000', 'MMS2GetDriveControllerlist', '00010008030000020000')
GO

