

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetDevicePathsForMountPath.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetDevicePathsForMountPath.sp,v $ $Id: MMS2GetDevicePathsForMountPath.sp,v 1.7.2.10 2018/10/30 03:55:23 rnannuri Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMS2GetDevicePathsForMountPath')
BEGIN
	print '>>> Drop Stored Procedure: MMS2GetDevicePathsForMountPath <<<'
	drop procedure MMS2GetDevicePathsForMountPath
END
IF EXISTS (select * from GxQscripts where name='MMS2GetDevicePathsForMountPath')
	delete from GxQscripts where name = 'MMS2GetDevicePathsForMountPath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetDevicePathsForMountPath')
	delete from GXDBVersions where aliasname = 'MMS2GetDevicePathsForMountPath'
GO
print '... Creating Procedure: MMS2GetDevicePathsForMountPath'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetDevicePathsForMountPath
-- returns all the mount paths and media agents for a replica library
  @mountPathId integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @deviceControllerId integer
  DECLARE @deviceControllerActive integer
  DECLARE @deviceControllerEnabled integer
  DECLARE @deviceAccessible integer
  DECLARE @MAClientId integer
  DECLARE @MAClientName char(255)
  DECLARE @deviceControllerPath VARCHAR(1024)
  DECLARE @deviceControllerUser VARCHAR(1024)
  DECLARE @readWriteAccess integer
  DECLARE @servicePack integer
  DECLARE @dataServerPath VARCHAR(1024)
  DECLARE @deviceId integer
  DECLARE @credentialId integer
  DECLARE @credentialName NVARCHAR(255)
  DECLARE @MADisplayName NVARCHAR(255)
IF OBJECT_ID('tempdb.dbo.#tmpDeviceControllersForStoragePoolLocal') IS NOT NULL DROP TABLE #tmpDeviceControllersForStoragePoolLocal
-- query comes from Enterprise Manager
-- WITH needs ; on the previous statement. ; is added to serve that purpose
;
WITH DCINFO AS (
SELECT  MMDeviceController.DeviceControllerId, MMDeviceController.DeviceControllerActive,
		MMDeviceController.DeviceControllerEnabled, MMDeviceController.DeviceAccessible,
		MMDeviceController.ClientId, APP_Client.name,
        MMDeviceController.Folder, MMDeviceController.UserName AS UserName, MMDeviceController.DeviceAccessType,ISNULL(PKG.HighestSP, -1) as HighestSP,
		dbo.MMS2FUNC_GetSharedMountPath(MMDeviceController.DeviceId,0) as DataServerPath,
		MMDeviceController.DeviceId, ISNULL(AC.credentialId, 0) AS credentialId, ISNULL(AC.credentialName, '') AS credentialName,APP_Client.displayName AS DisplayName,
		ROW_NUMBER() OVER (PARTITION BY MMDeviceController.DeviceControllerId ORDER BY MMDeviceController.DeviceControllerId, PKG.HighestSP) as RowNumber
FROM         MMDevice INNER JOIN
                      MMDeviceController ON MMDevice.DeviceId = MMDeviceController.DeviceId INNER JOIN
                      MMMountPathToStorageDevice ON MMDevice.DeviceId = MMMountPathToStorageDevice.DeviceId INNER JOIN
                      APP_Client ON MMDeviceController.ClientId = APP_Client.Id LEFT JOIN
			 APP_VMToPMMap MAP ON MAP.VMClientId = APP_Client.Id LEFT OUTER JOIN
SimInstalledPackages PKG ON PKG.ClientId = ISNULL(MAP.PMClientId, APP_Client.Id) AND PKG.simPackageID in (51, 1301, 54, 1305)
			 LEFT OUTER JOIN APP_CredentialAssoc ACA WITH(READUNCOMMITTED) ON ACA.assocId = MMDeviceController.CredentialAssocId
			 LEFT OUTER JOIN APP_Credentials AC WITH(READUNCOMMITTED) ON AC.credentialId = ACA.credentialId
WHERE     (MMMountPathToStorageDevice.MountPathId = @mountPathId))
SELECT DeviceControllerId,  DeviceControllerActive, DeviceControllerEnabled, DeviceAccessible, ClientId, name, Folder, UserName, DeviceAccessType, HighestSP, DataServerPath, DeviceId, credentialId, credentialName,DisplayName
INTO #tmpDeviceControllersForStoragePoolLocal
FROM DCINFO WHERE RowNumber = 1
IF OBJECT_ID('tempdb.dbo.#tmpDeviceControllersForStoragePool') IS NOT NULL
BEGIN
INSERT INTO #tmpDeviceControllersForStoragePool
SELECT DeviceControllerId,  DeviceControllerActive, DeviceControllerEnabled, DeviceAccessible, ClientId, name, Folder, UserName, DeviceAccessType, HighestSP, DataServerPath, DeviceId, credentialId, credentialName,DisplayName
FROM #tmpDeviceControllersForStoragePoolLocal
END
ELSE
BEGIN
SELECT DeviceControllerId,  DeviceControllerActive, DeviceControllerEnabled, DeviceAccessible, ClientId, name, Folder, UserName, DeviceAccessType, HighestSP, DataServerPath, DeviceId, credentialId, credentialName,DisplayName
FROM #tmpDeviceControllersForStoragePoolLocal
END
IF OBJECT_ID('tempdb.dbo.#tmpDeviceControllersForStoragePoolLocal') IS NOT NULL DROP TABLE #tmpDeviceControllersForStoragePoolLocal
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetDevicePathsForMountPath')
	delete from GxQscripts where name = 'MMS2GetDevicePathsForMountPath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetDevicePathsForMountPath')
	delete from GXDBVersions where aliasname = 'MMS2GetDevicePathsForMountPath'
GO

insert into GXDBVersions values(2, 'MMS2GetDevicePathsForMountPath',  '00010007000200100000', 'MMS2GetDevicePathsForMountPath', '00010007000200100000')
GO

