

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetDeviceInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetDeviceInfo.sp,v $ $Id: MMS2GetDeviceInfo.sp,v 1.5.88.4 2020/12/02 11:34:42 anarulkar Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMS2GetDeviceInfo')
BEGIN
	print '>>> Drop Stored Procedure: MMS2GetDeviceInfo <<<'
	drop procedure MMS2GetDeviceInfo
END
IF EXISTS (select * from GxQscripts where name='MMS2GetDeviceInfo')
	delete from GxQscripts where name = 'MMS2GetDeviceInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetDeviceInfo')
	delete from GXDBVersions where aliasname = 'MMS2GetDeviceInfo'
GO
print '... Creating Procedure: MMS2GetDeviceInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMS2GetDeviceInfo
  @i_mountPathId integer,
  @i_mountPathTypeId integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_DeviceAliasName NVARCHAR(255)
  DECLARE @o_IsDeviceEnabled integer
  DECLARE @o_DeviceId integer
  DECLARE @o_IsDeviceBroken integer
  DECLARE @o_DeviceOfflineReason integer
  DECLARE @o_TotalCapacity bigint
  DECLARE @o_FreeSpaceCapacity bigint
  DECLARE @o_UniqueId char(255)
  DECLARE @o_UniqueIdType integer
  DECLARE @o_LUN integer
  DECLARE @o_FSType char(255)
  DECLARE @o_DeviceAttributes integer
		DECLARE @l_mediaSideId		integer
		SET @l_mediaSideId		= (select MediaSideId from MMMountPath as mmp
									where mmp.MountPathId = @i_mountPathId)
		if(@i_mountPathTypeId = 2)
		begin
			select md.AliasName, md.DeviceEnabled, md.DeviceId, md.DeviceBroken, md.OfflineReason,
			TotalCapacity = (select TotalSpaceMB from MMMediaSide as mms where mms.MediaSideId in
			(select MediaSideId from MMMountPath as mmp where mmp.MountPathId = @i_mountPathId)),
			FreeSpaceCapacity = (select FreeBytesMB from MMMediaSide as mms where mms.MediaSideId in
			(select MediaSideId from MMMountPath as mmp where mmp.MountPathId = @i_mountPathId)),
			snrv.UniqueId, snrv.UniqueIDType, snrv.LUN, snrv.FSType, md.DeviceAttributes
			from QRPhysicalVolume as snrv, MMDevice as md
			where md.DeviceId = (select DeviceId from MMMountPathToStorageDevice as mmpsd
			where mmpsd.MountPathId = @i_mountPathId) and md.SNRPartitionId = snrv.id
        end
        else if(@i_mountPathTypeId IN (4,5,7,9, 11) ) -- MOUNT_PATH_SHARED_STATIC MOUNT_PATH_SHARED_REPLICA MOUNT_PATH_EXTERNAL_REMOTE_HOST MOUNT_PATH_RPSTORE MOUNT_PATH_CACHE
        begin
			select md.AliasName, md.DeviceEnabled, md.DeviceId, md.DeviceBroken, md.OfflineReason,
			TotalCapacity = (select TotalSpaceMB from MMMediaSide as mms where mms.MediaSideId = @l_mediaSideId),
			FreeSpaceCapacity = (select FreeBytesMB from MMMediaSide as mms where mms.MediaSideId = @l_mediaSideId),
			'', 0, 0, '', md.DeviceAttributes
			from MMDevice as md, MMMountPathToStorageDevice as mmpsd
			where md.DeviceId = mmpsd.DeviceId and mmpsd.MountPathId = @i_mountPathId
        end
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetDeviceInfo')
	delete from GxQscripts where name = 'MMS2GetDeviceInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetDeviceInfo')
	delete from GXDBVersions where aliasname = 'MMS2GetDeviceInfo'
GO

insert into GXDBVersions values(2, 'MMS2GetDeviceInfo',  '00010005008800040000', 'MMS2GetDeviceInfo', '00010005008800040000')
GO

