

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetDeviceControllerInfoByDevCtrlId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2017  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetDeviceControllerInfoByDevCtrlId.sp,v $ $Id: MMS2GetDeviceControllerInfoByDevCtrlId.sp,v 1.1.2.2 2020/12/29 18:58:01 pveeravalli Exp $";
--
--  +========================================================================+
--  |   Procedure:  MMS2GetDeviceControllerInfoByDevCtrlId
--  |
--  | Description:  Retrieves the device controller's info based on the information passed
--  |
--  |       Input:  Entity Id, Entity Type, Credential Id, Flag to indicate an updation is requires
--  |
--  |      Output:  Credential assoc ID if a valid credential ID was passed
--  |
--  |      Notes:	None at this time
--  |
--  |   Revisions  Author			Description
--  |   ---------  -------			---------------------------------------------
--  |   1.1        aselvanayagam 	Stored procedure to get device controller info
--	|								for a given device controller ID by performing
--	|								 an extra lookup to get the right credentials
--  +========================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMS2GetDeviceControllerInfoByDevCtrlId')
BEGIN
	print '>>> Drop Stored Procedure: MMS2GetDeviceControllerInfoByDevCtrlId <<<'
	drop procedure MMS2GetDeviceControllerInfoByDevCtrlId
END
IF EXISTS (select * from GxQscripts where name='MMS2GetDeviceControllerInfoByDevCtrlId')
	delete from GxQscripts where name = 'MMS2GetDeviceControllerInfoByDevCtrlId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetDeviceControllerInfoByDevCtrlId')
	delete from GXDBVersions where aliasname = 'MMS2GetDeviceControllerInfoByDevCtrlId'
GO
print '... Creating Procedure: MMS2GetDeviceControllerInfoByDevCtrlId'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMS2GetDeviceControllerInfoByDevCtrlId
  @i_deviceControllerId integer
AS
  DECLARE @o_deviceControllerId integer
  DECLARE @o_clientId integer
  DECLARE @o_deviceId integer
  DECLARE @o_deviceControllerActive integer
  DECLARE @o_deviceControllerEnabled integer
  DECLARE @o_SNRVolumeId integer
  DECLARE @o_useCount integer
  DECLARE @o_userName varchar(1024)
  DECLARE @o_userPassword varchar(2048)
  DECLARE @o_folder varchar(1024)
  DECLARE @o_deviceMounted integer
  DECLARE @o_deviceAccessible integer
  DECLARE @o_volumeRecoveryStatus integer
  DECLARE @o_volumeRecoveryTime integer
  DECLARE @o_volumeScsiReserved integer
  DECLARE @o_DeviceAccessType integer
  DECLARE @o_RMStatus integer
  DECLARE @o_RMStatusUpdateTime integer
  DECLARE @o_credentialAssocId integer
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#deviceControllerTable') IS NOT NULL
    DROP TABLE #deviceControllerTable
CREATE TABLE #deviceControllerTable
(
    deviceControllerId INT,
    clientId INT,
    deviceId INT,
    deviceControllerActive INT,
    deviceControllerEnabled INT,
    SNRVolumeId INT,
    useCount INT,
userName VARCHAR(1024),
userPassword VARCHAR(2048),
folder VARCHAR(1024),
	deviceMounted INT,
	deviceAccessible INT,
	volumeRecoveryStatus INT,
	volumeRecoveryTime INT,
	volumeScsiReserved INT,
	DeviceAccessType INT,
	RMStatus INT,
	RMStatusUpdateTime INT,
	credentialAssocId INT
)
BEGIN
	INSERT INTO #deviceControllerTable ( deviceControllerId, clientId, deviceId, deviceControllerActive, deviceControllerEnabled, SNRVolumeId, useCount, userName, userPassword, folder, deviceMounted, deviceAccessible, volumeRecoveryStatus,	volumeRecoveryTime,	volumeScsiReserved,	DeviceAccessType, RMStatus,	RMStatusUpdateTime,	credentialAssocId)
        SELECT
           DC.DeviceControllerId,
		   DC.ClientId,
		   DC.DeviceId,
		   DC.DeviceControllerActive,
		   DC.DeviceControllerEnabled,
		   DC.SNRVolumeId,
		   DC.UseCount,
		   DC.UserName,
		   DC.UserPassword,
		   DC.Folder,
		   DC.DeviceMounted,
		   DC.DeviceAccessible,
		   DC.VolumeRecoveryStatus,
		   DC.VolumeRecoveryTime,
		   DC.VolumeScsiReserved,
		   DC.DeviceAccessType,
		   DC.RMStatus,
		   DC.RMStatusUpdateTime,
		   DC.CredentialAssocId
	FROM   MMDeviceController DC WITH(READUNCOMMITTED)
		WHERE DC.DeviceControllerId = @i_deviceControllerId
	BEGIN
		EXEC MMS2GetDeviceControllerCredentials
	END
		SELECT deviceControllerId,
			clientId,
			deviceId,
			deviceControllerActive,
			deviceControllerEnabled,
			SNRVolumeId,
			useCount,
			userName,
			userPassword,
			folder,
			deviceMounted,
			deviceAccessible,
			volumeRecoveryStatus,
			volumeRecoveryTime,
			volumeScsiReserved,
			DeviceAccessType,
			RMStatus,
			RMStatusUpdateTime,
			credentialAssocId
		FROM #deviceControllerTable
	IF OBJECT_ID('tempdb.dbo.#deviceControllerTable') IS NOT NULL
		DROP TABLE #deviceControllerTable
END
SET NOCOUNT OFF;
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetDeviceControllerInfoByDevCtrlId')
	delete from GxQscripts where name = 'MMS2GetDeviceControllerInfoByDevCtrlId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetDeviceControllerInfoByDevCtrlId')
	delete from GXDBVersions where aliasname = 'MMS2GetDeviceControllerInfoByDevCtrlId'
GO

insert into GXDBVersions values(2, 'MMS2GetDeviceControllerInfoByDevCtrlId',  '00010001000200020000', 'MMS2GetDeviceControllerInfoByDevCtrlId', '00010001000200020000')
GO

