

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetDeviceControllerInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetDeviceControllerInfo.sp,v $ $Id: MMS2GetDeviceControllerInfo.sp,v 1.3.198.2 2018/03/20 20:05:58 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetDeviceControllerInfo <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetDeviceControllerInfo')
	drop procedure MMS2GetDeviceControllerInfo
IF EXISTS (select * from GxQscripts where name='MMS2GetDeviceControllerInfo')
	delete from GxQscripts where name = 'MMS2GetDeviceControllerInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetDeviceControllerInfo')
	delete from GXDBVersions where aliasname = 'MMS2GetDeviceControllerInfo'
GO
print '... Creating Procedure: MMS2GetDeviceControllerInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetDeviceControllerInfo
  @i_mountPathId integer,
  @i_mountPathTypeId integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_ClientId integer
  DECLARE @o_MMHostId integer
  DECLARE @o_ClientName char(255)
  DECLARE @o_DeviceId integer
  DECLARE @o_DeviceControllerId integer
  DECLARE @o_IsDeviceControllerActive integer
  DECLARE @o_SNRVolumeId integer
  DECLARE @o_IsDeviceControllerEnabled integer
  DECLARE @o_IsDeviceAccessible integer
  DECLARE @o_DeviceName char(255)
  DECLARE @o_Path char(255)
  DECLARE @o_drivePoolId integer
  DECLARE @o_maxWriters integer
	SET NOCOUNT ON
	declare @l_libraryId		integer
	declare @l_MasterPoolId		integer
	set @l_libraryId		= (select LibraryId from MMMedia where MediaId in
							  (select MediaId from MMMediaSide where MediaSideId in
							  (select MediaSideId from MMMountPath where MountPathId =
							  @i_mountPathId)))
	set @l_MasterPoolId		= (select MasterPoolId from MMMasterPool where
							  LibraryId = @l_libraryId)
	create table #TmpDeviceController ( DeviceId				Integer,
										DeviceControllerId		Integer,
										DeviceControllerActive	Integer,
										DeviceControllerenabled	Integer,
										DeviceAccessible		Integer,
										SNRVolumeId				Integer,
										SNRDeviceName			varchar(255),
										mountPath				varchar(255),
										Clientname				VARCHAR(255),
										ClientId				Integer,
										drivePoolId				integer,
										maxWriters				integer)
	insert into #TmpDeviceController
	select md.DeviceId, mdc.DeviceControllerId, mdc.VolumeScsiReserved,
	mdc.DeviceControllerenabled, mdc.DeviceAccessible, mdc.SNRVolumeId, '', '',
	Clientname = (select name from APP_Client where id = MDC.ClientId),
	ClientId = mdc.ClientId, 0, 0
	from MMDevice as md, MMDeviceController as mdc
	where md.DeviceId = (select DeviceId from MMMountPathToStorageDevice as mmpsd where
	mmpsd.MountPathId = @i_mountPathId) and mdc.DeviceId = md.DeviceId
	update #TmpDeviceController
	set drivePoolId = mdp.DrivePoolId
	from MMDrivePool as mdp, #TmpDeviceController as tt
	where tt.ClientId = mdp.ClientId and mdp.MasterPoolId = @l_MasterPoolId
	update #TmpDeviceController
	set maxWriters = mdp.MaxDrivesToSwitch
	from MMDrivePool as mdp, #TmpDeviceController as tt
	where tt.DrivePoolId = mdp.drivePoolId
	if(@i_mountPathTypeId = 2)
	begin
		update #TmpDeviceController
		set SNRDeviceName = snrvdn.DeviceName
		from QRPhysicalDevice as snrvdn, #TmpDeviceController  as tt
		where snrvdn.Id = tt.SNRVolumeId
		update #TmpDeviceController
		set mountPath = snrvmp.Path
		from QRMountPoint as snrvmp, #TmpDeviceController  as tt
		where snrvmp.DeviceNameId = tt.SNRVolumeId
	end
	select tt.ClientId, tt.ClientId, tt.ClientName, tt.DeviceId, tt.DeviceControllerId,
	tt.DeviceControllerActive, tt.SNRVolumeId, tt.DeviceControllerenabled, tt.DeviceAccessible,
	tt.SNRDeviceName, tt.mountPath, tt.drivePoolId, tt.maxWriters
	from 	#TmpDeviceController as tt
	drop table #TmpDeviceController
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetDeviceControllerInfo')
	delete from GxQscripts where name = 'MMS2GetDeviceControllerInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetDeviceControllerInfo')
	delete from GXDBVersions where aliasname = 'MMS2GetDeviceControllerInfo'
GO

insert into GXDBVersions values(2, 'MMS2GetDeviceControllerInfo',  '00010003019800020000', 'MMS2GetDeviceControllerInfo', '00010003019800020000')
GO

