

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetDeviceControllerCredentials.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetDeviceControllerCredentials.sp,v $ $Id: MMS2GetDeviceControllerCredentials.sp,v 1.1.2.5 2019/08/28 22:01:09 pnara Exp $";
--  +===============================================================================================================================================+
--  | MMS2GetDeviceControllerCredentials - Update #deviceControllerTable with the right credentials when they are using saved credentials			|
--  +===============================================================================================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMS2GetDeviceControllerCredentials')
BEGIN
	print '>>> Drop Stored Procedure: MMS2GetDeviceControllerCredentials <<<'
	drop procedure MMS2GetDeviceControllerCredentials
END
IF EXISTS (select * from GxQscripts where name='MMS2GetDeviceControllerCredentials')
	delete from GxQscripts where name = 'MMS2GetDeviceControllerCredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetDeviceControllerCredentials')
	delete from GXDBVersions where aliasname = 'MMS2GetDeviceControllerCredentials'
GO
print '... Creating Procedure: MMS2GetDeviceControllerCredentials'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMS2GetDeviceControllerCredentials
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS                         ---
-----------------------------------------------------------
  @i_tempDevCtrlTblName CHAR(255) = '#deviceControllerTable',
  @i_credentialAssocIdColName CHAR(255) = 'credentialAssocId',
  @i_userNameColName CHAR(255) = 'userName',
  @i_userPasswordColName CHAR(255) = 'userPassword'
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
--Remove any leading/trailing spaces from inputs
SET @i_tempDevCtrlTblName = LTRIM(RTRIM(@i_tempDevCtrlTblName))
SET @i_credentialAssocIdColName = LTRIM(RTRIM(@i_credentialAssocIdColName))
SET @i_userNameColName = LTRIM(RTRIM(@i_userNameColName))
SET @i_userPasswordColName = LTRIM(RTRIM(@i_userPasswordColName))
IF OBJECT_ID('tempdb.dbo.'+ RTRIM(@i_tempDevCtrlTblName)) IS NOT NULL
BEGIN
	DECLARE @sqlStatement nvarchar(max)
	-- Table to hold v3 password
	CREATE TABLE #tmpV3PasswordCred
	( credentialId INT NOT NULL PRIMARY KEY,
userName VARCHAR(1024),
userPassword VARCHAR(2048) )
	-- Insert distinct credential Ids
	SET @sqlStatement = 'INSERT INTO #tmpV3PasswordCred
						 SELECT DISTINCT ASSOC.credentialId AS credentialId, '''' AS userName, '''' AS userPassword
						 FROM 	' + @i_tempDevCtrlTblName + ' TMP
								INNER JOIN APP_CredentialAssoc ASSOC
								ON TMP.' + @i_credentialAssocIdColName + ' = ASSOC.assocId
						 WHERE TMP.' + @i_credentialAssocIdColName + ' > 0'
	EXEC(@sqlStatement)
	IF @@ROWCOUNT > 0
	BEGIN
		-- Update user name and convert to V3 password
		UPDATE 	V3
		SET 	V3.userName = CRED.userName,
				V3.userPassword = (CASE WHEN CRED.password = '' THEN '' ELSE dbo.pswConvertV5ToV3(CRED.password) END)
		FROM 	#tmpV3PasswordCred V3
				INNER JOIN APP_Credentials CRED ON V3.credentialId = CRED.credentialId
		-- Update the main temp table
		SET @sqlStatement =
		'
			UPDATE 	TMP
			SET		TMP.'+ @i_userNameColName +' =
					(
						CASE
WHEN (CHARINDEX(''__CVCRED__'', TMP.'+ @i_userNameColName +') > 0
OR CHARINDEX(''__CVCREDID__'', TMP.'+ @i_userNameColName +') > 0)
THEN REPLACE(REPLACE(TMP.'+ @i_userNameColName +', ''__CVCRED__'', V3.userName), ''__CVCREDID__'', cast(V3.credentialId as varchar(10)))
							ELSE V3.userName
						END
					),
					TMP.'+ @i_userPasswordColName +' = V3.userPassword
			FROM 	'+ @i_tempDevCtrlTblName +' TMP
					INNER JOIN APP_CredentialAssoc ASSOC ON TMP.'+ @i_credentialAssocIdColName +' = ASSOC.assocId
					INNER JOIN #tmpV3PasswordCred V3 ON ASSOC.credentialID = V3.credentialId
			WHERE 	TMP.'+ @i_credentialAssocIdColName +' > 0
		'
		EXEC (@sqlStatement)
	END
	IF OBJECT_ID('tempdb.dbo.#tmpV3PasswordCred') IS NOT NULL
	DROP TABLE #tmpV3PasswordCred
END
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetDeviceControllerCredentials')
	delete from GxQscripts where name = 'MMS2GetDeviceControllerCredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetDeviceControllerCredentials')
	delete from GXDBVersions where aliasname = 'MMS2GetDeviceControllerCredentials'
GO

insert into GXDBVersions values(2, 'MMS2GetDeviceControllerCredentials',  '00010001000200050000', 'MMS2GetDeviceControllerCredentials', '00010001000200050000')
GO

