

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetDataPathList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetDataPathList.sp,v $ $Id: MMS2GetDataPathList.sp,v 1.2.302.1 2018/03/20 20:02:16 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetDataPathList <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetDataPathList')
	drop procedure MMS2GetDataPathList
IF EXISTS (select * from GxQscripts where name='MMS2GetDataPathList')
	delete from GxQscripts where name = 'MMS2GetDataPathList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetDataPathList')
	delete from GXDBVersions where aliasname = 'MMS2GetDataPathList'
GO
print '... Creating Procedure: MMS2GetDataPathList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetDataPathList
  @i_copyId integer,
  @i_appId integer,
  @i_dataType integer,
  @i_backupType integer,
  @i_clientId integer,
  @i_includeReserved integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_NumRows integer
  DECLARE @o_CopyId integer
  DECLARE @o_DrivePoolId integer
  DECLARE @o_HostClientId integer
  DECLARE @o_Flag integer
  DECLARE @o_SpareGroupId integer
  DECLARE @o_DataPathId integer
  DECLARE @o_ReadinessFlag integer
  DECLARE @o_Priority integer
  DECLARE @o_IsHardwareCompressed integer
  DECLARE @o_ChunkSizeMB integer
  DECLARE @o_FlushBlockSizeKB integer
  DECLARE @o_UseHardwareEncryption integer
	set nocount on
	if object_id('tempdb.dbo.#tmpDataPathList') is not null DROP TABLE #tmpDataPathList
	declare @rows integer
	set @rows = 0
	create table #tmpDataPathList (		CopyId						integer,
		DrivePoolId					integer,
		HostClientId				integer,
		Flag						integer,
		SpareGroupId				integer,
		DataPathId					integer,
		ReadinessFlag				integer,
		Priority					integer,
		IsHardwareCompressed		integer,
		ChunkSizeMB					integer,
		FlushBlockSizeKB			integer,
		precedence					integer,
		UseHardwareEncryption		integer)
	insert into #tmpDataPathList
	select DP.CopyId, DP.DrivePoolId, DP.HostClientId, DP.Flag, DP.SpareGroupId, DP.DataPathId, DP.ReadinessFlag, DP.Priority, DP.IsHardwareCompressed, DP.ChunkSizeMB, DP.FlushBlockSizeKB, A.precedence, DP.UseHardwareEncryption
	from MMDataPath as DP, APP_AppToDataPath A
	WHERE DP.DataPathId = A.DataPathId
	AND DP.CopyId = @i_CopyId
	AND A.componentNameId =	@i_AppId
	AND A.dataType = @i_dataType
--	AND A.backupType = @i_backupType
	AND (DP.Flag & 4) > 0
	AND (@i_clientId = 0 or (@i_clientId > 0 AND DP.HostClientId = @i_clientId))
	AND (@i_includeReserved > 0 or (@i_includeReserved = 0 AND DP.DrivePoolId not in (select DrivePoolId from MMResource with (readuncommitted))))
	select @rows = count(*) from #tmpDataPathList
	select @rows, CopyId, DrivePoolId, HostClientId, Flag, SpareGroupId, DataPathId, ReadinessFlag, Priority, IsHardwareCompressed, ChunkSizeMB, FlushBlockSizeKB, UseHardwareEncryption
	from #tmpDataPathList
	order by precedence
	drop table #tmpDataPathList
	set nocount off
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetDataPathList')
	delete from GxQscripts where name = 'MMS2GetDataPathList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetDataPathList')
	delete from GXDBVersions where aliasname = 'MMS2GetDataPathList'
GO

insert into GXDBVersions values(2, 'MMS2GetDataPathList',  '00010002030200010000', 'MMS2GetDataPathList', '00010002030200010000')
GO

