

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetDRUInfoByMountPathId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetDRUInfoByMountPathId.sp,v $ $Id: MMS2GetDRUInfoByMountPathId.sp,v 1.3.210.1 2018/03/20 19:58:45 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetDRUInfoByMountPathId <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetDRUInfoByMountPathId')
	drop procedure MMS2GetDRUInfoByMountPathId
IF EXISTS (select * from GxQscripts where name='MMS2GetDRUInfoByMountPathId')
	delete from GxQscripts where name = 'MMS2GetDRUInfoByMountPathId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetDRUInfoByMountPathId')
	delete from GXDBVersions where aliasname = 'MMS2GetDRUInfoByMountPathId'
GO
print '... Creating Procedure: MMS2GetDRUInfoByMountPathId'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetDRUInfoByMountPathId
  @i_MountPathId integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_DRUId integer
  DECLARE @o_DRUHostName varchar(256)
  DECLARE @o_DRUUserName varchar(256)
  DECLARE @o_DRUPassword varchar(256)
  DECLARE @o_DRUDeviceId varchar(256)
  DECLARE @o_DRUPortNumber integer
  DECLARE @o_DRUAttributes integer
  DECLARE @o_TotalReservations integer
  DECLARE @o_RetentionDays integer
  DECLARE @o_DrivePoolId integer
	IF object_id('tempdb.dbo.#tmpDRUInfo') is not null DROP TABLE #tmpDRUInfo
	IF object_id('tempdb.dbo.#tmMediaListForDueBackCalc') is not null DROP TABLE #tmMediaListForDueBackCalc
	create table #tmpDRUInfo(t_MountPathId	integer,
				t_MountPathName	varchar(256),
				t_MediaSideId	integer,
				t_MediaId	integer,
				t_MasterPoolId	integer,
				t_DrivePoolId	integer,
				t_LibraryId	integer,
				t_DeviceId	integer,
				t_DRUId		integer,
				t_numWriters	integer,
				t_retentionDays	integer,
				t_DRUDeviceId	varchar(256),
				t_DeviceAttributes	integer)
	CREATE TABLE #tmMediaListForDueBackCalc (
			MediaId		INT,
			retentionDays	INT
	)
	IF(@i_mountPathId = 0)
	BEGIN
		insert into #tmpDRUInfo
		select MM.MountPathId, MM.MountPathName, MM.MediaSideId, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
		from MMMountPath as MM
		where MountPathTypeId = 6 AND MountPathId > 0
	END
	ELSE
	BEGIN
		insert into #tmpDRUInfo
		select MM.MountPathId, MM.MountPathName, MM.MediaSideId, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
		from MMMountPath as MM
		where MountPathId = @i_mountPathId
	END
	update #tmpDRUInfo
	set t_MediaId = (select MediaId from MMMediaSide where MediaSideId = t_MediaSideId)
	update #tmpDRUInfo
	set t_MasterPoolId = MMP.MasterPoolId, t_LibraryId = MMP.LibraryId
	from #tmpDRUInfo as tt, MMMedia as MM, MMMasterPool as MMP
	where tt.t_MediaId = MM.MediaId AND MM.LibraryId = MMP.LibraryId
	update #tmpDRUInfo
	set t_DrivePoolId = MDP.DrivePoolId
	from #tmpDRUInfo as tt, MMDrivePool as MDP
	where tt.t_MasterPoolId = MDP.MasterPoolId
	update #tmpDRUInfo
	set t_DeviceId = ISNULL((select DeviceId from MMMountPathToStorageDevice where MountPathId = t_MountPathId), 0)
	update #tmpDRUInfo
	set t_DRUId = MD.DRUId, t_DRUDeviceId = MD.DRUDeviceId, t_DeviceAttributes = MD.DeviceAttributes
	from MMDevice as MD, #tmpDRUInfo as tt
	where MD.DeviceId = tt.t_DeviceId
	update #tmpDRUInfo
	set t_numWriters = ISNULL((select count(*) from MMResource where MasterPoolId = t_masterPoolId), 0)
	insert into #tmMediaListForDueBackCalc
	select tt.t_MediaId, 0
	from #tmpDRUInfo as tt
	declare @tblAgingRule table (
			copyId int, retTime int,
			extRule1 int, extRetTime1 int,
			extRule2 int, extRetTime2 int,
			extRule3 int, extRetTime3 int)
	declare @tblChunk table (
			mediaid int, id int, commcellid int)
	declare @tblAFCopy table (
			mediaid int, archfileid int, commcellid int, copyid int)
	declare @tblJobCopy table (
			mediaid int, jobId int, commcellid int,
			filetype int, copyid int)
	declare @tblJob table (
			mediaid int, jobId int, commcellid int,
			copyid int, retentionflags int,
			endTime int, pruneTime int)
	declare @tblDueBack table (mediaId int, dueBackDate int)
	insert into @tblAgingRule
	select copyId, retentionDays * 24 * 60 * 60, 0, 0, 0, 0, 0, 0
	from archAgingRule
	where retentionDays <> -1
	insert into @tblAgingRule
	select copyId, retentionDays, 0, 0, 0, 0, 0, 0
	from archAgingRule
	where retentionDays = -1
	declare extrulecur cursor for select * from archAgingRuleExtended
	declare @prevCopyId integer
	declare @ruleId integer
	declare @copyId integer
	declare @retentionDays integer
	declare @retentionRule integer
	set @prevCopyId = 0
	open extrulecur
	fetch extrulecur into @copyId, @retentionDays, @retentionRule
	while @@fetch_status = 0
	begin
		if @prevCopyId <> @copyId
		begin
			set @ruleId = 0
			set @prevCopyId = @copyId
		end
		set @ruleId = @ruleId + 1
		if @ruleId = 1
			update @tblAgingRule set extRetTime1 = @retentionDays * 24 * 60 * 60, extRule1 = @retentionRule where copyId = @copyId
		if @ruleId = 2
			update @tblAgingRule set extRetTime2 = @retentionDays * 24 * 60 * 60, extRule2 = @retentionRule where copyId = @copyId
		if @ruleId = 3
			update @tblAgingRule set extRetTime3 = @retentionDays * 24 * 60 * 60, extRule3 = @retentionRule where copyId = @copyId
		fetch extrulecur into @copyId, @retentionDays, @retentionRule
	end
	close extrulecur
	deallocate extrulecur
	insert into @tblChunk
	select c.mediaId, a.id, a.commCellId
	from archchunk a, MMVolume b, #tmMediaListForDueBackCalc c
	where a.volumeId = b.volumeId and b.mediaId = c.mediaId
	insert into @tblAFCopy
	select distinct b.mediaId, a.archfileid, a.commcellid, a.archcopyid
	from archchunkmapping a, @tblChunk b
	where a.archchunkid = b.id and a.chunkCommcellid = b.commcellid
	insert into @tblJobCopy
	select distinct b.mediaid, a.jobid, a.commCellId, a.filetype, b.copyid
	from archfile a, @tblAFCopy b
	where a.id = b.archfileid
	and a.commcellid = b.commcellid
	insert into @tblJob
	select distinct b.mediaid, b.jobid, b.commcellid, b.copyid, a.retentionFlags, 0, 0
	from jmjobdatastats a, @tblJobCopy b
	where a.jobid = b.jobid
	and a.dataType = b.fileType
	and a.archgrpcopyid = b.copyid
	and a.commcellid = b.commcellid
	update @tblJob set endTime = b.servEndDate
	from @tblJob a, jmbkpstats b
	where a.jobid = b.jobid
	and a.commcellid = b.commcellid
	update @tblJob set endTime = b.servEnd
	from @tblJob a, JMAdminJobStatsTable b
	where a.jobid = b.jobid
	and a.commcellid = b.commcellid
	update @tblJob set pruneTime = b.retTime
	from @tblJob a, @tblAgingRule b
	where a.copyId = b.copyId and b.retTime < 0
	update @tblJob set pruneTime = a.endTime + b.retTime
	from @tblJob a, @tblAgingRule b
	where a.copyId = b.copyId and b.retTime > 0
	update @tblJob set pruneTime = b.extRetTime1
	from @tblJob a, @tblAgingRule b
	where a.copyId = b.copyId
	and (a.retentionFlags & b.extRule1) <> 0
	and b.retTime > 0 and b.extRetTime1 < 0
	update @tblJob set pruneTime = a.endTime + b.extRetTime1
	from @tblJob a, @tblAgingRule b
	where a.copyId = b.copyId
	and (a.retentionFlags & b.extRule1) <> 0
	and b.retTime > 0 and b.extRetTime1 > 0
	update @tblJob set pruneTime = b.extRetTime2
	from @tblJob a, @tblAgingRule b
	where a.copyId = b.copyId
	and (a.retentionFlags & b.extRule2) <> 0
	and b.retTime > 0 and b.extRetTime2 < 0
	update @tblJob set pruneTime = a.endTime + b.extRetTime2
	from @tblJob a, @tblAgingRule b
	where a.copyId = b.copyId
	and (a.retentionFlags & b.extRule2) <> 0
	and b.retTime > 0 and b.extRetTime2 > 0
	update @tblJob set pruneTime = b.extRetTime3
	from @tblJob a, @tblAgingRule b
	where a.copyId = b.copyId
	and (a.retentionFlags & b.extRule3) <> 0
	and b.retTime > 0 and b.extRetTime3 < 0
	update @tblJob set pruneTime = a.endTime + b.extRetTime3
	from @tblJob a, @tblAgingRule b
	where a.copyId = b.copyId
	and (a.retentionFlags & b.extRule3) <> 0
	and b.retTime > 0 and b.extRetTime3 > 0
	insert into @tblDueBack
	select mediaId, max(pruneTime)
	from @tblJob
	group by mediaId
	update #tmMediaListForDueBackCalc set retentionDays = (b.DueBackDate - dbo.GetUnixTime(GetUTCDate()))/(60*60*24)
	from #tmMediaListForDueBackCalc a, @tblDueBack b
	where a.mediaId = b.mediaId and b.DueBackDate > 0
	update #tmpDRUInfo
	set t_retentionDays = ISNULL((select retentionDays from #tmMediaListForDueBackCalc where t_MediaId = MediaId), 0)
	select MD.DRUId, MD.DRUHostName, MD.DRUUserName, MD.DRUPassword, tt.t_DRUDeviceId, MD.DRUPortNumber,
	tt.t_DeviceAttributes, tt.t_numWriters, tt.t_retentionDays, t_DrivePoolId
	from #tmpDRUInfo as tt, MMDRUInfo as MD
	where tt.t_DRUId = MD.DRUId
	drop table #tmpDRUInfo
	drop table #tmMediaListForDueBackCalc
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetDRUInfoByMountPathId')
	delete from GxQscripts where name = 'MMS2GetDRUInfoByMountPathId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetDRUInfoByMountPathId')
	delete from GXDBVersions where aliasname = 'MMS2GetDRUInfoByMountPathId'
GO

insert into GXDBVersions values(2, 'MMS2GetDRUInfoByMountPathId',  '00010003021000010000', 'MMS2GetDRUInfoByMountPathId', '00010003021000010000')
GO

