

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetCurrentVolForMG.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetCurrentVolForMG.sp,v $ $Id: MMS2GetCurrentVolForMG.sp,v 1.33.44.6 2019/04/24 14:45:10 cliu Exp $";
--
--  +========================================================================+
--  | Stored Precedure: MMS2GetCurrentVolForMG()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMS2GetCurrentVolForMG')
BEGIN
	print '>>> Drop Stored Procedure: MMS2GetCurrentVolForMG <<<'
	drop procedure MMS2GetCurrentVolForMG
END
IF EXISTS (select * from GxQscripts where name='MMS2GetCurrentVolForMG')
	delete from GxQscripts where name = 'MMS2GetCurrentVolForMG'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetCurrentVolForMG')
	delete from GXDBVersions where aliasname = 'MMS2GetCurrentVolForMG'
GO
print '... Creating Procedure: MMS2GetCurrentVolForMG'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetCurrentVolForMG
  @i_MediaGroupId integer,
  @i_ScheduleRunId bigint,
  @i_DoNotAllowOtherSchedule integer,
  @i_CheckUsableByJob integer,
  @i_JobId integer,
  @i_JobType integer
AS
  DECLARE @r_retcode integer;
  DECLARE @r_volumeId integer;
  DECLARE @r_mediaid integer;
  DECLARE @r_scheduleRunId bigint;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @tblMedia TABLE
(
	VolumeId		int,
	VolumeFlags		int,
	VolumeState		int,
	MediaId			int,
	BarCode			varchar(256),
	MediaLocation	int,
	LibraryId		int,
	MediaFlags		int,
	Attributes		int,
	LastBackupTime	int,
	MediaTypeId		int,
	ScheduleRunId	bigint,
	SpareGroupId	int
)
DECLARE	@l_VolumeFlags		int
DECLARE	@l_VolumeState		int
DECLARE	@l_Barcode			varchar(256)
DECLARE	@l_MediaLocation	int
DECLARE	@l_MediaFlags		int
DECLARE	@l_Attributes		int
SET @r_RetCode = 0
SET @r_MediaId = 0
SET @r_VolumeId = 0
SET @r_ScheduleRunId = 0
SET @l_Attributes = 0
DECLARE @isQuickMR INT = 0;
DECLARE @mediaGroupSrc INT = -1;
DECLARE @tblVolNotEligible TABLE (volId INT)
IF @i_JobType = 25 --MEDIAREFRESHINGJOB
	SET @i_JobType = 74
IF @i_JobType = 0
	SET @i_JobType =(dbo.GetJobTypeForJobID(@i_JobId))
-- if media refresh with a config param set, then allow using all the available and appendable
IF (@i_JobType IN (74,127))
BEGIN
IF (cast(dbo.GetJobOption(@i_JobId, 1054046064) as int)) = 1
	BEGIN
		SET @isQuickMR =1;
		SELECT @mediaGroupSrc= SrcStrm.mediaGroupId FROM
		archStream DestStrm WITH (READUNCOMMITTED), archGroupCopy AGC WITH (READUNCOMMITTED), archStream SrcStrm WITH (READUNCOMMITTED)
		WHERE DestStrm.mediaGroupId = @i_MediaGroupId
		AND AGC.id = DestStrm.archGroupCopyId
		AND SrcStrm.archGroupCopyId = AGC.sourceCopyId
		AND DestStrm.stream = SrcStrm.stream
		INSERT INTO @tblVolNotEligible
		SELECT V.volumeId
		FROM archChunkToCopy A WITH (READUNCOMMITTED), MMVolume V WITH (READUNCOMMITTED)
		WHERE A.adminJobId = @i_JobId
			AND A.mediaGroupId = @mediaGroupSrc
			AND A.volumeId = V.VolumeId
			AND V.VolumeFlags IN (1,7)
	END
END
-- check if any volume is reserved for write for the given media group
SELECT	TOP 1 @r_MediaId = R.MediaId, @r_VolumeId = R.VolumeId
FROM	MMResource R WITH (NOLOCK), MMResourceToJob RJ WITH (NOLOCK)
WHERE	R.MediaGroupId = @i_MediaGroupId
	AND R.ReservationId = RJ.ReservationId
	AND RJ.ReservationType = 2
IF @r_VolumeId > 0
BEGIN
	-- volume is reserved for write now
	SELECT	@r_ScheduleRunId = ScheduleRunId, @l_Attributes = Attributes
	FROM	MMMedia WITH (NOLOCK)
	WHERE	MediaId = @r_MediaId
	IF	@i_DoNotAllowOtherSchedule > 0 AND @r_ScheduleRunId > 0 AND @r_ScheduleRunId != @i_ScheduleRunId
OR @i_DoNotAllowOtherSchedule <= 0 AND (@l_Attributes & 134217728) > 0
SET @r_RetCode = 298
	GOTO DONE_EXIT
END
-- no volume is reserved for the media group
-- make sure after media group migration, we pick volume from new lib
DECLARE @l_LibraryId	int
DECLARE @l_DataPathId	int
DECLARE @l_SpareGroupId int
DECLARE @l_DrivePoolId	int
DECLARE @l_MasterPoolId	int
DECLARE @l_LogEvent		int
DECLARE @l_FullReason	int
DECLARE @honourSpareGroup integer
SET @l_LogEvent = 0
SET @l_FullReason = 0
SELECT	@l_SpareGroupId = SpareGroupId,
		@l_DrivePoolId = DrivePoolId,
		@l_DataPathId = DataPathId
FROM	MMMediaGroup WITH (NOLOCK)
WHERE	MediaGroupId = @i_MediaGroupId
IF @l_DataPathId IS NOT NULL AND @l_DataPathId > 0
BEGIN
	SELECT @l_SpareGroupId = SpareGroupId, @l_DrivePoolId = DrivePoolId FROM MMDataPath WITH (NOLOCK)
	WHERE DataPathId = @l_DataPathId
END
IF @l_SpareGroupId IS NOT NULL AND @l_SpareGroupId > 0
BEGIN
	SELECT @l_LibraryId = LibraryId FROM MMSpareGroup WITH (NOLOCK) WHERE SpareGroupId = @l_SpareGroupId
END
ELSE
BEGIN
    SELECT TOP 1 @l_MasterPoolId = MasterPoolId FROM MMDrivePool WITH (NOLOCK) WHERE DrivePoolId = @l_DrivePoolId
    IF	@l_MasterPoolId IS NOT NULL AND @l_MasterPoolId > 0
		SELECT @l_LibraryId = LibraryId FROM MMMasterPool WITH (NOLOCK) WHERE MasterPoolId = @l_MasterPoolId
END
IF @l_LibraryId IS NULL OR @l_LibraryId = 0
BEGIN
SET @r_RetCode = 103
  GOTO DONE_EXIT
END
SET @honourSpareGroup = ISNULL((select Value from MMConfigs (NOLOCK) where name = 'MMS2_CONFIG_HONOUR_SPAREGROUP_FOR_PICKING_MEDIA'), 0)
-- get active and appendable volumes from the library. VOL_ACTIVE (=1), VOL_ACTIVE_APPEND (=7)
INSERT  into @tblMedia
SELECT  V.VolumeId, V.VolumeFlags, V.VolumeState,
        M.MediaId, M.BarCode, M.MediaLocation, M.LibraryId, M.MediaFlags,
        M.Attributes, M.LastBackupTime, M.MediaTypeId, M.ScheduleRunId, M.SpareGroupId
FROM    MMVolume V WITH (NOLOCK), MMMedia M WITH (NOLOCK)
WHERE   V.MediaGroupId IN (@mediaGroupSrc, @i_MediaGroupId) AND V.VolumeFlags IN (1, 7)
    AND V.MediaId = M.MediaId AND M.MediaId > 0 AND M.LibraryId = @l_LibraryId
    AND M.MediaTypeId IN
        (SELECT MRF.MediaTypeId
        FROM MMRecFmtMedTyp MRF WITH (NOLOCK), MMMediaGroup MMG WITH (NOLOCK), MMDataPath MDP WITH (NOLOCK), MMDrivePool MDRP WITH (NOLOCK), MMDrive MMD WITH (NOLOCK)
        WHERE MMG.MediaGroupId = @i_MediaGroupId AND MDP.DataPathId = MMG.DataPathId AND MDRP.DrivePoolId = MDP.DrivePoolId
            AND MMD.MasterPoolId = MDRP.MasterPoolId AND MRF.DriveTypeId = MMD.DriveTypeId)
	AND NOT EXISTS (SELECT 1 from @tblVolNotEligible WHERE volId = v.VolumeId)
--if honour spareGroup is set then delete media belongs to other sparegroups.
IF @honourSpareGroup > 0 AND ISNULL(@l_SpareGroupId, 0) > 0
BEGIN
	delete from @tblMedia
	WHERE SpareGroupId <> @l_SpareGroupId
END
IF	NOT EXISTS (SELECT * FROM @tblMedia)
BEGIN
	IF	@i_CheckUsableByJob = 0
		GOTO DONE_EXIT
SET @r_RetCode = 20008
SET @l_FullReason = 42018
	GOTO VOLUME_FULL_EXIT
END
-- find a volume if ScheduleRunId matches
IF	@i_ScheduleRunId > 0
BEGIN
	SELECT	TOP 1 @r_VolumeId = VolumeId, @r_MediaId = MediaId, @r_ScheduleRunId = ScheduleRunId,
			@l_VolumeFlags = VolumeFlags, @l_VolumeState = VolumeState, @l_Barcode = BarCode,
			@l_MediaLocation = MediaLocation, @l_MediaFlags = MediaFlags, @l_Attributes = Attributes
	FROM	@tblMedia
	WHERE	ScheduleRunId = @i_ScheduleRunId
	ORDER BY LastBackupTime DESC
	IF	@r_VolumeId > 0
		GOTO FOUND_VOLUME
	IF	@i_DoNotAllowOtherSchedule > 0 AND @i_CheckUsableByJob > 0
		AND EXISTS (SELECT * FROM @tblMedia WHERE VolumeFlags = 1)
	BEGIN
		SELECT TOP 1 @r_VolumeId = VolumeId FROM @tblMedia WHERE VolumeFlags = 1
SET @l_FullReason = 42028
		GOTO VOLUME_FULL_EXIT
	END
END
-- find an active volume and good media no matter if ScheduleRunId matches
SELECT	TOP 1 @r_VolumeId = VolumeId, @r_MediaId = MediaId, @r_ScheduleRunId = ScheduleRunId,
		@l_VolumeFlags = VolumeFlags, @l_VolumeState = VolumeState, @l_Barcode = BarCode,
		@l_MediaLocation = MediaLocation, @l_MediaFlags = MediaFlags, @l_Attributes = Attributes
FROM	@tblMedia
WHERE	VolumeFlags = 1 AND MediaFlags = 1
	AND (@i_DoNotAllowOtherSchedule > 0 AND ScheduleRunId = 0
OR @i_DoNotAllowOtherSchedule <= 0 AND (Attributes & 134217728) = 0)
ORDER BY LastBackupTime DESC
IF	@r_VolumeId = 0
BEGIN
SET @r_RetCode = 20008
SET @l_FullReason = 42018
	GOTO DONE_EXIT
END
FOUND_VOLUME:
IF	@i_CheckUsableByJob = 0
	GOTO DONE_EXIT
-- check if the volume is good or not
DECLARE @l_LibraryOnline	int
DECLARE @l_LibraryTypeId	int
DECLARE @l_LibraryAttribute	int
SELECT	@l_LibraryOnline	= LibrarySoftState * LibraryEnabled * (1-LibraryBroken),
		@l_LibraryTypeId	= LibraryTypeId,
		@l_LibraryAttribute = libraryattribute
FROM	MMLibrary WITH (NOLOCK)
WHERE	LibraryId = @l_LibraryId
IF	@l_LibraryOnline = 0
BEGIN
SET @r_RetCode = 270
SET @l_FullReason = 42017
	GOTO VOLUME_FULL_EXIT
END
IF	@l_MediaFlags != 1
BEGIN
SET @r_RetCode = 453
SET @l_FullReason = 42031
	GOTO VOLUME_FULL_EXIT
END
IF @l_LibraryTypeId = 3
BEGIN
	DECLARE @l_MountPathsLeft		int
	DECLARE	@l_MaxConcurrentWriters	int
SELECT @r_RetCode = CASE WHEN device.DeviceEnabled = 0 THEN 441
WHEN device.DeviceBroken = 1 THEN 442
ELSE 0 END
	FROM	MMMountPath path WITH (NOLOCK), MMMediaSide side WITH (NOLOCK), MMDevice device WITH (NOLOCK), MMMountPathToStorageDevice mtd WITH (NOLOCK)
	WHERE	side.MediaId = @r_MediaId
	AND		path.MediaSideId = side.MediaSideId
	AND		path.MountPathId = mtd.MountPathId
	AND		device.DeviceId = mtd.DeviceId
	AND		(device.DeviceEnabled = 0 OR device.DeviceBroken = 1)
IF @r_RetCode != 0
	BEGIN
SET @l_FullReason = 42017
		GOTO VOLUME_FULL_EXIT
	END
	DECLARE @tblMountPaths TABLE
	(
		MaxConcurrentWriters	int,
		MagneticSpaceRsrvInMB	bigint,
		FreeBytesMB				bigint,
		IsOffline					int
	)
	INSERT	INTO @tblMountPaths
	SELECT	a.MaxConcurrentWriters, a.MagneticSpaceRsrvInMB, b.FreeBytesMB, a.IsOffline
	FROM	MMMountPath a WITH (NOLOCK), MMMediaSide b WITH (NOLOCK)
	WHERE	a.MediaSideId = b.MediaSideId
		AND b.MediaId = @r_MediaId AND a.IsEnabled > 0
	SELECT	@l_MountPathsLeft = @@ROWCOUNT
	IF	@l_MountPathsLeft <= 0
	BEGIN
SET @r_RetCode = 395
SET @l_FullReason = 42006
		GOTO VOLUME_FULL_EXIT
	END
	DELETE	@tblMountPaths
	WHERE		IsOffline > 0
	SELECT	@l_MountPathsLeft = @l_MountPathsLeft - @@ROWCOUNT
	IF	@l_MountPathsLeft <= 0
	BEGIN
SET @r_RetCode = 312
SET @l_FullReason = 42017
		GOTO VOLUME_FULL_EXIT
	END
	DELETE	@tblMountPaths
	WHERE	MagneticSpaceRsrvInMB >= FreeBytesMB
	SELECT	@l_MountPathsLeft = @l_MountPathsLeft - @@ROWCOUNT
	IF	@l_MountPathsLeft <= 0
	BEGIN
SET @r_RetCode = 20009
SET @l_FullReason = 42010
		GOTO VOLUME_FULL_EXIT
	END
	DELETE	@tblMountPaths
	WHERE	MaxConcurrentWriters = 0
	SELECT	@l_MountPathsLeft = @l_MountPathsLeft - @@ROWCOUNT
	IF	@l_MountPathsLeft > 0 AND EXISTS (SELECT * FROM @tblMountPaths WHERE MaxConcurrentWriters > 0)
	BEGIN
		SELECT	@l_MaxConcurrentWriters = COUNT(JobId_l)
		FROM	MMResourceToJob WITH (NOLOCK)
		WHERE	ReservationType = 2
			AND ReservationId IN (SELECT ReservationId FROM MMResource WITH (NOLOCK) WHERE MediaId = @r_MediaId)
		DELETE	@tblMountPaths
		WHERE	MaxConcurrentWriters > 0 AND MaxConcurrentWriters <= @l_MaxConcurrentWriters
		SELECT	@l_MountPathsLeft = @l_MountPathsLeft - @@ROWCOUNT
	END
	IF @l_MountPathsLeft <= 0
	BEGIN
SET @r_RetCode = 297
SET @l_FullReason = 42024
		GOTO VOLUME_FULL_EXIT
	END
	-- cliu, check whether current volume physical space reaches the magnetic volume high wartermark in MMConfigs table
	DECLARE @l_MagVolHighWaterMark	int
	SELECT	@l_MagVolHighWaterMark = ISNULL(Value, 0)
	FROM	MMConfigs WITH (NOLOCK)
	WHERE	Name = 'MMS2_CONFIG_MAGNETIC_VOLUME_SIZE_WATERMARK_GB'
	DECLARE @l_MagVolPhysicalSpaceGB	int
	SELECT	@l_MagVolPhysicalSpaceGB = PhysicalBytesMB / 1024
	FROM	MMVolume WITH (NOLOCK)
	WHERE	VolumeId = @r_VolumeId
	IF (@l_MagVolHighWaterMark > 0) AND (@l_MagVolHighWaterMark <= @l_MagVolPhysicalSpaceGB)
	BEGIN
SET @r_RetCode = 20053
SET @l_FullReason = 42039
		GOTO VOLUME_FULL_EXIT
	END
END
ELSE
BEGIN
IF	@l_LibraryTypeId NOT IN (4, 5)
	BEGIN
		IF	@l_MediaLocation NOT IN (1, 2)
			OR (@l_MediaLocation = 1 AND EXISTS (SELECT * FROM MMSlot WITH (NOLOCK) WHERE MediaId = @r_MediaId AND SlotType = 2))
		BEGIN
SET @r_RetCode = 273
SET @l_FullReason = 42003
IF (@l_LibraryAttribute & 128) = 0
				GOTO DONE_EXIT
			ELSE
				GOTO VOLUME_FULL_EXIT
		END
		ELSE
		IF	(@l_MediaLocation = 1 AND NOT EXISTS (SELECT * FROM MMSlot WITH (NOLOCK)
				WHERE MediaId = @r_MediaId AND SlotType = 1)
		 OR  @l_MediaLocation = 2 AND NOT EXISTS
			(
				SELECT *
				FROM MMDrive DRV WITH (NOLOCK), MMDriveController DRVCTRL WITH (NOLOCK),
						MMHost HOST WITH (NOLOCK)
				WHERE DRV.MediaId = @r_MediaId AND DRV.DriveSoftState = 1 AND
						DRV.DriveEnabled = 1 AND DRV.DriveBroken = 0 AND DRV.MountStatus != 4
				AND DRV.DriveId = DRVCTRL.DriveId AND DRVCTRL.DriveControllerSoftState = 1
				AND DRVCTRL.DriveControllerEnabled = 1 AND DRVCTRL.DriveAccessible = 1
				AND DRVCTRL.ClientId = HOST.ClientId AND HOST.MmHostSoftState = 1 AND MmHostEnabled = 1
			))
		BEGIN
SET @r_RetCode = 819
SET @l_FullReason = 42004
			GOTO VOLUME_FULL_EXIT
		END
	END
	IF	EXISTS (SELECT * FROM MMSlot WITH (NOLOCK)
WHERE BarCode = @l_Barcode AND (MediaStatus & 1) > 0)
	BEGIN
SET @r_RetCode = 409
SET @l_FullReason = 42030
	END
	ELSE
IF	( ((@l_Attributes & 1) > 0) AND
((@l_LibraryAttribute & 32768) = 0) )
	BEGIN
SET @r_RetCode = 20008
SET @l_FullReason = 42018
	END
	ELSE
IF	(@l_Attributes & 536870912) > 0
	BEGIN
SET @r_RetCode = 20041
SET @l_FullReason = 42035
	END
	ELSE
	IF	@l_VolumeState = 2 /*VOLUME_STUCK = 2*/
	BEGIN
SET @r_RetCode = 819
SET @l_FullReason = 42004
	END
END
VOLUME_FULL_EXIT:
IF	@l_FullReason != 0
BEGIN
	-- mark media full
	EXEC MMS2SETVolumeFull @r_VolumeId, @l_LogEvent OUTPUT, @l_FullReason, @i_JobId, 0, 0
	SET @r_MediaId = 0
	SET @r_VolumeId = 0
	SET @r_ScheduleRunId = 0
END
DONE_EXIT:
IF (@isQuickMR = 1 AND @r_retcode = 0 AND @r_volumeId > 0)
BEGIN
	UPDATE MMVolume
	SET MediaGroupId = @i_MediaGroupId
	WHERE VolumeId = @r_volumeId
		AND MediaGroupId = @mediaGroupSrc
END
SELECT @r_RetCode, @r_VolumeId, @r_MediaId, @r_ScheduleRunId
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetCurrentVolForMG')
	delete from GxQscripts where name = 'MMS2GetCurrentVolForMG'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetCurrentVolForMG')
	delete from GXDBVersions where aliasname = 'MMS2GetCurrentVolForMG'
GO

insert into GXDBVersions values(2, 'MMS2GetCurrentVolForMG',  '00010033004400060000', 'MMS2GetCurrentVolForMG', '00010033004400060000')
GO

