

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetContainersList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetContainersList.sp,v $ $Id: MMS2GetContainersList.sp,v 1.13.74.2 2018/03/20 20:02:13 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetContainersList <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetContainersList')
	drop procedure MMS2GetContainersList
IF EXISTS (select * from GxQscripts where name='MMS2GetContainersList')
	delete from GxQscripts where name = 'MMS2GetContainersList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetContainersList')
	delete from GXDBVersions where aliasname = 'MMS2GetContainersList'
GO
print '... Creating Procedure: MMS2GetContainersList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetContainersList
  @dummyInput integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_ContainerId integer
  DECLARE @o_ContainerName NVARCHAR(255)
  DECLARE @o_flag integer
  DECLARE @o_Capacity integer
  DECLARE @o_Description NVARCHAR(3072)
  DECLARE @o_TrackingId NVARCHAR(255)
  DECLARE @o_MediaatypeId integer
  DECLARE @o_MediaTypeName char(255)
  DECLARE @o_isClaeningMedia integer
  DECLARE @o_numSides integer
  DECLARE @o_numMedia integer
  DECLARE @o_dueBackDate varchar(255)
  DECLARE @o_dueBackDateInt bigint
  DECLARE @o_sidbStoreId integer
  DECLARE @o_sidbStoreName char(255)
	create table #tmpContainer (containerId integer,
					mediacount integer,
					DueBackDate bigint)
	declare @filter integer
	if @dummyInput > 0
		set @filter = 1
	else
		set @filter = 0
	insert into #tmpContainer
	select MC.containerId, count(M.MediaId), max(coalesce(nullif(isnull(M.retentionExpireTime,0), -1),  2147483647))
	from MMContainer MC LEFT OUTER JOIN MMMedia M ON M.ContainerId = MC.ContainerId
where MC.containerId > 0 and (@filter = 0 or @filter = 1 and MC.Flag <> 1)
	group by MC.ContainerId
	select Mc.ContainerId, MC.Containername, MC.Flag, MC.Capacity, MC.Descript, MC.TrackingId,
	MC.MediaType, isnull((select MediaTypeName from MMMediaType where MediaTypeId = MC.MediaType AND MediaTypeId > 0), 'Not Applicable'),
	isnull((select IsCleaningMedia from MMMediaType where MediaTypeId = MC.MediaType AND MediaTypeId > 0), 0),
	isnull((select NumberOfSides from MMMediaType where MediaTypeId = MC.MediaType AND MediaTypeId > 0), 0),
	tc.mediacount, dbo.GetDateTimeBig(tC.DueBackDate), tC.DueBackDate, MC.sidbStoreId,
	isnull((select SIDBStoreName from IdxSIDBStore where SIDBStoreId = MC.SIDBStoreId), '')
	from MMContainer as MC, #tmpContainer tc
	where MC.ContainerId > 0
	and MC.ContainerId = tc.ContainerId
	drop table #tmpcontainer
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetContainersList')
	delete from GxQscripts where name = 'MMS2GetContainersList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetContainersList')
	delete from GXDBVersions where aliasname = 'MMS2GetContainersList'
GO

insert into GXDBVersions values(2, 'MMS2GetContainersList',  '00010013007400020000', 'MMS2GetContainersList', '00010013007400020000')
GO

