

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetCompleteSlotView.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetCompleteSlotView.sp,v $ $Id: MMS2GetCompleteSlotView.sp,v 1.2.294.2 2018/03/20 19:54:13 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "archCopyForDataPathUpdate"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetCompleteSlotView <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetCompleteSlotView')
	drop procedure MMS2GetCompleteSlotView
IF EXISTS (select * from GxQscripts where name='MMS2GetCompleteSlotView')
	delete from GxQscripts where name = 'MMS2GetCompleteSlotView'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetCompleteSlotView')
	delete from GXDBVersions where aliasname = 'MMS2GetCompleteSlotView'
GO
print '... Creating Procedure: MMS2GetCompleteSlotView'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetCompleteSlotView
  @i_libraryId integer,
  @i_slotTypeFilter integer
AS
-- SlottypeFilter: 0 show all
-- 								 1 show only regular
--					 			 2 show only IE
--							1+2=3 show both regular and IE
  DECLARE @o_slotId integer
  DECLARE @o_slotName char(255)
  DECLARE @o_BarCode char(255)
  DECLARE @o_mediaId integer
  DECLARE @o_isOccupied integer
  DECLARE @o_ElementAddress integer
  DECLARE @o_slotType integer
  DECLARE @o_driveId integer
  DECLARE @o_driveName NVARCHAR(255)
	declare @l_bayId integer
	set @l_bayId = (select BayId from MMBay where LibraryId = @i_libraryId)
	IF object_id('tempdb.dbo.#tmpMasterPool') is not null DROP TABLE #tmpMasterPool
	IF object_id('tempdb.dbo.#tmpSlot') is not null DROP TABLE #tmpSlot
	create table #tmpMasterPool(masterPoolId	integer)
	create table #tmpSlot(	slotId		integer,
				slotName	varchar(256),
				BarCode		varchar(256),
				mediaId		integer,
				isOccupied	integer,
				elementAddress	integer,
				slotType	integer,
				driveId		integer,
				driveName	varchar(256))
	insert into #tmpSlot
	select slotId, slotName, BarCode, mediaId, isOccupied, ElementAddress, SlotType, 0, ''
	from MMSlot
	where 	bayId = @l_bayId and
		(		@i_slotTypeFilter = 0 or
				(SlotType = 1 AND (@i_slotTypeFilter & 1) > 0) OR
				(SlotType > 1 AND (@i_slotTypeFilter & 2) > 0)
		)
		-- 2 - regular IE port, 3 - ASCLS IE port
	insert into #tmpMasterPool
	select MasterPoolId from MMMasterPool where LibraryId = @i_libraryId
	update #tmpSlot
	set MediaId = MD.MediaId, DriveId = MD.DriveId, DriveName = MD.AliasName
	from #tmpSlot as tt, MMDrive as MD, MMMedia as MM
	where tt.ElementAddress = MD.SlotElementAddress and MD.MasterPoolId
	in(select MasterPoolId from #tmpMasterPool)
	update #tmpSlot
	set BarCode = MM.BarCode
	from #tmpSlot as tt, MMMedia as MM
	where tt.MediaId = MM.MediaId and tt.MediaId > 0 and tt.BarCode='' AND (tt.isOccupied = 1 or tt.DriveId > 0)
	select slotId, slotName, BarCode, MediaId, isOccupied, elementAddress, slotType,
	driveId, DriveName
	from #tmpSlot
	drop table #tmpSlot
	drop table #tmpMasterPool
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetCompleteSlotView')
	delete from GxQscripts where name = 'MMS2GetCompleteSlotView'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetCompleteSlotView')
	delete from GXDBVersions where aliasname = 'MMS2GetCompleteSlotView'
GO

insert into GXDBVersions values(2, 'MMS2GetCompleteSlotView',  '00010002029400020000', 'MMS2GetCompleteSlotView', '00010002029400020000')
GO

