

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetCloudLibArchiveMountPath.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetCloudLibArchiveMountPath.sp,v $ $Id: MMS2GetCloudLibArchiveMountPath.sp,v 1.1.2.2.14.2 2021/05/12 22:31:16 rsivadas Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMS2GetCloudLibArchiveMountPath')
BEGIN
	print '>>> Drop Stored Procedure: MMS2GetCloudLibArchiveMountPath <<<'
	drop procedure MMS2GetCloudLibArchiveMountPath
END
IF EXISTS (select * from GxQscripts where name='MMS2GetCloudLibArchiveMountPath')
	delete from GxQscripts where name = 'MMS2GetCloudLibArchiveMountPath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetCloudLibArchiveMountPath')
	delete from GXDBVersions where aliasname = 'MMS2GetCloudLibArchiveMountPath'
GO
print '... Creating Procedure: MMS2GetCloudLibArchiveMountPath'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMS2GetCloudLibArchiveMountPath
  @i_libraryId integer = 0
AS
  DECLARE @o_archStorageExists integer = 0
  DECLARE @o_combinedTier integer = 0
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#tmpArchNumDevType') is not null DROP TABLE #tmpArchNumDevType
CREATE TABLE #tmpArchNumDevType(
	DeviceId		INTEGER,
	ArchiveNumber	INTEGER,
	DeviceTypeId	INTEGER,
	LibraryId		INTEGER
)
INSERT INTO #tmpArchNumDevType
SELECT MDC.DeviceId,
	CASE WHEN MDC.UserName LIKE '%@%//%' THEN
		CAST(SUBSTRING(MDC.UserName, CHARINDEX('@', MDC.UserName, 0)+1, PATINDEX(N'%[^0-9]%',RIGHT(MDC.UserName, LEN(MDC.UserName) - CHARINDEX('@', MDC.UserName, 0)))-1) AS int)
	ELSE
		0
	END AS ArchiveNumber,
	MD.DeviceTypeId,
	MP.LibraryId
FROM MMDeviceController MDC WITH (READUNCOMMITTED)
	INNER JOIN MMDevice MD WITH (READUNCOMMITTED) ON MD.DeviceId = MDC.DeviceId
	INNER JOIN MMMountPathToStorageDevice MPSD WITH (READUNCOMMITTED) ON MPSD.DeviceId = MD.DeviceId
	INNER JOIN MMMountPath MP WITH (READUNCOMMITTED) ON MP.MountPathId = MPSD.MountPathId
WHERE ((MDC.UserName like '%@%//%'AND MD.DeviceTypeId in (23, 2, 3)) OR (MD.DeviceTypeId in (22, 28,
53)))
	AND MP.LibraryId = @i_libraryId
--
-- Check for direct archive
--
IF EXISTS (SELECT DISTINCT 1 FROM #tmpArchNumDevType TMP WITH (READUNCOMMITTED)
WHERE ((TMP.ArchiveNumber = 8 AND TMP.DeviceTypeId = 23)
OR ((TMP.ArchiveNumber = 8 OR TMP.ArchiveNumber = 16) AND TMP.DeviceTypeId = 2)
OR (TMP.ArchiveNumber = 3 AND TMP.DeviceTypeId = 3)
OR (TMP.DeviceTypeId = 28)
OR (TMP.DeviceTypeId = 22
OR (TMP.DeviceTypeId = 53)))
			AND TMP.LibraryId = @i_libraryId
	)
SET @o_archStorageExists = 1
--
-- Check for combined tier
--
IF EXISTS (SELECT DISTINCT 1 FROM #tmpArchNumDevType TMP WITH (READUNCOMMITTED)
WHERE ((TMP.ArchiveNumber > 8 AND TMP.DeviceTypeId = 23)
OR (TMP.ArchiveNumber > 8 AND TMP.ArchiveNumber <> 16 AND TMP.DeviceTypeId = 2)
OR ((TMP.ArchiveNumber = 4 OR TMP.ArchiveNumber = 5) AND TMP.DeviceTypeId = 3))
			AND TMP.LibraryId = @i_libraryId
	)
BEGIN
	SET @o_combinedTier = 1
	SET @o_archStorageExists = 1
END
IF OBJECT_ID('tempdb.dbo.#tmpArchNumDevType') is not null DROP TABLE #tmpArchNumDevType
SELECT @o_archStorageExists, @o_combinedTier
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetCloudLibArchiveMountPath')
	delete from GxQscripts where name = 'MMS2GetCloudLibArchiveMountPath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetCloudLibArchiveMountPath')
	delete from GXDBVersions where aliasname = 'MMS2GetCloudLibArchiveMountPath'
GO

insert into GXDBVersions values(2, 'MMS2GetCloudLibArchiveMountPath',  'v1.1.2.2.14.2', 'MMS2GetCloudLibArchiveMountPath', 'v1.1.2.2.14.2')
GO

