

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetCacheMountExpiredDriveList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetCacheMountExpiredDriveList.sp,v $ $Id: MMS2GetCacheMountExpiredDriveList.sp,v 1.3.274.1 2018/03/20 19:43:33 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetCacheMountExpiredDriveList <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetCacheMountExpiredDriveList')
	drop procedure MMS2GetCacheMountExpiredDriveList
IF EXISTS (select * from GxQscripts where name='MMS2GetCacheMountExpiredDriveList')
	delete from GxQscripts where name = 'MMS2GetCacheMountExpiredDriveList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetCacheMountExpiredDriveList')
	delete from GXDBVersions where aliasname = 'MMS2GetCacheMountExpiredDriveList'
GO
print '... Creating Procedure: MMS2GetCacheMountExpiredDriveList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetCacheMountExpiredDriveList
  @CommCellId integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @DriveId integer	
  DECLARE @DriveSoftState integer
  DECLARE @DriveEnabled integer
  DECLARE @DriveBroken integer
  DECLARE @CleaningRequired integer
  DECLARE @DriveOccupied integer
  DECLARE @MediaId integer
  DECLARE @MasterPoolId integer	
  DECLARE @VolumeId integer
  DECLARE @MountStatus integer
SELECT	D.DriveId,
		D.DriveSoftState,
		D.DriveEnabled,
		D.DriveBroken,
		D.CleaningRequired,
		D.DriveOccupied,
		D.MediaId,
		D.MasterPoolId,
		D.VolumeId,
		D.MountStatus
FROM	MMDrive D WITH (NOLOCK),
		(SELECT	DISTINCT MP.MasterPoolId, L.CacheMountPeriodInSec
		FROM	MMLibrary as L WITH (NOLOCK), MMMasterPool as MP WITH (NOLOCK)
		WHERE	L.LibraryId = MP.LibraryId
			AND L.LibraryId > 0 AND L.CacheMountPeriodInSec > 0  AND L.LibraryEnabled = 1 AND L.LibrarySoftState =1) as tt
WHERE	D.MasterPoolId = tt.MasterPoolId
	AND D.DriveId > 0
	AND D.DriveTypeId <> 10001
	AND D.VolumeId > 0
	AND D.MountStatus > 0
	AND (D.Attributes & 32) = 0
	AND D.LastLogicalUnmountTime <> 0
	AND D.LastLogicalUnmountTime < (datediff(second, '01/01/1970', getutcdate()) - tt.CacheMountPeriodInSec)
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetCacheMountExpiredDriveList')
	delete from GxQscripts where name = 'MMS2GetCacheMountExpiredDriveList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetCacheMountExpiredDriveList')
	delete from GXDBVersions where aliasname = 'MMS2GetCacheMountExpiredDriveList'
GO

insert into GXDBVersions values(2, 'MMS2GetCacheMountExpiredDriveList',  '00010003027400010000', 'MMS2GetCacheMountExpiredDriveList', '00010003027400010000')
GO

