

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetAvailableDrivesNotReserved.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2005  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetAvailableDrivesNotReserved.sp,v $ $Id: MMS2GetAvailableDrivesNotReserved.sp,v 1.1.292.1 2018/03/19 23:56:48 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetAvailableDrivesNotReserved <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetAvailableDrivesNotReserved')
	drop procedure MMS2GetAvailableDrivesNotReserved
IF EXISTS (select * from GxQscripts where name='MMS2GetAvailableDrivesNotReserved')
	delete from GxQscripts where name = 'MMS2GetAvailableDrivesNotReserved'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetAvailableDrivesNotReserved')
	delete from GXDBVersions where aliasname = 'MMS2GetAvailableDrivesNotReserved'
GO
print '... Creating Procedure: MMS2GetAvailableDrivesNotReserved'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetAvailableDrivesNotReserved
  @i_copyId integer,
  @i_streamNumber integer,
  @i_resType integer,
  @i_masterPoolId integer,
  @i_drivePoolId integer,
  @i_ignoreCleaningMedia integer
AS
  DECLARE @o_DriveId integer;
  DECLARE @o_DriveTypeId integer	;	
  DECLARE @o_MountStatus integer;
  DECLARE @o_Attributes integer;
	DECLARE @lt_DrivesToReturn TABLE (driveId			Integer,
																		driveTypeId Integer,
																		mountStatus Integer,
																		Attributes	Integer,
																		mediaId			Integer,
																		lastusetime Integer,
																		sortorder		Integer)
	INSERT INTO @lt_DrivesToReturn
	SELECT driveId, driveTypeId, mountStatus, Attributes, MediaId, lastusetime, 0
	FROM MMDrive WITH (NOLOCK)
	WHERE
		DriveId not in
	  (select DriveId from MMResource WITH (NOLOCK) where DriveId <> 0)
	AND DriveId in
	  (		select DC.DriveId
		    from 	MMDriveController as DC WITH (NOLOCK)
		    where DC.DrivePoolId = @i_drivePoolId AND
					    DC.DriveControllerSoftState = 1 AND
					    DC.DriveControllerEnabled = 1 AND
					    DC.DriveAccessible = 1
	  )
	AND MasterPoolId = @i_masterPoolId AND DriveSoftState = 1
	AND DriveEnabled = 1 AND DriveBroken = 0
	-- all of the above WHERE clause was copy pasted from the corresponding MMDbInterface function.
	AND (@i_ignoreCleaningMedia = 1 OR (@i_ignoreCleaningMedia = 0 and CleaningRequired = 0))
	-- AND (@i_ignoreCleaningMedia = 1 OR @i_ignoreCleaningMedia = CleaningRequired )
	-- the above AND clause emulates this code:
	--if (ignoreCleaningMedia == true)
	-- {
	--		snprintf (where, sizeof (where) - 1,
	--				"PERCENTs", tempWhere);
	--	}
	--	else
	--	{
	--		snprintf (where, sizeof (where) - 1,
	--				"PERCENTs AND CleaningRequired = PERCENTd", tempWhere, false);
	--	}
	DECLARE @l_useAppendibleMedia Integer
	SELECT @l_useAppendibleMedia = LibraryAttribute & 512
	FROM MMLibrary L INNER JOIN MMMasterPool MP ON L.LibraryId = MP.LibraryId
	WHERE MP.MasterPoolId = @i_masterPoolId
	DECLARE @lt_drivesortOrder TABLE (DriveId Integer, sortOrder Integer Identity(1,1))
	INSERT INTO @lt_drivesortOrder  (DriveId)
	SELECT dd.driveId
	FROM @lt_DrivesToReturn  dd LEFT OUTER JOIN MMVolume V WITH (NOLOCK)
	                                   ON   V.MediaId = dd.MediaId AND
	                                        @i_resType = 2 AND V.VolumeFlags in (1,5,7) AND
	                                        dd.MediaId > 0
							LEFT OUTER JOIN archstream ASt WITH (NOLOCK)
							       ON   ASt.MediaGroupId = V.mediaGroupId AND
							            ASt.archgroupcopyId = @i_copyId AND
							               Ast.stream = @i_streamNumber
							LEFT OUTER JOIN MMMedia M WITH (NOLOCK)
							        ON M.MediaId = dd.MediaId AND M.MediaId > 0
	ORDER BY
	  -- prefer empty drives for reads or if reservation type is not known
	  ( case when dd.mediaId = 0 and @i_resType <> 2 then 0 else 1 end),
	  -- prefer active media which belongs to the current media group
	  ( case when @i_resType = 2 and @i_copyId > 0 and M.MediaFlags = 1 and
	              V.VolumeFlags = 1 AND M.IsInMediaGroup = 1  AND
	              ASt.MediagroupId is not null
	    then 0 else 1 end ),
	  -- prefer appendable media if library option is set and media is from correct stream
	  ( case when @i_resType = 2 and @i_copyId > 0 and M.MediaFlags = 1 AND
	              V.VolumeFlags = 7 and @l_useAppendibleMedia > 0 and
	              M.IsInMediaGroup = 1 and
	              ASt.MediagroupId is not null
	    then 0 else 1 end ),
	  -- prefer spare media if writeable
	  ( case when @i_resType = 2 and M.MediaFlags = 1 and M.IsInMediaGroup = 0 then 0 else 1 end ),
	  -- prefer empty drives for writes if none of the other media in the other drives is useable
	  ( case when dd.mediaId = 0 and @i_resType = 2 then 0 else 1 end),
	  -- otherwise sort by lastusetime
	  dd.lastusetime
	UPDATE	@lt_DrivesToReturn
	SET sortOrder = A.minSortOrder
	FROM @lt_DrivesToReturn dd,
	    (
		    SELECT so.driveId, min(so.sortOrder) as minSortOrder
		    FROM @lt_drivesortOrder so
		    GROUP BY so.driveId
		    -- the group by stuff we need to do for optical....
	    ) A
	WHERE A.driveId = dd.driveId
	SELECT DriveId, DriveTypeId, MountStatus, Attributes
	FROM @lt_DrivesToReturn
	ORDER BY sortOrder
return;
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetAvailableDrivesNotReserved')
	delete from GxQscripts where name = 'MMS2GetAvailableDrivesNotReserved'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetAvailableDrivesNotReserved')
	delete from GXDBVersions where aliasname = 'MMS2GetAvailableDrivesNotReserved'
GO

insert into GXDBVersions values(2, 'MMS2GetAvailableDrivesNotReserved',  '00010001029200010000', 'MMS2GetAvailableDrivesNotReserved', '00010001029200010000')
GO

