

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetActiveDataPathByJobId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2005  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetActiveDataPathByJobId.sp,v $ $Id: MMS2GetActiveDataPathByJobId.sp,v 1.5.208.1 2018/03/20 20:05:28 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetActiveDataPathByJobId <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetActiveDataPathByJobId')
	drop procedure MMS2GetActiveDataPathByJobId
IF EXISTS (select * from GxQscripts where name='MMS2GetActiveDataPathByJobId')
	delete from GxQscripts where name = 'MMS2GetActiveDataPathByJobId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetActiveDataPathByJobId')
	delete from GXDBVersions where aliasname = 'MMS2GetActiveDataPathByJobId'
GO
print '... Creating Procedure: MMS2GetActiveDataPathByJobId'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetActiveDataPathByJobId
  @i_JobId_l int,
  @i_JobId_h int,
  @i_CopyId int
AS
  DECLARE @o_DataPathId integer;
  DECLARE @o_ErrorCodeVal integer;
DECLARE @r_DataPathId		integer
DECLARE @r_ErrorCode 		integer
SET @r_DataPathId = 0
SET @r_ErrorCode  = 0
DECLARE @l_tmpCandidates table (id Integer IDENTITY, dataPathId Integer, isDefault Integer)
DECLARE @l_NumtmpCandidates INTEGER
-- get all enabled datapaths
INSERT INTO @l_tmpCandidates (dataPathId, isDefault)
SELECT	DPath.DataPathId, DPath.Flag & 1
FROM		MMDataPath AS DPath, IDXAccessPath as IAP, IdxCache as IC, MMDrivePool AS H2DP, MMHost AS H
WHERE		DPath.CopyId = @i_CopyId and ((DPath.Flag & 4) = 4) AND DPath.DrivePoolId = H2DP.DrivePoolId AND
			H2DP.ClientId = IAP.ClientId AND
			IAP.Softstate = 1 AND IAP.Enabled = 1 AND IAP.IdxCacheId = IC.IdxCacheId AND
			IC.Softstate = 1 AND IC.Enabled = 1 AND
			H2DP.ClientId = H.ClientId AND H.MmHostSoftState = 1 AND H.MmHostEnabled = 1
ORDER BY DPath.Flag Desc, DPath.Priority
SET @l_NumtmpCandidates = @@ROWCOUNT
IF (@l_NumtmpCandidates = 0)
BEGIN
	-- get default DP
	INSERT INTO @l_tmpCandidates (dataPathId, isDefault)
	SELECT DataPathId, 1 FROM MMDataPath WHERE CopyId = @i_CopyId AND (Flag & 1) = 1
	SET @l_NumtmpCandidates = @@ROWCOUNT
	IF (@l_NumtmpCandidates = 0)
	BEGIN
		SET  @r_ErrorCode 	 = 323
		-- No failover candidate
		GOTO EXITWITHERROR
	END
	SET @r_DataPathId = (SELECT TOP 1 DataPathId FROM @l_tmpCandidates)
	GOTO EXITOK
END
-- now here is the difference between getActiveCandidate and getActiveCandidateByJobId
--   getActiveCandidateByJobId returns the dp round robined
--   getActiveCandidate returns the default if available, if not, the first entry in the list
SET @r_DataPathId =
		(
			SELECT DataPathId FROM @l_tmpCandidates WHERE id =
			CASE
				WHEN ((@i_JobId_l <> 0) OR (@i_JobId_h<>0)) then (@i_JobId_l%@l_NumtmpCandidates)+1
				ELSE ISNULL( (SELECT TOP 1 Id FROM @l_tmpCandidates WHERE isDefault = 1), 1 )
			END
		)
EXITOK:
EXITWITHERROR:
SELECT @r_DataPathId AS DataPathId, @r_ErrorCode AS ErrorCodeVal
return;
GO


IF EXISTS (select * from GxQscripts where name = 'MMS2GetActiveDataPathByJobId')
	delete from GxQscripts where name = 'MMS2GetActiveDataPathByJobId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetActiveDataPathByJobId')
	delete from GXDBVersions where aliasname = 'MMS2GetActiveDataPathByJobId'
GO

insert into GXDBVersions values(2, 'MMS2GetActiveDataPathByJobId',  '00010005020800010000', 'MMS2GetActiveDataPathByJobId', '00010005020800010000')
GO

