

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GetAGCsAssociatedWithMA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GetAGCsAssociatedWithMA.sp,v $ $Id: MMS2GetAGCsAssociatedWithMA.sp,v 1.4.194.3 2018/03/20 19:53:35 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2GetAGCsAssociatedWithMA"
--	|
--	| This is for getting a list of all storage policy and storage policy
--      | copies that are associated with an MA
--	|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GetAGCsAssociatedWithMA <<<'

IF EXISTS (select * from sysobjects where name='MMS2GetAGCsAssociatedWithMA')
	drop procedure MMS2GetAGCsAssociatedWithMA
IF EXISTS (select * from GxQscripts where name='MMS2GetAGCsAssociatedWithMA')
	delete from GxQscripts where name = 'MMS2GetAGCsAssociatedWithMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetAGCsAssociatedWithMA')
	delete from GXDBVersions where aliasname = 'MMS2GetAGCsAssociatedWithMA'
GO
print '... Creating Procedure: MMS2GetAGCsAssociatedWithMA'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GetAGCsAssociatedWithMA
  @hostClientId integer
AS
  DECLARE @archGroupId integer
  DECLARE @archGroupName NVARCHAR(255)
  DECLARE @archCopyId integer
  DECLARE @archCopyIdisAGDefault integer
  DECLARE @archGroupCopyName NVARCHAR(255)
  DECLARE @MAisDefaultDPath integer
  DECLARE @isNASProxyMA integer
  DECLARE @isMADedupeStoreHost integer
	declare @i_clientId	integer
	set 	@i_clientId = @hostClientId
	DECLARE  @showHiddenSPConfig INTEGER = 0
	----------------------------------------------
	-- Get 'MMCONFIG_SHOW_HIDDEN_STORAGE_POLICIES' value from MMConfigs
	----------------------------------------------
	SELECT @showHiddenSPConfig = value
    FROM    MMConfigs WITH (NOLOCK)
    WHERE NAME = 'MMCONFIG_SHOW_HIDDEN_STORAGE_POLICIES' AND nConfigSubSystemId = 1
	DECLARE @tmpCopies TABLE (copyId integer,
				 drivePoolId integer,
				 isDefaultDP integer,
				 DPType  integer )
	INSERT INTO @tmpCopies
	SELECT distinct MDP.CopyId, MDP.DrivePoolId, MDP.Flag & 1,  DP.DrivePoolType
	FROM   MMDataPath AS MDP WITH (NOLOCK), MMDrivePool AS DP WITH (NOLOCK)
	where  DP.ClientId = @i_clientId AND MDP.DrivePoolId = DP.DrivePoolId
	-- now get information only for the copies
	DECLARE @tmpCopies2 TABLE (	copyId integer,
					isDefCopy integer,
					MAisDefaultDataPath integer,
					isNASProxy integer,
					isMADedupeDBHost integer,
					archGroupCopyName NVARCHAR(255),
					archGroupId integer,
				    archGroupName NVARCHAR(255))
 	-- Filter out hidden storage policies base on MMConfig param
	INSERT INTO @tmpCopies2
	SELECT DISTINCT tc.copyId,
			-- following case statements gives 1 if this is the default copy
			case
			 	when (AG.defaultCopy = tc.CopyId and AG.id = AGC.archGroupId) then 1
	 			else 0
	 		end, 0,0,0,AGC.name,AG.id,AG.name
	FROM @tmpCopies AS tc, ArchGroup as AG WITH (NOLOCK), ArchGroupCopy as AGC WITH (NOLOCK)
	WHERE
( ((@showHiddenSPConfig = 0) AND (AG.flags & 64 = 0)) OR (@showHiddenSPConfig > 0))
	    AND AGC.id = tc.copyId AND AG.id = AGC.archGroupId
AND AG.type <> 4
AND AGC.type <> 5
	UPDATE @tmpCopies2
	SET MAisDefaultDataPath = 1
	WHERE CopyId IN
	(	SELECT CopyId FROM @tmpCopies
		WHERE isDefaultDP = 1
	)
	-- set NAS
	UPDATE @tmpCopies2
	SET isNASProxy = 1
	WHERE CopyId IN
	(
		SELECT CopyID FROM @tmpCopies
		WHERE DPType = 3
	)
	UPDATE @tmpCopies2
	SET isMADedupeDBHost = 1
	WHERE CopyId IN (SELECT DISTINCT A.CopyId FROM archCopySIDBStore A, IdxSIDBSubStore I
					WHERE I.SIDBStoreId = A.SIDBStoreId AND I.ClientId = @hostClientId)
	-- now return data
	SELECT 	archGroupId, archGroupName, copyId, isDefCopy, archGroupCopyName, MAisDefaultDataPath, isNASProxy, isMADedupeDBHost
	FROM 	@tmpCopies2  ORDER BY archGroupName
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GetAGCsAssociatedWithMA')
	delete from GxQscripts where name = 'MMS2GetAGCsAssociatedWithMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GetAGCsAssociatedWithMA')
	delete from GXDBVersions where aliasname = 'MMS2GetAGCsAssociatedWithMA'
GO

insert into GXDBVersions values(2, 'MMS2GetAGCsAssociatedWithMA',  '00010004019400030000', 'MMS2GetAGCsAssociatedWithMA', '00010004019400030000')
GO

