

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GUISP_getMediaList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GUISP_getMediaList.sp,v $ $Id: MMS2GUISP_getMediaList.sp,v 1.14.208.4 2018/05/23 12:11:28 shubhamagrawal Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						Cursor: "MMS2GUISP_getMediaList"								|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GUISP_getMediaList <<<'

IF EXISTS (select * from sysobjects where name='MMS2GUISP_getMediaList')
	drop procedure MMS2GUISP_getMediaList
IF EXISTS (select * from GxQscripts where name='MMS2GUISP_getMediaList')
	delete from GxQscripts where name = 'MMS2GUISP_getMediaList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GUISP_getMediaList')
	delete from GXDBVersions where aliasname = 'MMS2GUISP_getMediaList'
GO
print '... Creating Procedure: MMS2GUISP_getMediaList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GUISP_getMediaList
-- This creates the Media in Library view.
-- The following two lines indicate, in order, parameters that will be
--  expected in the "setValues()" method, as well as the order in which
--  they will be provided as arguments to the SQLSTRING command
  @i_LibraryId int
--	The next two lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
AS
  DECLARE @o_MediaId integer               																							
  DECLARE @o_BarCode char(255)
  DECLARE @o_UniqueId char(255)
  DECLARE @o_MediaLocation integer               																				
  DECLARE @o_ExportLocation NVARCHAR(255)
  DECLARE @o_MediaTypeId integer               																				
  DECLARE @o_MediaFlags integer               																				
  DECLARE @o_ExternalGUID char(255)
  DECLARE @o_IsCleaningMedia integer               																				
  DECLARE @o_MediaSideId integer               																				
  DECLARE @o_VolumeId integer               																				
  DECLARE @o_VolumeFlags integer               																				
  DECLARE @o_MediaStatus integer               																				
  DECLARE @o_slotId integer               																				
  DECLARE @o_slotName char(255)
  DECLARE @o_slotElementAddress integer               																				
  DECLARE @o_slotType integer               																				
  DECLARE @o_driveId integer               																				
  DECLARE @o_driveAliasName NVARCHAR(255)
  DECLARE @o_libraryId integer               																				
  DECLARE @o_libraryAliasName NVARCHAR(255)
  DECLARE @o_lastWriteLibraryId integer               																				
  DECLARE @o_lastWriteLibName NVARCHAR(255)
  DECLARE @o_containerId integer               																				
  DECLARE @o_containerName NVARCHAR(255)
  DECLARE @o_mediaAttributes integer               																				
  DECLARE @o_guiAttributes integer
  DECLARE @o_exportLocationId integer               																				
  DECLARE @o_archiveGroupId integer               																				
  DECLARE @o_archiveGroupName NVARCHAR(255)
  DECLARE @o_archiveGroupCopyId integer               																				
  DECLARE @o_archiveGroupCopyName NVARCHAR(255)
  DECLARE @o_spareGroupId integer               																				
  DECLARE @o_spareGroupName NVARCHAR(255)
  DECLARE @o_spareGroupType integer
  DECLARE @o_usageCounter integer               																				
  DECLARE @o_numberOfExtRetentionJobsOnMedia integer
  DECLARE @o_numberOfSoftErrors integer
  DECLARE @o_numberOfHardErrors integer
  DECLARE @o_isAged integer
  DECLARE @o_isInMediaGroup integer
  DECLARE @o_isPrimaryCopy integer
  DECLARE @o_archStreamNum integer
  DECLARE @o_lastWriteTime integer
  DECLARE @o_physicalBytesMB bigint
  DECLARE @o_extendedAttributes integer
  DECLARE @o_retentionExpireTime bigint
  DECLARE @o_mediaStatusReason integer
  DECLARE @o_creationTime integer
  DECLARE @o_lastExportTime integer
  DECLARE @o_mediaTypeName NVARCHAR(255)
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
	IF object_id('tempdb.dbo.#tmpMedList')  is not null DROP TABLE #tmpMedList
	create table #tmpMedList(
				mediaId				integer,
				BarCode				varchar(256),
				UniqueId			varchar(256),
				mediaLocation		integer,
				ExportLocation		nvarchar(256),
				MediaTypeId			integer,
				MediaFlags			integer,
				ExternalGUID		varchar(256),
				IsCleaningMedia		integer,
				MediaSideId			integer,
				VolumeId			integer,
				VolumeFlags			integer,
				mediaGroupId		integer,
				MediaStatus			integer,
				slotId				integer,
				slotName			varchar(256),
				slotElementAddress	integer,
				slotType			integer,
				driveId				integer,
				driveAliasName		nvarchar(256),
				libraryId			integer,
				libraryAliasName	nvarchar(256),
				lastWriteLibraryId	integer,
				lastWriteLibName	nvarchar(256),
				containerId			integer,
				containerName		nvarchar(256),
				mediaAttributes		integer,
				exportLocationId	integer,
				archiveGroupId		integer,
				archiveGroupName	nvarchar(256),
				archiveGroupCopyId	integer,
				archiveGroupCopyName nvarchar(256),
				spareGroupId		integer,
				spareGroupName		varchar(256),
				spareGroupType		integer,
				usageCounter		integer,
				numberOfExtRetentionJobsOnMedia integer,
				guiAttributes		integer,
				numberOfSoftErrors	integer,
				numberOfHardErrors	integer,
				isAged				integer,
				isInMediaGroup		integer,
				isPrimaryCopy		integer,
				archStreamNum		integer,
				lastWriteTime		integer,
				physicalBytesMB		bigint,
				extendedAttributes	integer,
				retentionExpireTime	bigint,
				mediaStatusReason	integer,
				creationTime		integer,
				lastExportTime		integer,
				mediaTypeName		nvarchar(256),
				primary key (mediaId, VolumeId)
				)
	insert into #tmpMedList
	SELECT DISTINCT M.MediaId, M.BarCode, M.UniqueId, M.MediaLocation,
	ME.ExportLocation,M.MediaTypeId,	M.MediaFlags,M.ExternalGUID,
	MT.IsCleaningMedia,V.MediaSideId,V.VolumeId,
	V.VolumeFlags, V.MediaGroupId, 0, 0, '', 0, 0, 0, '',
	LibraryId = M.LibraryId,
	LibraryName = (select AliasName from MMLibrary where LibraryId = M.LibraryId),
	lastWriteLibraryId = M.LastWriteLibraryId,
	lastWriteLibName = (select AliasName from MMLibrary where LibraryId = M.LastWriteLibraryId),
	mc.ContainerId, mc.ContainerName, M.attributes,
	M.ExportLocationId, 0, '', 0, '',
	M.SpareGroupId, MS.SpareGroupName, MS.spareGroupType, M.NumberOfReUses, M.retentionFlags, 0,
	MMS.NumberOfSoftErrors, MMS.NumberOfHardErrors, M.IsAged, M.IsInMediaGroup, 0, 0, M.LastBackupTime, 0,
	M.ExtendedAttributes,  M.retentionExpireTime, M.MediaStatusReason, M.CreationTime, M.LastExportTime,MT.MediaTypeName
	FROM 	MMMedia as M, MMMediaType as MT, MMExportLocation as ME,
	MMVolume as V, MMContainer as mc, MMSpareGroup as MS, MMMediaSide as MMS
	WHERE 	M.MediaTypeId = MT.MediaTypeId and M.ExportLocationId = ME.ExportLocationId and
	V.MediaId = M.MediaId and M.MediaLocation != 3 and
	M.LibraryId = @i_LibraryId and mc.ContainerId = m.containerId and M.MediaId > 0 and
	MS.SpareGroupId = M.SpareGroupId
	and MMS.MediaSideId = V.MediaSideId
	update #tmpMedList
	SET slotId = MS.SlotId, slotName = MS.SlotName, slotElementAddress = MS.ElementAddress,
	slotType = MS.SlotType
	from MMSlot as MS, #tmpMedList as tt
	where MS.MediaId = tt.MediaId
	update #tmpMedList
	SET driveId = MD.DriveId, driveAliasName = MD.AliasName
	from MMDrive as MD, #tmpMedList as tt
	where MD.MediaId = tt.MediaId
	-- duplicate barcode media has a mediaId so appears, but does not have a slot Id, get rid
	-- of these:
	delete from #tmpMedList
	where slotId = 0 and driveid=0
	-- now get the storage policy copy...
	update #tmpMedList
set archiveGroupCopyId = (case when (Ast.flags & 2) = 0 then Ast.ArchGroupCopyId else (select archGroupCopyId from archStream WITH (NOLOCK) where MediaGroupId = Ast.mediaGroupId and (flags & 2) = 0) end),
archiveGroupId = (case when (Ast.flags & 2) = 0 then Ast.ArchGroupId else (select archGroupId from archStream WITH (NOLOCK) where MediaGroupId = Ast.mediaGroupId and (flags & 2) = 0) end),
	archStreamNum = Ast.stream
	from ArchStream AS Ast
	where Ast.MediaGroupId = #tmpMedList .MediaGroupId
	update #tmpMedList
	set archiveGroupCopyName = AGC.name
	from archGroupCopy as AGC
	where AGC.id = #tmpMedList .archiveGroupCopyId AND #tmpMedList .archiveGroupCopyId > 0
	update #tmpMedList
	SET 	archiveGroupName = AG.name,
			isPrimaryCopy = CASE WHEN AG.defaultCopy = archiveGroupCopyId THEN 1 ELSE 0 END
	FROM 	archGroup as AG
	WHERE 	archiveGroupId > 0 and	#tmpMedList .archiveGroupId  = AG.Id
	-- add some safety for not-available spare groups
	update #tmpMedList
	SET	spareGroupId = 0, spareGroupName = ''
	WHERE   spareGroupId < 1
	-- get PhysicalBytes MB from MMMediaSide table
	UPDATE #tmpMedList
	set physicalBytesMB = (select sum(MS.PhysicalBytesMB)
	from MMMediaSide MS
	where #tmpMedList.mediaId = MS.mediaId)
	-- number of extended retention jobs will be passed as 0 for 6.1
	declare @sperr Integer
	exec @sperr = MMS2CalculateGUIMediaAttrEnBulk '#tmpMedList'
	select mediaId,BarCode, UniqueId, mediaLocation, ExportLocation, MediaTypeId,
	MediaFlags, ExternalGUID, IsCleaningMedia, MediaSideId, VolumeId,
	VolumeFlags, MediaStatus, slotId, slotName, slotElementAddress, slotType, driveId,
	driveAliasName, libraryId, libraryAliasName, lastWriteLibraryId,
	lastWriteLibName, containerId, containerName, mediaAttributes, guiAttributes, exportLocationId,
	archiveGroupId, archiveGroupName, archiveGroupCopyId, archiveGroupCopyName,
	spareGroupId, spareGroupName, spareGroupType, usageCounter, numberOfExtRetentionJobsOnMedia,
	numberOfSoftErrors, numberOfHardErrors, isAged, isInMediaGroup, isPrimaryCopy, archStreamNum, lastWriteTime, physicalBytesMB,
	extendedAttributes, retentionExpireTime, mediaStatusReason, creationTime, lastExportTime, mediaTypeName
	from #tmpMedList
	ORDER BY slotid, driveid
	drop table #tmpMedList
	return;
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GUISP_getMediaList')
	delete from GxQscripts where name = 'MMS2GUISP_getMediaList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GUISP_getMediaList')
	delete from GXDBVersions where aliasname = 'MMS2GUISP_getMediaList'
GO

insert into GXDBVersions values(2, 'MMS2GUISP_getMediaList',  '00010014020800040000', 'MMS2GUISP_getMediaList', '00010014020800040000')
GO

