

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GUISP_getMedByLastWriteLib.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GUISP_getMedByLastWriteLib.sp,v $ $Id: MMS2GUISP_getMedByLastWriteLib.sp,v 1.7.208.2 2018/03/20 20:01:00 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						Cursor: "MMS2GUISP_getMedByLastWriteLib"								|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GUISP_getMedByLastWriteLib <<<'

IF EXISTS (select * from sysobjects where name='MMS2GUISP_getMedByLastWriteLib')
	drop procedure MMS2GUISP_getMedByLastWriteLib
IF EXISTS (select * from GxQscripts where name='MMS2GUISP_getMedByLastWriteLib')
	delete from GxQscripts where name = 'MMS2GUISP_getMedByLastWriteLib'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GUISP_getMedByLastWriteLib')
	delete from GXDBVersions where aliasname = 'MMS2GUISP_getMedByLastWriteLib'
GO
print '... Creating Procedure: MMS2GUISP_getMedByLastWriteLib'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GUISP_getMedByLastWriteLib
  @i_LibraryId int
AS
  DECLARE @o_MediaId integer               
  DECLARE @o_BarCode char(255)
  DECLARE @o_UniqueId char(255)
  DECLARE @o_MediaLocation integer               
  DECLARE @o_ExportLocation NVARCHAR(255)
  DECLARE @o_MediaTypeId integer               
  DECLARE @o_MediaFlags integer               
  DECLARE @o_ExternalGUID char(255)
  DECLARE @o_IsCleaningMedia integer               
  DECLARE @o_MediaSideId integer               
  DECLARE @o_VolumeId integer               
  DECLARE @o_VolumeFlags integer               
  DECLARE @o_MediaStatus integer               
  DECLARE @o_slotId integer               
  DECLARE @o_slotName char(255)
  DECLARE @o_slotType integer               
  DECLARE @o_driveId integer               
  DECLARE @o_driveAliasName NVARCHAR(255)
  DECLARE @o_lastWriteLibraryId integer               
  DECLARE @o_lastWriteLibName NVARCHAR(255)
  DECLARE @o_libraryId integer	              
  DECLARE @o_libraryAliasName NVARCHAR(255)
  DECLARE @o_containerId integer               
  DECLARE @o_containerName NVARCHAR(255)
  DECLARE @o_mediaAttributes integer               
  DECLARE @o_guiAttributes integer
  DECLARE @o_exportLocationId integer               
  DECLARE @o_archiveGroupId integer               
  DECLARE @o_archiveGroupName NVARCHAR(255)
  DECLARE @o_archiveGroupCopyId integer               
  DECLARE @o_archiveGroupCopyName NVARCHAR(255)
  DECLARE @o_spareGroupId integer               
  DECLARE @o_spareGroupName NVARCHAR(255)
  DECLARE @o_spareGroupType integer
  DECLARE @o_usageCounter integer               
  DECLARE @o_numberOfExtRetentionJobsOnMedia integer    
  DECLARE @o_isAged integer    
  DECLARE @o_isInMediaGroup integer    
  DECLARE @o_isPrimaryCopy integer
  DECLARE @o_archStreamNum integer
	if object_id('tempdb.dbo.#tmpMediaSelect') is not null DROP TABLE #tmpMediaSelect
	create table #tmpMediaSelect(
					MediaId				integer primary key,
					archiveGroupId		integer,
					archiveGroupName	nvarchar(256),
					archiveGroupCopyId	integer,
					archiveGroupCopyName nvarchar(256),
					slotId				integer,
					guiAttributes		integer,
					mediaGroupId		integer,
					isPrimaryCopy		integer,
					archStreamNum		integer)
	INSERT INTO #tmpMediaSelect
	SELECT distinct M.MediaId, 0, '', 0, '', 0, 0,
	(select top 1 V.mediagroupId from MMVolume as V where V.MediaId = M.MediaId), 0, 0
	FROM MMMedia AS M
	WHERE 	M.MediaLocation != 3 and
		M.LibraryId <> @i_LibraryId and
		M.LastWriteLibraryId = @i_LibraryId
	update #tmpMediaSelect
	SET slotId = MS.SlotId
	FROM #tmpMediaSelect as tt, MMSlot as MS
	WHERE MS.MediaId = tt.MediaId
	update #tmpMediaSelect
set archiveGroupCopyId = (case when (Ast.flags & 2) = 0 then Ast.ArchGroupCopyId else (select archGroupCopyId from archStream WITH (NOLOCK) where MediaGroupId = Ast.mediaGroupId and (flags & 2) = 0) end),
archiveGroupId = (case when (Ast.flags & 2) = 0 then Ast.ArchGroupId else (select archGroupId from archStream WITH (NOLOCK) where MediaGroupId = Ast.mediaGroupId and (flags & 2) = 0) end),
archStreamNum = (case when (Ast.flags & 2) = 0 then Ast.stream else (select stream from archStream WITH (NOLOCK) where MediaGroupId = Ast.mediaGroupId and (flags & 2) = 0) end)
	from ArchStream AS Ast
	where Ast.MediaGroupId = #tmpMediaSelect.MediaGroupId
	update #tmpMediaSelect
	set archiveGroupCopyName = AGC.name
	from archGroupCopy as AGC
	where AGC.id = #tmpMediaSelect.archiveGroupCopyId AND #tmpMediaSelect.archiveGroupCopyId > 0
	update #tmpMediaSelect
	SET 	archiveGroupName = AG.name,
				isPrimaryCopy = CASE WHEN AG.defaultCopy = archiveGroupCopyId THEN 1 ELSE 0 END
	FROM 	archGroup as AG
	WHERE 	archiveGroupId > 0 and	#tmpMediaSelect.archiveGroupId  = AG.Id
	declare @sperr Integer
	exec @sperr = MMS2CalculateGUIMediaAttrEnBulk '#tmpMediaSelect'
	SELECT DISTINCT M.MediaId, M.BarCode, M.UniqueId, M.MediaLocation,
	ME.ExportLocation,M.MediaTypeId,	M.MediaFlags,M.ExternalGUID,
	MT.IsCleaningMedia,v.MediaSideId,V.VolumeId,
	V.VolumeFlags,
	msl.mediastatus,
	msl.SlotId,
	msl.slotname,
	msl.slotType as thisSlotId,
	driveid=(select top 1 driveid from MMDrive where mediaid = M.mediaid),
	drivename=(select top 1 aliasname from MMDrive where mediaid = M.mediaid),
	lastWriteLibraryId = M.LastWriteLibraryId,
	lastWriteLibName = (select aliasName from MMLibrary where libraryId = M.LastWriteLibraryId),
	libraryId = M.LibraryId,
	libraryAliasName = (select AliasName from MMLibrary where LibraryId = M.LibraryId),
	mc.ContainerId, mc.ContainerName, M.attributes, tt.guiAttributes, M.ExportLocationId,
	tt.archiveGroupId, tt.archiveGroupName, tt.archiveGroupCopyId, tt.archiveGroupCopyName,
	M.SpareGroupId, MS.SpareGroupName, MS.SpareGroupType, M.NumberOfReUses, M.retentionFlags,
	M.IsAged, M.IsInMediaGroup, tt.isPrimaryCopy, tt.archStreamNum
	FROM 	MMMedia as M, #tmpMediaSelect as tt, MMMediaType as MT, MMExportLocation as ME,
	MMVolume as V, MMContainer as mc, MMSpareGroup AS ms, MMSlot as MSL
	WHERE 	tt.MediaId = M.MediaId and
		M.MediaTypeId = MT.MediaTypeId and
		M.ExportLocationId = ME.ExportLocationId and
		V.MediaId = M.MediaId and
		mc.ContainerId = m.containerId and
		ms.SpareGroupId = m.SpareGroupId and
		msl.SlotId = tt.SlotId
	ORDER BY thisSlotId, driveid
	DROP TABLE #tmpMediaSelect
	return;
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GUISP_getMedByLastWriteLib')
	delete from GxQscripts where name = 'MMS2GUISP_getMedByLastWriteLib'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GUISP_getMedByLastWriteLib')
	delete from GXDBVersions where aliasname = 'MMS2GUISP_getMedByLastWriteLib'
GO

insert into GXDBVersions values(2, 'MMS2GUISP_getMedByLastWriteLib',  '00010007020800020000', 'MMS2GUISP_getMedByLastWriteLib', '00010007020800020000')
GO

