

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GUISP_getExportedMediaList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GUISP_getExportedMediaList.sp,v $ $Id: MMS2GUISP_getExportedMediaList.sp,v 1.20.180.5 2018/05/23 11:06:08 shubhamagrawal Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						Cursor: "MMS2GUISP_getExportedMediaList"								|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GUISP_getExportedMediaList <<<'

IF EXISTS (select * from sysobjects where name='MMS2GUISP_getExportedMediaList')
	drop procedure MMS2GUISP_getExportedMediaList
IF EXISTS (select * from GxQscripts where name='MMS2GUISP_getExportedMediaList')
	delete from GxQscripts where name = 'MMS2GUISP_getExportedMediaList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GUISP_getExportedMediaList')
	delete from GXDBVersions where aliasname = 'MMS2GUISP_getExportedMediaList'
GO
print '... Creating Procedure: MMS2GUISP_getExportedMediaList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GUISP_getExportedMediaList
  @i_LibraryId int
AS
  DECLARE @o_MediaId integer                  
  DECLARE @o_BarCode varchar(255)
  DECLARE @o_UniqueId varchar(255)
  DECLARE @o_ExportLocation NVARCHAR(255)
  DECLARE @o_MediaFlags integer
  DECLARE @o_ExternalGUID varchar(255)
  DECLARE @o_MediaTypeId integer
  DECLARE @o_MediaTypeName NVARCHAR(255)
  DECLARE @o_IsCleaningMedia integer
  DECLARE @o_VolumeId integer
  DECLARE @o_VolumeFlags integer
  DECLARE @o_libraryId integer
  DECLARE @o_libraryAliasName NVARCHAR(255)
  DECLARE @o_lastWriteLibraryId integer                  
  DECLARE @o_lastWriteLibName NVARCHAR(255)
  DECLARE @o_containerId integer
  DECLARE @o_containerName NVARCHAR(255)
  DECLARE @o_mediaAttributes integer                  
  DECLARE @o_guiAttributes integer
  DECLARE @o_exportLocationId integer                  
  DECLARE @o_archiveGroupId integer                  
  DECLARE @o_archiveGroupName NVARCHAR(255)
  DECLARE @o_archiveGroupCopyId integer                  
  DECLARE @o_archiveGroupCopyName NVARCHAR(255)
  DECLARE @o_spareGroupId integer                  
  DECLARE @o_spareGroupName NVARCHAR(255)
  DECLARE @o_spareGroupType integer
  DECLARE @o_usageCounter integer                  
  DECLARE @o_numberOfExtRetentionJobsOnMedia integer    
  DECLARE @o_numberOfSoftErrors integer
  DECLARE @o_numberOfHardErrors integer
  DECLARE @o_isAged integer
  DECLARE @o_isInMediaGroup integer
  DECLARE @o_isPrimaryCopy integer
  DECLARE @o_archStreamNum integer
  DECLARE @o_lastWriteTime integer
  DECLARE @o_physicalBytesMB bigint
  DECLARE @o_retentionExpireTime bigint
  DECLARE @o_mediaStatusReason integer
  DECLARE @o_creationTime integer
  DECLARE @o_lastExportTime integer
	if object_id('tempdb.dbo.#exportSGId') is not null DROP TABLE #exportSGId
	if object_id('tempdb.dbo.#exportMGId') is not null DROP TABLE #exportMGId
	if object_id('tempdb.dbo.#tmpMediaInfo') is not null DROP TABLE #tmpMediaInfo
	select SpareGroupId into #exportSGId
	from MMSpareGroup
	where LibraryId = @i_LibraryId
	select MMG.MediaGroupId, MV.MediaId into #exportMGId
	from MMMediaGroup as MMG, MMVolume as MV
	where MMG.SpareGroupId in (select SpareGroupId from #exportSGId)
	and MMG.MediaGroupId = MV.MediaGroupId and MV.MediaGroupId > 0
	create table #tmpMediaInfo(	MediaId		integer primary key,
					LibraryId	integer,
					AliasName	nvarchar(255),
					archiveGroupId	 integer,
					archiveGroupName nvarchar(256),
					archiveGroupCopyId integer,
					archiveGroupCopyName nvarchar(256),
					guiAttributes integer,
					numberOfExtRetentionJobsOnMedia integer,
					mediaGroupId Integer,
					isPrimaryCopy Integer,
					archStreamNum Integer,
					lastWriteTime		integer,
					physicalBytesMB		bigint,
                                        retentionExpireTime     bigint)
	insert into #tmpMediaInfo
	select MM.MediaId, ML.LibraryId, ML.AliasName, 0, '', 0, '', 0, MM.retentionFlags, 0, 0, 0, MM.LastBackupTime, 0, MM.retentionExpireTime
	from	MMMedia as MM, MMLibrary as ML
	where (MM.MediaLocation = 3 and MM.LastWriteLibraryId = @i_LibraryId and
	ML.LibraryId = MM.LastWriteLibraryId AND @i_LibraryId <> 0 )
	union
	select MM.MediaId,0,'',0, '', 0, '', 0, MM.retentionFlags, 0, 0, 0, MM.LastBackupTime, 0, MM.retentionExpireTime
	from  MMMedia as MM
	where(  MM.LibraryId = 0 AND @i_LibraryId = 0 AND MM.MediaId <> 0)
	union
	select MM.MediaId, ML.LibraryId, ML.AliasName, 0, '', 0, '', 0, MM.retentionFlags, 0, 0, 0, MM.LastBackupTime, 0, MM.retentionExpireTime
	from MMMedia as MM, MMLibrary as ML, MMSpareGroup as MSP
	where (MM.LastWriteLibraryId != @i_LibraryId and MM.IsInMediaGroup = 0 and
	MM.MediaLocation = 3 and MSP.LibraryId = @i_LibraryId and ML.LibraryId = MSP.LibraryId
	and MM.SpareGroupId = MSP.SpareGroupId) AND @i_LibraryId <> 0
	union
	select MM.MediaId, ML.LibraryId, ML.AliasName, 0, '', 0, '', 0, MM.retentionFlags, 0, 0, 0, MM.LastBackupTime, 0, MM.retentionExpireTime
	from MMMedia as MM, MMLibrary as ML, MMMediaGroup as MMG, MMVolume as MV
	where (MM.LastWriteLibraryId != @i_LibraryId and
	MM.IsInMediaGroup = 1 and
	MM.MediaLocation = 3 and MM.MediaId = MV.MediaId and MV.MediaGroupId = MMG.MediaGroupId and ML.LibraryId = @i_LibraryId
	and MMG.SpareGroupId in (select SpareGroupId from #exportSGId))
	AND @i_LibraryId <> 0 and MM.LastWriteLibraryId <> 0
	union
	select MM.MediaId, ML.LibraryId, ML.AliasName, 0, '', 0, '', 0, MM.retentionFlags, 0, 0, 0, MM.LastBackupTime, 0, MM.retentionExpireTime
	from MMMedia as MM, MMLibrary as ML, MMMediaGroup as MMG, MMVolume as MV
	where (MM.LastWriteLibraryId != @i_LibraryId and
	MM.IsInMediaGroup = 1 and MM.LibraryId = @i_LibraryId and
	MM.MediaLocation = 3 and MM.MediaId = MV.MediaId and MV.MediaGroupId = MMG.MediaGroupId and ML.LibraryId = @i_LibraryId
	)
	--and MMG.SpareGroupId in (select SpareGroupId from #exportSGId))
	AND @i_LibraryId <> 0
	update 	#tmpMediaInfo
	set mediaGroupId = isnull((select top 1 V.mediagroupId from MMVolume as V where V.mediaId = #tmpMediaInfo.mediaId), 0)
	update #tmpMediaInfo
set archiveGroupCopyId = (case when (Ast.flags & 2) = 0 then Ast.ArchGroupCopyId else (select archGroupCopyId from archStream WITH (NOLOCK) where MediaGroupId = Ast.mediaGroupId and (flags & 2) = 0) end),
archiveGroupId = (case when (Ast.flags & 2) = 0 then Ast.ArchGroupId else (select archGroupId from archStream WITH (NOLOCK) where MediaGroupId = Ast.mediaGroupId and (flags & 2) = 0) end),
	archStreamNum = Ast.stream
	from ArchStream AS Ast
	where Ast.MediaGroupId = #tmpMediaInfo.MediaGroupId
	update #tmpMediaInfo
	set archiveGroupCopyName = AGC.name
	from archGroupCopy as AGC
	where AGC.id = #tmpMediaInfo.archiveGroupCopyId AND #tmpMediaInfo.archiveGroupCopyId > 0
	update #tmpMediaInfo
	SET 	archiveGroupName = AG.name,
			isPrimaryCopy = CASE WHEN AG.defaultCopy = archiveGroupCopyId THEN 1 ELSE 0 END
	FROM 	archGroup as AG
	WHERE 	archiveGroupId > 0 and	#tmpMediaInfo.archiveGroupId  = AG.Id
	-- get PhysicalBytes MB from MMMediaSide table
	UPDATE #tmpMediaInfo
	set physicalBytesMB = (select sum(MS.PhysicalBytesMB)
	from MMMediaSide MS
	where #tmpMediaInfo.MediaId = MS.mediaId)
	declare @sperr Integer
	exec @sperr = MMS2CalculateGUIMediaAttrEnBulk '#tmpMediaInfo'
	/*
	SELECT 	distinct M.MediaId, M.BarCode, M.UniqueId,
	ME.ExportLocation, M.MediaFlags,
	M.ExternalGUID,
	M.MediaTypeId,MT.MediaTypeName, MT.IsCleaningMedia,
	V.VolumeId, V.VolumeFlags,
	libraryId = tt.LibraryId,
	libraryAliasName = (select AliasName from MMLibrary where LibraryId = tt.LibraryId),
	lastWriteLibraryId = M.LastWriteLibraryId,
	lastWriteLibName = (select AliasName from MMLibrary where LibraryId = M.LastWriteLibraryId),
	mc.ContainerId, mc.ContainerName, M.attributes, tt.guiAttributes,
	ME.ExportLocationId,
	tt.archiveGroupId, tt.archiveGroupName, tt.archiveGroupCopyId, tt.archiveGroupCopyName,
	M.SpareGroupId, MS.SpareGroupName, MS.SpareGroupType, M.NumberOfReUses, tt.numberOfExtRetentionJobsOnMedia,
	MMS.numberOfSoftErrors, MMS.numberOfHardErrors, M.IsAged, M.IsInMediaGroup, tt.isPrimaryCopy, tt.archStreamNum, tt.lastWriteTime, tt.physicalBytesMB, tt.retentionExpireTime
	FROM 	MMMedia as M, MMMediaType as MT,
	MMVolume as V, MMExportLocation as ME, #tmpMediaInfo as tt,
	MMContainer as mc, MMSpareGroup as MS, MMMediaSide as MMS
	/*WHERE 	M.MediaTypeId = MT.MediaTypeId and
	M.MediaId = V.MediaId and M.exportlocationid = ME.exportlocationid and
	((M.LastWriteLibraryId > 0 and  M.LastWriteLibraryId  = @i_LibraryId ) OR
	(M.LastWriteLibraryId = 0 and (M.IsInMediaGroup = 0 AND M.SpareGroupId in (select SpareGroupId from #exportSGId)))
	OR
	(M.LastWriteLibraryId = 0 and (M.IsInMediaGroup > 0 AND M.MediaId in (select MediaId from #exportMGId))))
	and M.MediaId = tt.MediaId and mc.ContainerId = m.containerId
	and MS.SpareGroupId = M.SpareGroupId
	and MMS.MediaSideId = V.MediaSideId
	and M.BarCode not in (select 'StdAln_' + CAST(MediaId as varchar(64)) from MMMedia) --Dummy Media for stand alone library not to be shown MR 9121
	ORDER BY M.MediaId*/
	WHERE 	M.MediaTypeId = MT.MediaTypeId and
	M.MediaId = V.MediaId and M.exportlocationid = ME.exportlocationid and
	((M.LastWriteLibraryId > 0 and  M.LastWriteLibraryId  = @i_LibraryId ) OR
	((M.LastWriteLibraryId = 0 OR M.LibraryiD = @i_LibraryId) and (M.IsInMediaGroup = 0 AND M.SpareGroupId in (select SpareGroupId from #exportSGId)))
	OR
	(M.LastWriteLibraryId = 0 and (M.IsInMediaGroup > 0 AND M.MediaId in (select MediaId from #exportMGId)))
	OR
	(@i_LibraryId = 0)
	)
	and M.MediaId = tt.MediaId and mc.ContainerId = m.containerId
	and MS.SpareGroupId = M.SpareGroupId
	and MMS.MediaSideId = V.MediaSideId
	and M.BarCode not in (select 'StdAln_' + CAST(MediaId as varchar(64)) from MMMedia) --Dummy Media for stand alone library not to be shown MR 9121
	ORDER BY M.MediaId*/
	SELECT      distinct M.MediaId, M.BarCode, M.UniqueId,
      ME.ExportLocation, M.MediaFlags,
      M.ExternalGUID,
      M.MediaTypeId,MT.MediaTypeName, MT.IsCleaningMedia,
      V.VolumeId, V.VolumeFlags,
      libraryId = tt.LibraryId,
      libraryAliasName = (select AliasName from MMLibrary where LibraryId = tt.LibraryId),
      lastWriteLibraryId = M.LastWriteLibraryId,
      lastWriteLibName = (select AliasName from MMLibrary where LibraryId = M.LastWriteLibraryId),
      mc.ContainerId, mc.ContainerName, M.attributes, tt.guiAttributes,
      ME.ExportLocationId,
      tt.archiveGroupId, tt.archiveGroupName, tt.archiveGroupCopyId, tt.archiveGroupCopyName,
      M.SpareGroupId, MS.SpareGroupName, MS.SpareGroupType, M.NumberOfReUses, tt.numberOfExtRetentionJobsOnMedia,
      MMS.numberOfSoftErrors, MMS.numberOfHardErrors, M.IsAged, M.IsInMediaGroup, tt.isPrimaryCopy, tt.archStreamNum, tt.lastWriteTime, tt.physicalBytesMB, tt.retentionExpireTime,
	  M.MediaStatusReason,  M.CreationTime, M.LastExportTime
      FROM MMMedia M inner join  MMMediaType MT ON M.MediaTypeId = MT.MediaTypeId
      inner join MMVolume V ON V.MediaId = M.MediaId
      inner join MMMediaSide MMS ON  V.MediaSideId = MMS.MediaSideId
      inner join #tmpMediaInfo tt ON M.MediaId = tt.MediaId
      inner join MMSpareGroup MS ON M.SpareGroupId = MS.SpareGroupId
      inner join MMContainer MC ON M.ContainerId = MC.ContainerId
      inner join MMExportLocation ME ON M.ExportLocationId = ME.ExportLocationId
      left outer join #exportSGId ESG ON M.SpareGroupId = ESG.spareGroupId
      left outer join #exportMGId EMG ON M.MediaId = EMG.mediaid
      WHERE
      (
      (M.LastWriteLibraryId > 0 and  M.LastWriteLibraryId  = @i_LibraryId ) OR
      ((M.LastWriteLibraryId = 0 OR M.LibraryiD = @i_LibraryId) and (M.IsInMediaGroup = 0 AND ESG.spareGroupId is not null)) OR
      (M.LastWriteLibraryId = 0 and (M.IsInMediaGroup > 0 AND EMG.mediaid is not null)) OR
      (M.LastWriteLibraryId > 0 and M.LastWriteLibraryId != M.LibraryId and M.LibraryId = @i_LibraryId) OR
      (M.LastWriteLibraryId = 0 and M.LastWriteLibraryId != M.LibraryId and M.LibraryId = @i_LibraryId) OR
      (@i_LibraryId = 0)
      )
      AND M.BarCode not in (select 'StdAln_' + CAST(MediaId as varchar(64)) from MMMedia) --Dummy Media for stand alone library not to be shown MR 9121
      ORDER BY M.MediaId
	drop table #exportSGId
	drop table #exportMGId
	drop table #tmpMediaInfo
	return;
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GUISP_getExportedMediaList')
	delete from GxQscripts where name = 'MMS2GUISP_getExportedMediaList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GUISP_getExportedMediaList')
	delete from GXDBVersions where aliasname = 'MMS2GUISP_getExportedMediaList'
GO

insert into GXDBVersions values(2, 'MMS2GUISP_getExportedMediaList',  '00010020018000050000', 'MMS2GUISP_getExportedMediaList', '00010020018000050000')
GO

