

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2GUISP_getAssignedMediaList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2GUISP_getAssignedMediaList.sp,v $ $Id: MMS2GUISP_getAssignedMediaList.sp,v 1.18.198.5 2018/09/29 18:26:56 vikramsingh Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						Cursor: "MMS2GUISP_getAssignedMediaList"								|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2GUISP_getAssignedMediaList <<<'

IF EXISTS (select * from sysobjects where name='MMS2GUISP_getAssignedMediaList')
	drop procedure MMS2GUISP_getAssignedMediaList
IF EXISTS (select * from GxQscripts where name='MMS2GUISP_getAssignedMediaList')
	delete from GxQscripts where name = 'MMS2GUISP_getAssignedMediaList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GUISP_getAssignedMediaList')
	delete from GXDBVersions where aliasname = 'MMS2GUISP_getAssignedMediaList'
GO
print '... Creating Procedure: MMS2GUISP_getAssignedMediaList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2GUISP_getAssignedMediaList
-- The following two lines indicate, in order, parameters that will be
--  expected in the "setValues()" method, as well as the order in which
--  they will be provided as arguments to the SQLSTRING command
  @i_LibraryId int
AS
--	The next two lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
  DECLARE @o_MediaId integer                       
  DECLARE @o_BarCode char(255)
  DECLARE @o_UniqueId char(255)
  DECLARE @o_MediaLocation integer                       
  DECLARE @o_ExportLocation NVARCHAR(255)
  DECLARE @o_MediaTypeId integer                       
  DECLARE @o_MediaFlags integer                       
  DECLARE @o_ExternalGUID char(255)
  DECLARE @o_IsCleaningMedia integer                       
  DECLARE @o_MediaSideId integer                       
  DECLARE @o_VolumeId integer                       
  DECLARE @o_VolumeFlags integer                       
  DECLARE @o_MediaStatus integer                       
  DECLARE @o_slotId integer                       
  DECLARE @o_slotName char(255)
  DECLARE @o_slotType integer                       
  DECLARE @o_driveId integer                       
  DECLARE @o_driveAliasName NVARCHAR(255)
  DECLARE @o_lastWriteLibraryId integer                       
  DECLARE @o_lastWriteLibName NVARCHAR(255)
  DECLARE @o_libraryId integer                       
  DECLARE @o_libraryAliasName NVARCHAR(255)
  DECLARE @o_containerId integer                       
  DECLARE @o_containerName NVARCHAR(255)
  DECLARE @o_mediaAttributes integer                       
  DECLARE @o_guiAttributes integer
  DECLARE @o_exportLocationId integer                       
  DECLARE @o_archiveGroupId integer                       
  DECLARE @o_archiveGroupName NVARCHAR(255)
  DECLARE @o_archiveGroupCopyId integer                       
  DECLARE @o_archiveGroupCopyName NVARCHAR(255)
  DECLARE @o_spareGroupId integer                       
  DECLARE @o_spareGroupName NVARCHAR(255)
  DECLARE @o_spareGroupType integer
  DECLARE @o_usageCounter integer                       
  DECLARE @o_numberOfExtRetentionJobsOnMedia integer    
  DECLARE @o_numberOfSoftErrors integer
  DECLARE @o_numberOfHardErrors integer
  DECLARE @o_isAged integer
  DECLARE @o_isInMediaGroup integer
  DECLARE @o_isPrimaryCopy integer
  DECLARE @o_archStreamNum integer
  DECLARE @o_lastWriteTime integer
  DECLARE @o_physicalBytesMB bigint
  DECLARE @o_retentionExpireTime bigint
  DECLARE @o_mediaStatusReason integer
  DECLARE @o_mediaTypeName NVARCHAR(255)
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
	declare @LibType	integer
	set @LibType = (select LibraryTypeId from MMLibrary where LibraryId = @i_LibraryId)
	if object_id('tempdb.dbo.#tmpMediaList') is not null DROP TABLE #tmpMediaList
	if object_id('tempdb.dbo.#tmpMediaDetails') is not null DROP TABLE #tmpMediaDetails
	create table #tmpMediaList(MediaId		integer primary key)
	create table #tmpMediaDetails(	MediaId			integer,
									Barcode			varchar(256),
									UniqueId		varchar(256),
									mediaLocation	integer,
									exportLocation	nvarchar(256),
									exportLocationId	integer,
									MediaTypeId		integer,
									mediaFlags		integer,
									ExternalGUID	varchar(256),
									isCleaningMedia	integer,
									mediaSideId		integer,
									volumeId		integer,
									volumeFlags		integer,
									mediaGroupId	integer,
									mediaStatus		integer,
									slotId			integer,
									slotName		varchar(256),
									slotType		integer,
									driveId			integer,
									driveName		nvarchar(256),
									lastWriteLibId	integer,
									lastWriteLibName	nvarchar(256),
									LibraryId		integer,
									libraryName		nvarchar(256),
									containerId		integer,
									containerName	nvarchar(256),
									mediaAttributes	integer,
									guiAttributes	integer,
									archiveGroupId	integer,
									archiveGroupName nvarchar(256),
									archiveGroupCopyId integer,
									archiveGroupCopyName nvarchar(256),
									spareGroupId	integer,
									spareGroupName	nvarchar(256),
									spareGroupType	integer,
									usageCounter	integer,
									numberOfExtRetentionJobsOnMedia integer,
									numberOfSoftErrors	integer,
									numberOfHardErrors	integer,
									isAged integer,
									isInMediaGroup integer,
									isPrimaryCopy	integer,
									archStreamNum integer,
									lastWriteTime		integer,
									physicalBytesMB		bigint,
									retentionExpireTime	bigint,
									mediaStatusReason	integer,
									mediaTypeName       nvarchar(256),
									primary key (MediaId, MediaSideId) )
	if(@LibType = 8)
	begin
		insert into #tmpMediaList
		select MediaId from MMMedia where
		LibraryId = @i_LibraryId and IsInMediaGroup = 1
	end
	else
	begin
		insert into #tmpMediaList
		select MediaId from MMMedia
		where (IsInMediaGroup = 1 and
		(	LibraryId = @i_LibraryId
			OR
			(
				LastWriteLibraryId = @i_LibraryId AND
				LibraryId  != @i_LibraryId AND
				MediaLocation != 3
			) OR
			(
				MediaLocation = 3 AND
				LastWriteLibraryId = @i_LibraryId
			)
		) and
		MediaId in (select MediaId from MMVolume where MediaGroupId <> 0))
		OR (
			LibraryId = @i_LibraryId  AND
			@LibType = 9	AND
			SpareGroupId = 0
		)
	end
	insert into #tmpMediaDetails
		SELECT DISTINCT M.MediaId, M.BarCode, M.UniqueId, M.MediaLocation,
		'',0, M.MediaTypeId,	M.MediaFlags,M.ExternalGUID,
		MT.IsCleaningMedia,MMS.MediaSideId, 0, 0,0,0,0,'',0,0,'',M.LastWriteLibraryId,
		'',M.LibraryId, '',m.containerId, '', M.attributes, 0, 0, '', 0, '', M.SpareGroupId, MS.SpareGroupName, MS.SpareGroupType,
		M.NumberOfReUses, M.retentionFlags,
		MMS.NumberOfSoftErrors, MMS.NumberOfHardErrors, M.IsAged, M.IsInMediaGroup, 0, 0, M.LastBackupTime, 0, M.RetentionExpireTime, M.MediaStatusReason , MT.MediaTypeName
		FROM 	MMMedia as M, MMMediaType as MT, MMMediaSide as MMS, #tmpMediaList as tt, MMSpareGroup as MS
		WHERE 	M.MediaId = tt.MediaId and M.MediaId = MMS.MediaId
			and M.MediaTypeId = MT.MediaTypeId and MS.SpareGroupId =M.SpareGroupId
	update #tmpMediaDetails
	set exportLocation = ME.ExportLocation, exportLocationId = ME.ExportLocationId
	from MMExportLocation as ME, MMMedia as MM, #tmpMediaDetails as tt
	where ME.ExportLocationId = MM.ExportLocationid and MM.ExportLocationId > 0 and MM.MediaId = tt.MediaId
	update #tmpMediaDetails
	set VolumeId = MV.VolumeId, volumeFlags = MV.VolumeFlags,  mediaGroupId = MV.mediaGroupId
	from #tmpMediaDetails as tt, MMVolume as MV
	where MV.MediaSideId = tt.MediaSideId
	update #tmpMediaDetails
	set MediaStatus = MS.MediaStatus, slotId = MS.SlotId, SlotName = MS.SlotName,
	slotType = MS.SlotType
	from #tmpMediaDetails as tt, MMSlot as MS
	where MS.MediaId = tt.MediaId
	update #tmpMediaDetails
	set driveId = MD.DriveId, driveName = MD.AliasName
	from #tmpMediaDetails as tt, MMDrive as MD
	where MD.MediaId = tt.MediaId
	--LibraryId will never be zero from 6.1 onwards. So, no need for this update
--	update #tmpMediaDetails
--	set LibraryId = @i_LibraryId
--	from #tmpMediaDetails as tt, MMLibrary as ML
--	where tt.LibraryId = 0
	update #tmpMediaDetails
	set LibraryName = ML.AliasName
	from #tmpMediaDetails as tt, MMLibrary as ML
	where ML.LibraryId = tt.LibraryId
	update #tmpMediaDetails
	set LastWriteLibName = ML.AliasName
	from #tmpMediaDetails as tt, MMLibrary as ML
	where ML.LibraryId = tt.LastWriteLibId
	update #tmpMediaDetails
	set containerName = MC.containerName
	from #tmpMediaDetails as tt, MMContainer as MC
	where MC.ContainerId = tt.ContainerId and tt.ContainerId > 0
	update #tmpMediaDetails
set archiveGroupCopyId = (case when (Ast.flags & 2) = 0 then Ast.ArchGroupCopyId else (select archGroupCopyId from archStream WITH (NOLOCK) where MediaGroupId = Ast.mediaGroupId and (flags & 2) = 0) end),
archiveGroupId = (case when (Ast.flags & 2) = 0 then Ast.ArchGroupId else (select archGroupId from archStream WITH (NOLOCK) where MediaGroupId = Ast.mediaGroupId and (flags & 2) = 0) end),
	archStreamNum = Ast.stream
	from ArchStream AS Ast
	where Ast.MediaGroupId = #tmpMediaDetails.MediaGroupId
	update #tmpMediaDetails
	set archiveGroupCopyName = AGC.name
	from archGroupCopy as AGC
	where AGC.id = #tmpMediaDetails.archiveGroupCopyId AND #tmpMediaDetails.archiveGroupCopyId > 0
	update #tmpMediaDetails
	SET 	archiveGroupName = AG.name,
			isPrimaryCopy = CASE WHEN AG.defaultCopy = archiveGroupCopyId THEN 1 ELSE 0 END
	FROM 	archGroup as AG
	WHERE 	archiveGroupId > 0 and	#tmpMediaDetails.archiveGroupId  = AG.Id
	-- get PhysicalBytes MB from MMMediaSide table
	UPDATE #tmpMediaDetails
	set physicalBytesMB = (select sum(MS.PhysicalBytesMB)
	from MMMediaSide MS
	where #tmpMediaDetails.MediaId = MS.mediaId)
	--Dummy Media for stand alone library not to be shown MR 9121
	delete from #tmpMediaDetails
	where BarCode in (select 'StdAln_' + CAST(MediaId as varchar(64)) from #tmpMediaDetails)
	declare @sperr Integer
	exec @sperr = MMS2CalculateGUIMediaAttrEnBulk '#tmpMediaDetails'
	-- number of extended retention jobs will be passed as 0 for 6.1
	select MediaId, Barcode, UniqueId, mediaLocation, exportLocation, MediaTypeId,
	mediaFlags, ExternalGUID, isCleaningMedia, mediaSideId,
	volumeId, volumeFlags, mediaStatus, slotId, slotName, slotType, driveId, driveName,
	lastWriteLibId, lastWriteLibName, LibraryId, libraryName, containerId,
	containerName, mediaAttributes, guiAttributes , exportLocationId,
	archiveGroupId, archiveGroupName, archiveGroupCopyId, archiveGroupCopyName,
	spareGroupId, spareGroupName, spareGroupType, usageCounter, numberOfExtRetentionJobsOnMedia,
	numberOfSoftErrors, numberOfHardErrors, IsAged, IsInMediaGroup, isPrimaryCopy, archStreamNum, lastWriteTime, physicalBytesMB, retentionExpireTime, mediaStatusReason,mediaTypeName
	from #tmpMediaDetails
	ORDER BY slotid, driveid
	drop table #tmpMediaList
	drop table #tmpMediaDetails
	return;
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2GUISP_getAssignedMediaList')
	delete from GxQscripts where name = 'MMS2GUISP_getAssignedMediaList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2GUISP_getAssignedMediaList')
	delete from GXDBVersions where aliasname = 'MMS2GUISP_getAssignedMediaList'
GO

insert into GXDBVersions values(2, 'MMS2GUISP_getAssignedMediaList',  '00010018019800050000', 'MMS2GUISP_getAssignedMediaList', '00010018019800050000')
GO

