

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2FillMediaInfoForDM.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2FillMediaInfoForDM.sp,v $ $Id: MMS2FillMediaInfoForDM.sp,v 1.22.32.8 2020/06/30 00:26:57 cliu Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMS2FillMediaInfoForDM')
BEGIN
	print '>>> Drop Stored Procedure: MMS2FillMediaInfoForDM <<<'
	drop procedure MMS2FillMediaInfoForDM
END
IF EXISTS (select * from GxQscripts where name='MMS2FillMediaInfoForDM')
	delete from GxQscripts where name = 'MMS2FillMediaInfoForDM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2FillMediaInfoForDM')
	delete from GXDBVersions where aliasname = 'MMS2FillMediaInfoForDM'
GO
print '... Creating Procedure: MMS2FillMediaInfoForDM'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2FillMediaInfoForDM
  @i_volId integer,
  @i_mediaId integer
AS
  DECLARE @o_mediaID integer
  DECLARE @o_uniqueID varchar(256)
  DECLARE @o_libraryID integer
  DECLARE @o_mediaGroupID integer
  DECLARE @o_volBlockSize integer
  DECLARE @o_omlVersion integer
  DECLARE @o_mediaType integer
  DECLARE @o_barCode varchar(256)
  DECLARE @o_sideName varchar(256)
  DECLARE @o_sideId integer
  DECLARE @o_isOmlValid integer
  DECLARE @o_lastBackupTime integer
  DECLARE @o_creationTime integer
  DECLARE @o_OverWriteJobId bigint
  DECLARE @o_commCellNumber integer
  DECLARE @o_attributes integer
  DECLARE @o_spareGroupId integer
  DECLARE @o_exportLocation NVARCHAR(256)
  DECLARE @o_numberOfSides integer
  DECLARE @o_isWormMedia integer
  DECLARE @o_NumActiveFiles integer
  DECLARE @o_lastFileMarker integer
  DECLARE @o_FreeBytes bigint
  DECLARE @o_IsHardwareCompressed integer
  DECLARE @o_ChunkSizeMB integer
  DECLARE @o_mountPathID integer
  DECLARE @o_mountPathHostId integer
  DECLARE @o_MountPathTypeId integer
  DECLARE @o_VolCClip varchar(256)
  DECLARE @o_MountPathName NVARCHAR(256)
  DECLARE @o_mountPathReserveSpaceMB integer
  DECLARE @o_mountPathMaxDataToWriteMB integer
  DECLARE @o_mountPathAttributes integer
  DECLARE @o_VolumeGUID varchar(256)
  DECLARE @o_isAged integer
  DECLARE @o_isInMediaGroup integer
  DECLARE @o_SIDBStoreId integer
  DECLARE @o_mediaCopyId integer
  DECLARE @o_magneticChunkFileIncrSizeMB integer
  DECLARE @o_DeviceId integer
  DECLARE @o_DeviceControllerId integer
  DECLARE @o_mountPathUserName varchar (1024)
  DECLARE @o_mountPathPassword varchar (2048)
  DECLARE @o_mediaInfoFlags integer
  DECLARE @o_HwEncKey varchar(114)
  DECLARE @o_reserveParam1 integer
  DECLARE @o_reserveParam2 integer
--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	Declare @l_origCommCellId	integer
	Declare @l_ExportLocationId	integer
	Declare @mediaCopyId	integer
	Declare @mediaID		integer
	Declare @uniqueID		varchar(256)
	Declare @libraryID		integer
	Declare @mountPathID		integer
	Declare @mountPathHostId	integer
	Declare @mediaGroupID		integer
	Declare @mediaType		integer
	Declare @barCode		varchar(256)
	Declare @sideName		varchar(256)
	Declare @sideId			integer
	Declare @exportLocation		nvarchar(256)
	Declare @isOmlValid		integer
	Declare @lastBackupTime		integer
	Declare @volBlockSize		integer
	Declare @creationTime		integer
	Declare @omlVersion		integer
	Declare @OverWriteJobId		bigint
	Declare @commCellNumber		integer
	Declare @attributes		integer
	Declare @spareGroupId		integer
	Declare @numberOfSides		integer
	Declare @isWormMedia		integer
	Declare @MountPathTypeId	integer
	Declare @NumActiveFiles		integer
	Declare @lastFileMarker		integer
	Declare @FreeBytes		bigint
	Declare @IsHardwareCompressed	integer
	Declare @ChunkSizeMB		integer
	Declare @VolCClip			varchar(256)
	Declare @MountPathName		nvarchar(256)
	Declare @mountPathReserveSpaceMB	integer
	Declare @mountPathMaxDataToWriteMB	integer
	Declare @mountPathAttributes		integer
	Declare @VolumeGUI			varchar(256)
	Declare @CenteraFriendslyName		varchar(256)
	Declare @isAged				integer
	Declare @isInMediaGroup		integer
	Declare @SIDBStoreId		integer
	Declare @magneticChunkFileIncrSizeMB	integer
	Declare @deviceId				integer
	Declare @deviceControllerId		integer
Declare @mountPathUserName		varchar (1024)
Declare @mountPathPassword		varchar (2048)
	Declare @mediaInfoFlags			integer
	Declare @l_drivePoolId		integer
	Declare	@cacheMountPathId	integer	= 0
	DECLARE @deviceTypeId int = 0
	DECLARE @credentialAssocId integer = 0
	set @l_origCommCellId = 0
	set @l_ExportLocationId = 0
	set @mediaID 		= 0
	set @uniqueID 		= ''
	set @libraryID 		= 0
	set @mountPathID	= 0
	set @mountPathHostId	= 0
	set @mediaGroupID	= 0
	set @mediaType		= 0
	set @barCode		= ''
	set @sideName		= ''
	set @sideId		= 0
	set @exportLocation	= ''
	set @isOmlValid		= 0
	set @lastBackupTime	= 0
	set @volBlockSize	= 0
	set @creationTime	= 0
	set @omlVersion		= 0
	set @OverWriteJobId	= 0
	set @commCellNumber	= 0
	set @attributes		= 0
	set @spareGroupId	= 0
	set @numberOfSides	= 0
	set @isWormMedia	= 0
	set @MountPathTypeId	= 0
	set @NumActiveFiles	= 0
	set @lastFileMarker	= 0
	set @FreeBytes		= 0
	set @IsHardwareCompressed = 0
	set @ChunkSizeMB	= 0
	set @VolCClip		= ''
	set @MountPathName	= ''
	set @mountPathReserveSpaceMB	 = 0
	set @mountPathMaxDataToWriteMB	 = 0
	set @mountPathAttributes	 = 0
	set @VolumeGUI			 = ''
	set @CenteraFriendslyName	 = ''
	set @isAged			=	0
	set @isInMediaGroup	=	0
	set @mountPathHostId = 0
	set @mountPathID = 0
	set @SIDBStoreId = 0
	set @magneticChunkFileIncrSizeMB = 0
	set @deviceId = 0
	set @deviceControllerId = 0
	set @mountPathUserName = ''
	set @mountPathPassword = ''
	set @mediaInfoFlags = 0
	set @o_HwEncKey = ''
	set @l_drivePoolId		=	0
	set @credentialAssocId = 0
	-- Constants that are enums.
	declare @MOUNT_PATH_MAGNETIC		integer
	declare @MOUNT_PATH_CENTERA			integer
	declare @MOUNT_PATH_DYNAMIC_SHARED	integer
	declare @MOUNT_PATH_TAPE			integer
	declare @MOUNT_PATH_SHARED_STATIC	integer
	declare @MOUNT_PATH_SHARED_REPLICA	integer
	declare @MOUNT_PATH_DRU				integer
	declare @MOUNT_PATH_EXTERNAL_REMOTE_HOST	integer
	set @MOUNT_PATH_MAGNETIC			=	0
	set @MOUNT_PATH_CENTERA				=	1
	set @MOUNT_PATH_DYNAMIC_SHARED		=	2
	set @MOUNT_PATH_TAPE				=	3
	set @MOUNT_PATH_SHARED_STATIC		=	4
	set @MOUNT_PATH_SHARED_REPLICA		=	5
	set @MOUNT_PATH_DRU					=	6
	set @MOUNT_PATH_EXTERNAL_REMOTE_HOST	=	7
	IF(@i_volId > 0)
	BEGIN
		select @mediaID = V.MediaId, @sideId = V.MediaSideId, @NumActiveFiles = V.NumberOfActiveFiles,
		@mediaGroupID = V.MediaGroupId, @omlVersion = OMLVersion, @volBlockSize = V.FlushBlockSizeKB,
		@lastFileMarker = V.LastFile, @VolCClip = V.VolumeName, @VolumeGUI = V.ExternalGUID,
		@SIDBStoreId = SIDBStoreId
		from MMVolume as V WITH (READUNCOMMITTED)
		where V.VolumeId = @i_VolId
		if ((select COUNT(archGroupCopyId) from archStream WITH (READUNCOMMITTED) where mediaGroupId = @mediaGroupID) = 1)
		begin
			  set @mediaCopyId = (select ArchGroupCopyId from ArchStream WITH (READUNCOMMITTED) where MediaGroupId = @mediaGroupID)
			  IF (@SIDBStoreId = 0)
			  BEGIN
				-- From the Copy, get the configured SIDBStore if any.
				select @SIDBStoreId = CS.SIDBStoreId
				FROM	archCopySIDBStore CS WITH (READUNCOMMITTED)
				WHERE	CS.copyId = @mediaCopyId
AND (CS.Flags & (2|4) = (2|4))
			END
		end
		else
		begin --get the GACP copyinfo
set @mediaCopyId = (select id from archGroupCopy WITH (READUNCOMMITTED) where id in (select archGroupCopyId from archStream WITH (READUNCOMMITTED) where mediaGroupId = @mediaGroupID) and (extendedFlags & 1) > 0)
		end
	END
	ELSE
	BEGIN
		set @mediaID = @i_mediaId
		set @sideId = (select MediaSideId from MMMediaSide WITH (READUNCOMMITTED) where MediaId = @mediaID)
	END
	select @uniqueID = M.UniqueId, @libraryID = M.LibraryId, @mediaType = M.MediaTypeId,
	@barCode = M.BarCode, @l_ExportLocationId = ExportLocationId,
	@l_origCommCellId = origCCcommCellID, @lastBackupTime = LastBackupTime,
	@creationTime = CreationTime, @OverWriteJobId = OverWriteJobId,
	@attributes = Attributes, @spareGroupId = SpareGroupId, @isAged	= M.IsAged, @isInMediaGroup = M.IsInMediaGroup,
	@o_HwEncKey = HwEncKey
	from MMMedia as M WITH (READUNCOMMITTED)
	where M.MediaId = @mediaID
	select @sideName = SideName, @isOmlValid = IsOMLValid, @FreeBytes = FreeBytesMB
	from MMMediaSide as MMS WITH (READUNCOMMITTED)
	where MMS.MediaSideId = @sideId
	select @numberOfSides = MMT.NumberOfSides, @isWormMedia = MMT.isWormMedia
	from MMMediaType as MMT WITH (READUNCOMMITTED)
	where MMT.MediaTypeId = @mediaType
	IF(@i_volId > 0)
	BEGIN
		select @IsHardwareCompressed = isnull(MD.IsHardwareCompressed, 0),
		@ChunkSizeMB = isnull(MD.ChunkSizeMB, 0),
		@mediaInfoFlags = ( @mediaInfoFlags | (isnull(MD.UseHardwareEncryption, 0)) )
		from MMDataPath as MD WITH (READUNCOMMITTED), MMMediaGroup as MG WITH (READUNCOMMITTED)
		where MG.MediaGroupId = @mediaGroupID
		AND MD.DataPathId = MG.DataPathId
		set @l_drivePoolId	=	(select drivepoolid from MMMediaGroup AS MG WITH (READUNCOMMITTED) where MG.MediaGroupid = @mediaGroupID)
		-- If there exists a chunk for this volume that is hardware encrypted, set the flag in the mediaInfoFlags field.
		IF EXISTS
		(
			select top 1 id
			from archchunk WITH (READUNCOMMITTED)
			where volumeid = @i_VolId
				AND LEN(hwEncKey) > 0
		)
		OR LEN(@o_HwEncKey) > 0
		BEGIN
set @mediaInfoFlags	=	(@mediaInfoFlags | 4)
		END
		IF EXISTS (SELECt 1 FROM MMHybridCloudMapping WHERE cloudLibId = @libraryID)
		BEGIN
			SELECT @cacheMountPathId = cacheMountPathId FROM MMCloudVolCacheMountPath WITH (READUNCOMMITTED) WHERE volumeId = @i_volId
		END
		-- Set MediaInfoFlags for sharsing harware encryption key based on media if it is allowed
		IF EXISTS (SELECT 1 FROM MMConfigs WITH (NOLOCK) WHERE Name = 'MMCONFIG_ENABLE_HARDWARE_ENCRYPTION_SHARING_BASED_ON_MEDIA' and Value > 0)
		BEGIN
SET @mediaInfoFlags =  @mediaInfoFlags | 32
		END
	END
	ELSE
	BEGIN
		set @l_drivePoolId	=	(select top 1 DrivePoolId from MMDrivePool as DP WITH (READUNCOMMITTED), MMDrive as MD WITH (READUNCOMMITTED) where DP.MasterPoolId = MD.MasterPoolId and MD.MediaId = @mediaID)
	END
	if(@isOmlValid = 0 AND @NumActiveFiles >= 1)
	BEGIN
		set @isOmlValid = 1
	END
	if(@mediaType = 10001)
	BEGIN
		select @mountPathID = MM.MountPathId, @MountPathTypeId = MM.MountPathTypeId,
		@MountPathName = MM.MountPathName, @mountPathReserveSpaceMB = MM.MagneticSpaceRsrvInMB,
		@mountPathMaxDataToWriteMB = MM.MaxDataToWriteMB, @mountPathAttributes = MM.Attribute,
		@magneticChunkFileIncrSizeMB = MM.MagneticChunkFileIncrSizeMB,
		@mountPathUserName = MM.UserName, @mountPathPassword = MM.UserPassword
		from MMMountPath as MM WITH (READUNCOMMITTED)
		where MM.MediaSideId = @sideId
		--In case of Centera, just get the Centera Friendly name
--		if(@MountPathTypeId = 1)
--		BEGIN
--			set @CenteraFriendslyName = (select FriendlyName from MMCenteraInfo where CenteraId in
--							(select CenteraId from MMMountPathToStorageDevice
--							where MountPathId = @mountPathID))
--		END
		--In case of Dynamic or Static Shared MountPath
		if(@MountPathTypeId = @MOUNT_PATH_DYNAMIC_SHARED OR
			@MountPathTypeId = @MOUNT_PATH_SHARED_STATIC OR
			@MountPathTypeId = @MOUNT_PATH_SHARED_REPLICA OR
			@MountPathTypeId = @MOUNT_PATH_DRU OR
			@MountPathTypeId = @MOUNT_PATH_EXTERNAL_REMOTE_HOST)
		BEGIN
			if object_id('tempdb.dbo.#tmpDeviceControllerCredentials') is not null DROP TABLE #tmpDeviceControllerCredentials
			create table #tmpDeviceControllerCredentials
			(
UserName			varchar(1024),
UserPassword		NVARCHAR(2048),
				CredentialAssocId	INTEGER
			)
			select top 1 @mountPathHostId = MDC.ClientId, @deviceId = MD.DeviceId, @deviceControllerId = MDC.DeviceControllerId, @mountPathUserName = MDC.UserName, @mountPathPassword = MDC.UserPassword, @deviceTypeId = MD.deviceTypeId, @credentialAssocId = MDC.CredentialAssocId
			from MMMountPathToStorageDevice as MMPSD WITH (READUNCOMMITTED),
				MMDevice as MD WITH (READUNCOMMITTED),
				MMDeviceController as MDC WITH (READUNCOMMITTED), MMDrivePool as DRVP WITH (READUNCOMMITTED)
			where MMPSD.MountPathId = @mountPathID AND MMPSD.DeviceId = MD.DeviceId
			and MDC.DeviceId = MD.DeviceId AND DRVP.DrivePoolId = @l_drivePoolId
			and MDC.ClientId = DRVP.ClientId
			--If chunk size is not set at data path level get chunk size for device types
			IF(@ChunkSizeMB = 0)
				SET @ChunkSizeMB = (dbo.MMGetChunkSizeForDeviceType(@deviceTypeId))
			-- Changes for form 3096 - if not found correct device controller
			-- according to the mediagroups drivepool, then select based on datapath
			-- settings.
			if (@deviceControllerId = 0)
			BEGIN
				declare @hostCandidate integer
				set @hostCandidate = 0
				if ((select COUNT(archGroupCopyId) from archStream where mediaGroupId = @mediaGroupID) = 1)
				begin
					select top 1 @hostCandidate = MD.HostClientId
					from MMDataPath MD, MMHost MH
					where MD.copyId = @mediaCopyId
					and MD.drivePoolId in (select DP.DrivePoolId from MMDrivePool DP, MMMountPath MP
														where DP.masterPoolId = MP.masterPoolId and MP.mountPathId = @mountPathID)
					and MD.HostClientId = MH.ClientId
order by MH.MmHostSoftState DESC, MH.MmHostEnabled DESC, (MD.flag & 1) DESC
					select top 1 @mountPathHostId = MDC.ClientId, @deviceId = MD.DeviceId, @deviceControllerId = MDC.DeviceControllerId, @mountPathUserName = MDC.UserName, @mountPathPassword = MDC.UserPassword, @credentialAssocId = MDC.CredentialAssocId
					from MMMountPathToStorageDevice as MMPSD WITH (READUNCOMMITTED),
					MMDevice as MD WITH (READUNCOMMITTED),
					MMDeviceController as MDC WITH (READUNCOMMITTED)
					where MMPSD.MountPathId = @mountPathID AND MMPSD.DeviceId = MD.DeviceId
					and MDC.DeviceId = MD.DeviceId
					order by  MDC.DeviceControllerActive desc, MDC.DeviceControllerEnabled desc, MDC.DeviceAccessible desc,
						case @hostCandidate when MDC.clientId then 0 else 1 end,
(MDC.DeviceAccessType & 4) desc, MDC.DeviceMounted desc
                                end
			END
			INSERT INTO #tmpDeviceControllerCredentials
			SELECT @mountPathUserName, @mountPathPassword, @credentialAssocId
			-- Update user name and password for entries that use credentials
			EXEC MMS2GetDeviceControllerCredentials '#tmpDeviceControllerCredentials', 'CredentialAssocId', 'UserName', 'UserPassword'
			SELECT @mountPathUserName = DC.UserName, @mountPathPassword = DC.UserPassword FROM #tmpDeviceControllerCredentials DC
			if object_id('tempdb.dbo.#tmpDeviceControllerCredentials') is not null DROP TABLE #tmpDeviceControllerCredentials
			/* Jai - Fri Feb 21 16:02:30 EST 2014
			--
			-- For data server set the MP name to the preferred path.
			-- The caller in getMediaInfo will overwrite it with whatever funky format MA
			-- needs to interpret the path/type.
			--
			-- Data Server - Shared Devices
			-- Mount Path Protocol - Access Protocol(SAN or IP)|DeviceAccessType|Preferred Data Server Host Id|Preferred Data Server Host Name|Mount Paths Preferred Device Controller|Disk Library Access Path
			SELECT @MountPathName = (CASE WHEN DC1.DeviceAccessType & 16 /* 16 */ = 16 /* 16 */ THEN N'IP|' ELSE N'SAN|' END)
										+ CAST(DC1.DeviceAccessType AS NVARCHAR(10)) + N'|'
										+ CAST(DC2.ClientId AS NVARCHAR(10)) + N'|'
										+ N'|'	-- No Host Name for Datamover
										+ CAST(@mountPathID AS NVARCHAR(10)) + N'|'
										+ (CASE WHEN ( ('/' = RIGHT (DC2.Folder, 1)) OR ('\' = RIGHT (DC2.Folder, 1)) ) THEN (DC2.Folder + MP.MountPathName) ELSE (DC2.Folder + '\' + MP.MountPathName) END)
			FROM	MMDeviceController DC1 WITH(NOLOCK), MMMountPath MP WITH(NOLOCK), MMDeviceController DC2 WITH(NOLOCK)
			WHERE	DC1.DeviceControllerId = @deviceControllerId
					AND MP.MountPathId = @mountPathID
					AND ( (DC1.DeviceAccessType & 16 /* 16 */ = 16 /* 16 */) OR (DC1.DeviceAccessType & 32 /* 32 */ = 32 /* 32 */) )
					AND DC2.DeviceId = @deviceId
					AND (DC2.DeviceAccessType & 8 /* 8 */ = 8 /* 8 */)
			SELECT @MountPathName = (CASE WHEN ( ('/' = RIGHT (DC.Folder, 1)) OR ('\' = RIGHT (DC.Folder, 1)) ) THEN (DC.Folder + MP.MountPathName) ELSE (DC.Folder + '\' + MP.MountPathName) END)
			FROM	MMDeviceController DC WITH(NOLOCK), MMMountPath MP WITH(NOLOCK)
			WHERE	MP.MountPathId = @mountPathID
					AND DC.DeviceId = @deviceId
					AND (DC.DeviceAccessType & 8 /* 8 */ = 8 /* 8 */)
			*/
		END
	END
	set @commCellNumber = (select number from APP_CommCell WITH (READUNCOMMITTED)
							where id = @l_origCommCellId)
	set @exportLocation = (select ExportLocation from MMExportLocation WITH (READUNCOMMITTED)
				where ExportLocationId = @l_ExportLocationId)
	/*
	Using reserve field to return the @l_origCommcellId as it is needed for data that is auxcopied locally from migrated data
	ArchFile's commcellid and Chunk's CommcellId will differ
	*/
	select @mediaID, @uniqueID, @libraryID, @mediaGroupID, @volBlockSize, @omlVersion, @mediaType,
	@barCode, @sideName, @sideId, @isOmlValid, @lastBackupTime, @creationTime, @OverWriteJobId,
	@commCellNumber, @attributes, @spareGroupId, @exportLocation, @numberOfSides, @isWormMedia,
	@NumActiveFiles, @lastFileMarker, @FreeBytes, @IsHardwareCompressed,
	@ChunkSizeMB, @mountPathID, @mountPathHostId, @MountPathTypeId, @VolCClip, @MountPathName,
	@mountPathReserveSpaceMB, @mountPathMaxDataToWriteMB, @mountPathAttributes, @VolumeGUI, @isAged,
	@isInMediaGroup, @SIDBStoreId, @mediaCopyId, @magneticChunkFileIncrSizeMB, @deviceId,
	@deviceControllerId, @mountPathUserName, @mountPathPassword, @mediaInfoFlags, @o_HwEncKey, @l_origCommCellId, @cacheMountPathId
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2FillMediaInfoForDM')
	delete from GxQscripts where name = 'MMS2FillMediaInfoForDM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2FillMediaInfoForDM')
	delete from GXDBVersions where aliasname = 'MMS2FillMediaInfoForDM'
GO

insert into GXDBVersions values(2, 'MMS2FillMediaInfoForDM',  '00010022003200080000', 'MMS2FillMediaInfoForDM', '00010022003200080000')
GO

