

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2ExpireMedia.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2ExpireMedia.sp,v $ $Id: MMS2ExpireMedia.sp,v 1.10.294.5 2018/08/26 16:36:45 shubhamagrawal Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2ExpireMedia <<<'

IF EXISTS (select * from sysobjects where name='MMS2ExpireMedia')
	drop procedure MMS2ExpireMedia
IF EXISTS (select * from GxQscripts where name='MMS2ExpireMedia')
	delete from GxQscripts where name = 'MMS2ExpireMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2ExpireMedia')
	delete from GXDBVersions where aliasname = 'MMS2ExpireMedia'
GO
print '... Creating Procedure: MMS2ExpireMedia'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2ExpireMedia
  @i_CommCellId integer,
  @i_LibraryId integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_NumMedia integer
  DECLARE @o_NumExpiredPinMedia Integer
	--- Section 1 - expire Media
	declare @ExpiredGroupId integer
	declare @MEDIA_FLAG_BAD integer
	declare @MEDIA_FLAG_DEPRECATED integer
	declare @VERY_LARGE_NUMBER integer
	declare	@MEDIA_STATUS_DEPRECATED_YEARS_THRESH_EXCEEDED integer
	declare @MEDIA_STATUS_DEPRECATED_REUSES_THRESH_EXCEEDED integer
	declare @MEDIA_STATUS_DEPRECATED_RW_SESS_THRESH_EXCEEDED integer
	declare @MEDIA_STATUS_DEPRECATED_SOFT_ERR_THRESH_EXCEEDED integer
	declare @MEDIA_STATUS_DEPRECATED_HARD_ERR_THRESH_EXCEEDED integer
	declare @MEDIA_STATUS_BAD_AS_MEDIA_WRITE_PROTECTED integer
	set @MEDIA_FLAG_BAD = 2
	set @MEDIA_FLAG_DEPRECATED = 3
	set @VERY_LARGE_NUMBER = 999999999
	set @MEDIA_STATUS_DEPRECATED_YEARS_THRESH_EXCEEDED = 18
	set @MEDIA_STATUS_DEPRECATED_REUSES_THRESH_EXCEEDED = 19
	set @MEDIA_STATUS_DEPRECATED_RW_SESS_THRESH_EXCEEDED = 20
	set @MEDIA_STATUS_DEPRECATED_SOFT_ERR_THRESH_EXCEEDED = 21
	set @MEDIA_STATUS_DEPRECATED_HARD_ERR_THRESH_EXCEEDED = 22
	set @MEDIA_STATUS_BAD_AS_MEDIA_WRITE_PROTECTED = 4
	declare @rNumMediaExpired  INTEGER
	declare @rNumExpiredPinMedia INTEGER
	declare @lt_ExpiredPINs TABLE (MediaId Integer)
	declare @lt_ExpiredGroupsToProcess TABLE (ExpiredGroupId INTEGER, LibraryId INTEGER)
	if @i_LibraryId > 0
	begin
		INSERT INTO @lt_ExpiredGroupsToProcess
		SELECT SpareGroupId, @i_LibraryId
		FROM MMSpareGroup with (readuncommitted)
		WHERE libraryid = @i_LibraryId and SpareGroupType = 8
	END ELSE
	BEGIN
		INSERT INTO @lt_ExpiredGroupsToProcess
		SELECT SpareGroupId, LibraryId
		from MMSpareGroup with (readuncommitted)
		where sparegrouptype = 8
		declare @l_CurTime Integer
		set @l_CurTime = dbo.getUnixTime(getdate())
		-- do not do a write table lock while table scanning the entire table.
		insert into @lt_ExpiredPINs
		select MediaId
		from mmmedia with (readuncommitted)
		WHERE @l_CurTime >= PinMediaExpireTime AND PinMediaExpireTime > 0
	end
 	CREATE TABLE #tmp_tblMediaToProcess
	(
		mediaId int,
		MediaTypeId int,
		CreationTime int,
		NumberOfReUses int,
		MediaFlags int,
 		expiredGroupId int,
		VTLType int,
		MediaStatusReason int
		PRIMARY KEY(mediaId)
	)
	INSERT INTO #tmp_tblMediaToProcess
	SELECT  M.MediaId, M.MediaTypeId, M.CreationTime, M.NumberOfReUses, M.MediaFlags, E.ExpiredGroupId, L.VTLType, M.MediaStatusReason
	FROM 	MMMedia   AS M WITH (READUNCOMMITTED),
			MMLibrary AS L WITH (READUNCOMMITTED),
			@lt_ExpiredGroupsToProcess AS E
	WHERE	M.LibraryId = E.LibraryId
		AND M.LibraryId = L.LibraryId
		AND M.SpareGroupId != E.ExpiredGroupId
		AND M.IsInMediaGroup = 0
	-- BEGIN updating #tmp_tblMediaToProcess
	BEGIN
			UPDATE #tmp_tblMediaToProcess
			SET MediaFlags = @MEDIA_FLAG_DEPRECATED,
			MediaStatusReason = CASE
									WHEN ((M.VTLType = 0) -- No. of Years
										AND DATEDIFF(month, DATEADD(second, M.CreationTime, '01/01/1970'), getutcdate()) > (  CASE WHEN isnull(MT.MonthsInUseThreshold, 0) > 0
										then MT.MonthsInUseThreshold ELSE @VERY_LARGE_NUMBER end ) )
									THEN
										@MEDIA_STATUS_DEPRECATED_YEARS_THRESH_EXCEEDED
									WHEN ((M.VTLType = 0)  -- No. of Reuses
										AND	M.NumberOfReUses >= ( CASE WHEN isnull(MT.NumberOfReUsesThreshold, 0) > 0
										then MT.NumberOfReUsesThreshold ELSE @VERY_LARGE_NUMBER end ) )
									THEN
										@MEDIA_STATUS_DEPRECATED_REUSES_THRESH_EXCEEDED
									WHEN ( isnull(MS.MediaSideId, 0) > 0 -- No. of Read, Write Sessions
										AND	( ( (M.VTLType = 0)
											AND	(MS.NumberOfRestores + MS.NumberOfBackups) > ( CASE WHEN isnull(MT.ShortLengthDurabilityThreshold, 0) > 0
											then MT.ShortLengthDurabilityThreshold ELSE @VERY_LARGE_NUMBER end ) ) ) )
									THEN
										@MEDIA_STATUS_DEPRECATED_RW_SESS_THRESH_EXCEEDED
									WHEN ( isnull(MS.MediaSideId, 0) > 0  -- No. of Soft Errors
										AND	( ( MS.NumberOfSoftErrors > ( CASE WHEN isnull(MT.NumberOfSoftErrorsThreshold,0) > 0
										then MT.NumberOfSoftErrorsThreshold ELSE  @VERY_LARGE_NUMBER end ) ) ) )
									THEN
										@MEDIA_STATUS_DEPRECATED_SOFT_ERR_THRESH_EXCEEDED
									WHEN ( isnull(MS.MediaSideId, 0) > 0 -- No. of Hard Errors
										AND	( ( MS.NumberOfHardErrors > ( CASE WHEN isnull(MT.NumberOfHardErrorsThreshold, 0) > 0
										then MT.NumberOfHardErrorsThreshold ELSE @VERY_LARGE_NUMBER end ) )	) )
									THEN
										@MEDIA_STATUS_DEPRECATED_HARD_ERR_THRESH_EXCEEDED
									WHEN (M.MediaFlags = @MEDIA_FLAG_BAD OR M.MediaFlags = @MEDIA_FLAG_DEPRECATED)
									THEN M.MediaStatusReason
								END
			FROM    #tmp_tblMediaToProcess as M
				LEFT OUTER JOIN MMMediaType as MT WITH (READUNCOMMITTED) ON M.MediaTypeId = MT.MediaTypeId
				LEFT OUTER JOIN MMMediaSide as MS WITH (READUNCOMMITTED) ON M.MediaId = MS.MediaId
				LEFT OUTER JOIN MMResource  as  R WITH (READUNCOMMITTED) ON M.MediaId = R.MediaId
			WHERE
				(
					(	M.MediaFlags in (@MEDIA_FLAG_BAD, @MEDIA_FLAG_DEPRECATED)
						AND M.MediaStatusReason <> @MEDIA_STATUS_BAD_AS_MEDIA_WRITE_PROTECTED -- don't retire WP media
					)
					OR
					(	(M.VTLType = 0)
						AND
						DATEDIFF(month, DATEADD(second, M.CreationTime, '01/01/1970'), getutcdate())
		  				> (  CASE WHEN isnull(MT.MonthsInUseThreshold, 0) > 0 then MT.MonthsInUseThreshold ELSE @VERY_LARGE_NUMBER end )
		  			)
					OR
		  			(	(M.VTLType = 0) AND
						M.NumberOfReUses >=
		  				( CASE WHEN isnull(MT.NumberOfReUsesThreshold, 0) > 0 then MT.NumberOfReUsesThreshold ELSE @VERY_LARGE_NUMBER end )
					)
					OR
		  			(	isnull(MS.MediaSideId, 0) > 0 AND
		    			(
		    				(	(M.VTLType = 0) AND
								(MS.NumberOfRestores + MS.NumberOfBackups) >
		    					( CASE WHEN isnull(MT.ShortLengthDurabilityThreshold, 0) > 0 then MT.ShortLengthDurabilityThreshold ELSE @VERY_LARGE_NUMBER end )
		    				)
							OR
		    				(	MS.NumberOfSoftErrors >
		    					( CASE WHEN isnull(MT.NumberOfSoftErrorsThreshold,0) > 0 then MT.NumberOfSoftErrorsThreshold ELSE  @VERY_LARGE_NUMBER end)
		    				) OR
		    				(	MS.NumberOfHardErrors >
		    					( CASE WHEN isnull(MT.NumberOfHardErrorsThreshold, 0) > 0 then MT.NumberOfHardErrorsThreshold ELSE @VERY_LARGE_NUMBER end)
		    				)
		    			)
					)
				)
			AND R.MediaId IS NULL
			SET @rNumMediaExpired = @@rowcount
	END
	-- Begin updating MMMedia
	BEGIN
		UPDATE MMMedia
			SET sparegroupid = M.ExpiredGroupId, MediaFlags = M.MediaFlags, MediaStatusReason = M.MediaStatusReason
		FROM    #tmp_tblMediaToProcess as M
		INNER JOIN MMMedia on M.MediaId = MMMedia.MediaId
		WHERE M.MediaFlags = @MEDIA_FLAG_DEPRECATED
	END
	-- End updating MMMedia
	--- Section 2 - expire media pin time
	SET @rNumExpiredPinMedia = 0
	if @i_LibraryId = 0
	begin
		UPDATE MMMedia
SET PinMediaExpireTime = 0, Attributes = Attributes & ~16777216
		FROM @lt_ExpiredPINs tt
		WHERE MMMedia.MediaId = tt.MediaId
		SET @rNumExpiredPinMedia = @@rowcount
	end
	--- Section 3 - return results
	SELECT @rNumMediaExpired, @rNumExpiredPinMedia
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2ExpireMedia')
	delete from GxQscripts where name = 'MMS2ExpireMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2ExpireMedia')
	delete from GXDBVersions where aliasname = 'MMS2ExpireMedia'
GO

insert into GXDBVersions values(2, 'MMS2ExpireMedia',  '00010010029400050000', 'MMS2ExpireMedia', '00010010029400050000')
GO

