

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2DeleteMediaByMediaId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2DeleteMediaByMediaId.sp,v $ $Id: MMS2DeleteMediaByMediaId.sp,v 1.17.60.2 2018/03/20 19:42:16 jiechen Exp $";
-- 	+----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2DeleteMediaByMediaId"                          |
--	|                                                                      |
--	| This procedure is executed only for magnetic media. It assumes that  |
--	| all chunks in the media are aged except for invalid chunks.          |
--	|                                                                      |
-- 	+----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2DeleteMediaByMediaId <<<'

IF EXISTS (select * from sysobjects where name='MMS2DeleteMediaByMediaId')
	drop procedure MMS2DeleteMediaByMediaId
IF EXISTS (select * from GxQscripts where name='MMS2DeleteMediaByMediaId')
	delete from GxQscripts where name = 'MMS2DeleteMediaByMediaId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2DeleteMediaByMediaId')
	delete from GXDBVersions where aliasname = 'MMS2DeleteMediaByMediaId'
GO
print '... Creating Procedure: MMS2DeleteMediaByMediaId'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2DeleteMediaByMediaId
  @i_mediaId integer
AS
  DECLARE @errorCode integer
  DECLARE @errorString varchar(255)
	DECLARE @l_retValue		integer
	DECLARE @l_errorString	varchar(256)
	DECLARE @l_mediaTypeId	integer
	IF object_id('tempdb.dbo.#tmpVolumes') is not null DROP TABLE #tmpVolumes
	IF object_id('tempdb.dbo.#tempChunk') is not null DROP TABLE #tempChunk
	CREATE TABLE #tmpVolumes(volumeId int, SIDBStoreId int, MediaSideId int, primary key (volumeid))
	CREATE TABLE #tempChunk (id bigint, commCellId int, volumeId int, SIDBStoreId int, MediaSideId int, MountPathId int)
	SET 	@l_retValue = 0
	SET 	@l_errorString = ''
	SELECT	@l_mediaTypeId = MediaTypeId
	FROM	MMMedia WITH (NOLOCK)
	WHERE	MediaId = @i_mediaId
	IF EXISTS (SELECT MediaId FROM VTActionMedia WITH (NOLOCK) WHERE MediaId = @i_mediaId)
	BEGIN
		SET @l_retValue = -1
		SET @l_errorString = 'Delete Media Failed: This media is currently in use by a pending action'
		goto ERROR_EXIT
	END
	INSERT	INTO #tmpVolumes
	SELECT	VolumeId, SIDBStoreId, MediaSideId
	FROM	MMVolume WITH (NOLOCK)
	WHERE	MediaId = @i_mediaId
	--Is volume referenced??? and is it a Magnetic Volume??
	IF	@l_mediaTypeId = 10001
	AND EXISTS (select	AC.id from ArchChunk as AC WITH (NOLOCK) INNER JOIN #tmpVolumes as MV ON AC.VolumeId = MV.VolumeId
				where	(AC.physicalSize > 0 OR AC.logicalSize > 0) and (AC.flags & 256) = 0)
	begin
		SET @l_retValue = -1
		SET @l_errorString = 'Delete Media Failed: This Mount Path has some non-aged data.'
		goto ERROR_EXIT
	end
	--Delete archive files and chunks. Make sure that no orphan chunks remain.
	IF OBJECT_ID('tempdb..#tmpResutSetForArchDeleteBackupByMedia') IS NOT NULL  DROP TABLE #tmpResutSetForArchDeleteBackupByMedia
	CREATE TABLE #tmpResutSetForArchDeleteBackupByMedia (jobId INT, appId INT, appTypeId INT, backupSet INT, forceNextBkpFull INT)
	EXEC @l_retValue = ArchDeleteBackupByMedia @i_mediaId, -1, 1
	IF (@l_retValue <> 0)
		goto ERROR_EXIT
	DROP TABLE #tmpResutSetForArchDeleteBackupByMedia
	--Delete the invalid chunks
	INSERT	INTO #tempChunk
	SELECT	AC.id, AC.commCellId, AC.volumeId, tt.SIDBStoreId, tt.MediaSideId, 0
	FROM	#tmpVolumes as tt INNER JOIN archChunk AC WITH (NOLOCK) ON AC.volumeId = tt.VolumeId
	WHERE	AC.physicalSize = 0
		AND AC.logicalSize = 0 AND tt.volumeId NOT IN (select VolumeId from MMResource WITH (NOLOCK))
	DELETE	archChunkMapping
	FROM	#tempChunk
	WHERE	archChunkMapping.archChunkId = #tempChunk.id AND archChunkMapping.chunkCommCellId = #tempChunk.commCellId
	DELETE	archChunk
	FROM	#tempChunk
	WHERE	archChunk.id = #tempChunk.id AND archChunk.commCellId = #tempChunk.commCellId
	UPDATE	#tempChunk
	SET		MountPathId = MP.MountPathId
	FROM	MMMountPath MP WITH (NOLOCK)
	WHERE	MP.MediaSideId = #tempChunk.MediaSideId
	INSERT INTO MMDeletedAF
	SELECT	0, volumeId, 0, 0, 0, '', 0, id, MountPathId, SIDBStoreId, 0, dbo.GetUnixTime(GETUTCDATE()), 0, 0, 0, 0, 0, CommCellId
	FROM	#tempChunk
	DELETE archChunk WITH(PAGLOCK)
	FROM   archChunk a, #tempChunk b
	WHERE  a.id = b.id AND a.commCellId = b.commCellId
	--replace volume in Drive
	Update MMDrive
	set MediaId = 0, VolumeId = 0, CurrentFileMarker = -1, FileMarkerCacheType = 0,
		LastUseTime = datediff(second,'01/01/1970', getutcdate())
	where MediaId = @i_mediaId
	--Undeclare Media from the Slot table.
	update MMSlot
	set MediaId = 0, ConfidenceLevel = 0, InventoryTimeStamp = 0
	where MediaId = @i_mediaId
	--Delete the alerts
	delete from VTAlerts
	where mediaId = @i_mediaId
	--Now remove the volumes
	delete MMVolume from #tmpVolumes
	where MMVolume.VolumeId = #tmpVolumes.VolumeId
	--No harm if MMMountPathToStorageDevice and MMMountPath tables are already cleaned.
	IF	@l_mediaTypeId = 10001
	BEGIN
		delete from MMMountPathToStorageDevice
		where MountPathId IN (select MountPathId from MMMountPath where MediaSideId IN (
							select MediaSideId from MMMediaSide where MediaId = @i_mediaId))
		delete from MMMountPath
		where MediaSideId IN (select MediaSideId from MMMediaSide where MediaId = @i_mediaId)
	END
	--Now remove the sides.
	delete from MMMediaSide
	where MediaId = @i_mediaId
	--Finally delete the Media
	delete from MMMedia
	where Mediaid = @i_mediaId
ERROR_EXIT:
	DROP TABLE #tmpVolumes
	DROP TABLE #tempChunk
	IF OBJECT_ID('tempdb..#tmpResutSetForMMS2DeleteMediaByMediaId') IS NOT NULL
	BEGIN
		INSERT INTO #tmpResutSetForMMS2DeleteMediaByMediaId
		select @l_retValue, @l_errorString
	END
	ELSE
		select @l_retValue, @l_errorString
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2DeleteMediaByMediaId')
	delete from GxQscripts where name = 'MMS2DeleteMediaByMediaId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2DeleteMediaByMediaId')
	delete from GXDBVersions where aliasname = 'MMS2DeleteMediaByMediaId'
GO

insert into GXDBVersions values(2, 'MMS2DeleteMediaByMediaId',  '00010017006000020000', 'MMS2DeleteMediaByMediaId', '00010017006000020000')
GO

