

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2DeleteDeviceControllerByDevCtrlId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2017  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2DeleteDeviceControllerByDevCtrlId.sp,v $ $Id: MMS2DeleteDeviceControllerByDevCtrlId.sp,v 1.1.2.2 2018/09/08 03:32:49 aselvanayagam Exp $";
--
--  +========================================================================+
--  |   Procedure:  MMS2DeleteDeviceControllerByDevCtrlId
--  |
--  | Description:  Creates an association between credential and caller entity
--  |
--  |       Input:  Entity Id, Entity Type, Credential Id, Flag to indicate an updation is requires
--  |
--  |      Output:  Credential assoc ID if a valid credential ID was passed
--  |
--  |      Notes:	None at this time
--  |
--  |   Revisions  Author			Description
--  |   ---------  -------			---------------------------------------------
--  |   1.1        aselvanayagam 	Stored procedure to delete a credential association and update the creating entity with the association
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2DeleteDeviceControllerByDevCtrlId <<<'

IF EXISTS (select * from sysobjects where name='MMS2DeleteDeviceControllerByDevCtrlId')
	drop procedure MMS2DeleteDeviceControllerByDevCtrlId
IF EXISTS (select * from GxQscripts where name='MMS2DeleteDeviceControllerByDevCtrlId')
	delete from GxQscripts where name = 'MMS2DeleteDeviceControllerByDevCtrlId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2DeleteDeviceControllerByDevCtrlId')
	delete from GXDBVersions where aliasname = 'MMS2DeleteDeviceControllerByDevCtrlId'
GO
print '... Creating Procedure: MMS2DeleteDeviceControllerByDevCtrlId'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2DeleteDeviceControllerByDevCtrlId
  @i_deviceControllerId integer
AS
  DECLARE @dbErrorCode integer
  DECLARE @errorCode integer
  DECLARE @errorString varchar(255)
SET NOCOUNT ON
BEGIN TRY
	DECLARE @l_credentialAssocId	integer
	SELECT @dbErrorCode = 0, @errorCode = 0, @errorString = ''
	SELECT @l_credentialAssocId = CredentialAssocId FROM MMDeviceController WHERE DeviceControllerId = @i_deviceControllerId
	DELETE MMDeviceController WHERE DeviceControllerId = @i_deviceControllerId
	-- Delete the credential association only if it exists
	IF @l_credentialAssocId > 0
		DELETE APP_CredentialAssoc WHERE assocId = @l_credentialAssocId
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @dbErrorCode = ERROR_NUMBER()
SET @errorCode = 287
	SET @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' + Convert(varchar(5), ERROR_LINE()) + ']. ' + ERROR_MESSAGE()
END CATCH
SELECT @dbErrorCode, @errorCode, @errorString
SET NOCOUNT OFF;
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2DeleteDeviceControllerByDevCtrlId')
	delete from GxQscripts where name = 'MMS2DeleteDeviceControllerByDevCtrlId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2DeleteDeviceControllerByDevCtrlId')
	delete from GXDBVersions where aliasname = 'MMS2DeleteDeviceControllerByDevCtrlId'
GO

insert into GXDBVersions values(2, 'MMS2DeleteDeviceControllerByDevCtrlId',  '00010001000200020000', 'MMS2DeleteDeviceControllerByDevCtrlId', '00010001000200020000')
GO

