

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2DataPathMAsAreCompatibleForAppTypesInSP.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2DataPathMAsAreCompatibleForAppTypesInSP.sp,v $ $Id: MMS2DataPathMAsAreCompatibleForAppTypesInSP.sp,v 1.7.202.2 2018/03/20 20:00:51 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2DataPathMAsAreCompatibleForAppTypesInSP"					|
--	|
--	|	Check if all datapaths for a particular copy also have
--	|	Clients installed on them (so they have a JobResultsdirectory)
--	|  	- this is required when assigning a SP to a NAS client or
--	|  	  if adding a Datapath to SP that has a NAS client in it
--  |	Also check if there is a CBRM client that all MAs have the CBRM module
--  | and if there is a NAS client, check that all MAs have NRS installed on them if
--  | the default drivepool type is NAS.
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2DataPathMAsAreCompatibleForAppTypesInSP <<<'

IF EXISTS (select * from sysobjects where name='MMS2DataPathMAsAreCompatibleForAppTypesInSP')
	drop procedure MMS2DataPathMAsAreCompatibleForAppTypesInSP
IF EXISTS (select * from GxQscripts where name='MMS2DataPathMAsAreCompatibleForAppTypesInSP')
	delete from GxQscripts where name = 'MMS2DataPathMAsAreCompatibleForAppTypesInSP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2DataPathMAsAreCompatibleForAppTypesInSP')
	delete from GXDBVersions where aliasname = 'MMS2DataPathMAsAreCompatibleForAppTypesInSP'
GO
print '... Creating Procedure: MMS2DataPathMAsAreCompatibleForAppTypesInSP'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2DataPathMAsAreCompatibleForAppTypesInSP
  @archGroupId integer,
  @newAppTypeId integer,
  @includeMAClientIdInCheck integer
AS
-- skip NAS CHeck - if assigning this Storage Policy to a NAS client, then we
-- want to skip this check because we want to check if the SP is valid for a NAS client
-- include MA ClientId - when adding a datapath, we want to check if with this new datapath
--			- the config would still be valid.
--			- To see that, pass in this new MA ClientID.
  DECLARE @o_problemType integer
  DECLARE @o_MAClientId integer
  DECLARE @o_MAClientName varchar(255)
  DECLARE @o_AppTypeId integer
-- Problem types:
--
-- 1: No client installed on given MA
-- 2: Some apptype was uninstalled from the MA, but further
--    checks are needed to see if this apptype is a filesystem agent
-- 3: NRS is required but not installed on this MA
-- 4: CBRM requires that all MAs have CBRM modules installed on them, this MA does not.
-- the cursor will return nothing if everything is OK.
	SET NOCOUNT ON
	DECLARE @i_archgroupId integer
	SET @i_archgroupId = @archGroupId
	DECLARE @i_newAppTypeId integer
	SET @i_newAppTypeId = @newAppTypeId
	DECLARE @i_IncludeMA	integer
	SET @i_IncludeMA = @includeMAClientIdInCheck
	-- end of input
	DECLARE @i_forceMAAreClientsCheck  Integer
	SET @i_forceMAAreClientsCheck = CASE when @i_newAppTypeId IN (13,88) then 1 else 0 END
	DECLARE @l_NASIdaInCopy	integer
	SET @l_NASIdaInCopy = 0
	DECLARE @l_CBRMClientsInCopy Integer
	SET @l_CBRMClientsInCopy  = 0
	-- first, detect if there are any NAS clients in the SP
	IF (@i_forceMAAreClientsCheck = 1)
	BEGIN
		SET @l_NASIdaInCopy = CASE WHEN (@i_newAppTypeId = 13) then 1 ELSE 0  END
		SET @l_CBRMClientsInCopy = CASE WHEN (@i_newAppTypeId = 88) then 1 ELSE 0 END
	END ELSE
	IF (@i_archgroupId > 0)
	BEGIN
			IF ( exists
			(
				SELECT App.Id
				FROM APP_Application AS App, APP_IDAName AS INm
				WHERE 			App.appTypeId = 13 AND Inm.appTypeId = 13
										AND (INm.status & 2) = 0 and INm.modified = 0
										-- status & 2 means means deconfigured
										AND INm.ClientId = App.ClientId
										AND (App.dataArchGrpId = @i_archGroupId OR App.logArchGrpId = @i_archGroupId)
			) )
			BEGIN
				SET @l_NASIdaInCopy = 1
			END ELSE
			BEGIN
				SET @l_NASIdaInCopy = 0
			END
			IF ( exists
			(
				SELECT App.Id
				FROM APP_Application AS App, APP_IDAName AS INm
				WHERE 			App.appTypeId = 88 AND Inm.appTypeId = 88
										AND (INm.status & 2) = 0 and INm.modified = 0
										-- status & 2 means means deconfigured
										AND INm.ClientId = App.ClientId
										AND (App.dataArchGrpId = @i_archGroupId OR App.logArchGrpId = @i_archGroupId)
			) )
			BEGIN
				SET @l_CBRMClientsInCopy = 1
			END ELSE
			BEGIN
				SET @l_CBRMClientsInCopy = 0
			END
	END
	declare @tmpProblematicMAs TABLE 			( 	problemType		integer,
									MAClientId 		integer,
									AppTypeId		integer)
	IF (@l_NASIdaInCopy = 1 OR @i_forceMAAreClientsCheck = 1)
	BEGIN
		-- get list of MAs in storage policy copy
		DECLARE @l_defCopyId integer
		SET @l_defCopyId = (SELECT defaultCopy FROM ArchGroup WHERE id = @i_archgroupId)
		declare  @tmpMAs	TABLE ( MAClientId		integer)
		INSERT INTO @tmpMAs
		SELECT distinct MD.ClientId
		FROM MMDataPath AS MDP, MMDrivePool as MD
		WHERE MDP.CopyId = @l_defCopyId AND MD.DrivePoolId = MDP.DrivePoolId
		if (@i_IncludeMA > 0)
		BEGIN
			INSERT INTO @tmpMAs
			SELECT @i_IncludeMA
			-- add NAS proxy MAs
			INSERT INTO @tmpMAs
			SELECT 	distinct MDP.ClientId
			FROM  	MMNDMPHostInfo as NHI, MMDrivePool as MDP
			WHERE 	NHI.ClientId = @i_IncludeMA AND
			      	MDP.NDMPHostId = NHI.NDMPHostId
		END
		-- first make sure that if default drivepool for copy is non-NAS and if we have NAS clients that all MAs have a configured
		-- NRS
		IF (@l_NASIdaInCopy = 1 OR @l_CBRMClientsInCopy = 1) AND (ISNULL((SELECT DP.DrivePoolType
		FROM MMDrivePool AS DP, MMDataPath as DPath
		WHERE DPath.CopyId = @l_defCopyId AND (DPath.Flag & 1) = 1 AND DP.DrivePoolId = DPath.DrivePoolId ), 3) <> 3)
		-- the ISNULL(..., 3) is a cludge so that if the lookup fails that we just skip the if statement.
		-- important is that if the default is NAS drivepool type, then go in...
		BEGIN
			-- make sure each MA has NRS installed, get ones which do not have NRS (= NDMP Remote Server)
			DECLARE @sNRS_CP varchar(128)
SET @sNRS_CP = dbo.GetLicensePropName(1004);
			INSERT INTO @tmpProblematicMAs
			SELECT 3, tMA.MAClientId,  0
			FROM @tmpMAs AS tMA, APP_Client AS CL
WHERE ((tMA.MAClientId = CL.id) AND (CL.releaseId < 15))
					AND NOT EXISTS
						(SELECT componentNameId FROM APP_ClientProp AS CP
						 WHERE CP.componentNameId = tMA.MAClientId AND
							   CP.attrName = @sNRS_CP AND
							   CP.modified = 0 AND
							   CP.attrVal = '1')
			IF (@@ROWCOUNT > 0)
			BEGIN
				GOTO SHOWRESULTS
			END
		END
		-- if we have CBRMs, we have to check for a CBRM entry on every MA in the NDMPHostInfo table
		-- make sure that if we have CBRM clients that all MAs are CBRM - do not check if passed in APP_Client is type 13.
		-- (we do not want to disallow something that will work because something else is not configured right that
		--  has nothing to do with this operation)
		IF (@l_CBRMClientsInCopy = 1) AND (@i_newAppTypeId <> 13)
		BEGIN
			INSERT INTO @tmpProblematicMAs
			SELECT 4, tMA.MAClientId,  0
			FROM @tmpMAs AS tMA
			WHERE tMA.MAClientId NOT IN
			(
					SELECT NDMPHI.ClientId FROM MMNDMPHostInfo as NDMPHI WHERE NDMPHI.OsType = 16
			)
			IF (@@ROWCOUNT > 0)
			BEGIN
				GOTO SHOWRESULTS
			END
		END
		-- now check that all windows MAs have file system agents installed:
		-- first remove all the non-windows ones.
		DELETE @tmpMAs
--		FROM @tmpMAs AS tt, APP_Client AS CL, simos as SOS, simsystemos as SSOS
--		WHERE  tt.MAClientId = CL.id  AND SSOS.id = CL.SimSystemOSId AND SOS.id = SSOS.simOSId
--					AND ((SOS.simvendorid <> 2) AND (SOS.simvendorid <> 25))
		FROM @tmpMAs AS tt, APP_Client AS CL, simOperatingSystem S
		WHERE  tt.MAClientId = CL.id  AND CL.simOperatingSystemId = S.id AND S.type <> 'Windows'
		-- (vendorId 2 = Microsoft).
		-- of these, let's see if there are any MAs that are not clients
		INSERT INTO @tmpProblematicMAs
		SELECT distinct 1, tt.MAClientId, 0
		FROM @tmpMAs AS tt
		WHERE NOT Exists
		( 	SELECT P.ClientId from APP_Platform AS P
			WHERE P.ClientId = tt.MAClientId
			AND P.PlatformType = 4
		)
		-- remove these as candidates because they are definately wrong already and returned
		DELETE @tmpMAs
		FROM @tmpMAs AS tMAs, @tmpProblematicMAs AS tPMAs
		WHERE tPMAs.MAClientId = tMAs.MAClientId
		-- check to see if there are any uninstalled platforms on the remaining MAs
		INSERT INTO @tmpProblematicMAs
		SELECT distinct 2, tt.MAClientId,  INm.appTypeId
		FROM @tmpMAs AS tt, APP_IDAName AS INm
		WHERE INm.clientId = tt.MAClientId AND (status & 2) = 2 AND INm.modified = 0
	END
SHOWRESULTS:
	SELECT tPMAs.problemType, tPMAs.MAClientId, C.name, tPMAs.AppTypeId
	FROM @tmpProblematicMAs AS tPMAs, APP_Client AS C
	WHERE C.id = tPMAs.MAClientId
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2DataPathMAsAreCompatibleForAppTypesInSP')
	delete from GxQscripts where name = 'MMS2DataPathMAsAreCompatibleForAppTypesInSP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2DataPathMAsAreCompatibleForAppTypesInSP')
	delete from GXDBVersions where aliasname = 'MMS2DataPathMAsAreCompatibleForAppTypesInSP'
GO

insert into GXDBVersions values(2, 'MMS2DataPathMAsAreCompatibleForAppTypesInSP',  '00010007020200020000', 'MMS2DataPathMAsAreCompatibleForAppTypesInSP', '00010007020200020000')
GO

