

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2ConfigureSIDBStoreAndSubStoreInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2ConfigureSIDBStoreAndSubStoreInfo.sp,v $ $Id: MMS2ConfigureSIDBStoreAndSubStoreInfo.sp,v 1.38.14.50 2020/12/23 23:13:23 pnara Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMS2ConfigureSIDBStoreAndSubStoreInfo')
BEGIN
	print '>>> Drop Stored Procedure: MMS2ConfigureSIDBStoreAndSubStoreInfo <<<'
	drop procedure MMS2ConfigureSIDBStoreAndSubStoreInfo
END
IF EXISTS (select * from GxQscripts where name='MMS2ConfigureSIDBStoreAndSubStoreInfo')
	delete from GxQscripts where name = 'MMS2ConfigureSIDBStoreAndSubStoreInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2ConfigureSIDBStoreAndSubStoreInfo')
	delete from GXDBVersions where aliasname = 'MMS2ConfigureSIDBStoreAndSubStoreInfo'
GO
print '... Creating Procedure: MMS2ConfigureSIDBStoreAndSubStoreInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMS2ConfigureSIDBStoreAndSubStoreInfo
  @strxml XML,
  @i_localeId int = 0
AS
  DECLARE @o_SIDBStoreId integer;
  DECLARE @o_SubStoreId integer;
  DECLARE @o_cacheId integer;
  DECLARE @o_accessPathId integer;
  DECLARE @o_ClientId integer;
  DECLARE @o_errorCode int;
  DECLARE @o_errorStr NVARCHAR(1024);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @errCode int
DECLARE @errStr nvarchar(1024)
SET @errCode = 0
SET @errStr = N'NO ERROR'
DECLARE @iDoc INTEGER
Declare @numSubStores int
Declare @clientId int
Declare @commCellId int
Declare @storeName  NVARCHAR(256)
Declare @accesspath varchar(250)
Declare @createTime int
DECLARE @input xml
Declare @copyId int
DECLARE @SQLString nvarchar(500);
DECLARE @ParmDefinition nvarchar(500);
DECLARE @oldestEligibleObjArchiveTime bigint
DECLARE @freeWarningMB int
DECLARE @freeThreshholdMB int
DECLARE @snapIntervalHrs int
declare @spName nvarchar(255)
declare @spCopyName nvarchar(255)
declare @spCommCellId int = 0
declare @l_dedupeFlags int = 0
declare @i_SIDBStoreFlags int = 0
declare @i_SIDBStoreExFlags int = 0
declare @l_defaultCopyId int = 0
declare @l_sealStoreTaskId int = 0
DECLARE @l_lastMultiplexingJobTime  int = 0
declare @l_sourceCopyId int = 0
DECLARE @l_releaseId int = 0
DECLARE @l_90releaseId int = 0
DECLARE @l_version     int = 0
DECLARE @maxNumOfAFsInSecondaryFile INT = 0
DECLARE @operation INT = 0
DECLARE @StoreId INT = 0
DECLARE @oldSubStoreCount INT = 0
DECLARE @archGroupId INT = 0
DECLARE @dedupFactorFlags INT = 0
DECLARE @multiDDBConfig BIT = 0
DECLARE @markAndSweepSupported BIT = 0
DECLARE @isNewCopy BIT = 0
DECLARE @l_appTypeGroupId INT = 0
DECLARE @l_appTypeGroupName nvarchar(255) = ''
DECLARE @cacheId INT = 0
DECLARE @accessPathId INT = 0
IF OBJECT_ID('tempdb..#lt_Stores') IS NOT NULL DROP TABLE #lt_Stores
CREATE TABLE #lt_Stores (SIDBStoreId INT, AppTypeGroupName nvarchar(255))
IF OBJECT_ID('tempdb..#lt_SubStores') IS NOT NULL DROP TABLE #lt_SubStores
CREATE TABLE #lt_SubStores (SIDBStoreId INT, SubStoreId INT)
IF OBJECT_ID('tempdb..#lt_AppTypeGroups') IS NOT NULL DROP TABLE #lt_AppTypeGroups
CREATE TABLE #lt_AppTypeGroups (AppTypeGroupId INT, AppTypeGroupName nvarchar(255))
IF OBJECT_ID('tempdb..#tempSubStore') IS NOT NULL DROP TABLE #tempSubStore
CREATE TABLE #tempSubStore
(
	id 					INT IDENTITY(1,1),
	accessPath			nvarchar(250),
	clientId			INTEGER,
	commCellId			INTEGER,
	freeWarningMB		INTEGER,
	freeThresholdMB		INTEGER
)
IF OBJECT_ID('tempdb..#lt_AccessPath') IS NOT NULL DROP TABLE #lt_AccessPath
CREATE TABLE #lt_AccessPath (IdxCacheId INT, IdxAccessPathId INT, ClientId INT)
SET @createTime = dbo.GetUnixTime(GETUTCDATE())
DECLARE @totalSubStoreCount INT = 0
-- Set both flags
-- For GDSP since we do not know if primary or secondary are pointing.
-- Even for primary if later on copy promotion happens.
IF EXISTS (SELECT 1 FROM MMConfigs WITH(READUNCOMMITTED) WHERE name = 'MMS2_CONFIG_ENABLE_DEDUPFACTOR_SETTINGS' AND value > 0)
BEGIN
SET @dedupFactorFlags = 65536 | 131072
END
ELSE
BEGIN
	-- 6/25/2020 we can allow secondary to always follow primary block size
SET @dedupFactorFlags = 131072
END
set @numSubStores = 0
set @clientId = 0
set @commCellId = 0
set @accesspath = ''
--set @input = '<ParallelDedupConfigReq commCellId="2" clientId="2" copyId="3" libraryId="0" operation="1" opCopyData="0">
--			<SIDBStore>
--			</SIDBStore>
--			<dedupConfigItem commCellId="2">
--				<maInfoList>
--					<clientInfo id="2" name="xyz">
--					<subStoreList subStoreId="" groupNum="">
--						<accessPath idxAccessPathId="2" idxCacheId="2" clientId="2" clientName="xyz" path="C:\ddb" username="" password="" enabled="1" softstate="" offlineReason="" priority=""/>
--					</subStoreList>
--				</maInfoList>
--			</dedupConfigItem>
--	     </ParallelDedupConfigReq>'
set @input = @strXML
exec sp_xml_preparedocument @iDoc OUTPUT, @input
	SET @l_90releaseId = (SELECT id from simAllGalaxyRel WITH(READUNCOMMITTED) where release = '9.0')
	SELECT @operation = operation
	FROM
		OPENXML(@iDoc, 'EVGui_ParallelDedupConfigReq', 0)WITH(operation int '@operation')
	IF(@operation = 0 or @operation is null)
	BEGIN
SET @errStr = (SELECT message FROM EvLocaleMsgs WITH(READUNCOMMITTED) WHERE messageId = (209 | (CAST(POWER(2, 24) AS BIGINT) * 80)) AND localeId = @i_localeId)
SET @errCode = 186
		GOTO CX_EXIT
	END
	SELECT @copyId = copyId
	FROM
		OPENXML(@iDoc, 'EVGui_ParallelDedupConfigReq', 0)WITH(copyId NVARCHAR(250) '@copyId')
IF((@copyId = 0 or @copyId is null) and (@operation <> 15) and (@operation <> 16))
	BEGIN
SET @errStr = (SELECT message FROM EvLocaleMsgs WITH(READUNCOMMITTED) WHERE messageId = (209 | (CAST(POWER(2, 24) AS BIGINT) * 80)) AND localeId = @i_localeId)
SET @errCode = 186
		GOTO CX_EXIT
	END
	SELECT @commCellId = commCellId
	FROM
		OPENXML(@iDoc, 'EVGui_ParallelDedupConfigReq', 0)WITH(commCellId int '@commCellId')
	IF(@commCellId = 0 or @commCellId is null)
	BEGIN
SET @errStr = (SELECT message FROM EvLocaleMsgs WITH(READUNCOMMITTED) WHERE messageId = (209 | (CAST(POWER(2, 24) AS BIGINT) * 80)) AND localeId = @i_localeId)
SET @errCode = 186
		GOTO CX_EXIT
	END
	-- Retreive the substore information from the XML
	INSERT INTO #tempSubStore
	SELECT
			RTRIM(tXml.accessPath)	as 'accessPath',
			tXml.clientId			as 'clientId',
			tXml.commCellId			as 'commCellId',
			tXml.freeWarningMB		as 'freeWarningMB',
			tXml.freeThresholdMB	as 'freeThresholdMB'
	FROM
		OPENXML(@iDoc, 'EVGui_ParallelDedupConfigReq/dedupconfigItem/maInfoList/subStoreList', 0)
		WITH
		(
			accessPath			nvarchar(250)	'accessPath/@path',
			clientId			INTEGER		'../clientInfo/@id',
			commCellId			INTEGER		'../../../@commCellId',
			freeWarningMB		INTEGER		'@diskFreeWarningThreshholdMB',
			freeThresholdMB		INTEGER		'@diskFreeThresholdMB'
		) as tXml
	select @numSubStores = @@ROWCOUNT
IF (@operation = 15) OR (@operation = 16)
	BEGIN
		SELECT @StoreId = SIDBStoreId
		FROM
			OPENXML(@iDoc, 'EVGui_ParallelDedupConfigReq/SIDBStore', 0)WITH(SIDBStoreId int '@SIDBStoreId')
		IF(@StoreId = 0 or @StoreId is null) and (@copyId = 0 or @copyId is null)
		BEGIN
SET @errStr = (SELECT message FROM EvLocaleMsgs WITH(READUNCOMMITTED) WHERE messageId = (209 | (CAST(POWER(2, 24) AS BIGINT) * 80)) AND localeId = @i_localeId)
SET @errCode = 186
			GOTO CX_EXIT
		END
		IF (@copyId = 0 or @copyId is null)
		BEGIN
			select 	@copyId = C.id
			from 	archGroupCopy C WITH(READUNCOMMITTED), archCopySIDBStore S WITH(READUNCOMMITTED)
where 	C.id = S.copyId AND S.SIDBStoreId = @StoreId and C.dedupeFlags & 134217728 = 0
		END
SET @maxNumOfAFsInSecondaryFile = ISNULL((SELECT value FROM MMConfigs WITH (NOLOCK) WHERE name = 'MMS2_CONFIG_DDB_MAX_NUM_OF_AF_IN_SECFILE'),16)
DECLARE @markAndSweepOrPruningLogEnabledStore BIT = (SELECT ExtendedFlags FROM IdxSIDBStore WITH (READUNCOMMITTED) WHERE SIDBStoreId = @StoreId) & (4|8)
SET @multiDDBConfig = ISNULL((SELECT 1 FROM archCopySIDBStore WITH(READUNCOMMITTED) WHERE copyId = @copyId AND (flags & 4) > 0 HAVING count(1) > 1), 0)
		-- if multiple DDBs configured then don't allow adding partitions when new MAs are lower than v11 SP15
		-- else if mark and sweep enabled then don't allow adding partitions when new MAs are lower than v11 SP14
		IF @multiDDBConfig = 1 OR @markAndSweepOrPruningLogEnabledStore = 1
		BEGIN
			IF EXISTS
			(
				SELECT 1
				FROM	(
							SELECT 	ISNULL(VC.PMClientId, T.clientId) clientId
							FROM 	#tempSubStore T
									LEFT OUTER JOIN APP_VMToPMMap VC WITH(READUNCOMMITTED)
									ON T.clientId = VC.VMClientId
						) PC
						INNER JOIN App_Client CN WITH(READUNCOMMITTED) ON CN.id = PC.clientId
						INNER JOIN simInstalledPackages PKG WITH(READUNCOMMITTED) ON CN.id = PKG.ClientId
				WHERE	(CN.releaseId < 16 OR (CN.releaseId = 16 AND PKG.HighestSP < (CASE WHEN @multiDDBConfig = 1 THEN 15 ELSE 14 END)))
AND PKG.simPackageID IN (51, 1301)
			)
			BEGIN
SET @errStr = (SELECT message FROM EvLocaleMsgs WITH(READUNCOMMITTED) WHERE messageId = (1111 | (CAST(POWER(2, 24) AS BIGINT) * 62)) AND localeId = @i_localeId)
SET @errCode = 1012
				GOTO CX_EXIT
			END
		END
		if (@StoreId = 0)
		begin
			INSERT INTO #lt_AppTypeGroups
			select 	S.AppTypeGroupId, N''
			from 	archCopySIDBStore ACS WITH(READUNCOMMITTED)
					INNER JOIN IdxSIDBStore S WITH(READUNCOMMITTED) ON ACS.SIDBStoreId = S.SIDBStoreId
			where 	ACS.copyId = @copyId
and ACS.flags & 4 > 0
		end
		else
		begin
			INSERT INTO #lt_AppTypeGroups
			select 	S.AppTypeGroupId, N''
			FROM	IdxSIDBStore S WITH(READUNCOMMITTED)
			WHERE	S.SIDBStoreId = @StoreId
		end
	END
	ELSE
	BEGIN
		select @spName = ag.name, @archGroupId = ag.id, @spCopyName = agc.name, @l_dedupeFlags = agc.dedupeFlags,
			@l_defaultCopyId = ag.defaultCopy, @l_sourceCopyId = (case agc.sourceCopyId when 0 then ag.defaultCopy else agc.sourcecopyid end ),
@spCommCellId = (case when ag.origCCcommCellID > 0 then ag.origCCcommCellID else 2 end)
		from archGroup ag WITH(READUNCOMMITTED), archGroupCopy agc WITH(READUNCOMMITTED) where agc.id = @copyId and agc.archGroupId = ag.id
IF (@l_dedupeFlags & 268435456) > 0
			set @storeName = @spName
		ELSE
			set @storeName = @spName + '_' + @spCopyName
		SELECT @oldestEligibleObjArchiveTime = oldestEligibleObjArchiveTime
		FROM
			OPENXML(@iDoc, 'EVGui_ParallelDedupConfigReq/SIDBStore', 0)WITH(oldestEligibleObjArchiveTime BIGINT '@oldestEligibleObjArchiveTime')
		IF(@oldestEligibleObjArchiveTime >= 4294967295 or @oldestEligibleObjArchiveTime = 0 or @oldestEligibleObjArchiveTime is null)
		BEGIN
			set @oldestEligibleObjArchiveTime = -1
		END
		SELECT @freeWarningMB = diskFreeWarningThreshholdMB
		FROM
			OPENXML(@iDoc, 'EVGui_ParallelDedupConfigReq/SIDBStore', 0)WITH(diskFreeWarningThreshholdMB INT '@diskFreeWarningThreshholdMB')
		IF((@freeWarningMB is null) or (@freeWarningMB = 0))
		BEGIN
			set @freeWarningMB = 10240
		END
		SELECT @freeThreshholdMB = diskFreeThresholdMB
		FROM
			OPENXML(@iDoc, 'EVGui_ParallelDedupConfigReq/SIDBStore', 0)WITH(diskFreeThresholdMB INT '@diskFreeThresholdMB')
		IF((@freeThreshholdMB is null) or (@freeThreshholdMB = 0))
		BEGIN
			set @freeThreshholdMB = 5120
		END
		SELECT @snapIntervalHrs = SIDBSnapIntervalHours
		FROM
			OPENXML(@iDoc, 'EVGui_ParallelDedupConfigReq/SIDBStore', 0)WITH(SIDBSnapIntervalHours INT '@SIDBSnapIntervalHours')
		IF((@snapIntervalHrs  is null) or (@snapIntervalHrs = 0))
		BEGIN
			set @snapIntervalHrs = 8
		END
		SELECT @i_SIDBStoreFlags = flags
		FROM
			OPENXML(@iDoc, 'EVGui_ParallelDedupConfigReq/SIDBStore', 0)WITH(flags INT '@flags')
		SELECT @i_SIDBStoreExFlags = extendedFlags
		FROM
			OPENXML(@iDoc, 'EVGui_ParallelDedupConfigReq/SIDBStore', 0)WITH(extendedFlags BIGINT '@extendedFlags')
		IF NOT EXISTS (SELECT 1 FROM archCopySIDBStore WITH(READUNCOMMITTED) WHERE copyId = @copyId)
			SET @isNewCopy = 1
IF @i_SIDBStoreFlags & 8192 = 0 AND EXISTS(SELECT 1 FROM MMConfigs WITH(READUNCOMMITTED) WHERE name = 'MMS2_CONFIG_ENABLE_DDB_GARBAGE_COLLECTION' AND value = 1)
		BEGIN
			-- To allow mark and sweep all DDB MAs should be at v11 SP14 or higher
			IF NOT EXISTS
			(
				SELECT 1
				FROM	App_Client CN WITH(READUNCOMMITTED)
						INNER JOIN simInstalledPackages PKG WITH(READUNCOMMITTED) ON CN.id = PKG.ClientId
						INNER JOIN
						(
							SELECT 	ISNULL(VC.PMClientId, ST.clientId) clientId
							FROM	#tempSubStore ST
									LEFT OUTER JOIN APP_VMToPMMap VC WITH(READUNCOMMITTED) ON ST.clientId = VC.VMClientId
						) AS T ON CN.id = T.clientId
				WHERE	(CN.releaseId < 16 OR (CN.releaseId = 16 AND PKG.HighestSP < 14))
AND PKG.simPackageID IN (51, 1301)
			)
				SET @markAndSweepSupported = 1
		END
		IF @markAndSweepSupported = 0
		BEGIN
SET @i_SIDBStoreExFlags = @i_SIDBStoreExFlags & ~(4|8)
		END
		-- 1 DDB
		INSERT INTO #lt_AppTypeGroups
		SELECT ISNULL((SELECT appTypeGroupId FROM OPENXML(@iDoc, 'EVGui_ParallelDedupConfigReq', 0) WITH(appTypeGroupId int '@appTypeGroupId')), 0), N''
		UPDATE	a
		SET		AppTypeGroupName = b.GroupName
		FROM	#lt_AppTypeGroups a, App_AppTypeGroup b WITH(READUNCOMMITTED)
		WHERE 	a.AppTypeGroupId > 0
				AND a.AppTypeGroupId = b.AppTypeGroupId
AND b.TypeOfGroup = 4
		--
		-- Default create 2 partitions if user provides only one DDB path
		--
		IF @numSubStores = 1
			AND ISNULL((SELECT numSIDBStore	FROM OPENXML(@iDoc, 'EVGui_ParallelDedupConfigReq/SIDBStore', 0) WITH(numSIDBStore INT '@numSIDBStore')), @numSubStores) = 2
		BEGIN
			INSERT 	INTO #tempSubStore
			SELECT 	accessPath, clientId, commCellId, freeWarningMB, freeThresholdMB
			FROM	#tempSubStore
			SET @numSubStores = 2
		END
		SET @totalSubStoreCount = @numSubStores
	END
	--
	-- Don't create more than 30 partitions (configurable) on a MA
	--
DECLARE @maxNumPartitionsOnMA int = 50
	SELECT	@maxNumPartitionsOnMA = value
	FROM	MMConfigs WITH (READUNCOMMITTED)
	WHERE	name = 'MMCONFIG_INFINI_STORE_MAX_PATITIONS_ON_MA'
	IF EXISTS
	(
		SELECT 	1
		FROM	(
					SELECT 	clientId, COUNT(1) NumPartitions
					FROM	#tempSubStore, #lt_AppTypeGroups
					GROUP BY ClientId
				) AS NP,
				(
					SELECT 	SS.clientId, 1 NumPartitions
					FROM 	(SELECT DISTINCT clientId FROM #tempSubStore) AS N,
							IdxSIDBSubStore SS WITH(READUNCOMMITTED)
					WHERE	N.clientId = SS.clientId
							AND EXISTS(SELECT 1 FROM archCopySIDBStore CS WITH(READUNCOMMITTED) WHERE CS.SIDBStoreId = SS.SIDBStoreId)
				) AS T
		WHERE	NP.clientId = T.clientId
		GROUP BY NP.ClientId, NP.NumPartitions
		HAVING (SUM(T.NumPartitions) + NP.NumPartitions) >= @maxNumPartitionsOnMA
	)
	BEGIN
SET @errStr = (SELECT message FROM EvLocaleMsgs WITH(READUNCOMMITTED) WHERE messageId = (259 | (CAST(POWER(2, 24) AS BIGINT) * 80)) AND localeId = @i_localeId)
SET @errCode = 361
		GOTO CX_EXIT
	END
-- find if an active store exists for this copy
Declare @sidbStoreId int = 0
DECLARE @tmpStoreId INT = 0
if @operation <> 15 AND @operation <> 16 AND
	( @isNewCopy = 1 OR @multiDDBConfig = 1 )
begin
    -- Determine if the store is eligible for taking lower value based on the release level of the DDB MAs.
    IF EXISTS (SELECT 1 FROM #tempSubStore S WITH (NOLOCK)
		INNER JOIN APP_Client C WITH (NOLOCK) ON S.ClientId = C.id
		INNER JOIN simInstalledPackages I WITH(READUNCOMMITTED) ON C.id = I.ClientId
WHERE I.simPackageID IN (51, 1301)
AND (C.releaseId < 16))
    BEGIN
		-- The partition DDB MAs do not have required release/SP level. Default the setting to 256
		SET @maxNumOfAFsInSecondaryFile = 256
    END
    ELSE
    BEGIN
		-- All the partition DDB MAs have required release level. Set MMConfigs setting to this store in MMEntity
SET @maxNumOfAFsInSecondaryFile = ISNULL((SELECT value FROM MMConfigs WITH (NOLOCK) WHERE name = 'MMS2_CONFIG_DDB_MAX_NUM_OF_AF_IN_SECFILE'),16)
    END
    -- Silo can be enabled for Deduplication stores at any time started from 9.0
SET @i_SIDBStoreFlags = (@i_SIDBStoreFlags | 1048576)
IF  (@l_dedupeFlags & 2097152) <> 0
SET @i_SIDBStoreFlags = (@i_SIDBStoreFlags | 2097152)
    -- Software compression is enable by default for primary copy
    IF  @l_defaultCopyId = @copyId
SET @i_SIDBStoreFlags = (@i_SIDBStoreFlags | 2 ) -- DISABLED FOR SP 9, NEED to UN-COMMENT FOR SP 10 | 16384)
IF  (@l_dedupeFlags & 268435456) <> 0
SET @i_SIDBStoreFlags = (@i_SIDBStoreFlags | 16)
SET @i_SIDBStoreFlags = (@i_SIDBStoreFlags | 536870912)
    -- If MAs are v10 and above then enable validation flag before hand. So that we avoid cases where the flag gets reset by DDB engine.
    IF NOT EXISTS (SELECT 1 FROM #tempSubStore S WITH (NOLOCK)
		INNER JOIN APP_Client C WITH (NOLOCK) ON S.ClientId = C.id
WHERE (C.releaseId < 15))
    BEGIN
SET @i_SIDBStoreFlags = (@i_SIDBStoreFlags | 8388608)
    END
	--
	-- SIDBGroup to use
	--
	DECLARE @l_SIDBGroupId INT = 0
	DECLARE @l_CommCellId INT = @spCommCellId
	--For migrated storage policy try getting commCellId from jobs if there are any other copies exists already
IF  @spCommCellId > 2
	BEGIN
		SELECT 	@l_CommCellId = ISNULL(MIN(JS.commCellId), @spCommCellId)
		FROM	JMJobDataStats JS WITH(READUNCOMMITTED)
		WHERE	JS.archGrpCopyId = @l_sourceCopyId
	END
	--Create group for migrated CommCellId if not exists
IF @l_CommCellId > 2
	BEGIN
		SELECT	@l_SIDBGroupId = SIDBGroupId
		FROM	IdxSIDBGroup WITH(READUNCOMMITTED)
		WHERE	CopyId = @copyId AND CommCellId = @l_CommCellId
		IF @@ROWCOUNT = 0
		BEGIN
			INSERT INTO IdxSIDBGroup (CopyId, CommCellId)
			SELECT @copyId, @l_CommCellId
			SET @l_SIDBGroupId = SCOPE_IDENTITY()
		END
SELECT 	@storeName = LEFT(@storeName + '_' +  aliasName, 256/2 - 30)
		FROM	App_CommCell WITH(READUNCOMMITTED)
		WHERE	id = @l_CommCellId
	END
	DECLARE curStore CURSOR LOCAL FORWARD_ONLY FOR
	SELECT 	AppTypeGroupId, AppTypeGroupName
	FROM 	#lt_AppTypeGroups
	OPEN curStore
	FETCH NEXT FROM curStore INTO @l_appTypeGroupId, @l_appTypeGroupName
	WHILE (@@FETCH_STATUS = 0)
	BEGIN
		INSERT INTO IdxSIDBStore
			   ([SIDBStoreName]
			   ,[SIDBStoreAliasName]
			   ,[CommCellId],[IdxCacheId]
			   ,[IdxAccessPathId],[ClientId],[FirstBackupTime],[MinObjSizeKB]
			   ,[oldestEligibleObjArchiveTime],[SignatureType],[flags]
			   ,[TotalDataSizeBytes],[InstancedDataSizeBytes],[Status],[LastAccessTime]
			   ,[CreatedTime],[SealedTime],[origCCSIDBStoreId],[Version]
			   ,[SIDBSnapPath],[LastSnapTime],[LastRecoveryTime],[SealedReason]
			   ,[SIDBSiloedTime],[SIDBSiloStatus],[SIDBSiloJobId], [SubStoreCount], [MaxAllowedConnections], [MaxNumOfAFsInSecFile]
			   ,[DedupFactor]
			   ,[AppTypeGroupId]
			   ,[ExtendedFlags]
			   ,[SIDBGroupId])
		VALUES
			    (case when @l_appTypeGroupId > 0
					then @storeName + '_' +  @l_appTypeGroupName
					else @storeName
				end,
				case when @l_appTypeGroupId > 0
					then @storeName + '_' +  @l_appTypeGroupName
					else @storeName
				end
    		   ,@commCellId,0
			   ,0,@clientId,-1,50
			   ,@oldestEligibleObjArchiveTime,4, @i_SIDBStoreFlags | @dedupFactorFlags
			   ,0,0,0,0
			   ,@createTime,0,0,-1
			   ,'',0,0,0
			   ,0,0,0, @numSubStores,0,0
,case when (@dedupFactorFlags & 65536) > 0 then 2 else 1 end
			   ,@l_appTypeGroupId
,@i_SIDBStoreExFlags | (case when @isNewCopy = 1 and @sidbStoreId = 0 then 2 else 0 end)
			   ,@l_SIDBGroupId)
		SET @tmpStoreId = SCOPE_IDENTITY()
		UPDATE	IdxSIDBStore
		SET		SIDBStoreName = SIDBStoreName + '_' + CONVERT(varchar, @tmpStoreId),
				SIDBStoreAliasName = SIDBStoreAliasName + '_' + CONVERT(varchar, @tmpStoreId)
		WHERE	SIDBStoreId = @tmpStoreId
		--Take first store as default store
		IF @sidbStoreId = 0
			SET @sidbStoreId = @tmpStoreId
		INSERT INTO #lt_Stores
		VALUES(@tmpStoreId, @l_appTypeGroupName)
		FETCH NEXT FROM curStore INTO @l_appTypeGroupId, @l_appTypeGroupName
	END
	CLOSE curStore
	DEALLOCATE curStore
	INSERT INTO archCopySIDBStore
	(
		CopyId, SIDBStoreId, CommCellId, flags, TotalDataSizeBytes, InstancedDataSizeBytes
	)
SELECT 	@copyId, SIDBStoreId, @commCellId, 4 | (case when @isNewCopy = 1 AND @sidbStoreId = SIDBStoreId then 2 else 0 end), 0, 0
	FROM	#lt_Stores
	--Adding new DDB to an existing GDSP we should add association to dependent copies as well
IF @isNewCopy = 0 AND (@l_dedupeFlags & 268435456) > 0
	BEGIN
		INSERT INTO archCopySIDBStore
		(
			CopyId, SIDBStoreId, CommCellId, flags, TotalDataSizeBytes, InstancedDataSizeBytes
		)
		SELECT 	DC2GC.copyId, C2S.SIDBStoreId, @commCellId, C2S.flags, 0, 0
		FROM	archCopyToGlobalPolicy DC2GC WITH(READUNCOMMITTED),
				archCopySIDBStore C2S WITH(READUNCOMMITTED), #lt_Stores S
		WHERE	DC2GC.globalPolicyId = @archGroupId
				AND C2S.SIDBStoreId = S.SIDBStoreId
	END
	-- Verify if the store copy is pointing to cloud. If so, create an exclusion of this copy from DV2 schedule policy
	IF EXISTS
	(
		SELECT 	1
		FROM 	archGroupCopy AGC WITH (NOLOCK)
				INNER JOIN MMDataPath M WITH (NOLOCK) ON AGC.id = M.CopyId
				INNER JOIN MMDrivePool D WITH (NOLOCK) ON M.DrivePoolId = D.DrivePoolId
				INNER JOIN MMMountPath P WITH (NOLOCK) ON D.MasterPoolId = P.MasterPoolId
		WHERE 	AGC.id = @copyId AND P.MountPathTypeId = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
		UNION
		SELECT	1
		FROM	archGroupCopy AGC WITH (NOLOCK)
				INNER JOIN archGroup AG WITH (READUNCOMMITTED) ON AGC.archGroupId = AG.id
		WHERE	AGC.id = @copyId
AND (AG.flags & 33554432) > 0
	)
	BEGIN
		INSERT INTO TM_AssocEntity(assocType, taskId, flags, created, clientGroupId, clientId, appTypeId, instanceId,
									   backupsetId, subclientId, policyId, copyId, srmReportSet, srmReportType, exclude,
									   trackingPolicyId, MediaagentId, agentlessPolicyId, workflowId, sidbStoreId, libraryId, logMonitoringPolicyId)
SELECT		18,
					taskId,     	-- Task ID
					0,              -- Flags
					@createTime,    -- Created
					0,              -- ClientGroupID
					0,              -- ClientID
					0,              -- AppTypeID
					0,              -- InstanceID
					0,              -- BackupSetID
					0,              -- SubClient ID
					@archGroupId,   -- PolicyID
					@copyId,        -- Copy ID
					0,              -- SRM Report Set
					0,              -- SRM Report Type
					1,              -- Exclude
					0,              -- Trackung Policy ID
					0,              -- Media Agent ID
					0,              -- Agentless SRM ID
					0,              -- Workflow ID
					0,   			-- SIDB Store ID
					0,              -- Library ID
					0               -- Log Monitor Policy ID
		FROM	TM_Task WITH(READUNCOMMITTED)
WHERE 	flags & 0x800 > 0
				AND NOT EXISTS
				(
					SELECT 	1
					FROM 	TM_AssocEntity WITH(READUNCOMMITTED)
					WHERE	taskId = TM_Task.taskId
							AND policyId = @archGroupId
							AND copyId = @copyId
							AND sidbStoreId = 0
				)
	END
end
else if (@StoreId = 0)
begin
	--
	-- Take all active DDBs of copy
	--
	select 	@sidbStoreId = SIDBStoreId
	from 	archCopySIDBStore WITH(READUNCOMMITTED)
	where 	copyId = @copyId
and flags & (4 | 2) = (4 | 2)
	INSERT INTO #lt_Stores
	select 	S.SIDBStoreId, ISNULL(G.GroupName, N'')
	from 	archCopySIDBStore ACS WITH(READUNCOMMITTED)
			INNER JOIN IdxSIDBStore S WITH(READUNCOMMITTED) ON ACS.SIDBStoreId = S.SIDBStoreId
LEFT OUTER JOIN App_AppTypeGroup G WITH(READUNCOMMITTED) ON S.AppTypeGroupId = G.AppTypeGroupId AND G.TypeOfGroup = 4
	where 	ACS.copyId = @copyId
and ACS.flags & 4 > 0
end
else
begin
	SET @sidbStoreId = @StoreId
	INSERT INTO #lt_Stores
	SELECT 	S.SIDBStoreId, ISNULL(G.GroupName, N'')
	FROM	IdxSIDBStore S WITH(READUNCOMMITTED)
LEFT OUTER JOIN App_AppTypeGroup G WITH(READUNCOMMITTED) ON S.AppTypeGroupId = G.AppTypeGroupId AND G.TypeOfGroup = 4
	WHERE	S.SIDBStoreId = @sidbStoreId
end
DECLARE @l_PathSep char = ''
SET @tmpStoreId = 0
DECLARE curStore CURSOR LOCAL FORWARD_ONLY FOR
SELECT SIDBStoreId, AppTypeGroupName FROM #lt_Stores
OPEN curStore
FETCH NEXT FROM curStore INTO @tmpStoreId, @l_appTypeGroupName
WHILE (@@FETCH_STATUS = 0)
BEGIN
	DECLARE @grpNum INT = 0
	SELECT 	@storeName = SIDBStoreAliasName,
		@i_SIDBStoreExFlags = ExtendedFlags
	FROM 	IdxSIDBStore WITH(READUNCOMMITTED)
	WHERE 	SIDBStoreId = @tmpStoreId
IF (@operation = 15) OR (@operation = 16)
	BEGIN
		--Use the same flags as on other substores.
		(SELECT TOP 1 @i_SIDBStoreFlags = flags, @l_version = Version FROM IdxSIDBSubStore WITH (NOLOCK) WHERE SIDBStoreId = @tmpStoreId)
		--well except for ddb move flag, dont copy ddb move flag from some other substore
SET @i_SIDBStoreFlags = @i_SIDBStoreFlags & ~(1024)
		SELECT @grpNum = MAX(GroupNumber) + 1, @oldSubStoreCount = COUNT(1) FROM IdxSIDBSubStore WHERE SIDBStoreId = @tmpStoreId
		SET @totalSubStoreCount = @oldSubStoreCount + @numSubStores
	END
	DECLARE curSubStore CURSOR LOCAL FORWARD_ONLY FOR
	SELECT accessPath, clientId, commCellId, freeWarningMB, freeThresholdMB
	FROM #tempSubStore
	OPEN curSubStore
	FETCH NEXT FROM curSubStore INTO @accesspath, @clientId, @commCellId, @freeWarningMB, @freeThreshholdMB
	WHILE (@@FETCH_STATUS = 0)
	BEGIN
		SELECT 	@cacheId = IdxCacheId, @accessPathId = IdxAccessPathId
		FROM	IdxAccessPath WITH(READUNCOMMITTED)
		WHERE 	Path = @accessPath and ClientId = @clientId
		IF @@ROWCOUNT = 0
		BEGIN
			Declare @poolId int
			INSERT INTO IdxPool ([Description],[Enabled],[IsShared],[AgeingNoOfDays])
			VALUES (@storeName + '_Pool',1,0,20)
			SELECT @errCode = @@ERROR, @poolId = SCOPE_IDENTITY()
			if (@errCode <> 0)
			BEGIN
SET @errStr = (SELECT message FROM EvLocaleMsgs WITH(READUNCOMMITTED) WHERE messageId = (18 | (CAST(POWER(2, 24) AS BIGINT) * 80)) AND localeId = @i_localeId)
SET @errCode = 2
				GOTO CX_EXIT
			END
			UPDATE IdxPool
			SET Description = Description + convert(varchar, @poolId)
			WHERE IdxPoolId = @poolId
			IF((@freeWarningMB is null) or (@freeWarningMB = 0))
			BEGIN
				set @freeWarningMB = 10240
			END
			IF((@freeThreshholdMB is null) or (@freeThreshholdMB = 0))
			BEGIN
				set @freeThreshholdMB = 5120
			END
			INSERT INTO IdxCache
				   ([IdxPoolId],[Description],[Enabled],[Creationtime]
				   ,[SoftState],[OfflineReason],[AgeingPercentDiskspace],[FillUpOrder]
				   ,[FreeDiskSpaceMB],[LastUpdateTime],[LastUpdateAPId],[DiskUsageMB]
				   ,[DiskUsageLastChecked],[DiskFreeThresholdMB],[DiskFreeWarningThreshholdMB],[IdxCacheType]
				   ,[DiskReadSpeed],[DiskWriteSpeed],[CatalogServerClientId],[flags]
				   ,[TotalCapacityMB])
			VALUES
				   (@poolId,@storeName + '_Cache',1,@createTime
				   ,1,0,90,1
				   ,-1,0,-1,-1
				   ,0,@freeThreshholdMB,@freeWarningMB,2
				   ,0,0,0,0
				   ,-1)
			set @errCode = @@ERROR
			if (@errCode <> 0)
			BEGIN
SET @errStr = (SELECT message FROM EvLocaleMsgs WITH(READUNCOMMITTED) WHERE messageId = (18 | (CAST(POWER(2, 24) AS BIGINT) * 80)) AND localeId = @i_localeId)
SET @errCode = 2
				GOTO CX_EXIT
			END
			set @cacheId = SCOPE_IDENTITY()
			UPDATE IdxCache
			SET Description = Description + convert(varchar, @cacheId)
			WHERE IdxCacheId = @cacheId
			INSERT INTO IdxAccessPath
					   ([IdxCacheId],[ClientId],[Path],[Username]
					   ,[Password],[Enabled],[SoftState],[OfflineReason]
					   ,[Priority],[LocalIndexTimeStamp],[ActualDaysIndexRetain],[Flags]
					   ,[AgeingNoOfDays],[AgeingPercentDiskspace],[DiskFreeThresholdMB],[DiskFreeWarningThreshholdMB]
					   ,[TotalCapacityMB],[FreeDiskSpaceMB],[DiskUsageMB],[DiskUsageLastChecked]
					   ,[StagingCachePath], [VolumeGUID])
				 VALUES
					   (@cacheId,@clientId,@accessPath,''
					   ,'',1,1,0
					   ,1,0,0,0
					   ,0,0,@freeThreshholdMB,@freeWarningMB
					   ,0,0,0,0
					   ,'', '')
			set @errCode = @@ERROR
			if (@errCode <> 0)
			BEGIN
SET @errStr = (SELECT message FROM EvLocaleMsgs WITH(READUNCOMMITTED) WHERE messageId = (18 | (CAST(POWER(2, 24) AS BIGINT) * 80)) AND localeId = @i_localeId)
SET @errCode = 2
				GOTO CX_EXIT
			END
			set @accessPathId = SCOPE_IDENTITY()
			INSERT INTO #lt_AccessPath
			VALUES(@cacheId, @accessPathId, @clientId)
		END
		SET @l_releaseId = (SELECT releaseId FROM APP_Client WITH(READUNCOMMITTED) WHERE id = @clientId)
IF (@operation <> 15) AND (@operation <> 16)
		BEGIN
			IF (@l_releaseId >= @l_90releaseId)
				 SET @l_version = -1
			ELSE
			BEGIN
				 SET @l_version = 0
				 UPDATE IdxSIDBStore
				 SET Version = @l_version
				 WHERE SIDBStoreId = @tmpStoreId
			END
		END
		DECLARE @AFPerSec INT = @maxNumOfAFsInSecondaryFile -- Set it to previous setting for older MAs so that after upgrade it works fine.
		SELECT @AFPerSec = 1
		FROM APP_Client C WITH (NOLOCK)
			LEFT OUTER JOIN APP_VMToPMMap MAP WITH (READUNCOMMITTED) ON MAP.VMClientId = C.Id
			INNER JOIN SimInstalledPackages PKG WITH (READUNCOMMITTED) ON PKG.ClientId = ISNULL(MAP.PMClientId, C.Id)
WHERE (C.releaseId > 16) OR ((C.releaseId = 16)  AND (PKG.HighestSP >= 13))
		AND C.id = @clientId
		-- if could not set the above value due to old MA then set the value on the main store row
		IF @@ROWCOUNT = 0
		BEGIN
			UPDATE IdxSIDBStore
			SET MaxNumOfAFsInSecFile = @maxNumOfAFsInSecondaryFile
			WHERE SIDBStoreId = @tmpStoreId
		END
		DECLARE @subStoreExtendedFlags BIGINT = 0
IF @i_SIDBStoreExFlags & 4 > 0
SET @subStoreExtendedFlags |= 1
IF @i_SIDBStoreExFlags & 8 > 0
SET @subStoreExtendedFlags |= 2
		INSERT INTO IdxSIDBSubStore
				   ([SIDBStoreId], [commCellId], [GroupNumber], [IdxCacheId]
				   ,[IdxAccessPathId], [ClientId], [FirstBackupTime], [flags]
				   ,[TotalDataSizeBytes],[InstancedDataSizeBytes],[Status],[LastAccessTime]
				   ,[CreatedTime],[SealedTime],[Version],[SIDBSnapPath]
				   ,[LastSnapTime],[origSubStoreId], [ReconLevel], LastSnapJobId, DDBBackupCSGUID, PrimaryId, MemDbTimeStamp, CorruptionTime, ZeroRefBatchSeq, StartLogSequence, EndLogSequence, SnapLogSequence, MaxNumOfAFsInSecFile, ExtendedFlags, PageSize)
			 VALUES
				   (@tmpStoreId,@commCellId,@grpNum,@cacheId
				   ,@accessPathId,@clientId,-1,@i_SIDBStoreFlags
				   ,0,0,0,0
				   ,@createTime,0,@l_version,''
				   ,0,0, 0, 0, '',0, 0, 0, 0, '', '', '', @AFPerSec, @subStoreExtendedFlags, 0)
		set @errCode = @@ERROR
		if (@errCode <> 0)
		BEGIN
SET @errStr = (SELECT message FROM EvLocaleMsgs WITH(READUNCOMMITTED) WHERE messageId = (18 | (CAST(POWER(2, 24) AS BIGINT) * 80)) AND localeId = @i_localeId)
SET @errCode = 2
			GOTO CX_EXIT
		END
		DECLARE @subStoreId INT = 0
		SET @subStoreId = SCOPE_IDENTITY()
		INSERT INTO #lt_SubStores
		SELECT @tmpStoreId, @subStoreId
		SET @grpNum += 1
		FETCH NEXT FROM curSubStore INTO @accesspath, @clientId, @commCellId, @freeWarningMB, @freeThreshholdMB
	END
	CLOSE curSubStore
    DEALLOCATE curSubStore
IF (@operation = 15) OR (@operation = 16)
	BEGIN
		--Update the substore count in IdxSIDBStore table
		UPDATE IdxSIDBStore
		SET SubStoreCount = @oldSubStoreCount + @numSubStores
		WHERE SIDBStoreId = @tmpStoreId
	END
	FETCH NEXT FROM curStore INTO @tmpStoreId, @l_appTypeGroupName
END
CLOSE curStore
DEALLOCATE curStore
IF (@operation <> 15) AND (@operation <> 16)
BEGIN
	/*PrasadNara 5:36 PM 6/26/2012 MR #74413
	 * If the primary copy has multipexing, with GUI side check this creation should never happen.
	 * However, if the multiplexing has been enabled before, then disabled, there may be jobs that
	 * need to be aux-copied still have multiplexing enabled. Here, we modify the copy start time
	 * to skip such jobs for single instance aux copy.
	 * NOTE : once the fix for auxcopying such multiplexed jobs is ready then the setting copy start time is not needed.
	 */
	SELECT	@l_lastMultiplexingJobTime = ISNULL(MAX(cTime), 0)
	FROM		ArchFile as af WITH(READUNCOMMITTED), ArchFileCopy as afc WITH(READUNCOMMITTED)
	WHERE		af.Id = afc.ArchFileId AND af.commcellId = afc.commcellId
AND			afc.ArchCopyId = @l_sourceCopyId AND (afc.Flags & 64) > 0
	UPDATE ArchGroupCopy
	SET	SIDBStoreId = @sidbStoreId,
dedupeFlags = dedupeFlags | 262144,
		SIDBSnapIntervalHours = @snapIntervalHrs,
		StartTime = CASE WHEN (@l_lastMultiplexingJobTime = 0 OR @l_lastMultiplexingJobTime < StartTime)
							THEN StartTime
							ELSE @l_lastMultiplexingJobTime + 1
					END
	WHERE	Id = @copyId
END
--Set resiliency for HyperScale to 3 partitions
SET @l_sealStoreTaskId = (SELECT sealStoreTaskId FROM archGroupCopy WHERE id = @copyId)
IF (@operation = 16)
BEGIN
    UPDATE archTask
    SET percentCorruptLimit = (@totalSubStoreCount / 2)
    WHERE id = @l_sealStoreTaskId
END
CX_EXIT:
EXEC sp_xml_removedocument @iDoc
IF OBJECT_ID('tempdb.dbo.#tempSubStore') is not null DROP TABLE #tempSubStore
IF @errCode <> 0
BEGIN
	select 0, 0, 0, 0, 0, @errCode, @errStr
END
ELSE
BEGIN
	--
	-- Return access path list to create icl_label file. We fail creation of DDB if label file creation files (it fails if file was already present)
	-- So return only newly created access path entries, if path created by previous DDB is getting reused then don't return it, so that we don't attempt create file again.
	--
	SELECT 	I.SIDBStoreId, I.SubStoreId, ISNULL(AP.IdxCacheId, 0), ISNULL(AP.IdxAccessPathId, 0), ISNULL(AP.ClientId, 0), @errCode, @errStr
	FROM 	IdxSIDBSubStore I
			INNER JOIN #lt_SubStores T ON I.SubStoreId = T.SubStoreId AND I.SIDBStoreId = T.SIDBStoreId
			LEFT OUTER JOIN #lt_AccessPath AP ON I.IdxAccessPathId = AP.IdxAccessPathId
	WHERE	I.SIDBStoreId = @sidbStoreId
	ORDER BY AP.IdxAccessPathId
END
IF OBJECT_ID('tempdb..#lt_Stores') IS NOT NULL DROP TABLE #lt_Stores
IF OBJECT_ID('tempdb..#lt_SubStores') IS NOT NULL DROP TABLE #lt_SubStores
IF OBJECT_ID('tempdb..#lt_AppTypeGroups') IS NOT NULL DROP TABLE #lt_AppTypeGroups
IF OBJECT_ID('tempdb..#lt_AccessPath') IS NOT NULL DROP TABLE #lt_AccessPath
return
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2ConfigureSIDBStoreAndSubStoreInfo')
	delete from GxQscripts where name = 'MMS2ConfigureSIDBStoreAndSubStoreInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2ConfigureSIDBStoreAndSubStoreInfo')
	delete from GXDBVersions where aliasname = 'MMS2ConfigureSIDBStoreAndSubStoreInfo'
GO

insert into GXDBVersions values(2, 'MMS2ConfigureSIDBStoreAndSubStoreInfo',  '00010038001400500000', 'MMS2ConfigureSIDBStoreAndSubStoreInfo', '00010038001400500000')
GO

