

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2CloneVaultTrackerPolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2CloneVaultTrackerPolicy.sp,v $ $Id: MMS2CloneVaultTrackerPolicy.sp,v 1.5.278.3 2018/03/20 19:59:12 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2GetMagLibInfo"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2CloneVaultTrackerPolicy <<<'

IF EXISTS (select * from sysobjects where name='MMS2CloneVaultTrackerPolicy')
	drop procedure MMS2CloneVaultTrackerPolicy
IF EXISTS (select * from GxQscripts where name='MMS2CloneVaultTrackerPolicy')
	delete from GxQscripts where name = 'MMS2CloneVaultTrackerPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2CloneVaultTrackerPolicy')
	delete from GXDBVersions where aliasname = 'MMS2CloneVaultTrackerPolicy'
GO
print '... Creating Procedure: MMS2CloneVaultTrackerPolicy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2CloneVaultTrackerPolicy
  @i_oldPolicyId integer,
  @i_newPolicyName NVARCHAR(255)
AS
  DECLARE @errorCode integer
  DECLARE @errorString char(255)
  DECLARE @newPolicyId integer
	declare		@retVal					integer
	SET			@retVal				=	0
	set			@errorString		=	''
	declare		@l_oldRuleId			integer
	declare		@newRuleId				integer
	set			@l_oldRuleId		=	0
	set			@newPolicyId		=	0
	set			@newRuleId			=	0
	IF EXISTS (SELECT * FROM VTPolicy WHERE PolicyName = @i_newPolicyName)
	BEGIN
		SET @errorString = 'Policy name ''' + @i_newPolicyName + ''' exists already'
		SET @retVal = -1
		goto ErrorExit
	END
	set @l_oldRuleId = (select RuleId from VTPolicyToRule where PolicyId = @i_oldPolicyId)
	--First create the PolicyId.
	insert into VTPolicy
	select @i_newPolicyName, (Flag & ~1), DestinationId, InTransitId, Descript, OfflineReason,
	ContainerId, ContainerPattern, ContainerPatternNumber, ContainerCapacity, DelayTimeInMinutes,
	QuitTimeInMinutes
	from VTPolicy
	where PolicyId = @i_oldPolicyId
	SET	@retVal = @@ERROR
	IF	@retVal != 0
	BEGIN
		SET @errorString = 'Failed to create a new PolicyId'
		goto ErrorExit
	END
	set @newPolicyId = @@IDENTITY
	--Create a Rule with the same association with the Schema.
	insert into VTRule
	select RuleName, Flag
	from VTRule
	where RuleId = @l_oldRuleId
	SET	@retVal = @@ERROR
	IF	@retVal != 0
	BEGIN
		SET @errorString = 'Failed to create a new Rule'
		goto ErrorExit
	END
	set @newRuleId	= @@IDENTITY
	--Create RuleToSchema Association
	insert into VTRuleToSchema
	select @newRuleId, schemaId, Param, Flag
	from VTRuleToSchema
	where RuleId = @l_oldRuleId
	SET	@retVal = @@ERROR
	IF	@retVal != 0
	BEGIN
		SET @errorString = 'Failed to create Rule To Schema Association'
		goto ErrorExit
	END
	--Create the Policy to Rule Association.
	insert into VTPolicyToRule
	select @newPolicyId, @newRuleId
	from VTPolicyToRule
	where PolicyId = @i_oldPolicyId
	SET	@retVal = @@ERROR
	IF	@retVal != 0
	BEGIN
		SET @errorString = 'Failed to create a Policy To Rule Association'
		goto ErrorExit
	END
	--Create the PolicyToCopy Assotiation here
	insert into VTPolicyToCopy
	select @newPolicyId, ArchGroupId, CopyId
	from VTPolicyToCopy
	where PolicyId = @i_oldPolicyId
	SET	@retVal = @@ERROR
	IF	@retVal != 0
	BEGIN
		SET @errorString = 'Failed to create Policy ToCopy Association'
		goto ErrorExit
	END
	INSERT	INTO UMGroupAssociation
	SELECT	groupId, type1, @newPolicyId, type2, id2, type3, id3, type4, id4, flag
	FROM	UMGroupAssociation
	WHERE	type1 = 8462 AND id1 = @i_oldPolicyId
	IF dbo.isNewSecurity() = 1
	BEGIN
		DECLARE @errorMsg NVARCHAR(MAX)
EXEC sec_cloneSecurityAssociationsFromEntity 1, 0, @errorCode OUTPUT, @errorMsg OUTPUT, 21, @i_oldPolicyId, 21, @newPolicyId
	END
	ErrorExit:
		select @retVal, @errorString, @newPolicyId
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2CloneVaultTrackerPolicy')
	delete from GxQscripts where name = 'MMS2CloneVaultTrackerPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2CloneVaultTrackerPolicy')
	delete from GXDBVersions where aliasname = 'MMS2CloneVaultTrackerPolicy'
GO

insert into GXDBVersions values(2, 'MMS2CloneVaultTrackerPolicy',  '00010005027800030000', 'MMS2CloneVaultTrackerPolicy', '00010005027800030000')
GO

