

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2CleanupStoreAndSubStoreInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2CleanupStoreAndSubStoreInfo.sp,v $ $Id: MMS2CleanupStoreAndSubStoreInfo.sp,v 1.4.208.4 2020/09/17 01:33:27 pnara Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMS2cleanupStoreAndSubStoreInfo')
BEGIN
	print '>>> Drop Stored Procedure: MMS2cleanupStoreAndSubStoreInfo <<<'
	drop procedure MMS2cleanupStoreAndSubStoreInfo
END
IF EXISTS (select * from GxQscripts where name='MMS2cleanupStoreAndSubStoreInfo')
	delete from GxQscripts where name = 'MMS2cleanupStoreAndSubStoreInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2cleanupStoreAndSubStoreInfo')
	delete from GXDBVersions where aliasname = 'MMS2cleanupStoreAndSubStoreInfo'
GO
print '... Creating Procedure: MMS2cleanupStoreAndSubStoreInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMS2cleanupStoreAndSubStoreInfo
  @copyId int
AS
  DECLARE @o_errorCode int;
  DECLARE @o_errorStr varchar(255);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @errCode int
DECLARE @errStr nvarchar(255)
SET @errCode = 0
SET @errStr = 'NO ERROR'
DECLARE @subStoreId 	int = 0
DECLARE @accessPathId 	int = 0
DECLARE @cacheId	int = 0
DECLARE	@poolId		int = 0
--get the SIDBStoreId from the archCopySIDBStore table
IF OBJECT_ID('tempdb..#lt_Stores') IS NOT NULL DROP TABLE #lt_Stores
CREATE TABLE #lt_Stores (SIDBStoreId INT)
INSERT INTO #lt_Stores
select SIDBStoreId from archCopySIDBStore WITH (NOLOCK) where copyId = @copyId
If @@ROWCOUNT = 0
 goto EXIT_PROC
--get the corresponding substores and the accessPaths in cursor and cleanup
DECLARE curSubStore CURSOR FOR
SELECT SubStoreId, IdxCacheId, IdxAccessPathId
FROM IdxSIDBSubStore SS WITH (NOLOCK), #lt_Stores S
WHERE SS.SIDBStoreId = S.SIDBStoreId
OPEN curSubStore
FETCH NEXT FROM curSubStore INTO @subStoreId, @cacheId, @accessPathId
WHILE @@FETCH_STATUS = 0
BEGIN
	DELETE FROM IdxSIDBSubStore
	WHERE SubStoreId = @subStoreId
	--Remove access path only when it's not in use
	IF NOT EXISTS(SELECT 1 FROM IdxSIDBSubStore WITH(READUNCOMMITTED) WHERE IdxAccessPathId = @accessPathId)
	BEGIN
		DELETE FROM IdxAccessPath
		WHERE IdxAccessPathId = @accessPathId
		--get the poolId before cleanup of IdxCache entry
		SET @poolId = (SELECT IdxPoolId FROM IdxCache WITH (NOLOCK) WHERE IdxCacheId = @cacheId)
		DELETE FROM IdxCache
		WHERE IdxCacheId = @cacheId
		DELETE FROM IdxPool
		WHERE IdxPoolId = @poolId
	END
	FETCH NEXT FROM curSubStore INTO @subStoreId, @cacheId, @accessPathId
END
CLOSE curSubStore
DEALLOCATE curSubStore
--cleanup the archCopySIDBStore entry
DELETE FROM archCopySIDBStore
WHERE copyId = @copyId
--cleanup the main store entry
DELETE FROM IdxSIDBStore
WHERE SIDBStoreId IN (SELECT SIDBStoreId FROM #lt_Stores)
EXIT_PROC:
select @errCode, @errStr
return
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2CleanupStoreAndSubStoreInfo')
	delete from GxQscripts where name = 'MMS2CleanupStoreAndSubStoreInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2CleanupStoreAndSubStoreInfo')
	delete from GXDBVersions where aliasname = 'MMS2CleanupStoreAndSubStoreInfo'
GO

insert into GXDBVersions values(2, 'MMS2CleanupStoreAndSubStoreInfo',  '00010004020800040000', 'MMS2CleanupStoreAndSubStoreInfo', '00010004020800040000')
GO

