

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2CleanupFullMediaInScratch.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2CleanupFullMediaInScratch.sp,v $ $Id: MMS2CleanupFullMediaInScratch.sp,v 1.2 2006/02/16 00:24:13 mklose Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2CleanupFullMediaInScratch <<<'

IF EXISTS (select * from sysobjects where name='MMS2CleanupFullMediaInScratch')
	drop procedure MMS2CleanupFullMediaInScratch
IF EXISTS (select * from GxQscripts where name='MMS2CleanupFullMediaInScratch')
	delete from GxQscripts where name = 'MMS2CleanupFullMediaInScratch'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2CleanupFullMediaInScratch')
	delete from GXDBVersions where aliasname = 'MMS2CleanupFullMediaInScratch'
GO
print '... Creating Procedure: MMS2CleanupFullMediaInScratch'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2CleanupFullMediaInScratch
  @CommCellId integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @NumMediaAffected integer
	declare @i_CommCellId	integer
	declare @l_numRows		integer
	set @i_CommCellId = @CommCellId
	declare @tmpMedia table (t_MediaId integer,
				t_isAged integer,
				LogicalBytesMB integer,
				PhysicalBytesMB integer)
	insert into @tmpMedia
	select M.MediaId, IsAged, V.LogicalBytesMB, V.PhysicalBytesMB
	from MMMedia as M WITH(READUNCOMMITTED), MMSpareGroup as MSG WITH(READUNCOMMITTED), MMVolume as V WITH(READUNCOMMITTED)
	where V.MediaId = M.MediaId
	AND M.SpareGroupId = MSG.SpareGroupId
	AND M.MediaLocation in(1, 2)
	AND IsInMediaGroup = 0
	AND MSG.SparegroupType in (1,2)
	AND V.VolumeFlags in (2, 7)
	-- Set the logical and physical bytes to 0 if the media are not aged.
	update	@tmpMedia
	set     LogicalBytesMB = 0, PhysicalBytesMB = 0
	WHERE 	t_isAged = 0
	--For all full/appendable media that have no data, just set the VolumeFlags to 5 so that the Jobs can pick them up.
	update  MMVolume
	set		VolumeFlags = 5, VolumeFullJobId = 0, LastFile = 0, NumberOfActiveFiles = 0, LogicalBytesMB = tt.LogicalBytesMB, PhysicalBytesMB = tt.PhysicalBytesMB
	FROM 	@tmpMedia tt
	WHERE MediaId = tt.t_MediaId
	set @l_numRows = @@ROWCOUNT
	select @l_numRows
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2CleanupFullMediaInScratch')
	delete from GxQscripts where name = 'MMS2CleanupFullMediaInScratch'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2CleanupFullMediaInScratch')
	delete from GXDBVersions where aliasname = 'MMS2CleanupFullMediaInScratch'
GO

insert into GXDBVersions values(2, 'MMS2CleanupFullMediaInScratch',  '00010002000000000000', 'MMS2CleanupFullMediaInScratch', '00010002000000000000')
GO

