

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2CheckSpareGroupsForOutOfSparesCondition.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2CheckSpareGroupsForOutOfSparesCondition.sp,v $ $Id: MMS2CheckSpareGroupsForOutOfSparesCondition.sp,v 1.13.2.2 2018/03/20 20:00:45 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2GetCountersInSpare"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2CheckSpareGroupsForOutOfSparesCondition <<<'

IF EXISTS (select * from sysobjects where name='MMS2CheckSpareGroupsForOutOfSparesCondition')
	drop procedure MMS2CheckSpareGroupsForOutOfSparesCondition
IF EXISTS (select * from GxQscripts where name='MMS2CheckSpareGroupsForOutOfSparesCondition')
	delete from GxQscripts where name = 'MMS2CheckSpareGroupsForOutOfSparesCondition'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2CheckSpareGroupsForOutOfSparesCondition')
	delete from GXDBVersions where aliasname = 'MMS2CheckSpareGroupsForOutOfSparesCondition'
GO
print '... Creating Procedure: MMS2CheckSpareGroupsForOutOfSparesCondition'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2CheckSpareGroupsForOutOfSparesCondition
  @CommCellId integer
AS
  DECLARE @o_SpareGroupId integer
  DECLARE @o_SpareGroupName NVARCHAR(256)
  DECLARE @o_LibraryId integer
  DECLARE @o_LibraryName NVARCHAR(256)
  DECLARE @o_TotalSpares integer
  DECLARE @o_LowWaterMark integer
  DECLARE @o_OutSideLib integer
  DECLARE @o_StuckMedia integer
  DECLARE @o_IsLowWaterMark integer
	SET NOCOUNT ON
	IF object_id('tempdb.dbo.#tmpLibList') is not null DROP TABLE #tmpLibList
	IF object_id('tempdb.dbo.#SpareGrpLst') is not null DROP TABLE #SpareGrpLst
	IF object_id('tempdb.dbo.#tmpStuckMedia') is not null DROP TABLE #tmpStuckMedia
	IF object_id('tempdb.dbo.#tmpLibraryAndController') is not null DROP TABLE tmpLibraryAndController
	create table #tmpLibList(LibraryId	integer,
				LibraryName	nvarchar(256),
				LibraryTypeId integer,
				ExtendedAttributes integer)
	create table #SpareGrpLst(SpareGroupId	integer,
				SpareGroupName	nvarchar(256),
				LibraryId	integer,
				TotalSpares	integer,
				LowWaterMark	integer,
				OutSideLib	integer,
				StuckMedia	integer,
				IsLowWaterMark	integer)
	create table #tmpStuckMedia(MediaId		integer)
	--Libraries only including regular, standalone and blind(both regular and optical)
	insert into #tmpLibList
	select distinct L.LibraryId, L.aliasName, L.LibraryTypeId, L.ExtendedAttributes
	from MMLibrary L
	where L.LibraryId > 0 and L.LibraryTypeId in(1, 2, 4, 5, 6, 7)
	--Only spare groups of regular, default(1,2) for all library and cleaning group(32) for non-PnP libs
	--and non-mag libraries
	--Adding a condition for avoid getting Cleaning Media LowWaterMark for Removable Magnetic Library based on Media type
	--MediaTypeId of Removable Mag Library Cleaning media is zero. So check MediaTypeId of Default ScrathPool of the same library
	insert into #SpareGrpLst
	select distinct SpareGroupId, SpareGroupName, MSG.LibraryId, 0, LowWaterMark, 0, 0, IsLowWaterMark
	from MMSpareGroup as MSG WITH (READUNCOMMITTED), #tmpLibList as tt
	where MSG.LibraryId = tt.LibraryId AND
(MSG.SpareGroupType in(1, 2) OR ( MSG.SpareGroupType = 32 AND (((tt.ExtendedAttributes & 4096) = 0) AND (NOT(select MSG1.MediaTypeId from MMSpareGroup MSG1 where MSG1.SpareGroupType = 2 AND MSG.LibraryId = MSG1.LibraryId) between 11001 AND 11999))))
	update #SpareGrpLst
	set TotalSpares = (select count(*) from MMMedia  WITH (READUNCOMMITTED)
						where MediaId > 0 AND LibraryId = tt.LibraryId AND
						SpareGroupId = tt.SpareGroupId
						AND (IsInMediaGroup = 0))
	from #SpareGrpLst as tt
	update #SpareGrpLst
	set OutSideLib = (select count(*) from MMMedia WITH (READUNCOMMITTED)
						where MediaId > 0 AND LibraryId = tt.LibraryId AND
						SpareGroupId = tt.SpareGroupId
						AND MediaLocation = 3
						AND (IsInMediaGroup = 0)
						AND LibraryId NOT IN (select LibraryId from #tmpLibList where LibraryTypeId in (4,5))
						)
	from #SpareGrpLst as tt
	insert into #tmpStuckMedia
	select distinct mediaId
	from MMVolume WITH (READUNCOMMITTED)
	where VolumeId > 0 and VolumeState = 2
	update #SpareGrpLst
	set StuckMedia = (select count(*) from MMMedia WITH (READUNCOMMITTED)
						where MediaId > 0 AND LibraryId = tt.LibraryId AND
						SpareGroupId = tt.SpareGroupId
						AND IsInMediaGroup = 0
						-- check for in-library since the CPP code will minus the
						-- available spares by this count also.. (overall weird logic i know)
						AND MediaLocation <> 3
						AND MediaId in (select MediaId from #tmpStuckMedia))
	from #SpareGrpLst as tt
	select tt1.SpareGroupId, tt1.SpareGroupName, tt1.LibraryId, tt2.LibraryName,
	tt1.TotalSpares, tt1.LowWaterMark, tt1.OutSideLib, tt1.StuckMedia, tt1.IsLowWaterMark
	from #SpareGrpLst as tt1, #tmpLibList as tt2
	where tt1.LibraryId = tt2.LibraryId
	drop table #tmpLibList
	drop table #SpareGrpLst
	drop table #tmpStuckMedia
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2CheckSpareGroupsForOutOfSparesCondition')
	delete from GxQscripts where name = 'MMS2CheckSpareGroupsForOutOfSparesCondition'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2CheckSpareGroupsForOutOfSparesCondition')
	delete from GXDBVersions where aliasname = 'MMS2CheckSpareGroupsForOutOfSparesCondition'
GO

insert into GXDBVersions values(2, 'MMS2CheckSpareGroupsForOutOfSparesCondition',  '00010013000200020000', 'MMS2CheckSpareGroupsForOutOfSparesCondition', '00010013000200020000')
GO

