

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2CheckMountPathsForOutOfSpaceCondition.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2CheckMountPathsForOutOfSpaceCondition.sp,v $ $Id: MMS2CheckMountPathsForOutOfSpaceCondition.sp,v 1.12.48.11.28.1 2021/04/08 22:35:04 pnara Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2CheckMountPathsForOutOfSpaceCondition"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMS2CheckMountPathsForOutOfSpaceCondition')
BEGIN
	print '>>> Drop Stored Procedure: MMS2CheckMountPathsForOutOfSpaceCondition <<<'
	drop procedure MMS2CheckMountPathsForOutOfSpaceCondition
END
IF EXISTS (select * from GxQscripts where name='MMS2CheckMountPathsForOutOfSpaceCondition')
	delete from GxQscripts where name = 'MMS2CheckMountPathsForOutOfSpaceCondition'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2CheckMountPathsForOutOfSpaceCondition')
	delete from GXDBVersions where aliasname = 'MMS2CheckMountPathsForOutOfSpaceCondition'
GO
print '... Creating Procedure: MMS2CheckMountPathsForOutOfSpaceCondition'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMS2CheckMountPathsForOutOfSpaceCondition
  @CommCellId integer,
  @DaysToConsider integer
AS
  DECLARE @o_LibraryId integer
  DECLARE @o_LibraryName NVARCHAR(256)
  DECLARE @o_FreeBytesMB bigint
  DECLARE @o_FreeSpaceStr VARCHAR(128)
  DECLARE @o_LibLowWaterMarkMB bigint
  DECLARE @o_LibLowWaterMarkStr VARCHAR(128)
  DECLARE @o_LibWarningWaterMarkMB bigint
  DECLARE @o_LibWarningWaterMarkStr VARCHAR(128)
  DECLARE @o_OutOfSpaceAlertInDays integer
  DECLARE @o_clientId integer
  DECLARE @o_clientName varchar(256)
  DECLARE @o_AverageSpaceUsedMB bigint
	SET NOCOUNT ON
	declare @i_commCellId	integer
	set @i_commCellId = @CommCellId
	IF object_id('tempdb.dbo.#MountPathList') is not null DROP TABLE #MountPathList
	IF object_id('tempdb.dbo.#tmpLibList') is not null DROP TABLE #tmpLibList
	create table #tmpLibList(LibraryId	integer primary key,
				LibraryName	nvarchar(256),
				FreespaceMB	bigint,
				LowWaterMarkMB	bigint,
				WarningWaterMarkMB	bigint,
				OutOfSpaceAlertInDays	integer,
				ClientId	integer,
				ClientName	varchar(256),
				totalCapMB		bigint,
				DataWrittenMBForAvg	bigint,
				capacityFreedMBForAvg	bigint,
				lastNumDays		integer)
	create table #MountPathList(MountPathId		integer primary key,
					MountPathName		varchar(256),
					LibraryId		integer,
					LibraryName		nvarchar(256),
					mediaId			integer,
					MediaSideId		integer,
					FreeBytesMB		bigint,
					MagneticSpaceRsrvInMB	bigint,
					MaxDataToWriteMB	bigint,
					TotalSpaceMB		bigint,
					ValidData		bigint,
					MountPathTypeId integer)
	insert into #tmpLibList
	select LibraryId, AliasName, 0, LowWaterMarkMB, WarningWaterMark, OutOfSpaceAlertInDays, 0, '', 0, 0, 0, 0
	from MMLibrary WITH (READUNCOMMITTED)
	where LibraryId > 0 AND LibraryTypeId = 3
	if @@ROWCOUNT <> 0
	begin
		-- check if the config param to skip mount paths disabled for write is set.
declare @config bit = 1
		select @config = value from MMConfigs where name = 'MMS2_CONFIG_SKIP_LOW_WATERMARK_CHECK_FOR_MP_DISABLED_FOR_WRITE'
		if(@config = 0)
		begin
			insert into #MountPathList
			select MMP.MountPathId, MMP.MountPathName, MM.LibraryId, tt.LibraryName,
			MMS.MediaId, MMP.MediaSideId, MMS.FreeBytesMB, MMP.MagneticSpaceRsrvInMB,
			MMP.MaxDataToWriteMB, MMS.TotalSpaceMB, 0, MMP.MountPathTypeId
			from MMMountPath as MMP WITH (READUNCOMMITTED), MMMediaSide as MMS WITH (READUNCOMMITTED),
			MMMedia as MM WITH (READUNCOMMITTED), #tmpLibList as tt
			where MM.MediaTypeId = 10001 AND MMP.MountPathId > 0 AND MMP.MediaSideId = MMS.MediaSideId AND MMP.IsEnabled = 1
			ANd MMS.MediaId = MM.MediaId AND MM.LibraryId = tt.LibraryId
		end
		else
		begin
			insert into #MountPathList
			select MMP.MountPathId, MMP.MountPathName, MM.LibraryId, tt.LibraryName,
			MMS.MediaId, MMP.MediaSideId, MMS.FreeBytesMB, MMP.MagneticSpaceRsrvInMB,
			MMP.MaxDataToWriteMB, MMS.TotalSpaceMB, 0, MMP.MountPathTypeId
			from MMMountPath as MMP WITH (READUNCOMMITTED), MMMediaSide as MMS WITH (READUNCOMMITTED),
			MMMedia as MM WITH (READUNCOMMITTED), #tmpLibList as tt
			where MM.MediaTypeId = 10001 AND MMP.MountPathId > 0 AND MMP.MediaSideId = MMS.MediaSideId AND MMP.IsEnabled = 1
			ANd MMS.MediaId = MM.MediaId AND MM.LibraryId = tt.LibraryId AND MMP.MaxConcurrentWriters > 0
		end
		-- Remove MPs that do not have any wrt-enabled paths
		DELETE #MountPathList
		FROM #MountPathList
			INNER JOIN MMMountPathToStorageDevice MPDEV ON #MountPathList.MountPathId = MPDEV.MountPathId
			LEFT OUTER JOIN MMDeviceController DEVC ON MPDEV.DeviceId = DEVC.DeviceId
AND (DEVC.DeviceAccessType & 2) > 0
		WHERE DEVC.DeviceControllerId IS NULL
		-- delete libraries which have disabled all mount paths for write.
		delete from #tmpLibList where LibraryId in
		(select T.LibraryId from #tmpLibList T left join #MountPathList M on T.LibraryId = M.LibraryId where M.MountPathId is NULL)
		--delete all cloud libraries, which are pending for space update.
		-- At the time of mp creation, we set freeSpaceMB and totalSpaceMB as default values(CLOUD_DEFAULT_CAPACITY_MB)
		--During pruning also we set this default value as freeSpace, so that mp can be picked up by space-update
		-- so we cannot send alert on the basis of default values.
		DELETE FROM #tmpLibList
		WHERE LibraryId in (
			SELECT DISTINCT(LibraryId) from #MountPathList MP
WHERE MP.FreeBytesMB = 1048576
				AND MP.MountPathTypeId = 7 -- MOUNT_PATH_EXTERNAL_REMOTE_HOST  = 7
				AND MP.MaxDataToWriteMB <= 0 -- Don't skip cloud libraries set with don't consume more than X GB option.
		)
		--Get rid of mount paths we are not going to process any more
		DELETE #MountPathList WHERE libraryId NOT IN (SELECT libraryId FROM #tmpLibList)
		--Find actual space occupied on disk by the mount path. It is needed only when MaxDataToWriteMB is set
		UPDATE #MountPathList SET ValidData =
		ISNULL((SELECT SUM(physicalBytesMB) FROM MMVolume WITH(NOLOCK) WHERE MMVolume.MediaId = #MountPathList.MediaId AND #MountPathList.MaxDataToWriteMB > 0),0)
		update #tmpLibList
		set FreespaceMB = (select isnull(sum(case   when(#MountPathList.MaxDataToWriteMB <= 0) then
								case when (#MountPathList.FreeBytesMB - MagneticSpaceRsrvInMB) < 0 then 0
									else (#MountPathList.FreeBytesMB - MagneticSpaceRsrvInMB) end
								else
									 case when (#MountPathList.MaxDataToWriteMB > #MountPathList.ValidData) then
										/*When available FreeBytes on disk is less than allotted quota just use FreeBytesMB else use available quota*/
										case when (#MountPathList.MaxDataToWriteMB - #MountPathList.ValidData) < #MountPathList.FreeBytesMB then (#MountPathList.MaxDataToWriteMB - #MountPathList.ValidData)
										else #MountPathList.FreeBytesMB end
									 else 0 end
								end) ,0)
				from #MountPathList
				where libraryid = #tmpLibList.libraryid)
		update #tmpLibList
		set totalCapMB = (select isnull(sum(case when (#MountPathList.MaxDataToWriteMB <= 0 )
							 then #MountPathList.TotalSpaceMB
							 else #MountPathList.MaxDataToWriteMB end),0)
				from #MountPathList
				where libraryid = #tmpLibList.libraryid)
		update #tmpLibList
		set ClientId = C.id, ClientName = C.net_hostName
		from MMLibraryController AS LC, APP_Client as C, #tmpLibList as tt
		where LC.LibraryId = tt.LibraryId AND LC.LibraryControllerActive = 1
		AND LC.ClientId = C.id
		--
		-- Update the LowWaterMarkMB to contain the MB after calculating percentage against total cap.
		--
		update #tmpLibList
		set LowWaterMarkMB = ((LowWaterMarkMB/100.0) * totalCapMB)
		update #tmpLibList
		set WarningWaterMarkMB = ((WarningWaterMarkMB/100.0) * totalCapMB)
		DECLARE	@currentTime datetime
		SET	@currentTime = GetUTCDate()
		update #tmpLibList
		set	DataWrittenMBForAvg = t2.TotalDataWritten,
			capacityFreedMBForAvg = t2.TotalCapacityFreed,
			lastNumDays = t2.numOfDays+1
		FROM	#tmpLibList as tt inner join
				(select libraryId, ISNULL(SUM(CAST(DataWritten AS BIGINT)), 0) as TotalDataWritten,
				 ISNULL(SUM(CAST(CapacityFreedMB AS BIGINT)), 0) as TotalCapacityFreed,
				 DATEDIFF(d, ISNULL(MIN(TimeStart), @currentTime), @currentTime) as numOfDays
				 from MMLibraryHistory as LH WITH (NOLOCK)
				WHERE TimeStart > (DATEADD(d, -@DaysToConsider, @currentTime)) group by LibraryId) as t2
				on tt.LibraryId = t2.LibraryId
	end
	select LibraryId,
		LibraryName,
		FreeSpaceMB,
		LTRIM(dbo.GetSizeString(FreeSpaceMB * 1024 * 1024)),
		LowWaterMarkMB,
		LTRIM(dbo.GetSizeString(LowWaterMarkMB * 1024 * 1024)),
		WarningWaterMarkMB,
		LTRIM(dbo.GetSizeString(WarningWaterMarkMB * 1024 * 1024)),
		OutOfSpaceAlertInDays,
		ClientId,
		ClientName,
	(CASE 	WHEN (lastNumDays = 0) THEN -1
			WHEN (DataWrittenMBForAvg <= capacityFreedMBForAvg) THEN -1
			WHEN ((DataWrittenMBForAvg-capacityFreedMBForAvg) / lastNumDays) = 0 THEN -1
			ELSE ((DataWrittenMBForAvg-capacityFreedMBForAvg) / lastNumDays) END) AS AverageSpaceUsedMB
	from #tmpLibList
	order by LibraryId ASC
	drop table #MountPathList
	drop table #tmpLibList
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2CheckMountPathsForOutOfSpaceCondition')
	delete from GxQscripts where name = 'MMS2CheckMountPathsForOutOfSpaceCondition'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2CheckMountPathsForOutOfSpaceCondition')
	delete from GXDBVersions where aliasname = 'MMS2CheckMountPathsForOutOfSpaceCondition'
GO

insert into GXDBVersions values(2, 'MMS2CheckMountPathsForOutOfSpaceCondition',  'v1.12.48.11.28.1', 'MMS2CheckMountPathsForOutOfSpaceCondition', 'v1.12.48.11.28.1')
GO

