

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2CheckHostDriveCountScaleOutStoragePool.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2CheckHostDriveCountScaleOutStoragePool.sp,v $ $Id: MMS2CheckHostDriveCountScaleOutStoragePool.sp,v 1.1.2.2 2020/11/17 12:58:15 aselvanayagam Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMS2CheckHostDriveCountScaleOutStoragePool')
BEGIN
	print '>>> Drop Stored Procedure: MMS2CheckHostDriveCountScaleOutStoragePool <<<'
	drop procedure MMS2CheckHostDriveCountScaleOutStoragePool
END
IF EXISTS (select * from GxQscripts where name='MMS2CheckHostDriveCountScaleOutStoragePool')
	delete from GxQscripts where name = 'MMS2CheckHostDriveCountScaleOutStoragePool'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2CheckHostDriveCountScaleOutStoragePool')
	delete from GXDBVersions where aliasname = 'MMS2CheckHostDriveCountScaleOutStoragePool'
GO
print '... Creating Procedure: MMS2CheckHostDriveCountScaleOutStoragePool'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMS2CheckHostDriveCountScaleOutStoragePool
  @i_deviceId integer,
  @i_xml XML
AS
  DECLARE @o_deviceId integer
SET NOCOUNT ON
DECLARE @configuredHostCount as integer
DECLARE @configuredDriveCount as integer
DECLARE @unconfiguredHostCount as integer
DECLARE @unconfiguredDriveCount as integer
DECLARE @hostCountThreshold as integer
DECLARE @driveCountThreshold as integer
DECLARE @checkThresholds as integer = 1
DECLARE @crossMountFeatureOn as integer = 0
-- check if the cross mount feature is enabled
SELECT @crossMountFeatureOn = value
FROM MMConfigs
WHERE name = 'MMCONFIG_WEBSCALE_CROSS_MOUNT'
SET @o_deviceId = @i_deviceId
IF (@crossMountFeatureOn = 1)
BEGIN
	DECLARE @mediaAgent TABLE (
		mediaAgentId int
	)
	INSERT INTO @mediaAgent
	SELECT T.MA.value('@mediaAgentId', 'int') as MediaAgentId
	FROM   @i_xml.nodes('/App_ScaleoutConfigRequest/storage/mediaAgent') T(MA)
	-- check if all the unconfigured MAs are at or above SP 19
	IF EXISTS
	(SELECT 1
	FROM    App_Client CN WITH(READUNCOMMITTED)
			INNER JOIN simInstalledPackages PKG WITH(READUNCOMMITTED) ON CN.id = PKG.ClientId
			INNER JOIN MMDiskHWInfo HW WITH(READUNCOMMITTED) ON HW.hostId = CN.id
			INNER JOIN @mediaAgent MA ON HW.hostId = MA.mediaAgentId
	WHERE   (CN.releaseId < 16 OR (CN.releaseId = 16 AND PKG.HighestSP < 20))
AND PKG.simPackageID IN (51, 1301))
	SET @checkThresholds = 0
	IF (@checkThresholds = 1)
	BEGIN
		SELECT @configuredHostCount = COUNT(DISTINCT hostId), @configuredDriveCount = COUNT(DISTINCT diskSerialNum)
		FROM MMDiskHWInfo
		WHERE deviceId = @i_deviceId
AND flags & 1 = 1
AND mountPathUsageType = 2
		SELECT @unconfiguredHostCount = COUNT(DISTINCT hostId), @unconfiguredDriveCount = COUNT(DISTINCT diskSerialNum)
		FROM MMDiskHWInfo HW
		INNER JOIN @mediaAgent MA on MA.mediaAgentId = HW.hostId
		WHERE deviceId = 0
AND flags & 1 = 0
AND mountPathUsageType = 2
		SELECT @hostCountThreshold = value
		FROM MMConfigs
		WHERE name = 'MMCONFIG_WEBSCALE_MAX_NODE_COUNT'
		SELECT @driveCountThreshold = value
		FROM MMConfigs
		WHERE name = 'MMCONFIG_WEBSCALE_MAX_DRV_COUNT'
		IF ((@configuredHostCount + @unconfiguredHostCount > @hostCountThreshold)  OR (@configuredDriveCount + @unconfiguredDriveCount > @driveCountThreshold))
			SET @o_deviceId = 0
	END
END
SELECT @o_deviceId
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2CheckHostDriveCountScaleOutStoragePool')
	delete from GxQscripts where name = 'MMS2CheckHostDriveCountScaleOutStoragePool'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2CheckHostDriveCountScaleOutStoragePool')
	delete from GXDBVersions where aliasname = 'MMS2CheckHostDriveCountScaleOutStoragePool'
GO

insert into GXDBVersions values(2, 'MMS2CheckHostDriveCountScaleOutStoragePool',  '00010001000200020000', 'MMS2CheckHostDriveCountScaleOutStoragePool', '00010001000200020000')
GO

