

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2ChangeMediaTypeForMedia.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2ChangeMediaTypeForMedia.sp,v $ $Id: MMS2ChangeMediaTypeForMedia.sp,v 1.3.300.2 2018/03/20 20:02:44 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2GetMediaAgentInfo"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2ChangeMediaTypeForMedia <<<'

IF EXISTS (select * from sysobjects where name='MMS2ChangeMediaTypeForMedia')
	drop procedure MMS2ChangeMediaTypeForMedia
IF EXISTS (select * from GxQscripts where name='MMS2ChangeMediaTypeForMedia')
	delete from GxQscripts where name = 'MMS2ChangeMediaTypeForMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2ChangeMediaTypeForMedia')
	delete from GXDBVersions where aliasname = 'MMS2ChangeMediaTypeForMedia'
GO
print '... Creating Procedure: MMS2ChangeMediaTypeForMedia'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2ChangeMediaTypeForMedia
  @mediaId integer,
  @newLibraryId integer,
  @spareGroupId integer,
  @mediaTypeId integer
AS
  DECLARE @errorCode integer
  DECLARE @errorString varchar(255)
	declare @i_mediaId	integer
	declare @i_newlibraryid	integer
	declare @i_newsparegroupid	integer
	declare @i_newmediatypeid	integer
	declare @l_TotalSpaceMB		integer
	declare @l_RecFmtId		integer
	declare @l_MediasRecFmtId	integer
	set @errorCode = 0
	set @errorString = ''
	set @i_mediaId = @mediaId
	set @i_newlibraryid  = @newLibraryId
	set @i_newsparegroupid = @spareGroupId
	set @i_newmediatypeid = @mediaTypeId
	set @l_TotalSpaceMB = 	(select MaxunCompressCapacityMB from MMMediaType where MediatypeId = @i_newmediatypeid)
	set @errorCode = @@ERROR
	if(@errorCode <> 0)
	begin
		set @errorString = 'Failed to get the Total SpaceMB for the MediaType'
		goto error_exit
	end
	set @l_MediasRecFmtId	=	(select top 1 recordingformatid from mmvolume with (readuncommitted) where mediaid = @i_mediaId)
	set @l_RecFmtId =	ISNULL((select top 1 RecordingFormatId from MMRecordingFormats as MRec
				where MRec.RecordingFormatId in
				(select RecordingFormatId from MMRecFmtMedTyp as MRecMed
				where (MRecMed.MediaTypeId = @i_newmediatypeid or MRecMed.CleaningMediaTypeId = @i_newmediatypeid)
				AND MRecMed.DriveTypeId in
				(select D.DriveTypeId from MMDrive as D, MMMasterPool as MP
				where D.MasterPoolId = MP.MasterPoolId and
				MP.LibraryId = @i_newlibraryid))
				order by RecordingFormatId DESC), @l_MediasRecFmtId)
	set @errorCode = @@ERROR
	if(@errorCode <> 0)
	begin
		set @errorString = 'Failed to get the Recording format type for the MediaType'
		goto error_exit
	end
	--1) Change the MediaTypeId in the MMMedia table
	update MMMedia
	set MediaTypeId = @i_newmediatypeid
	where MediaId = @i_mediaId
	set @errorCode = @@ERROR
	if(@errorCode <> 0)
	begin
		set @errorString = 'Failed to update the MMMedia table'
		goto error_exit
	end
	--2) Change the Total SpaceMB, in the MMMediaSide table
	update MMMediaSide
	set TotalSpaceMB = @l_TotalSpaceMB
	where MediaId = @i_mediaId
	set @errorCode = @@ERROR
	if(@errorCode <> 0)
	begin
		set @errorString = 'Failed to update the MMMediaSide table'
		goto error_exit
	end
	--3) Change the recordingFormatId in MMVolume table
	update MMVolume
	set RecordingFormatId = @l_RecFmtId
	where MediaId = @i_mediaId
	set @errorCode = @@ERROR
	if(@errorCode <> 0)
	begin
		set @errorString = 'Failed to update the MMVolume table'
		goto error_exit
	end
	error_exit:
		select @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2ChangeMediaTypeForMedia')
	delete from GxQscripts where name = 'MMS2ChangeMediaTypeForMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2ChangeMediaTypeForMedia')
	delete from GXDBVersions where aliasname = 'MMS2ChangeMediaTypeForMedia'
GO

insert into GXDBVersions values(2, 'MMS2ChangeMediaTypeForMedia',  '00010003030000020000', 'MMS2ChangeMediaTypeForMedia', '00010003030000020000')
GO

