

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2CanDeconfigureNASClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2CanDeconfigureNASClient.sp,v $ $Id: MMS2CanDeconfigureNASClient.sp,v 1.5.208.2 2020/09/28 21:31:47 duncan Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2CanDeconfigureNASClient"		|
--	|									|
--	|	Check if a NAS client can be deconfigured.			|
--	|	 	|							|
--	|  	- this is not allowed when there is still a drivepool 		|
--	|	  or library controller linked to this filer			|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMS2CanDeconfigureNASClient')
BEGIN
	print '>>> Drop Stored Procedure: MMS2CanDeconfigureNASClient <<<'
	drop procedure MMS2CanDeconfigureNASClient
END
IF EXISTS (select * from GxQscripts where name='MMS2CanDeconfigureNASClient')
	delete from GxQscripts where name = 'MMS2CanDeconfigureNASClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2CanDeconfigureNASClient')
	delete from GXDBVersions where aliasname = 'MMS2CanDeconfigureNASClient'
GO
print '... Creating Procedure: MMS2CanDeconfigureNASClient'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2CanDeconfigureNASClient
  @clientId integer,
  @flags integer = 0
-- flags:
--   Flag  0x01 means deconfiguring just the NDMP agent (not the whole client)
--   Flags 0x00 means defonfiguring the entire client
AS
  DECLARE @problemType integer
-- Problem types: (failure reasons)
-- 1: Drivepools still exist on this filer
-- 2: This filer is a library controller
-- 3: There is an array (SMControlHost) referencing this client
-- 4: There is a storage provisioning array (SMArray) referencing this client
-- the cursor will return zero if everything is OK.
	DECLARE @i_ClientId integer
	SET @i_ClientId = @clientId
	DECLARE @l_failreason INTEGER
	SET @l_failreason = 0
	-- When just deconfiguring the agent, we do not need to check if there is an array for the client
	DECLARE    @bNdmpAgentDeconf   INTEGER = 0
	IF (@flags & 0x01 = 0x01)
		SET @bNdmpAgentDeconf = 1
	IF ((@bNdmpAgentDeconf = 0) AND ((select count(*) from SMControlHost WHERE ClientId = @i_ClientId ) > 0))
		BEGIN
			SET @l_failreason = 3
		END
	ELSE IF ((@bNdmpAgentDeconf = 0) AND ((select count(*) from SMArray WHERE ClientId = @i_ClientId AND DeleteTime IS NULL ) > 0))
		BEGIN
			SET @l_failreason = 4
		END
	ELSE
		BEGIN
			DECLARE @l_NDMPHostId integer
			SET @l_NDMPHostId = isnull((SELECT NDMPHostId FROM MMNDMPHostInfo WHERE ClientId = @i_ClientId), 0)
			IF (0 =  @l_NDMPHostId )
				BEGIN
					SET @l_failreason = 0
				END
			ELSE
				BEGIN
					-- find out if there are any NAS drivepools
					IF ((select count(*) from MMDrivePool WHERE NDMPHostId = @l_NDMPHostId) > 0)
					BEGIN
						SET @l_failreason = 1
					END
					IF ((@l_failreason = 0) and (select count(*) from MMLibraryHostInfo WHERE NDMPHostId = @l_NDMPHostId ) > 0)
					BEGIN
						SET @l_failreason = 2
					END
				END
		END
	SELECT @l_failreason AS FailReason
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2CanDeconfigureNASClient')
	delete from GxQscripts where name = 'MMS2CanDeconfigureNASClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2CanDeconfigureNASClient')
	delete from GXDBVersions where aliasname = 'MMS2CanDeconfigureNASClient'
GO

insert into GXDBVersions values(2, 'MMS2CanDeconfigureNASClient',  '00010005020800020000', 'MMS2CanDeconfigureNASClient', '00010005020800020000')
GO

