

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2CalculateGUIMediaAttrEnBulk.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2CalculateGUIMediaAttrEnBulk.sp,v $ $Id: MMS2CalculateGUIMediaAttrEnBulk.sp,v 1.8.206.1 2018/03/20 19:48:25 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			PROCEDURE: "MMS2CalculateGUIMediaAttrEnBulk"										|
--	|																																				|
--	|   This procedure will calculate the media attributes for all the      |
--  |   media listed in the passed in temporary table and will update a
--  |	  column called GuiAttributes.	                  										|
--	|   																							                      |
--	|   Requirements: columns MediaId (Integer) and GuiAttributes (Integer)	|
--  |   for speed it is recommended that MediaId be made the primary key    |
--  |																																				|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2CalculateGUIMediaAttrEnBulk <<<'

IF EXISTS (select * from sysobjects where name='MMS2CalculateGUIMediaAttrEnBulk')
	drop procedure MMS2CalculateGUIMediaAttrEnBulk
IF EXISTS (select * from GxQscripts where name='MMS2CalculateGUIMediaAttrEnBulk')
	delete from GxQscripts where name = 'MMS2CalculateGUIMediaAttrEnBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2CalculateGUIMediaAttrEnBulk')
	delete from GXDBVersions where aliasname = 'MMS2CalculateGUIMediaAttrEnBulk'
GO
print '... Creating Procedure: MMS2CalculateGUIMediaAttrEnBulk'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2CalculateGUIMediaAttrEnBulk
  @i_tmptable varchar(64)
AS
  DECLARE @errorCode integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
		set @errorCode = 0
	-- calculate gui media attributes
	if object_id('tempdb.dbo.#MediaToProcess') is not null DROP TABLE #MediaToProcess
	if object_id('tempdb.dbo.#l_guimedattr') is not null DROP TABLE #l_guimedattr
	create table #MediaToProcess (MediaId Integer)
	declare @l_execSQL varchar(256)
	SET @l_execSQL = 'insert into #MediaToProcess select distinct MediaId from ' + @i_tmptable
	execute (@l_execSQL)
	create table #l_guimedattr (	MediaId Integer primary key,
					guiAttributes Integer,
					mediaTypeId Integer,
					isExportedBit Integer,
					isWrongLibBit Integer,
					libraryId Integer,
					libraryTypeId Integer,
					SlotMediaStatus Integer,
					volIdFirst		Integer,
					volIdLast		Integer)
	insert into #l_guimedattr
	select TM.MediaId,
		-- is mag
	 ( case when M.mediaTypeId = 10001 then 8 ELSE 0 END )
	 -- bad, depreciated media
	 + ( case when M.MediaFlags = 2 then 32 when M.MediaFlags = 3 then 64 ELSE 0 END )
	 -- is RSM
	 + ( case when M.ExternalGUID <> '' then 1024 ELSE 0 END )
	 + ( case when M.IsAged > 0 then 8388608 ELSE 0 END )
	 -- MMS2_PINNED and MMS2_PINNED_FOR_RECALL
	 + ( M.Attributes & 16777216 )
	 + ( M.Attributes & 536870912 )
	 -- assigned media
	 + ( case when M.IsInMediaGroup <> 0 then 1 ELSE 0 END ),
	 M.MediaTypeId,
	 ( case when M.mediaLocation = 3 then 2 ELSE 0 END ),
	 -- wrong library
	 ( case when (M.MediaLocation IN (1,2)  AND (M.LibraryId > 0) AND (M.LastWriteLibraryId > 0) AND (M.LibraryId <> M.LastWriteLibraryId)) then 262144 ELSE 0 END ),
	 M.LibraryId,
	 0,
	 0,
	 0,
	 0
	from #MediaToProcess AS TM, MMMedia AS M
	WHERE TM.MediaId = M.MediaId
	-- set is cleaning media bit
	UPDATE #l_guimedattr
	SET guiAttributes = guiAttributes | 512
	FROM #l_guimedattr AS TA, MMMediaType AS MT
	WHERE TA.MediaTypeId = MT.MediaTypeId AND MT.IsCleaningMedia = 1
	UPDATE #l_guimedattr
	SET SlotMediaStatus = MS.MediaStatus
	FROM #l_guimedattr AS TA, MMSlot as MS
	WHERE MS.MediaId = TA.MediaId
	-- now set flags based on media status in MMSlot table
	UPDATE #l_guimedattr
	SET guiAttributes =
		guiAttributes |
		( case
    	    	    -- duplicate barcode
		    when  (SlotMediaStatus & 1) <> 0  then 131072
		    -- unrecognized barcode
		    when  (SlotMediaStatus & 2) <> 0 then 1048576
		    else 0
		    end
		)
	WHERE SlotMediaStatus <> 0
	-- wrong library
	UPDATE #l_guimedattr
	SET isExportedBit = 0, isWrongLibBit =  262144
	WHERE (SlotMediaStatus & 4) <> 0
	-- library type
	UPDATE #l_guimedattr
	SET libraryTypeId = ML.LibraryTypeId,
			guiAttributes = guiAttributes |
				(
					case 	when ML.LibraryTypeId = 3 then 8
							  when ML.LibraryTypeId IN (4,5) then 4
					ELSE 0 END
				)
	FROM #l_guimedattr AS TA, MMLibrary AS ML
	WHERE TA.LibraryId = ML.LibraryId AND TA.LibraryId >0
	-- if librarytype is shelf, do not set wrong library bit
	UPDATE #l_guimedattr
	SET isWrongLibBit = 0
	WHERE LibraryTypeId = 8
	UPDATE #l_guimedattr
	SET volIdFirst = (SELECT TOP 1 V.VolumeId FROM MMVolume AS V WHERE V.MediaId = TA.MediaId )
	FROM #l_guimedattr AS TA
	UPDATE #l_guimedattr
	SET volIdLast = (SELECT TOP 1 V.VolumeId FROM MMVolume AS V WHERE V.MediaId = TA.MediaId AND V.VolumeId > TA.volIdFirst )
	FROM #l_guimedattr AS TA
	-- set multsided media bit, 16 = MMS2_MULTIPLESIDED_MEDIA
	UPDATE #l_guimedattr
	SET guiAttributes = guiAttributes | 16
	WHERE volIdFirst <> volIdLast
 -- update first mediaside
	UPDATE #l_guimedattr
	SET guiAttributes =
			guiAttributes |
					(
						case
							-- 1 = VOL_ACTIVE, 8 = VOL_ACTIVE_REFRESH, 128 = MMS2_MEDIA_SIDEA_ACTIVE
							when V.VolumeFlags IN (1, 8) then 128
							-- 2 = VOL_FULL, 256 = MMS2_MEDIA_SIDEA_FULL
							when V.VolumeFlags = 2 then 256
							-- 3 = VOL_READONLY, 4096 = MMS2_MEDIA_SIDEA_RDONLY
							when V.VolumeFlags = 3 then 4096
							-- 4 = VOL_BAD, 2048 = MMS2_MEDIA_SIDEA_BAD
							when V.VolumeFlags = 4 then 2048
							-- 7 = VOL_ACTIVE_APPEND, 2097152 = MMS2_MEDIA_SIDEA_PARTIALLY_FULL
							when V.VolumeFlags = 7 then 2097152
							ELSE 0
						END
					)		|
					(
						case
							-- 16 = MMS2_VOLUME_PREVENT_FOR_REFRESHING, 1073741824 = MMS2_MEDIA_REFRESH_PREVENTED
							WHEN (Attributes & 16) > 0 THEN 1073741824
							-- 8 = MMS2_VOLUME_PICKED_FOR_REFRESHING,  1024 = MMS2_MEDIA_REFRESH_PICKED
							WHEN (Attributes &  8) > 0 THEN 1024
							ELSE 0
						END
					)
	FROM #l_guimedattr AS TA, MMVolume AS V
	WHERE TA.volIdFirst  > 0 AND V.VolumeId = TA.volIdFirst
-- update last mediaside
	UPDATE #l_guimedattr
	SET guiAttributes =
			guiAttributes |
					(
						case
							-- 1 = VOL_ACTIVE, 8 = VOL_ACTIVE_REFRESH, 8192 = MMS2_MEDIA_SIDEB_ACTIVE
							when V.VolumeFlags IN (1, 8) then 8192
							-- 2 = VOL_FULL, 16384 = MMS2_MEDIA_SIDEB_FULL
							when V.VolumeFlags = 2 then 16384
							-- 3 = VOL_READONLY, 65536 = MMS2_MEDIA_SIDEB_RDONLY
							when V.VolumeFlags = 3 then 65536
							-- 4 = VOL_BAD, 32768 = MMS2_MEDIA_SIDEB_BAD
							when V.VolumeFlags = 4 then 32768
							-- 7 = VOL_ACTIVE_APPEND, 4194304 = MMS2_MEDIA_SIDEB_PARTIALLY_FULL
							when V.VolumeFlags = 7 then 4194304
							ELSE 0
						END
					)		|
					(
						case
							-- 16 = MMS2_VOLUME_PREVENT_FOR_REFRESHING, 1073741824 = MMS2_MEDIA_REFRESH_PREVENTED
							WHEN (Attributes & 16) > 0 THEN 1073741824
							-- 8 = MMS2_VOLUME_PICKED_FOR_REFRESHING,  1024 = MMS2_MEDIA_REFRESH_PICKED
							WHEN (Attributes &  8) > 0 THEN 1024
							ELSE 0
						END
					)
	FROM #l_guimedattr AS TA, MMVolume AS V
	WHERE TA.volIdLast  > 0 AND TA.volIdLast <> TA.VolIdFirst AND V.VolumeId = TA.volIdLast
	-- finalize result
	UPDATE #l_guimedattr
	SET guiAttributes = guiAttributes | isExportedBit | isWrongLibBit
	-- now put result back into temp table
	SET @l_execSQL = 'update ' + @i_tmptable + ' set guiAttributes = tmp.guiAttributes from '
			+ @i_tmptable  + ' as Target, #l_guimedattr  as tmp where Target.MediaId = tmp.MediaId '
	execute (@l_execSQL)
	return @errorCode
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2CalculateGUIMediaAttrEnBulk')
	delete from GxQscripts where name = 'MMS2CalculateGUIMediaAttrEnBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2CalculateGUIMediaAttrEnBulk')
	delete from GXDBVersions where aliasname = 'MMS2CalculateGUIMediaAttrEnBulk'
GO

insert into GXDBVersions values(2, 'MMS2CalculateGUIMediaAttrEnBulk',  '00010008020600010000', 'MMS2CalculateGUIMediaAttrEnBulk', '00010008020600010000')
GO

