

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2CVRMFillDBInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2CVRMFillDBInfo.sp,v $ $Id: MMS2CVRMFillDBInfo.sp,v 1.16.208.2 2018/03/20 19:53:55 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: MMS2CVRMFillDBInfo()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2CVRMFillDBInfo <<<'

IF EXISTS (select * from sysobjects where name='MMS2CVRMFillDBInfo')
	drop procedure MMS2CVRMFillDBInfo
IF EXISTS (select * from GxQscripts where name='MMS2CVRMFillDBInfo')
	delete from GxQscripts where name = 'MMS2CVRMFillDBInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2CVRMFillDBInfo')
	delete from GXDBVersions where aliasname = 'MMS2CVRMFillDBInfo'
GO
print '... Creating Procedure: MMS2CVRMFillDBInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2CVRMFillDBInfo
  @i_mediaGroupId integer,
  @i_drivePoolId integer,
  @i_masterPoolId integer,
  @i_libraryId integer,
  @i_hostId integer,
  @i_hostname varchar(1024),
  @i_mediaId integer,
  @i_volumeId integer,
  @i_driveId integer
AS
  DECLARE @l_mediaGroupId integer;
  DECLARE @l_datapathid integer;
  DECLARE @l_sparegroupid integer;
  DECLARE @l_drivePoolId integer;
  DECLARE @l_drivepoolname NVARCHAR(64);
  DECLARE @l_drivepooltype integer;
  DECLARE @l_maxDrivesToSwitch integer;
  DECLARE @l_masterPoolId integer;
  DECLARE @l_masterpoolname NVARCHAR(64);
  DECLARE @l_totaldrives integer;
  DECLARE @l_maxSwitchForHost integer;
  DECLARE @l_libraryId integer;
  DECLARE @l_aliasname NVARCHAR(128);
  DECLARE @l_libraryattribute integer;
  DECLARE @l_extendedattribute integer;
  DECLARE @l_librarytypeid integer;
  DECLARE @l_BarCodeReaderPresent integer;
  DECLARE @l_ExtendedAttributes integer;
  DECLARE @l_RestrictActivity integer;
  DECLARE @l_hostId integer;
  DECLARE @l_clientid integer;
  DECLARE @l_maxReservations integer;
  DECLARE @l_maAttribute integer;
  DECLARE @l_volumeId integer;
  DECLARE @l_VolumeState integer;
  DECLARE @l_mediaId integer;
  DECLARE @l_barcode varchar(256);
  DECLARE @l_uniqueid varchar(300);
  DECLARE @l_medialibraryid integer;
  DECLARE @l_mediatypeid integer;
  DECLARE @l_attributes integer;
  DECLARE @l_ScheduleRunId bigint;
  DECLARE @l_MediaLocation integer;
  DECLARE @l_driveid integer;
  DECLARE @l_drivetypeid integer;
  DECLARE @l_driveAttributes integer;
  DECLARE @l_MountPathId integer;
  DECLARE @l_MountPathName NVARCHAR(1024);
  DECLARE @l_MountPathTypeId integer;
  DECLARE @l_Attribute integer;
  DECLARE @l_MaxConcurrentWriters integer;
  DECLARE @l_IsOffline integer;
  DECLARE @l_IsEnabled integer;
  DECLARE @l_MagneticSpaceRsrvInMB integer;
  DECLARE @l_MediaSideId integer;
  DECLARE @l_MaxDataToWriteMB integer;
set @l_mediaGroupId = @i_mediagroupid
set @l_datapathid = 0
set @l_sparegroupid = 0
set @l_drivePoolId = @i_drivepoolid
set @l_drivepoolname = ''
set @l_drivepooltype = 0
set @l_maxDrivesToSwitch = 0
set @l_masterPoolId = @i_masterpoolid
set @l_masterpoolname = ''
set @l_totaldrives = 0
set @l_maxSwitchForHost = 0
set @l_libraryId = @i_libraryid
set @l_aliasname = ''
set @l_libraryattribute = 0
set @l_librarytypeid = 0
set @l_BarCodeReaderPresent = 0
set @l_ExtendedAttributes = 0
set @l_RestrictActivity = 0
set @l_hostId = @i_hostid
set @l_clientid = 0
set @l_maxReservations = 0
set @l_maAttribute = 0
set @l_volumeId = @i_volumeid
set @l_VolumeState = 0
set @l_mediaId = @i_mediaid
set @l_barcode = ''
set @l_uniqueid = ''
set @l_medialibraryid = 0
set @l_mediatypeid = 0
set @l_attributes = 0
set @l_ScheduleRunId = 0
set @l_MediaLocation = 0
set @l_driveid = 0
set @l_drivetypeid = 0
set @l_driveAttributes = 0
set @l_MountPathId = 0
set @l_MountPathName = ''
set @l_MountPathTypeId = 0
set @l_Attribute = 0
set @l_MaxConcurrentWriters = 0
set @l_IsOffline = 0
set @l_IsEnabled = 0
set @l_MagneticSpaceRsrvInMB = 0
set @l_MediaSideId = 0
set @l_MaxDataToWriteMB = 0
-- mediagroupinfo
if @i_mediagroupid > 0
begin
  select @l_drivepoolid = DrivePoolId, @l_datapathid = DataPathId, @l_sparegroupid = SpareGroupId
  from MMMediaGroup with (readuncommitted)
  where mediagroupid = @i_mediagroupid
	if @i_drivepoolid > 0 and @i_drivepoolid != @l_drivepoolid
		set @l_drivepoolid = @i_drivepoolid
  if @i_drivepoolid <= 0
   set @i_drivepoolid = @l_drivepoolid
end
if @i_drivepoolid > 0
begin
  select @l_drivepoolname = DrivePoolName, @l_drivepooltype = DrivePoolType, @l_maxDrivesToSwitch = MaxDrivesToSwitch
  from MMDrivePool with (readuncommitted)
  where drivepoolid = @i_drivepoolid
  if @i_masterpoolid <= 0
  begin
   set @i_masterpoolid = (select top 1 masterpoolid from MMDrivePool with (readuncommitted) where drivepoolid = @i_drivepoolid)
  end
end
if @i_masterpoolid > 0
begin
  select @l_masterpoolname = MasterPoolName, @l_totaldrives = TotalDrives, @l_maxSwitchForHost = MaxSwitchForHost
  from MMMasterPool with (readuncommitted)
  where masterpoolid = @i_masterpoolid
  if @i_libraryid <= 0
  begin
    select @i_libraryid = libraryid from MMMasterPool with (readuncommitted) where masterpoolid = @i_masterpoolid
  end
end
if @i_libraryid > 0
begin
  select @l_aliasname = AliasName,
  @l_libraryattribute = LibraryAttribute,
  @l_librarytypeid = LibraryTypeId,
  @l_BarCodeReaderPresent = BarCodeReaderPresent,
  @l_ExtendedAttributes = ExtendedAttributes,
  @l_RestrictActivity = RestrictActivity
  from MMLibrary with (readuncommitted)
  where libraryid = @i_libraryid
end
if @i_hostname != ''
begin
  set @i_hostid = (select top 1 ClientId from MMHost with (readuncommitted) where ClientId in (select id from APP_Client with (readuncommitted) where net_hostname = @i_hostname))
end
if @i_hostid = 0
and @i_drivepoolid > 0
and @i_masterpoolid > 0
begin
  set @i_hostid = (select top 1 ClientId from MMDrivePool with (readuncommitted) where drivepoolid = @i_drivepoolid and masterpoolid = @i_masterpoolid)
end
if @i_hostid > 0
begin
  select @l_clientid = ClientId, @l_maxReservations = MaxReservations, @l_maAttribute = Attribute
  from MMHost with (readuncommitted)
  where ClientId = @i_hostid
end
----------
if @i_volumeid > 0
begin
  select @l_VolumeState = VolumeState, @l_mediaid = mediaid
  from MMVolume with (readuncommitted)
  where volumeid = @i_volumeid
  if @i_mediaid <= 0
    set @i_mediaid = @l_mediaid
end
if @i_mediaid > 0
begin
  select @l_barcode = BarCode,
  @l_uniqueid = UniqueId,
  @l_mediatypeid = MediaTypeId,
  @l_attributes = Attributes,
  @l_ScheduleRunId = ScheduleRunId,
  @l_MediaLocation = MediaLocation,
  @l_medialibraryid = libraryid
  from MMMedia with (readuncommitted)
  where mediaid = @i_mediaid
  if @i_driveid <= 0
  and exists (select * from mmdrive where mediaid = @i_mediaid)
  begin
		select @i_driveid = driveid from mmdrive where mediaid = @i_mediaid
  end
end
-- we need to check whether this drive belongs to the drive pool or not
if (@i_driveid > 0 and @l_drivepoolid > 0)
begin
	if not exists (select * from MMDriveController where DriveId = @i_driveid and DrivePoolid = @l_drivepoolid)
		set @i_driveid = 0
end
if @l_mediatypeid = 10001
begin
  set @l_mediasideid = (select top 1 mediasideid from MMMediaSide with (readuncommitted) where mediaid = @i_mediaid)
  select @l_mountPathId = mountpathid,
--  @l_MountPathName = MountPathName,
  @l_MountPathTypeId = MountPathTypeId,
  @l_Attribute = Attribute,
  @l_MaxConcurrentWriters = MaxConcurrentWriters,
  @l_IsOffline = IsOffline,
  @l_IsEnabled = IsEnabled,
  @l_MagneticSpaceRsrvInMB = MagneticSpaceRsrvInMB,
  @l_MaxDataToWriteMB = MaxDataToWriteMB
  from MMMountPath with (readuncommitted)
  where mediasideid = @l_mediasideid
	select @l_MountPathName = MountPathName
	from MMS2getMountPathNameGUIView with (readuncommitted)
	where mediasideid = @l_mediasideid
end
if @i_driveid > 0
begin
  select @l_drivetypeid = DriveTypeId, @l_driveAttributes = Attributes
  from MMDrive with (readuncommitted)
  where driveid = @i_driveid
end
select isnull(@l_mediaGroupId, 0),
isnull(@l_datapathid, 0),
isnull(@l_sparegroupid, 0),
isnull(@l_drivePoolId, 0),
isnull(@l_drivepoolname, ''),
isnull(@l_drivepooltype, 0),
isnull(@l_maxDrivesToSwitch, 0),
isnull(@i_masterPoolId, 0),
isnull(@l_masterpoolname, ''),
isnull(@l_totaldrives, 0),
isnull(@l_maxSwitchForHost, 0),
isnull(@i_libraryId, 0),
isnull(@l_aliasname, ''),
isnull(@l_libraryattribute, 0),
isnull(@l_extendedattribute, 0),
isnull(@l_librarytypeid, 0),
isnull(@l_BarCodeReaderPresent, 0),
isnull(@l_ExtendedAttributes, 0),
isnull(@l_RestrictActivity, 0),
isnull(@i_hostId, 0),
isnull(@l_clientid, 0),
isnull(@l_maxReservations, 0),
isnull(@l_maAttribute, 0),
isnull(@l_volumeId, 0),
isnull(@l_VolumeState, 0),
isnull(@l_mediaId, 0),
isnull(@l_barcode, ''),
isnull(@l_uniqueid, ''),
isnull(@l_medialibraryid, 0),
isnull(@l_mediatypeid, 0),
isnull(@l_attributes, 0),
isnull(@l_ScheduleRunId, 0),
isnull(@l_MediaLocation, 0),
isnull(@i_driveid, 0),
isnull(@l_drivetypeid, 0),
isnull(@l_driveAttributes, 0),
isnull(@l_MountPathId, 0),
isnull(@l_MountPathName, ''),
isnull(@l_MountPathTypeId, 0),
isnull(@l_Attribute, 0),
isnull(@l_MaxConcurrentWriters, 0),
isnull(@l_IsOffline, 0),
isnull(@l_IsEnabled, 0),
isnull(@l_MagneticSpaceRsrvInMB, 0),
isnull(@l_MediaSideId, 0),
isnull(@l_MaxDataToWriteMB, 0)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
  return 0
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2CVRMFillDBInfo')
	delete from GxQscripts where name = 'MMS2CVRMFillDBInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2CVRMFillDBInfo')
	delete from GXDBVersions where aliasname = 'MMS2CVRMFillDBInfo'
GO

insert into GXDBVersions values(2, 'MMS2CVRMFillDBInfo',  '00010016020800020000', 'MMS2CVRMFillDBInfo', '00010016020800020000')
GO

