

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2BulkRenameBarCode.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2BulkRenameBarCode.sp,v $ $Id: MMS2BulkRenameBarCode.sp,v 1.17.46.3 2018/09/29 19:30:23 shubhamagrawal Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			PROCEDURE: "MMS2UpdateDriveConfig"								|
--	|																		|
--	|THIS PROCEDURE WILL TEST TO SEE IF THE STRING "NEWSTRING" IS ALREADY A	|
--	| NAME IN THE TABLE, AND IF NOT INSERTS IT BEFORE RETURNING ALL ROWS 	|
--	| THAT MATCH THE SEARCH CRITERIA "ID < compVal".						|
--	|																		|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A STORED PROCEDURE		|
--	| AND RETURNING RESULTS	                                                |
--  | Tinku:CCM:Archive File Id's are no longer unique						|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2BulkRenameBarCode <<<'

IF EXISTS (select * from sysobjects where name='MMS2BulkRenameBarCode')
	drop procedure MMS2BulkRenameBarCode
IF EXISTS (select * from GxQscripts where name='MMS2BulkRenameBarCode')
	delete from GxQscripts where name = 'MMS2BulkRenameBarCode'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2BulkRenameBarCode')
	delete from GXDBVersions where aliasname = 'MMS2BulkRenameBarCode'
GO
print '... Creating Procedure: MMS2BulkRenameBarCode'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMS2BulkRenameBarCode
  @i_libraryId integer,
  @i_mediaIdListXML XML,
  @i_operationId integer,
  @i_barCodeStr char(255),
  @i_callerSite integer
AS
  DECLARE @NumberOfMediaChanged integer;
  DECLARE @ReturnErrorCode integer;
  DECLARE @ReturnMessage char(255)
--This will turn off message: "xxx rows affected".
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
	declare @libraryid 	integer
	declare @mediaId 	integer
	declare @operationId 	integer
	declare @str 		varchar(64)
	declare @nummedia 	integer
	declare @rowCount 	integer
	declare @retVal 	integer
	declare @bayId		integer
	declare @callerOfSP integer
	SET @libraryid 		= @i_libraryId
	SET @operationId 	= @i_operationId
	set @str			= RTRIM(@i_barCodeStr)
	set @callerOfSP		= @i_callerSite
	set @nummedia		= 0
	set @rowCount		= 0
	IF object_id('tempdb.dbo.#tempMediaToRename') IS NOT NULL DROP TABLE #tempMediaToRename
	CREATE TABLE #tempMediaToRename (mediaId INT primary key)
	INSERT INTO #tempMediaToRename
	SELECT T.item.value('@ID','INTEGER')
	FROM @i_mediaIdListXML.nodes('/MediaIdList/Media') T(item)
	--Library level call
	IF NOT EXISTS(SELECT TOP 1 1 FROM #tempMediaToRename)
	BEGIN
		INSERT INTO #tempMediaToRename
		SELECT MediaId
		FROM MMMedia (NOLOCK) WHERE LibraryId = @libraryid
	END
	DELETE TM
	FROM #tempMediaToRename TM
		INNER JOIN MMMedia M ON TM.mediaId = M.MediaId
WHERE TM.mediaId <= 0 OR M.MediaTypeId = 10001 OR len(M.Barcode) <= 0
	create table #tmpDuplicateRowCount(tmpRowCount	integer, barcode varchar(255))
IF @operationId & 1 = 1
	BEGIN
		SET @rowCount=(select count(*) from MMMedia where barcode=@str)
		IF @rowCount > 0
		BEGIN
			select 0, -1, 'Rename barcode failed: Duplicate barcodes detected on individual barcode renaming.'
			RETURN
		END
		IF( 1 < (SELECT COUNT(1) FROM #tempMediaToRename))
		BEGIN
			SELECT 0, -1, 'Rename barcode failed: Replace Barcode option only expect one media'
			RETURN
		END
	END
	BEGIN TRANSACTION
IF @operationId & 1 = 1
	BEGIN
		UPDATE S
		SET S.Barcode = @str
		FROM MMSlot S
			INNER JOIN #tempMediaToRename TM  ON TM.mediaId = S.MediaId
		UPDATE M
		SET M.Barcode = @str
		FROM MMMedia M
		INNER JOIN #tempMediaToRename TM  ON TM.mediaId = M.MediaId
		select @nummedia = @@rowcount
	END
IF @operationId & 2 = 2
	BEGIN
		-- append string to barcode
		if @operationId & 128 = 128
		BEGIN
			UPDATE S
			SET S.Barcode = S.BarCode + @str
			FROM MMSlot S
			INNER JOIN #tempMediaToRename TM  ON TM.mediaId = S.MediaId
			WHERE len(S.Barcode) > 0
			if(@callerOfSP = 1)
			BEGIN
				UPDATE M
				SET M.BarCode = M.BarCode + @str
				FROM MMMedia M
					INNER JOIN #tmpBarcodes t ON M.Barcode = t.OldBarcode
					INNER JOIN #tempMediaToRename TM  ON M.MediaId = TM.MediaId
			END
			ELSE
			BEGIN
				UPDATE M
				SET M.BarCode = M.BarCode + @str
				FROM MMMedia M
				INNER JOIN #tempMediaToRename TM  ON M.MediaId = TM.MediaId
			END
		END
		ELSE
		BEGIN
			-- The following UPDATEs are added for the case where multiple Suffix changes are
			-- detected and the passed-in suffix (@str) is actually TOP 1 from the caller.
			-- Hence the barcodes from the MMTmpSlotConfig is used to update those in MMSlot & MMMedia
			UPDATE	SLOT
			SET		SLOT.BarCode = SLOTCFG.CartridgePCL
			FROM	MMSlot SLOT WITH (READUNCOMMITTED)
				INNER JOIN MMTmpSlotConfig SLOTCFG WITH (READUNCOMMITTED) ON SLOT.SlotName = SLOTCFG.SlotName
				INNER JOIN #tempMediaToRename TM  ON SLOT.mediaId = TM.MediaId
			WHERE	LEN(SLOT.BarCode) > 0
			UPDATE	MED
			SET		MED.BarCode = SLOT.BarCode
			FROM	MMMedia MED WITH (READUNCOMMITTED)
				INNER JOIN MMSlot SLOT WITH (READUNCOMMITTED) ON SLOT.MediaId = MED.MediaId
				INNER JOIN #tempMediaToRename TM  ON SLOT.mediaId = TM.MediaId
			WHERE	LEN(SLOT.BarCode) > 0
		END
		select @nummedia = @@rowcount
	END
IF @operationId & 4 = 4
	BEGIN
		-- prefix string to barcode
		UPDATE S
		set S.barcode = @str + barcode
		FROM MMSlot S
			INNER JOIN #tempMediaToRename TM  ON TM.mediaId = S.MediaId
		WHERE len(S.barcode) > 0
		if(@callerOfSP = 1)
		BEGIN
			UPDATE M
			SET M.BarCode = @str + M.BarCode
			FROM MMMedia M
				INNER JOIN #tmpBarcodes t ON M.Barcode = t.OldBarcode
				INNER JOIN #tempMediaToRename TM  ON M.MediaId = TM.MediaId
		END
		ELSE
		BEGIN
			UPDATE M
			SET M.BarCode = @str + M.BarCode
			FROM MMMedia M
				INNER JOIN #tempMediaToRename TM  ON M.MediaId = TM.MediaId
		END
		select @nummedia = @@rowcount
	END
IF @operationId & 8 = 8
	BEGIN
		-- remove string at the end of barcode
		UPDATE S
		SET S.BarCode = substring(S.BarCode, 0, len(S.BarCode)+1-len(@str))
		FROM MMSlot S
			INNER JOIN #tempMediaToRename TM  ON TM.mediaId = S.MediaId
		WHERE len(S.Barcode) > 0
			and S.BarCode like '%%' + @str
		if(@callerOfSP = 1)
		BEGIN
			UPDATE M
			SET M.BarCode = substring(M.BarCode, 0, len(M.BarCode)+1-len(@str))
			from MMMedia M
				INNER JOIN #tmpBarcodes t ON M.Barcode = t.OldBarcode
				INNER JOIN #tempMediaToRename TM  ON M.MediaId = TM.MediaId
		END
		ELSE
		BEGIN
			UPDATE M
			SET M.BarCode = substring(M.BarCode, 0, len(M.BarCode)+1-len(@str))
			from MMMedia M
				INNER JOIN #tempMediaToRename TM  ON M.MediaId = TM.MediaId
			WHERE barcode like '%%' + @str
		END
		select @nummedia = @@rowcount
	END
IF @operationId & 16 = 16
	BEGIN
		-- remove string at the begining of barcode
		UPDATE S
		SET S.BarCode = substring(S.BarCode, 1+len(@str), len(S.BarCode)+1)
		FROM MMSlot S
			INNER JOIN #tempMediaToRename TM  ON TM.mediaId = S.MediaId
		WHERE len(S.Barcode) > 0
			AND S.BarCode like @str + '%%'
		if(@callerOfSP = 1)
		BEGIN
			UPDATE M
			SET M.BarCode = substring(M.BarCode, 1+len(@str), len(M.BarCode)+1)
			from MMMedia M
				INNER JOIN #tmpBarcodes t ON M.Barcode = t.OldBarcode
				INNER JOIN #tempMediaToRename TM  ON M.MediaId = TM.MediaId
		END
		ELSE
		BEGIN
			UPDATE M
			SET M.BarCode = substring(M.BarCode, 1+len(@str), len(M.BarCode)+1)
			from MMMedia M
				INNER JOIN #tempMediaToRename TM  ON M.MediaId = TM.MediaId
			WHERE M.BarCode like @str + '%%'
		END
		select @nummedia = @@rowcount
	END
IF @operationId & 1 = 1
		SET @rowCount=0
	ELSE
	BEGIN
		insert into #tmpDuplicateRowCount
			select count(*), Barcode from MMSlot WHERE barcode <> ''
			GROUP BY Barcode HAVING count(barcode) > 1
		DELETE FROM #tmpDuplicateRowCount where
				barcode NOT IN (SELECT BarCode FROM MMSlot AS S INNER JOIN #tempMediaToRename TM  ON TM.mediaId = S.MediaId)
		SET @rowCount = (select COUNT(*) from #tmpDuplicateRowCount)
		IF @rowCount = 0
		BEGIN
			insert into #tmpDuplicateRowCount
				select count(*), BarCode from MMMedia WHERE barcode <> '' AND mediaTypeId <> 10001
				GROUP BY Barcode HAVING count(barcode) > 1
			DELETE FROM #tmpDuplicateRowCount where
					barcode NOT IN ( SELECT BarCode FROM MMMedia M INNER JOIN #tempMediaToRename TM  ON M.MediaId = TM.MediaId)
		END
	END
	set @rowCount = (select count(*) from #tmpDuplicateRowCount where tmpRowCount > 1)
	SET @retVal = @@ERROR
	IF @retVal != 0 OR @rowCount > 0
	BEGIN
		ROLLBACK TRANSACTION
		select @nummedia, -2, 'Rename barcode failed: Duplicate barcodes detected on bulk barcode renaming.'
	END
	ELSE
	BEGIN
		COMMIT   TRANSACTION
		select @nummedia, 0, 'Rename barcode is done'
	END
	IF object_id('tempdb.dbo.#tempMediaToRename') IS NOT NULL DROP TABLE #tempMediaToRename
	drop table #tmpDuplicateRowCount
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2BulkRenameBarCode')
	delete from GxQscripts where name = 'MMS2BulkRenameBarCode'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2BulkRenameBarCode')
	delete from GXDBVersions where aliasname = 'MMS2BulkRenameBarCode'
GO

insert into GXDBVersions values(2, 'MMS2BulkRenameBarCode',  '00010017004600030000', 'MMS2BulkRenameBarCode', '00010017004600030000')
GO

