

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2AutoUpdateBarCodesSP.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2AutoUpdateBarCodesSP.sp,v $ $Id: MMS2AutoUpdateBarCodesSP.sp,v 1.10.46.3 2018/09/29 19:30:17 shubhamagrawal Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2AutoUpdateBarCodesSP <<<'

IF EXISTS (select * from sysobjects where name='MMS2AutoUpdateBarCodesSP')
	drop procedure MMS2AutoUpdateBarCodesSP
IF EXISTS (select * from GxQscripts where name='MMS2AutoUpdateBarCodesSP')
	delete from GxQscripts where name = 'MMS2AutoUpdateBarCodesSP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2AutoUpdateBarCodesSP')
	delete from GXDBVersions where aliasname = 'MMS2AutoUpdateBarCodesSP'
GO
print '... Creating Procedure: MMS2AutoUpdateBarCodesSP'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2AutoUpdateBarCodesSP
  @i_LibraryId integer
AS
--  returning  integer, integer, varchar(255);	--skip for mssql7--
  DECLARE @o_NumberOfMediaChanged integer
  DECLARE @o_ReturnErrorCode integer
  DECLARE @o_ReturnMessage varchar(255)
--  :RETURN: o_NumberOfMediaChanged, o_ReturnErrorCode, o_ReturnMessage	--skip for mssql7--
	SET NOCOUNT ON
	Declare @l_BayId 			integer
	Declare @errorCode		integer
	Declare @errorString		varchar(1024)
	Declare @l_BarCodeLength	integer
	Declare @r_BarCodeLength	integer
	Declare @l_NumBarCodes		integer
	Declare @l_numDiffStrings	integer
	Declare @l_numOperations	integer
	Declare @l_AppendString		varchar(64)
	Declare @l_operationId		integer
	Declare @bayname 			varchar(1024)
	set @errorCode = 0
	set @errorString = ''
	set @l_numDiffStrings = 0
	set @l_AppendString = ''
	set @l_operationId = 0
	set @bayname = (select top 1 bayName from MMTmpSlotConfig with (READUNCOMMITTED) where libraryId = @i_LibraryId)
	set @l_BayId = (select BayId from MMBay where LibraryId = @i_LibraryId and Bayname =  @bayname)
	set @errorCode = @@ERROR
	if(@errorCode > 0)
	BEGIN
		set @errorString = 'Failed to get the BayId'
		goto proc_exit
	END
	create table #tmpBarCodes(OldBarCode	varchar(64),
				NewBarCode	varchar(64),
				DifferString	varchar(64),
				OperationType	integer)
	set @errorCode = @@ERROR
	if(@errorCode > 0)
	BEGIN
		set @errorString = 'Failed to create temp table #tmpBarCodes'
		goto proc_exit
	END
	create table #tmpResult(NumMediaChanged	integer,
							ReturnErrorCode	integer,
							ReturnMessage	varchar(256))
	set @errorCode = @@ERROR
	if(@errorCode > 0)
	BEGIN
		set @errorString = 'Failed to create temp table #tmpResult'
		goto proc_exit
	END
	set @l_BarCodeLength = (select top 1 (len(BarCode)) from MMSlot where BayId = @l_BayId and
				IsOccupied = 1 and IsGalaxyMedia = 1 and BarCode <> '')
	set @r_BarCodeLength = (select top 1 (len(cartridgePCL)) from MMTmpSlotConfig with (nolock) where isOccupied = 1 and CartridgePCL <> '')
	set @l_NumBarCodes = 0
	IF(@l_BarCodeLength <> @r_BarCodeLength)
	BEGIN
		insert into #tmpBarCodes
		select MS.BarCode, '', '', 0
		from MMSlot as MS
		where MS.BayId = @l_BayId and MS.BarCode <> '' AND MS.IsOccupied = 1 and MS.IsGalaxyMedia = 1
		set @errorCode = @@ERROR
		if(@errorCode > 0)
		BEGIN
			set @errorString = 'Failed to insert into #tmpBarCodes'
			goto proc_exit
		END
		--The old BarCodes had an extra string, and the new bardoes got it stripped
		IF(@l_BarCodeLength > @r_BarCodeLength)
		BEGIN
			update #tmpBarCodes
			set NewBarCode = A.cartridgePCL,
			DifferString = substring(B.OldBarCode, len(A.CartridgePCL)+1, (len(B.OldBarCode) - len(A.CartridgePCL))),
			OperationType = 8
			from MMTmpSlotConfig AS A with (nolock), #tmpBarCodes AS B
			where A.CartridgePCL <> '' and A.isOccupied = 1 and B.OldBarCode like (A.CartridgePCL + '%')
--			set @l_NumBarCodes = @@ROWCOUNT
			set @errorCode = @@ERROR
			if(@errorCode > 0)
			BEGIN
				set @errorString = 'Failed to update temp table #tmpBarCodes'
				goto proc_exit
			END
--			IF(@l_NumBarCodes = 0)
--			BEGIN
				update #tmpBarCodes
				set NewBarCode = A.cartridgePCL,
				DifferString = substring(B.OldBarCode, 0, (len(B.OldBarCode)+1 - len(A.CartridgePCL))),
				OperationType = 16
				from MMTmpSlotConfig AS A with (nolock), #tmpBarCodes AS B
				where A.CartridgePCL <> '' and A.isOccupied = 1 and B.OldBarCode like ('%' + A.CartridgePCL)
--				set @l_NumBarCodes = @@ROWCOUNT
				set @errorCode = @@ERROR
				if(@errorCode > 0)
				BEGIN
					set @errorString = 'Failed to update temp table #tmpBarCodes'
					goto proc_exit
				END
--			END
		END
		--The new BarCodes has an extra string.
		ELSE
		BEGIN
			update #tmpBarCodes
			set NewBarCode = A.cartridgePCL,
			DifferString = substring(A.CartridgePCL, len(B.OldBarCode) +1, len(A.CartridgePCL) - len(B.OldBarCode)),
			OperationType = 2
			from MMTmpSlotConfig AS A with (nolock) , #tmpBarCodes AS B
			where A.CartridgePCL <> '' and A.isOccupied = 1 and A.CartridgePCL like (B.OldBarCode + '%')
--			set @l_NumBarCodes = @@ROWCOUNT
			set @errorCode = @@ERROR
			if(@errorCode > 0)
			BEGIN
				set @errorString = 'Failed to update temp table #tmpBarCodes'
				goto proc_exit
			END
--			IF(@l_NumBarCodes = 0)
--			BEGIN
				update #tmpBarCodes
				set NewBarCode = A.cartridgePCL,
				DifferString = substring(A.CartridgePCL, 0, len(A.CartridgePCL)+1 - len(B.OldBarCode)),
				OperationType = 4
				from MMTmpSlotConfig AS A with (nolock), #tmpBarCodes AS B
				where A.CartridgePCL <> '' and A.isOccupied = 1 and A.CartridgePCL like ('%' + B.OldBarCode)
--				set @l_NumBarCodes = @@ROWCOUNT
				set @errorCode = @@ERROR
				if(@errorCode > 0)
				BEGIN
					set @errorString = 'Failed to update temp table #tmpBarCodes'
					goto proc_exit
				END
--			END
		END
	END
	ELSE
	BEGIN
		--There is nothing to process. So, do nothing
		goto proc_exit
	END
	--Not all the barcodes in the MMSlot table necessarily be in the incoming slot config.
	--So,check to see if there are any barcodes that do not have the similar barcodes in the config
	--and delete them from the table
	delete from #tmpBarCodes
	where OldBarCode <> '' and NewBarCode = '' or OldBarCode = NewBarCode
	--Now check to see if all the difference strings are same and the operations are also same
	--if not, don't proceed. Just bail out here.
	set @l_numDiffStrings = (select count(distinct DifferString) from #tmpBarCodes)
	set @l_numOperations = (select count(distinct OperationType) from #tmpBarCodes)
	IF(@l_numOperations > 1)
	BEGIN
		goto proc_exit
	END
	ELSE
	BEGIN
		set @l_AppendString = (select top 1 DifferString from #tmpBarCodes)
		set @l_operationId = (select top 1 OperationType from #tmpBarCodes)
		--All set to call the SP to do the job
		insert into #tmpResult
		exec MMS2BulkRenameBarCode @i_LibraryId, '', @l_operationId, @l_AppendString, 1
		set @errorCode = @@ERROR
		if(@errorCode > 0)
		BEGIN
			set @errorString = 'Failed to execute the Stored Procedure to rename the barCodes'
			goto proc_exit
		END
	END
proc_exit:
	IF(@errorCode > 0)
	BEGIN
		select -1, @errorCode, @errorString
		RETURN
	END
	ELSE
	BEGIN
		select NumMediaChanged, ReturnErrorCode, ReturnMessage from #tmpResult
		RETURN
	END
	drop table #tmpBarCodes
	drop table #tmpResult
GO

IF EXISTS (select * from GxQscripts where name = 'MMS2AutoUpdateBarCodesSP')
	delete from GxQscripts where name = 'MMS2AutoUpdateBarCodesSP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2AutoUpdateBarCodesSP')
	delete from GXDBVersions where aliasname = 'MMS2AutoUpdateBarCodesSP'
GO

insert into GXDBVersions values(2, 'MMS2AutoUpdateBarCodesSP',  '00010010004600030000', 'MMS2AutoUpdateBarCodesSP', '00010010004600030000')
GO

