

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2AddTapeMovement.sp] ---------- 

--#include <Db/DBsizes.h>
--#include <Db/DBrdbms.h>
--#include "MediaManager/MMS2Params.h"
--#include "MediaManager/MMS2Defines.h"
--#include "MediaManager/MMS2MediaTypes.h"
--#include "MediaManager/MMS2RecordingFormatTypes.h"
--#include "MediaManager/MMS2LibraryTypes.h"
--#include "MediaManager/MMS2Errors.h"
-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2AddTapeMovement.sp,v $ $Id: MMS2AddTapeMovement.sp,v 1.1.2.2 2016/06/18 15:50:35 rsivadas Exp $";
--
--  +========================================================================+
--  | Stored Precedure: MMS2AddTapeMovement()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMS2AddTapeMovement <<<'

IF EXISTS (select * from sysobjects where name='MMS2AddTapeMovement')
	drop procedure MMS2AddTapeMovement
IF EXISTS (select * from GxQscripts where name='MMS2AddTapeMovement')
	delete from GxQscripts where name = 'MMS2AddTapeMovement'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2AddTapeMovement')
	delete from GXDBVersions where aliasname = 'MMS2AddTapeMovement'
GO
print '... Creating Procedure: MMS2AddTapeMovement'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2AddTapeMovement
  @i_MediaId integer
AS
  DECLARE @o_ErrorCode integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	SET @o_ErrorCode = 0;
	INSERT  INTO MMTapeStateHistory(MediaId, BarCode, LibraryId, LibraryName, MediaLocation,
	MarkedForExport, SlotId, SlotName, DriveId, DriveName, ContainerId, ContainerName,
	ExportLocationId, ExportLocation, ExportTime, ImportTime, UpdateTime)
	SELECT MMMed.MediaId, MMMed.BarCode, MMMed.LibraryId, MML.AliasName,
			(CASE WHEN MMMed.MediaLocation = 1 THEN 'In Slot' WHEN MMMed.MediaLocation = 2 THEN 'In Drive' ELSE 'Exported' END),
			0, MMS.SlotId, MMS.SlotName, MMD.DriveId, MMD.DriveName, MMC.ContainerId, CASE WHEN MMC.ContainerId = 0 THEN '' ELSE MMC.ContainerName END,
			MMexp.ExportLocationId, MMexp.ExportLocation, NULL, MMMed.CreationTime, MMMed.CreationTime
	FROM MMMEdia MMMed with(READUNCOMMITTED)
	LEFT JOIN	MMLibrary MML with(READUNCOMMITTED) ON MMMed.LibraryId = MML.LibraryId
	LEFT JOIN   MMDrive MMD with(READUNCOMMITTED) on MMMed.MediaId = MMD.mediaid
	LEFT JOIN   MMContainer MMC with(READUNCOMMITTED) on MMMed.ContainerId = MMC.ContainerId
	LEFT JOIN   MMExportLocation MMexp with(READUNCOMMITTED) on MMMed.ExportLocationId = MMexp.ExportLocationId
	LEFT JOIN	MMTmpSlotConfig MMTSC with(READUNCOMMITTED) on MMTSC.CartridgePCL = MMMed.BarCode AND MMTSC.libraryId = MML.LibraryId
	LEFT JOIN	MMBay MMB with(READUNCOMMITTED) on MMTSC.libraryId = MMB.LibraryId AND MMTSC.BayName = MMB.BayName
	LEFT JOIN	MMSlot MMS with(READUNCOMMITTED) on MMTSC.SlotName = MMS.SlotName AND MMS.BayId = MMB.BayId
	WHERE MMMed.MediaId = @i_MediaId
	AND	  MMMed.MediaTypeId <> 10001
	IF @@ERROR <> 0
		SET @o_ErrorCode = 1;
	SELECT 	@o_ErrorCode;
GO


IF EXISTS (select * from GxQscripts where name = 'MMS2AddTapeMovement')
	delete from GxQscripts where name = 'MMS2AddTapeMovement'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2AddTapeMovement')
	delete from GXDBVersions where aliasname = 'MMS2AddTapeMovement'
GO

insert into GXDBVersions values(2, 'MMS2AddTapeMovement',  '00010001000200020000', 'MMS2AddTapeMovement', '00010001000200020000')
GO

