

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMS2AddMedia.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMS2AddMedia.sp,v $ $Id: MMS2AddMedia.sp,v 1.38.200.4 2020/01/07 05:45:17 cliu Exp $";
--
--  +========================================================================+
--  | Stored Precedure: MMS2AddMedia()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMS2AddMedia')
BEGIN
	print '>>> Drop Stored Procedure: MMS2AddMedia <<<'
	drop procedure MMS2AddMedia
END
IF EXISTS (select * from GxQscripts where name='MMS2AddMedia')
	delete from GxQscripts where name = 'MMS2AddMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2AddMedia')
	delete from GXDBVersions where aliasname = 'MMS2AddMedia'
GO
print '... Creating Procedure: MMS2AddMedia'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMS2AddMedia
  @i_CommCellId integer,
  @s_BarCode varchar(256),
  @i_MediaTypeId integer,
  @i_RecordingFormatId integer,
  @i_LibraryId integer,
  @i_SpareGroupId integer,
  @i_MediaLocation integer,
  @i_IsOMLWritten integer,
  @s_ExternalGUID varchar(33),
  @i_ExportLocation integer
AS
  DECLARE @i_MediaId integer;
  DECLARE @i_ErrorCode integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @OML_31 integer
	DECLARE @TotalSpaceMB integer
	DECLARE @VOL_IDLE integer
	DECLARE @FlushBlockSizeKB integer
	DECLARE @MEDIA_FLAG_GOOD integer
	DECLARE @MEDIASIDE_FLAG_GOOD integer
DECLARE @SideName varchar(80)
DECLARE @VolumeName varchar(112)
DECLARE	@UniqueId varchar(300)
	DECLARE @l_CommCellNumber	integer
	DECLARE @MediaSideId integer
	DECLARE @MediaSideId2 integer
	DECLARE @VolumeId integer
	DECLARE @NumSides integer
	DECLARE @LibraryTypeId integer
	DECLARE @Idx integer
	DECLARE @Error integer
	SET @VOL_IDLE = 5
	SET @MEDIASIDE_FLAG_GOOD = 1
	SET @OML_31 = 2
	SET @MEDIA_FLAG_GOOD = 1
	SET @i_MediaId = 0
	SET @MediaSideId = 0
	SET @MediaSideId2 = 0
	SET @LibraryTypeId = 0
	SET @Idx = 0
	SET @Error = 0
	SET @i_ErrorCode = 0
	SET @NumSides = (select NumberOfSides from MMMediaType where MediaTypeId = @i_MediaTypeId)
	SET @l_CommCellNumber = (select Number from App_CommCell where id = @i_CommCellId)
	--
	-- Jai - Wed Oct 11 18:05:44 EST 2006
	-- If Eval license, uniqueId should not be -1_..., instead set this to 2_...
	--
	IF @l_CommCellNumber <= 0
	BEGIN
		SET @l_CommCellNumber = 2
	END
	--
	-- The BarCode should contain only AlphaNumeric Characters for Regular and Optical Library
	--
	SET @LibraryTypeId = (SELECT LibraryTypeId FROM MMLibrary WHERE LibraryId = @i_LibraryId)
IF @LibraryTypeId = 1
OR @LibraryTypeId = 2
	BEGIN
		--
		-- Jai - Wed Aug 12 18:26:21 EDT 2009
		-- Allow some special characters as per specification - see TR 090812-000420 for details.
		--
		SET @Idx = PATINDEX('%[^a-zA-Z0-9-.$/+%*]%', @s_BarCode)
		IF @Idx > 0
		BEGIN
SET @i_ErrorCode = 1301
			GOTO ERROR_EXIT
		END
	END
IF @i_MediaTypeId >= 20001
AND @i_MediaTypeId <= 25000
	BEGIN
		SET @TotalSpaceMB = (select TOP 1 MaxUnCompressCapacityMB from MMMediaType where MediaTypeId = @i_MediaTypeId)
	END
	ELSE
	BEGIN
		SET @TotalSpaceMB = (SELECT TOP 1 MaxUncompressCapacityMB FROM MMRecordingFormats WHERE RecordingFormatId = @i_RecordingFormatId)
	END
	SET @FlushBlockSizeKB = (SELECT TOP 1 FlushBlockSizeKB FROM MMRecordingFormats WHERE RecordingFormatId = @i_RecordingFormatId)
	-- do MMMedia table
	INSERT INTO MMMedia(UniqueId, BarCode, MediaTypeId, CreationTime, NumberOfReUses, LastRestoreTime, LastBackupTime, LibraryId,
			SpareGroupId, LastExportTime, MediaLocation, ExternalGUID, MediaFlags, IsOMLWritten, MediaStatusReason,
			ExportLocationId, LastWriteLibraryId, Attributes, ContainerId, OverWriteJobId, origCCcommCellID, origCCmediaID,
			Descript, NumberOfSideOverwrites, ScheduleRunId, retentionFlags, retentionExpireTime, isInMediaGroup,
			isAged, PinMediaExpireTime, origSpareGroupId, RMSpareStatus, RMSpareStatusUpdateTime, ExtendedAttributes, minRetentionTime, HwEncKey)
	values ('', @s_BarCode, @i_MediaTypeId, dbo.GetUnixTime(getutcdate()), 0, 0, 0, @i_LibraryId,
			@i_SpareGroupId, 0, @i_MediaLocation, @s_ExternalGUID, @MEDIA_FLAG_GOOD, @i_IsOMLWritten, 0,
@i_ExportLocation, 0, 33554432, 0, 0, @i_CommCellId, 0,
			'', 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, '')
	SELECT @i_MediaId = @@identity, @Error = @@error
	IF @Error != 0
	BEGIN
		GOTO ERROR_EXIT
	END
	SET @UniqueId = '' + CAST(@l_CommCellNumber AS varchar(64)) + '_BC_' + @s_BarCode + '_' + CAST(@i_MediaId AS varchar(64))
	UPDATE MMMedia
	SET UniqueId = @UniqueId
	WHERE MediaId = @i_MediaId
	SELECT @Error = @@error
	IF @Error != 0
	BEGIN
		GOTO ERROR_EXIT
	END
if @s_BarCode = 'StdAln'
	begin
		SET @s_BarCode = '' + @s_BarCode + '_' + CAST(@i_MediaId AS varchar(64))
		UPDATE MMMedia
		SET BarCode = @s_BarCode
		WHERE MediaId = @i_MediaId
		SELECT @Error = @@error
		IF @Error != 0
		BEGIN
			GOTO ERROR_EXIT
		END
	end
	SET @SideName = 'A_' + CAST(@i_MediaId AS varchar(64))
	-- do MMMediaSide table
	INSERT INTO MMMediaSide(MediaId, SideName, MediaSideFlags, NumberOfRestores, NumberOfBackups, NumberOfMounts, NumberOfSoftErrors,
		NumberOfHardErrors, NumberOfReUses, LastRestoreTime, LastBackupTime, TotalSpaceMB, FreeBytesMB,  LogicalBytesMB,
		PhysicalBytesMB, IsOMLValid, FailureReason, ExternalGUID, IsOMLWritten, isErasable, UploadDataMB, DownloadDataMB)
	VALUES(@i_MediaId, @SideName, @MEDIASIDE_FLAG_GOOD, 0, 0, 0, 0,
		0, 0, 0, 0, @TotalSpaceMB, @TotalSpaceMB,  0,
		0, 0, '', @s_ExternalGUID, @i_IsOMLWritten, 0, 0, 0)
	SELECT @MediaSideId = @@identity, @Error = @@error
	IF @Error != 0
	BEGIN
		GOTO ERROR_EXIT
	END
	IF(@NumSides > 1)
	BEGIN
		SET @SideName = 'B_' + CAST(@i_MediaId AS varchar(64))
		INSERT INTO MMMediaSide(MediaId, SideName, MediaSideFlags, NumberOfRestores, NumberOfBackups, NumberOfMounts, NumberOfSoftErrors,
			NumberOfHardErrors, NumberOfReUses, LastRestoreTime, LastBackupTime, TotalSpaceMB, FreeBytesMB,  LogicalBytesMB,
			PhysicalBytesMB, IsOMLValid, FailureReason, ExternalGUID, IsOMLWritten, isErasable, UploadDataMB, DownloadDataMB)
		VALUES(@i_MediaId, @SideName, @MEDIASIDE_FLAG_GOOD, 0, 0, 0, 0,
			0, 0, 0, 0, @TotalSpaceMB, @TotalSpaceMB,  0,
			0, 0, '', @s_ExternalGUID, @i_IsOMLWritten, 0, 0, 0)
		SELECT @MediaSideId2 = @@identity, @Error = @@error
		IF @Error != 0
		BEGIN
			GOTO ERROR_EXIT
		END
	END
IF (@i_MediaTypeId != 10001)
	BEGIN
		-- do MMVolume table
		INSERT INTO MMVolume(VolumeName, CreationTime, VolumeFlags, VolumeInitialized, FlushBlockSizeKB, NumberOfRestores, NumberOfBackups, NumberOfMounts,
				NumberOfSoftErrors, NumberOfHardErrors, LastRestoreTime, LastBackupTime, LogicalBytesMB, PhysicalBytesMB, NumberOfActiveFiles,
				LastFile, RecordingFormatId, ExternalGUID, OMLVersion, VolumeState, VolumeFullReason, VolumeFullTime, VolumeFullJobId, origCCcommCellID,
				origCCvolumeID, MediaId, MediaSideId, Attributes, MediaGroupId, ReformatTime, RMSpareStatus, RMSpareStatusUpdateTime, SIDBStoreId, SiloStatus,
				CurrMountPathId, FailureErrorCode, MMSpareStatus)
		VALUES('', dbo.GetUnixTime(getutcdate()), @VOL_IDLE, 0, @FlushBlockSizeKB, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 0,
				0, @i_RecordingFormatId, @s_ExternalGUID, @OML_31, 0, 0, 0, 0, @i_CommCellId,
				0, @i_MediaId, @MediaSideId, 0, 0, dbo.GetUnixTime(getutcdate()), -1, 0, 0, -1, 0, 0, 0)
		SELECT @VolumeId = @@identity, @Error = @@error
		IF @Error != 0
		BEGIN
			GOTO ERROR_EXIT
		END
		SET @VolumeName = 'V_' + CAST(@VolumeId AS varchar(64))
		UPDATE MMVolume
		SET VolumeName = @VolumeName
		WHERE VolumeId = @VolumeId
		SELECT @Error = @@error
		IF @Error != 0
		BEGIN
			GOTO ERROR_EXIT
		END
		IF @MediaSideId2 > 0
		BEGIN
			INSERT INTO MMVolume(VolumeName, CreationTime, VolumeFlags, VolumeInitialized, FlushBlockSizeKB, NumberOfRestores, NumberOfBackups, NumberOfMounts,
					NumberOfSoftErrors, NumberOfHardErrors, LastRestoreTime, LastBackupTime, LogicalBytesMB, PhysicalBytesMB, NumberOfActiveFiles,
					LastFile, RecordingFormatId, ExternalGUID, OMLVersion, VolumeState, VolumeFullReason, VolumeFullTime, VolumeFullJobId, origCCcommCellID,
					origCCvolumeID, MediaId, MediaSideId, Attributes, MediaGroupId, ReformatTime, RMSpareStatus, RMSpareStatusUpdateTime, SIDBStoreId, SiloStatus,
					CurrMountPathId, FailureErrorCode, MMSpareStatus)
			VALUES('', dbo.GetUnixTime(getutcdate()), @VOL_IDLE, 0, @FlushBlockSizeKB, 0, 0, 0,
					0, 0, 0, 0, 0, 0, 0,
					0, @i_RecordingFormatId, @s_ExternalGUID, @OML_31, 0, 0, 0, 0, @i_CommCellId,
					0, @i_MediaId, @MediaSideId2, 0, 0, dbo.GetUnixTime(getutcdate()), -1, 0, 0, -1, 0, 0, 0)
			SELECT @VolumeId = @@identity, @Error = @@error
			IF @Error != 0
			BEGIN
				GOTO ERROR_EXIT
			END
			SET @VolumeName = 'V_' + CAST(@VolumeId AS varchar(64))
			UPDATE MMVolume
			SET VolumeName = @VolumeName
			WHERE VolumeId = @VolumeId
			SELECT @Error = @@error
			IF @Error != 0
			BEGIN
				GOTO ERROR_EXIT
			END
		END
	END
ERROR_EXIT:
	IF @Error > 0 OR @i_ErrorCode > 0
	BEGIN
		SET @i_MediaId = 0
	END
	select @i_MediaId, @i_ErrorCode
	return @i_MediaId;
GO


IF EXISTS (select * from GxQscripts where name = 'MMS2AddMedia')
	delete from GxQscripts where name = 'MMS2AddMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMS2AddMedia')
	delete from GXDBVersions where aliasname = 'MMS2AddMedia'
GO

insert into GXDBVersions values(2, 'MMS2AddMedia',  '00010038020000040000', 'MMS2AddMedia', '00010038020000040000')
GO

