

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMRptGetSPDataFreedUpPrediction.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :    MMRptGetSPDataFreedUpPrediction                          */
/*                                                                            */
/*  Description :    Returns an xml with details of how much data will be     */
/*					 freed up on each day starting today upto the no of days  */
/* 					 given as input											  */
/*					 This needs the temp table #ArchJobCopy					  */
/*					 with details of jobs			  						  */
/*				 	 and their estimated aging data as calculated by       	  */
/*					 data aging forecast report stored procs                  */
/*                                                                            */
/*  Author      :    Praveen Kumar Krishnan                                   */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMRptGetSPDataFreedUpPrediction.sp,v $ $Id: MMRptGetSPDataFreedUpPrediction.sp,v 1.7.192.2 2018/03/20 00:47:35 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMRptGetSPDataFreedUpPrediction <<<'

IF EXISTS (select * from sysobjects where name='MMRptGetSPDataFreedUpPrediction')
	drop procedure MMRptGetSPDataFreedUpPrediction
IF EXISTS (select * from GxQscripts where name='MMRptGetSPDataFreedUpPrediction')
	delete from GxQscripts where name = 'MMRptGetSPDataFreedUpPrediction'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMRptGetSPDataFreedUpPrediction')
	delete from GXDBVersions where aliasname = 'MMRptGetSPDataFreedUpPrediction'
GO
print '... Creating Procedure: MMRptGetSPDataFreedUpPrediction'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMRptGetSPDataFreedUpPrediction
  @i_reqXml xml,
  @i_reserveParam integer
AS
  DECLARE @o_retCode int
  DECLARE @o_errStr varchar(1024)
  DECLARE @o_outputXml xml
--SET @i_reqXml = '<EVGui_SPDataFreedupPredictionReq spId ="251" spCopyId ="0" forcastdays ="7"/>'
SET @o_retCode = -1
SET @o_errStr = 'Generic Error'
/*The stored procs to create this table and populate it with details of jobs
and their estimated aging date has to be executed before calling this*/
IF object_id('tempdb.dbo.#ArchJobCopy') is null
BEGIN
	SET @o_errStr = 'Table #ArchJobCopy does not exist. Cannot create prediction report'
	GOTO CX_EXIT
END
DECLARE @archGroupId int = 0
DECLARE @archGroupCopyId int = 0
DECLARE @tblCopiesToCheck table(copyId int)
DECLARE @i_asOfDays int = 0
DECLARE @i_respFlag int = 0
SELECT @archGroupId = ISNULL((col.value('@spId','integer')),0)
FROM @i_reqXml.nodes('/EVGui_SPDataFreedupPredictionReq') as a(col)
SELECT @archGroupCopyId = ISNULL((col.value('@spCopyId','integer')),0)
FROM @i_reqXml.nodes('/EVGui_SPDataFreedupPredictionReq') as a(col)
SELECT @i_asOfDays = ISNULL((col.value('@forcastdays','integer')),7)
FROM @i_reqXml.nodes('/EVGui_SPDataFreedupPredictionReq') as a(col)
SELECT @i_respFlag = ISNULL((col.value('@respFlag','integer')),0)
FROM @i_reqXml.nodes('/EVGui_SPDataFreedupPredictionReq') as a(col)
DECLARE @tempAsOfdays int = @i_asOfDays
IF @archGroupCopyId = 0
	INSERT	@tblCopiesToCheck
SELECT id FROM archGroupCopy WITH (NOLOCK) where archGroupId = @archGroupId AND type <> 5
ELSE
	INSERT	@tblCopiesToCheck
	SELECT @archGroupCopyId
DECLARE @currCSClientTime datetime = dbo.UTCToClientLocalTime(getutcdate(),2)
DECLARE @day1LocalTime datetime = DateAdd(Day, DateDiff(Day, 0, @currCSClientTime), 0)
DECLARE @day1UTCTime datetime = dbo.LocalToUTCTime(@day1LocalTime,dbo.GetClientTimeZone(2))
DECLARE @tblCopyBasedReport table(archGroupId int, copyId int, copyName varchar(512), sizeFreedInMB int, freedByDay bigint, jobCount int)
DECLARE @tblSPBasedReport table(archGroupId int, sizeFreedInMB int, freedByDay bigint, jobCount int)
DECLARE @reportRangeEnd int = dbo.getunixTime(DateAdd(Day,@i_asOfDays,@day1UTCTime))
DELETE #ArchJobCopy where estimatedAgingDate >= @reportRangeEnd or estimatedAgingDate < 0
DELETE #ArchJobCopy where copyid not in (select copyId from @tblCopiesToCheck)
DELETE #ArchJobCopy where dataStatus = 101
DECLARE @minEstAgingdate bigint
DECLARE @maxEstAgingDate bigint
SELECT @minEstAgingdate = MIN(estimatedAgingDate) from #ArchJobCopy
SELECT @maxEstAgingDate = MAX(estimatedAgingDate) from #ArchJobCopy
IF OBJECT_ID('tempdb.dbo.#tempTblJobToBeAgedPerDay') is not null
	DROP TABLE #tempTblJobToBeAgedPerDay
CREATE TABLE #tempTblJobToBeAgedPerDay
(jobId int,
commcellId int,
copyid int,
copyName nvarchar(128),
sizeOnMedia bigint,
appDataSize bigint,
jobStatus	int,
appId int,
subClientName nvarchar(256),
clientId int,
clientName nvarchar(512),
appTypeId int,
appTypeName varchar(256),
backupSetId int,
backupSetName nvarchar(256),
instanceId int,
instanceName nvarchar(1024),
freedByDay bigint,
primary key(jobId, commcellId, copyId, freedByDay))
WHILE(@tempAsOfdays > 0)
BEGIN
	DECLARE @jobCountForPolicy int
	SET @jobCountForPolicy = 0
	DECLARE @jobsAged table(jobId int, commcellId int, fileType int, copyId int, appId int)
	DELETE FROM @jobsAged
	DECLARE @startTimeUTC int = dbo.getunixTime(DATEADD(Day,(@i_asOfDays - @tempAsOfdays),@day1UTCTime))
	DECLARE @endTimeUTC int = dbo.getUnixTime(DATEADD(Day,1,dbo.getDateTime(@startTimeUTC)))
	DECLARE @freedByDay bigint
	SET @freedByDay = dbo.getunixtime(dbo.UTCToClientLocalTime(dbo.getdatetime(@startTimeUTC),2))
	IF @endTimeUTC <= @minEstAgingdate
		GOTO CONTINUE_LOOP
	IF @startTimeUTC > @maxEstAgingdate
		BREAK
	INSERT @jobsAged
	SELECT distinct jobId, commcellId, fileType, copyId, appId
	FROM #ArchJobCopy
	WHERE estimatedAgingDate >= @startTimeUTC and estimatedAgingDate < @endTimeUTC
	/*
	This means it is today. Jobs with estimatedAgingDate = 0 are prunable now so consider them for today
	Inside this block not considering the freedByDay column value the where condition because this block will be run only
	during first iteration of this loop (For today's prediction)
	*/
	IF @tempAsOfdays = @i_asOfDays
	BEGIN
		INSERT @jobsAged
		SELECT distinct jobId, commcellId, fileType, copyId, appId
		FROM #ArchJobCopy
		WHERE estimatedAgingDate = 0
	END
	INSERT #tempTblJobToBeAgedPerDay
	SELECT distinct jds.jobId, jds.commcellId, jds.archGrpCopyId, '', SUM(jds.SizeOnMedia), 0, 0, retInfo.appId, '', 0, '', 0, '', 0, '', 0, '', @freedByDay
	FROM @jobsAged retInfo inner join JMJobDataStats jds WITH (NOLOCK)
	ON jds.jobId = retInfo.jobId AND jds.commCellId = retInfo.commcellId AND (jds.dataType = retInfo.fileType OR retInfo.fileType = 0) AND jds.archGrpCopyId = retInfo.copyId
	group by jds.jobId, jds.commCellId, jds.archGrpCopyId, retInfo.appId
	INSERT @tblCopyBasedReport
	SELECT AGC.archGroupId, AGC.id, AGC.name, SizeOnMedia, @freedByDay,jobCount
	FROM archGroupCopy AGC WITH (NOLOCK)
	inner join
	(SELECT retInfo.CopyId, SUM(retInfo.sizeOnMedia)/1024/1024 as SizeOnMedia,COUNT(distinct CAST(retInfo.jobid as varchar(32))+'*'+CAST(retInfo.commcellid as varchar(32))) as jobCount
	FROM #tempTblJobToBeAgedPerDay retInfo WHERE retInfo.freedByDay = @freedByDay
	group by retInfo.CopyId
	) S
	ON S.CopyId = AGC.id
	SELECT @jobCountForPolicy = COUNT(distinct CAST(jobId as varchar(32))+'*'+CAST(commcellId as varchar(32)))
	FROM #tempTblJobToBeAgedPerDay	WHERE freedByDay = @freedByDay
	INSERT @tblSPBasedReport
	SELECT @archGroupId, SUM(SizeFreedInMB), freedByDay, @jobCountForPolicy
	FROM @tblCopyBasedReport
	WHERE freedByDay = @freedByDay
	group by freedByDay
	CONTINUE_LOOP:
	SET @tempAsOfdays = @tempAsOfdays - 1
END
UPDATE #tempTblJobToBeAgedPerDay SET jobStatus = bkpStats.status,
appDataSize = (case when bkpStats.dataArchGrpId > 1 and bkpStats.logArchGrpId > 1 and bkpStats.dataArchGrpId <> bkpStats.logArchGrpId
					then ISNULL((select sum(unCompBytes) from JMBkpAtmptStats WITH (NOLOCK)
							where jobId = bkpStats.jobId and commCellId = bkpStats.commCellId and archGrpId = @archGroupId and status in (1,3,14)), 0)
					else bkpStats.totalUncompBytes end)
FROM #tempTblJobToBeAgedPerDay retInfo inner join JMBkpStats bkpStats WITH (NOLOCK)
ON retInfo.jobId = bkpStats.jobId AND retInfo.commcellId = bkpStats.commcellId
UPDATE #tempTblJobToBeAgedPerDay SET jobStatus = bkpStats.status,
appDataSize = (case when bkpStats.uncompBytes > 0 then bkpStats.uncompBytes else bkpStats.totalBackupSize end)
FROM #tempTblJobToBeAgedPerDay retInfo inner join JMAdminJobStatsTable bkpStats WITH (NOLOCK)
ON retInfo.jobId = bkpStats.jobId AND retInfo.commcellId = bkpStats.commcellId
UPDATE #tempTblJobToBeAgedPerDay SET subClientName = app.SubClientName, clientId = app.clientId, appTypeId = app.appTypeId,
backupSetId = app.backupSet, instanceId = app.instance
FROM #tempTblJobToBeAgedPerDay retInfo inner join App_Application app WITH (NOLOCK) ON retInfo.appId = app.id
UPDATE #tempTblJobToBeAgedPerDay SET clientName = cl.name
FROM #tempTblJobToBeAgedPerDay retInfo inner join App_Client cl WITH (NOLOCK) ON retInfo.clientId = cl.id
UPDATE #tempTblJobToBeAgedPerDay SET appTypeName = ida.name
FROM #tempTblJobToBeAgedPerDay retInfo inner join App_IdaType ida WITH (NOLOCK) ON retInfo.appTypeId = ida.type
UPDATE #tempTblJobToBeAgedPerDay SET backupSetName = bkpSet.name
FROM #tempTblJobToBeAgedPerDay retInfo inner join App_BackupSetName bkpSet WITH (NOLOCK) ON retInfo.backupSetId = bkpSet.id
UPDATE #tempTblJobToBeAgedPerDay SET instanceName = instance.name
FROM #tempTblJobToBeAgedPerDay retInfo inner join App_InstanceName instance WITH (NOLOCK) ON retInfo.instanceId = instance.id
UPDATE #tempTblJobToBeAgedPerDay SET copyName = AGC.name
FROM #tempTblJobToBeAgedPerDay retInfo inner join ArchGroupCopy AGC WITH (NOLOCK) ON retInfo.copyId = AGC.id
SET @o_outputXml =
	(select
	cast((select sizeFreedInMB as '@dataWrittenSizeinMB',freedByDay as '@asof',jobCount as '@jobsCount'
	from @tblSPBasedReport WHERE (@i_respFlag = 0 OR @i_respFlag & 1 > 0) for xml path ('spPrediction')) as xml),
	cast((select sizeFreedInMB as '@dataWrittenSizeinMB', freedByDay as '@asof',jobCount as '@jobsCount',
	cast((select copyId as '@id',copyName as '@name'
	for xml path('spCopy')) as xml)
	from @tblCopyBasedReport WHERE (@i_respFlag = 0 OR @i_respFlag & 2 > 0) for xml path('spCopyPrediction')) as xml),
	cast ((select jobId as '@jobId', jobStatus as '@status',
				 sizeOnMedia as '@dataWrittenSize', appDataSize as '@applicationDataSize', freedByDay as '@asof',
				 cast((select copyId as '@id', dbo.NormalizeForXML(copyName) as '@name' for xml path('spCopy')) as xml),
				 cast((select clientId as '@id', dbo.NormalizeForXML(clientName) as '@name' for xml path('client')) as xml),
				 cast((select appTypeId as '@id', dbo.NormalizeForXML(appTypeName) as '@name' for xml path('appType')) as xml),
				 cast((select instanceId as '@id', dbo.NormalizeForXML(instanceName) as '@name' for xml path('instance')) as xml),
				 cast((select backupSetId as '@id', dbo.NormalizeForXML(backupSetName) as '@name' for xml path('backupSet')) as xml),
				 cast((select appId as '@id', dbo.NormalizeForXML(subClientName) as '@name' for xml path('subclient')) as xml)
				 from #tempTblJobToBeAgedPerDay WHERE (@i_respFlag = 0 OR @i_respFlag & 4 > 0) for xml path('spJobPrediction')) as xml)
	for xml path ('EVGui_SPDataFreedupPredictionResp'))
	IF OBJECT_ID('tempdb.dbo.#tempTblJobToBeAgedPerDay') is not null
		DROP TABLE #tempTblJobToBeAgedPerDay
SET @o_retCode = 0
SET @o_errStr = 'No Error'
CX_EXIT:
SELECT @o_retCode, @o_errStr, @o_outputXml

IF EXISTS (select * from GxQscripts where name = 'MMRptGetSPDataFreedUpPrediction')
	delete from GxQscripts where name = 'MMRptGetSPDataFreedUpPrediction'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMRptGetSPDataFreedUpPrediction')
	delete from GXDBVersions where aliasname = 'MMRptGetSPDataFreedUpPrediction'
GO

insert into GXDBVersions values(2, 'MMRptGetSPDataFreedUpPrediction',  '00010007019200020000', 'MMRptGetSPDataFreedUpPrediction', '00010007019200020000')
GO

