

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMRemoveEntryMMVMPowerMgmtReqTbl.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMRemoveEntryMMVMPowerMgmtReqTbl.sp,v $ $Id: MMRemoveEntryMMVMPowerMgmtReqTbl.sp,v 1.1.2.8 2018/03/20 00:15:55 jiechen Exp $";
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE	:	"MMRemoveEntryMMVMPowerMgmtReqTbl"              |
--  |		Author	    :	prasanthm     									|
--  | Execute the System stored procedure to fetch the physical files   	|
--  | .. for the (current) database.                    					|
--  +-----------------------------------------------------------------------+
/*
	1) This will remove powered off VMs entry from the table MMVMPowerMgmtReq.
	2) And will remove the entry which is failed to power on and reached maximum retry
*/
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMRemoveEntryMMVMPowerMgmtReqTbl <<<'

IF EXISTS (select * from sysobjects where name='MMRemoveEntryMMVMPowerMgmtReqTbl')
	drop procedure MMRemoveEntryMMVMPowerMgmtReqTbl
IF EXISTS (select * from GxQscripts where name='MMRemoveEntryMMVMPowerMgmtReqTbl')
	delete from GxQscripts where name = 'MMRemoveEntryMMVMPowerMgmtReqTbl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMRemoveEntryMMVMPowerMgmtReqTbl')
	delete from GXDBVersions where aliasname = 'MMRemoveEntryMMVMPowerMgmtReqTbl'
GO
print '... Creating Procedure: MMRemoveEntryMMVMPowerMgmtReqTbl'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMRemoveEntryMMVMPowerMgmtReqTbl
  @i_Operation INTEGER
AS
  DECLARE @o_errorCode Integer
DECLARE @currentUTCTime BIGINT = dbo.GetUnixTime(GetUTCDate())
IF @i_Operation = 1			-- Regular cleanup
BEGIN
	DECLARE @DaysToKeepHistory INT = 0
	SELECT @DaysToKeepHistory = value FROM MMConfigs WITH (NOLOCK) WHERE name = 'MMCONFIG_CLOUD_VM_MANAGEMENT_PRUNE_HISTORY'
	IF @DaysToKeepHistory = 0
SET @DaysToKeepHistory = 14
	DECLARE @TimeFromNotPrune BIGINT
	SELECT @TimeFromNotPrune = (@currentUTCTime - (@DaysToKeepHistory * 24 * 60 * 60))
	DELETE VM
	FROM MMPowerMgmtJobtoVMMap VM
INNER JOIN JMBkpStats JM WITH (NOLOCK) ON VM.EntityType = 1 AND JM.JobId = VM.EntityId AND JM.commCellId = VM.EntityCommCellId
	WHERE JM.servEndDate < @TimeFromNotPrune
	DELETE VM
	FROM MMPowerMgmtJobtoVMMap VM
INNER JOIN JMRestoreStats JM WITH (NOLOCK) ON VM.EntityType = 1 AND JM.JobId = VM.EntityId AND JM.commCellId = VM.EntityCommCellId
	WHERE JM.servEndTime < @TimeFromNotPrune
	DELETE VM
	FROM MMPowerMgmtJobtoVMMap VM
INNER JOIN JMAdminJobStatsTable JM WITH (NOLOCK) ON VM.EntityType = 1 AND JM.JobId = VM.EntityId AND JM.commCellId = VM.EntityCommCellId
	WHERE JM.servEnd < @TimeFromNotPrune
	DELETE VM
	FROM MMPowerMgmtJobtoVMMap VM
INNER JOIN MMVMPowerMgmtReq VMReq WITH (NOLOCK) ON VM.RequestId = VMReq.RequestId AND VMReq.RequestStatus = 3
	WHERE VMReq.ReqStartTime < @TimeFromNotPrune
	DELETE VM
	FROM  MMVMPowerMgmtReq VM
	LEFT OUTER JOIN MMPowerMgmtJobtoVMMap VMMAP WITH(NOLOCK) ON VM.RequestId = VMMAP.RequestId
WHERE VMMAP.RequestId IS NULL AND VM.RequestStatus = 3 AND VM.ReqStartTime < @TimeFromNotPrune
END
ELSE IF @i_Operation = 2		-- Dangled entry cleanup on MM service restarts
BEGIN
UPDATE MMVMPowerMgmtReq SET RequestStatus = 3,
	ReqExpiryTime = @currentUTCTime,
	LastUpdateTime = @currentUTCTime
WHERE RequestStatus = 2
END
SELECT @@ERROR
GO

IF EXISTS (select * from GxQscripts where name = 'MMRemoveEntryMMVMPowerMgmtReqTbl')
	delete from GxQscripts where name = 'MMRemoveEntryMMVMPowerMgmtReqTbl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMRemoveEntryMMVMPowerMgmtReqTbl')
	delete from GXDBVersions where aliasname = 'MMRemoveEntryMMVMPowerMgmtReqTbl'
GO

insert into GXDBVersions values(2, 'MMRemoveEntryMMVMPowerMgmtReqTbl',  '00010001000200080000', 'MMRemoveEntryMMVMPowerMgmtReqTbl', '00010001000200080000')
GO

