

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMRemoveDDBSubStore.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2011  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMRemoveDDBSubStore.sp,v $ $Id: MMRemoveDDBSubStore.sp,v 1.8.12.2.68.1 2021/02/10 19:43:08 anarulkar Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMRemoveDDBSubStore')
BEGIN
	print '>>> Drop Stored Procedure: MMRemoveDDBSubStore <<<'
	drop procedure MMRemoveDDBSubStore
END
IF EXISTS (select * from GxQscripts where name='MMRemoveDDBSubStore')
	delete from GxQscripts where name = 'MMRemoveDDBSubStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMRemoveDDBSubStore')
	delete from GXDBVersions where aliasname = 'MMRemoveDDBSubStore'
GO
print '... Creating Procedure: MMRemoveDDBSubStore'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMRemoveDDBSubStore
  @i_SIDBStoreId integer,
  @i_SubStoreId integer,
  @i_reserve integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_errorCode integer
  DECLARE @o_errorString nvarchar(256)
DECLARE @error int = 0
DECLARE @errorStr nvarchar(256) = ''
DECLARE @IdxAPId		int = 0
DECLARE @IdxCacheId		int = 0
DECLARE @IdxPoolId		int = 0
DECLARE @SIDBStoreId	int = 0
DECLARE @commCellId		int = 0
DECLARE @rowCount		int = 0
IF (@i_SubStoreId = 0) -- this request should come only when there is only 1 substore. 9.0
BEGIN
	SELECT @i_SubStoreId = SubStoreId
	FROM IdxSIDBSubStore WITH (NOLOCK)
	WHERE SIDBStoreId = @i_SIDBStoreId
END
SELECT @SIDBStoreId = SIDBStoreId, @IdxAPId = IdxAccessPathId, @IdxCacheId = IdxCacheId, @commCellId = commCellId
FROM IdxSIDBSubStore WITH (NOLOCK)
WHERE SubStoreId = @i_SubStoreId
BEGIN TRAN DDBCleanUp
IF (@i_SubStoreId > 0)
BEGIN
	DELETE IdxSIDBSubStore WITH (ROWLOCK)
	WHERE SubStoreId = @i_SubStoreId
	AND SIDBStoreId = @SIDBStoreId
	SELECT @error = @@ERROR
	IF @error <> 0
	BEGIN
		SET @errorStr = 'Error while deleting Substore'
		GOTO PROC_EXIT
	END
	DELETE MMEntityProp
	WHERE EntityId = @i_SubStoreId
AND EntityType = 7
	AND CommCellId = @commCellId
	SELECT @error = @@ERROR
	IF @error <> 0
	BEGIN
		SET @errorStr = 'Error while deleting MMEntityProp'
		GOTO PROC_EXIT
	END
END
-- check if any SubStore still pointing to this store, if not then delete the main store entry
IF NOT EXISTS (SELECT * FROM IdxSIDBSubStore WITH (NOLOCK) WHERE SIDBStoreId = @SIDBStoreId)
BEGIN
	IF (@SIDBStoreId > 0)
	BEGIN
		DELETE archCopySIDBStore
		WHERE SIDBStoreId = @SIDBStoreId
	    	AND CommCellId = @commCellId
		SELECT @error = @@ERROR
		IF @error <> 0
		BEGIN
			SET @errorStr = 'Error while deleting Copy To Store'
			GOTO PROC_EXIT
		END
		DELETE IdxSIDBStore
		WHERE SIDBStoreId = @SIDBStoreId
		SELECT @error = @@ERROR
		IF @error <> 0
		BEGIN
			SET @errorStr = 'Error while deleting Store'
			GOTO PROC_EXIT
		END
		DELETE archFileSIDBKeys
		WHERE SIDBStoreId = @SIDBStoreId
		AND commCellId = @commCellId
		SELECT @error = @@ERROR
		IF @error <> 0
		BEGIN
			SET @errorStr = 'Error while deleting archFileSIDBKeys'
			GOTO PROC_EXIT
		END
		DELETE MMEntityProp
		WHERE EntityId = @SIDBStoreId
AND EntityType = 3
		AND CommCellId = @commCellId
		SELECT @error = @@ERROR
		IF @error <> 0
		BEGIN
			SET @errorStr = 'Error while deleting MMEntityProp'
			GOTO PROC_EXIT
		END
		WHILE (1 = 1)
		BEGIN
			DELETE TOP (10000) FROM archFileSubStore
			FROM	archFileSubStore
			WHERE	SIDBStoreId = @SIDBStoreId
			SELECT @rowCount = @@ROWCOUNT, @error = @@ERROR
			IF @error <> 0
			BEGIN
				SET @errorStr = 'Error while deleting archFileSubStore'
				GOTO PROC_EXIT
			END
			IF @rowCount = 0
				BREAK
		END
	END
END
ELSE
BEGIN
	UPDATE IdxSIDBStore
	SET SubStoreCount = (SELECT COUNT(*) FROM IdxSIDBSubStore WITH (NOLOCK) WHERE SIDBStoreId = @SIDBStoreId)
	WHERE SIDBStoreId = @SIDBStoreId
END
-- check if there are references to the IdxAccessPath (this could be sealed store deletion so we dont want to delete AP without this check)
IF NOT EXISTS (SELECT * FROM IdxSIDBSubStore WITH (NOLOCK) WHERE IdxAccessPathId = @IdxAPId)
BEGIN
	IF (@IdxAPId > 0)
	BEGIN
		DELETE FROM IdxAccessPath
		WHERE IdxAccessPathId = @IdxAPId
		SELECT @error = @@ERROR
		IF @error <> 0
		BEGIN
			SET @errorStr = 'Error while deleting AccessPath'
			GOTO PROC_EXIT
		END
	END
	SELECT @IdxPoolId = IdxPoolId FROM IdxCache WITH (NOLOCK) WHERE IdxCacheId = @IdxCacheId
	IF (@IdxCacheId > 0)
	BEGIN
		DELETE FROM IdxCache
		WHERE IdxCacheId = @IdxCacheId
		SELECT @error = @@ERROR
		IF @error <> 0
		BEGIN
			SET @errorStr = 'Error while deleting Cache'
			GOTO PROC_EXIT
		END
	END
	IF (@IdxPoolId > 0)
	BEGIN
		DELETE FROM IdxPool
		WHERE IdxPoolId = @IdxPoolId
		SELECT @error = @@ERROR
		IF @error <> 0
		BEGIN
			SET @errorStr = 'Error while deleting Pool'
			GOTO PROC_EXIT
		END
	END
END
COMMIT TRAN DDBCleanUp
PROC_EXIT:
IF (@error <> 0)
	ROLLBACK TRAN DDBCleanUp
SELECT @error, @errorStr
GO

IF EXISTS (select * from GxQscripts where name = 'MMRemoveDDBSubStore')
	delete from GxQscripts where name = 'MMRemoveDDBSubStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMRemoveDDBSubStore')
	delete from GXDBVersions where aliasname = 'MMRemoveDDBSubStore'
GO

insert into GXDBVersions values(2, 'MMRemoveDDBSubStore',  'v1.8.12.2.68.1', 'MMRemoveDDBSubStore', 'v1.8.12.2.68.1')
GO

