

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMRemoveCloudControllerOnDelete.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMRemoveCloudControllerOnDelete.sp,v $ $Id: MMRemoveCloudControllerOnDelete.sp,v 1.1.2.1 2018/11/27 10:57:19 sasikalaraju Exp $";
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE	:	"MMRemoveCloudControllerOnDelete"               				|
--  |       Author	    :	prasanthm                            			|
--  | Execute the System stored procedure to fetch the physical files   	|
--  | .. for the (current) database.                    					|
--  +-----------------------------------------------------------------------+
/*
This stored procedure will mark cloud controller value as 0 on deletion of the cloud controller.
*/
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMRemoveCloudControllerOnDelete')
BEGIN
	print '>>> Drop Stored Procedure: MMRemoveCloudControllerOnDelete <<<'
	drop procedure MMRemoveCloudControllerOnDelete
END
IF EXISTS (select * from GxQscripts where name='MMRemoveCloudControllerOnDelete')
	delete from GxQscripts where name = 'MMRemoveCloudControllerOnDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMRemoveCloudControllerOnDelete')
	delete from GXDBVersions where aliasname = 'MMRemoveCloudControllerOnDelete'
GO
print '... Creating Procedure: MMRemoveCloudControllerOnDelete'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMRemoveCloudControllerOnDelete
  @i_CloudController Integer
AS
  DECLARE @o_errorCode INTEGER 
DECLARE @errorCode INTEGER = 0
-- Update MediaAgents cloud controllers
UPDATE MMPowerMgmtHost SET ControllerNode = 0 WHERE ControllerNode = @i_CloudController
IF (@@ERROR <> 0)
BEGIN
	SET @errorCode = 1
	GOTO EXIT1;
END
-- Update Client Group cloud controllers
Update APP_ComponentProp SET longVal = 0 WHERE componentType = 8 AND propertyTypeId = 3502 AND longVal  = @i_CloudController AND modified = 0
IF (@@ERROR <> 0)
BEGIN
	SET @errorCode = 2
	GOTO EXIT1;
END
EXIT1:
select @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'MMRemoveCloudControllerOnDelete')
	delete from GxQscripts where name = 'MMRemoveCloudControllerOnDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMRemoveCloudControllerOnDelete')
	delete from GXDBVersions where aliasname = 'MMRemoveCloudControllerOnDelete'
GO

insert into GXDBVersions values(2, 'MMRemoveCloudControllerOnDelete',  '00010001000200010000', 'MMRemoveCloudControllerOnDelete', '00010001000200010000')
GO

