

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMPruneMediaHistory.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMPruneMediaHistory.sp,v $ $Id: MMPruneMediaHistory.sp,v 1.16.12.8 2020/04/30 06:14:16 anarulkar Exp $";
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMPruneMediaHistory')
BEGIN
	print '>>> Drop Stored Procedure: MMPruneMediaHistory <<<'
	drop procedure MMPruneMediaHistory
END
IF EXISTS (select * from GxQscripts where name='MMPruneMediaHistory')
	delete from GxQscripts where name = 'MMPruneMediaHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMPruneMediaHistory')
	delete from GXDBVersions where aliasname = 'MMPruneMediaHistory'
GO
print '... Creating Procedure: MMPruneMediaHistory'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMPruneMediaHistory
  @i_dummy INTEGER
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @compareTime			DATETIME
DECLARE @compareTimeUnix		INT
DECLARE @errTrackerPruneDays	INT
DECLARE @mountHistoryPruneDays	INT
DECLARE @SIDBKeysLogsPruneDays	INT
DECLARE @VTHistoryPruneDays		INT
DECLARE @MMTapeStateHistoryPruneDays    INT
DECLARE @MMTblUpdatesHistoryPruneDays INT = 0
DECLARE @SIDBStoreLogsPruneDays INT = 0
DECLARE @LastDRBackupTime	INT = 0
DECLARE @tempDelAFPruneLogsDays INT = 0
DECLARE @PruneStatusHistoryDays INT = 0
DECLARE @PruneVolumeHistoryDays INT = 0
DECLARE @errVal	INTEGER = 0
DECLARE @rowCnt	INTEGER  = 0
DECLARE @TotalRowsPruned	INTEGER = 0
SET @errTrackerPruneDays	= 0
SET @mountHistoryPruneDays	= 0
SET @SIDBKeysLogsPruneDays	= 0
SET @VTHistoryPruneDays		= 0
SET @MMTapeStateHistoryPruneDays    = 0
SET	@retVal	= 0
DECLARE @maxJobsToPruneInBatch 	INTEGER = 2000
SELECT @maxJobsToPruneInBatch = isnull(value, 2000)
FROM mmconfigs
WHERE name = 'DA_CONFIG_MAX_JOB_HISTORIES_TO_PRUNE_IN_BATCH'
-- MMErrorTracker table
SELECT	TOP 1 @errTrackerPruneDays = value
FROM	MMConfigs WITH (NOLOCK)
WHERE	name = 'MMS2_CONFIG_STRING_ERROR_TRACKER_PRUN_DAYS'
IF @errTrackerPruneDays > 0
BEGIN
	SET @compareTime = DATEADD(d, - @errTrackerPruneDays, GETUTCDATE())
	DELETE	FROM MMErrorTracker
	WHERE	errortime < @compareTime
END
-- MMMountHistory table, 90 days
SELECT	TOP 1 @mountHistoryPruneDays = value
FROM	MMConfigs WITH (NOLOCK)
WHERE	name = 'MMS2_CONFIG_STRING_MOUNT_HISTORY_PRUN_DAYS'
IF @mountHistoryPruneDays > 0
BEGIN
	SET @compareTime = DATEADD(d, -@mountHistoryPruneDays, GETUTCDATE())
	DELETE	FROM MMMountHistory
	WHERE	MountFinishTime < @compareTime
END
-- MMTempDeletedAFPruningLogs table, 30 days
SELECT	TOP 1 @tempDelAFPruneLogsDays = value
FROM	MMConfigs WITH (NOLOCK)
WHERE	name = 'MMS2_CONFIG_STRING_TEMP_DELAF_PRUNELOGS_DAYS'
IF @tempDelAFPruneLogsDays > 0
BEGIN
	SET @compareTime = DATEADD(d, -@tempDelAFPruneLogsDays, GETUTCDATE())
	SET @compareTimeUnix = dbo.getUnixTime(@compareTime)
	DELETE FROM MMTempDeletedAFPruningLogs
	WHERE PruneTime < @compareTimeUnix
        WHILE (1 = 1)
        BEGIN
		IF (EXISTS (SELECT name FROM master.dbo.sysdatabases WHERE name = 'HistoryDB') AND OBJECT_ID('HistoryDB..MMDeletedAFPruningLogs') IS NOT NULL)
		BEGIN
			DELETE TOP (@maxJobsToPruneInBatch) FROM HistoryDB..MMDeletedAFPruningLogs
			WHERE PruneTime < @compareTimeUnix
			SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
			IF @errVal != 0
	                BEGIN
        	                SET @retVal = @errVal
                	        BREAK
	                END
        	        IF @rowCnt = 0
                	        BREAK
		END
	END
END
-- ArchFileSIDBKeysPruningLogs table, 7 YEARS
SELECT	TOP 1 @SIDBKeysLogsPruneDays = value
FROM	MMConfigs WITH (NOLOCK)
WHERE	name = 'MMS2_CONFIG_SIDB_KEYS_PRUNELOGS_PRUN_DAYS'
IF @SIDBKeysLogsPruneDays > 0
BEGIN
	SET @compareTime = DATEADD(d, -@SIDBKeysLogsPruneDays, GETUTCDATE())
	SET @compareTimeUnix = dbo.getUnixTime(@compareTime)
	DELETE	FROM archFileSIDBKeysPruningLogs
	WHERE	pruneTime < @compareTimeUnix
END
-- IdxSIDBStorePruningLogs table, 3 years
SELECT TOP 1 @SIDBStoreLogsPruneDays = value
FROM MMConfigs WITH (NOLOCK)
WHERE name = 'MMS2_CONFIG_SIDB_STORE_PRUNELOGS_PRUN_DAYS'
IF @SIDBStoreLogsPruneDays > 0
BEGIN
	SET @compareTime = DATEADD(d, -@SIDBStoreLogsPruneDays, GETUTCDATE())
	SET @compareTimeUnix = dbo.getUnixTime(@compareTime)
	DELETE	FROM IdxSIDBStorePruningLogs
	WHERE pruneTime < @compareTimeUnix
END
-- VTHistory table
SELECT	TOP 1 @VTHistoryPruneDays = value
FROM	MMConfigs WITH (NOLOCK)
WHERE	name = 'MMS2_CONFIG_VT_ACTION_HISTORY_RETENTION_DAYS'
IF @VTHistoryPruneDays > 0
BEGIN
	SET @compareTime = DATEADD(d, -@VTHistoryPruneDays, GETUTCDATE())
	DELETE	FROM VTHistory
	WHERE	EndTime < @compareTime
END
--MMTblUpdatesHistory table
SELECT TOP 1 @MMTblUpdatesHistoryPruneDays = value
FROM MMConfigs WITH (NOLOCK)
WHERE name = 'DA_CONFIG_NUMBER_OF_DAYS_OF_DATA_TO_KEEP_GENERIC_HISTORY'
IF @MMTblUpdatesHistoryPruneDays > 0
BEGIN
	SET @compareTime = DATEADD(d, -@MMTblUpdatesHistoryPruneDays, GETUTCDATE())
	SET @compareTimeUnix = dbo.getUnixTime(@compareTime)
	DELETE FROM HistoryDB..MMTblUpdatesHistory
	WHERE LastBatch < @compareTimeUnix
	AND TableName = 'IdxSIDBSubStore'
	AND RowId NOT IN (SELECT SubStoreId FROM IdxSIDBSubStore WITH (NOLOCK))
END
--Prune MMEntityProp entries for DDBDRLastBackupJobId and DDBDRLastBackupJobCommCellGUID for stores which are sealed/aged and DR backup has run since these entries were created.
IF EXISTS (SELECT * FROM MMEntityProp WITH (NOLOCK) WHERE EntityType = 7 AND propertyName IN ('DDBDRLastBackupJobId', 'DDBDRLastBackupJobCommCellGUID'))
BEGIN
	SET @LastDRBackupTime = (SELECT TOP 1 servStart FROM JMAdminJobStatsTable JM WITH (NOLOCK) WHERE opType = 11 /*CSDRBKP*/ AND status IN (1, 3) /*JMSUCCESS, PARTIALSUCCESS*/ order by servStart DESC)
	DELETE MME
	FROM MMEntityProp MME
		LEFT OUTER JOIN IdxSIDBSubStore SUB WITH (NOLOCK) ON MME.EntityId = SUB.SubStoreId AND MME.CommCellId = SUB.commCellId
WHERE ((SUB.SealedTime > 0) OR ((SUB.flags & 256) > 0) OR SUB.SubStoreId IS NULL)
	AND MME.created < @LastDRBackupTime
AND MME.EntityType = 7
	AND MME.propertyName IN ('DDBDRLastBackupJobId', 'DDBDRLastBackupJobCommCellGUID')
END
-- MMTapeStateHistory table
	SET @MMTapeStateHistoryPruneDays = ISNULL((SELECT Value FROM MMConfigs WITH(READUNCOMMITTED)
										WHERE name = 'MMS2_TAPE_STATE_HISTORY_RETENTION_DAYS'),
2)
	IF @MMTapeStateHistoryPruneDays > 0
	BEGIN
		SET @compareTime = DATEADD(d, -@MMTapeStateHistoryPruneDays, CURRENT_TIMESTAMP)
		DELETE  FROM MMTapeStateHistory
		WHERE   UpdateTime < dbo.GetUnixTime(@compareTime)
	END
--Code replaced to call this stored proc which does the same logic.
EXEC @retVal = MMCleanArchFileSubStore 0
IF OBJECT_ID('tempdb.dbo.#tempAFs') IS NOT NULL DROP TABLE #tempAFs
SELECT TOP 1 @PruneStatusHistoryDays = value
FROM MMConfigs WITH (NOLOCK)
WHERE name = 'MM_CONFIG_DAYS_TO_KEEP_PRUNING_STATUS_HISTORY'
IF @PruneStatusHistoryDays > 0
BEGIN
	SET @compareTime = DATEADD(d, -@PruneStatusHistoryDays, GETUTCDATE())
	SET @compareTimeUnix = dbo.getUnixTime(@compareTime)
	IF (EXISTS (SELECT name FROM master.dbo.sysdatabases WHERE name = 'HistoryDB') AND OBJECT_ID('HistoryDB..MMPruningStatusHistory') IS NOT NULL)
	BEGIN
		DELETE P
		FROM HistoryDB..MMPruningStatusHistory P
		WHERE P.CreateTime < @compareTimeUnix
	END
END
SET @PruneVolumeHistoryDays = ISNULL((SELECT value FROM MMConfigs WITH (READUNCOMMITTED)
WHERE name = 'MMCONFIG_VOLUME_HISTORY_PRUNE_DAYS'), 90)
IF @PruneVolumeHistoryDays > 0
BEGIN
	SET @compareTime = DATEADD(d, -@PruneVolumeHistoryDays, GETUTCDATE())
	SET @compareTimeUnix = dbo.getUnixTime(@compareTime)
	IF (EXISTS (SELECT name FROM master.dbo.sysdatabases WHERE name = 'HistoryDB') AND OBJECT_ID('HistoryDB..MMVolumeHistory') IS NOT NULL)
	BEGIN
		DELETE P
		FROM HistoryDB..MMVolumeHistory P
		WHERE P.PruneTime < @compareTimeUnix
	END
END
SELECT @retVal
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MMPruneMediaHistory')
	delete from GxQscripts where name = 'MMPruneMediaHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMPruneMediaHistory')
	delete from GXDBVersions where aliasname = 'MMPruneMediaHistory'
GO

insert into GXDBVersions values(2, 'MMPruneMediaHistory',  '00010016001200080000', 'MMPruneMediaHistory', '00010016001200080000')
GO

