

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMPruneDedupeRatioEntries.sp] ---------- 

-- ----------------------------------------------------------------------
--
--			  Copyright (c) 2006  CommVault Systems, Inc.
--						All rights reserved.
--
--
--		  This is unpublished proprietary source code of CommVault
--		  Systems, Inc. The copyright notice above does not evidence
--		  any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMPruneDedupeRatioEntries.sp,v $ $Id: MMPruneDedupeRatioEntries.sp,v 1.1.2.2 2018/05/22 23:54:17 lviswambharan Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMPruneDedupeRatioEntries <<<'

IF EXISTS (select * from sysobjects where name='MMPruneDedupeRatioEntries')
	drop procedure MMPruneDedupeRatioEntries
IF EXISTS (select * from GxQscripts where name='MMPruneDedupeRatioEntries')
	delete from GxQscripts where name = 'MMPruneDedupeRatioEntries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMPruneDedupeRatioEntries')
	delete from GXDBVersions where aliasname = 'MMPruneDedupeRatioEntries'
GO
print '... Creating Procedure: MMPruneDedupeRatioEntries'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMPruneDedupeRatioEntries
AS
  DECLARE @o_RetVal INTEGER
DECLARE @daysToKeepDailyEntries   INTEGER
SET 	@daysToKeepDailyEntries   = ISNULL((SELECT TOP 1 value FROM MMConfigs WHERE name = 'DA_CONFIG_DAYS_TO_KEEP_DEDUPLICATION_PERFORMANCE_HISTORY_DAILY_ENTRIES'), 31)
DECLARE @weeksToKeepWeeklyEntries INTEGER
SET 	@weeksToKeepWeeklyEntries = ISNULL((SELECT TOP 1 value FROM MMConfigs WHERE name = 'DA_CONFIG_WEEKS_TO_KEEP_DEDUPLICATION_PERFORMANCE_HISTORY_WEEKLY_ENTRIES'), 53)
DECLARE @timeToPruneDailyEntries  DATETIME
SET 	@timeToPruneDailyEntries  = DATEADD(DAY, -@daysToKeepDailyEntries, GetUTCDate())
DECLARE @timeToPruneWeeklyEntries DATETIME
SET 	@timeToPruneWeeklyEntries = DATEADD(DAY, -@weeksToKeepWeeklyEntries * 7, GetUTCDate())
DECLARE @maxRowsToPruneInBatch    INTEGER
SET 	@maxRowsToPruneInBatch    = ISNULL((SELECT TOP 1 value FROM MMConfigs WHERE name = 'DA_CONFIG_MAX_JOB_HISTORIES_TO_PRUNE_IN_BATCH'), 2000)
DECLARE @historyTypeDaily  INTEGER = 1
DECLARE @historyTypeWeekly INTEGER = 2
DECLARE @version  INTEGER = 1
DECLARE @errVal INTEGER = 0
DECLARE @rowCnt INTEGER = 0
DECLARE @retVal INTEGER = 0
WHILE (1 = 1)
BEGIN
	DELETE 	TOP (@maxRowsToPruneInBatch) MMSIDBDedupeRatioHistory
	WHERE	InsertTime < @timeToPruneDailyEntries AND HistoryType = @historyTypeDaily
	SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
	IF @errVal <> 0
	BEGIN
		SET @retVal = @errVal
		BREAK
	END
	IF @rowCnt = 0
		BREAK
END
IF @retVal <> 0 GOTO CX_EXIT
WHILE (1 = 1)
BEGIN
	DELETE 	TOP (@maxRowsToPruneInBatch) MMSIDBDedupeRatioHistory
	WHERE	InsertTime < @timeToPruneWeeklyEntries AND HistoryType = @historyTypeWeekly
	SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
	IF @errVal <> 0
	BEGIN
		SET @retVal = @errVal
		BREAK
	END
	IF @rowCnt = 0
		BREAK
END
CX_EXIT:
SELECT @retVal
RETURN @retVal
GO

IF EXISTS (select * from GxQscripts where name = 'MMPruneDedupeRatioEntries')
	delete from GxQscripts where name = 'MMPruneDedupeRatioEntries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMPruneDedupeRatioEntries')
	delete from GXDBVersions where aliasname = 'MMPruneDedupeRatioEntries'
GO

insert into GXDBVersions values(2, 'MMPruneDedupeRatioEntries',  '00010001000200020000', 'MMPruneDedupeRatioEntries', '00010001000200020000')
GO

