

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMPruneData.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2012  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMPruneData.sp,v $ $Id: MMPruneData.sp,v 1.2.186.5 2020/09/28 11:13:46 sjohnson Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMPruneData')
BEGIN
	print '>>> Drop Stored Procedure: MMPruneData <<<'
	drop procedure MMPruneData
END
IF EXISTS (select * from GxQscripts where name='MMPruneData')
	delete from GxQscripts where name = 'MMPruneData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMPruneData')
	delete from GXDBVersions where aliasname = 'MMPruneData'
GO
print '... Creating Procedure: MMPruneData'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMPruneData
  @i_reserveParam integer
AS
  DECLARE @dbErrorCode integer
  DECLARE @mmErrorCode integer
  DECLARE @errorString char(255)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @currentTime	int = 0
DECLARE @errCode int = 0
DECLARE @errString nvarchar(MAX)
DECLARE @mmErr int = 0
SET @currentTime = dbo.GetUnixTime(GETUTCDATE())
--------------------------------------------------------------------------------------------------------------------------
--
-- BEGIN Logic to prune the rows from archChunkDDBDrop for Mark Primary records bad. This is executed in MM admin thread.
--
---------------------------------------------------------------------------------------------------------------------------
-- Pruning logic for clearing bad chunks info from archChunkDDBDrop table
DECLARE @noOfDaysToPrune int = 60
DECLARE @buffTime int = 2 * 24 * 60 * 60
DECLARE @timePrune	int = 0
--get the no. of days to prune from MMConfig param.
SELECT  TOP 1 @noOfDaysToPrune = value
FROM    MMConfigs WITH (NOLOCK)
WHERE   name = 'MMCONFIG_PRUNE_INVALID_CHUNKS_TO_MARK_IN_DDB_DAYS'
SET @timePrune = @noOfDaysToPrune * 24 * 60 * 60
--delete the rows for which the stores are either pruned or sealed
DELETE FROM archChunkDDBDrop
WHERE SIDBStoreId NOT IN (SELECT SIDBStoreId FROM IdxSIDBStore WITH (NOLOCK))
DELETE archChunkDDBDrop
FROM archChunkDDBDrop AC, IdxSIDBStore I WITH (NOLOCK)
WHERE AC.SIDBStoreId = I.SIDBStoreId
AND AC.chunkCommCellId = I.commCellId
AND I.SealedTime > 0
--get the stores which are in archChunkDDBDrop
DECLARE @tblSIDBStore AS TABLE (SIDBStoreId INTEGER, commCellId INTEGER, pruneTime INTEGER)
INSERT INTO @tblSIDBStore
SELECT distinct AC.SIDBStoreId, chunkCommCellId, 0
FROM archChunkDDBDrop AC
JOIN IdxSIDBStore S ON AC.SIDBStoreId = S.SIDBStoreId
WHERE S.extendedFlags & 16 = 0 --Avoid any pruning for stores that are pending review.
UPDATE @tblSIDBStore
SET pruneTime =     dbo.GetUnixTime(DateAdd(s, -(case when ((@currentTime - ISNULL((select MIN(lastSnapTime) from IdxSIDBSubStore WITH (NOLOCK) WHERE SIDBStoreId = T.SIDBStoreId), 0) + @buffTime) > @timePrune)
                                then (@currentTime - ISNULL((select MIN(lastSnapTime) from IdxSIDBSubStore WITH (NOLOCK) WHERE SIDBStoreId = T.SIDBStoreId), 0)) + @buffTime
                                else @timePrune
                                end), GETUTCDATE()))
FROM @tblSIDBStore T, archCopySIDBStore CS WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
WHERE T.SIDBStoreId = CS.SIDBStoreId
AND CS.CopyId = AGC.id
AND AGC.dedupeFlags & 33554432 > 0
AND ((CS.Flags & 4) > 0)
UPDATE @tblSIDBStore
SET pruneTime =     dbo.GetUnixTime(DateAdd(s, -(case when ((@currentTime - ISNULL((select MIN(lastSnapTime) from IdxSIDBSubStore WITH (NOLOCK) WHERE SIDBStoreId = T.SIDBStoreId AND status <> 1), 0) + @buffTime) > @timePrune)
                                then (@currentTime - ISNULL((select MIN(lastSnapTime) from IdxSIDBSubStore WITH (NOLOCK) WHERE SIDBStoreId = T.SIDBStoreId and status <> 1), 0)) + @buffTime
                                else @timePrune
                                end), GETUTCDATE()))
FROM @tblSIDBStore T, archCopySIDBStore CS WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
WHERE T.SIDBStoreId = CS.SIDBStoreId
AND CS.CopyId = AGC.id
AND AGC.dedupeFlags & 33554432 = 0
AND ((CS.Flags & 4) > 0)
delete archChunkDDBDrop
from archChunkDDBDrop AC, @tblSIDBStore T
where AC.SIDBStoreId = T.SIDBStoreId
and AC.chunkCommCellId = T.commCellId
and AC.insertTime < T.pruneTime
-- Piggy back logic for pruning archChunkToSyncDDBFailedChunks as well. We dont use it for marking chunks bad in DDB.
-- No need for above checks. Just ensure recon job is not still running.
delete archChunkToSyncDDBFailedChunks
from archChunkToSyncDDBFailedChunks ACSF
LEFT OUTER JOIN JMJobInfo JI ON ACSF.adminJobId = JI.jobId AND JI.commCellId = 2 --Default CommCellId
WHERE (Modified < (@currentTime - @timePrune))
AND JI.JobId IS NULL
--------------------------------------------------------------------------------------------------------------------------
--
-- END Logic to prune the rows from archChunkDDBDrop for Mark Primary records bad. This is executed in MM admin thread.
--
---------------------------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------------------------
--
-- BEGIN Logic to prune off rows matching criteria for recopied AFs for CLDB. archFileMarkedForRecopy
--
---------------------------------------------------------------------------------------------------------------------------
DELETE archFileMarkedForRecopy
FROM archFileMarkedForRecopy AFR
	INNER JOIN archFile AF WITH (NOLOCK) ON AFR.archFileId = AF.id AND AFR.commCellId = AF.commCellId
	INNER JOIN JMJobDataStats JM WITH (NOLOCK) ON JM.jobId = AF.jobId AND JM.commCellId = AF.commCellId AND JM.archGrpCopyId = AFR.archCopyId AND JM.dataType = AF.fileType
WHERE JM.status NOT IN (101, 102, 103)
--------------------------------------------------------------------------------------------------------------------------
--
-- END Logic to prune off rows matching criteria for recopied AFs for CLDB. archFileMarkedForRecopy
--
---------------------------------------------------------------------------------------------------------------------------
IF @@ERROR <> 0
	SET @errCode = @@ERROR
FINISH:
SELECT @errCode, @mmErr, @errString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMPruneData')
	delete from GxQscripts where name = 'MMPruneData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMPruneData')
	delete from GXDBVersions where aliasname = 'MMPruneData'
GO

insert into GXDBVersions values(2, 'MMPruneData',  '00010002018600050000', 'MMPruneData', '00010002018600050000')
GO

