

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMPromotePreviousDDBBackup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMPromotePreviousDDBBackup.sp,v $ $Id: MMPromotePreviousDDBBackup.sp,v 1.1.2.1 2020/07/26 21:02:35 anarulkar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMPromotePreviousDDBBackup')
BEGIN
	print '>>> Drop Stored Procedure: MMPromotePreviousDDBBackup <<<'
	drop procedure MMPromotePreviousDDBBackup
END
IF EXISTS (select * from GxQscripts where name='MMPromotePreviousDDBBackup')
	delete from GxQscripts where name = 'MMPromotePreviousDDBBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMPromotePreviousDDBBackup')
	delete from GXDBVersions where aliasname = 'MMPromotePreviousDDBBackup'
GO
print '... Creating Procedure: MMPromotePreviousDDBBackup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMPromotePreviousDDBBackup
-- Stored Procedure Inputs
  @i_StoreId INTEGER=0,
  @i_subStoreId INTEGER=0
AS
Set NOCOUNT ON
  DECLARE @o_ErrorCode integer
  DECLARE @o_ErrorMessage nvarchar(max)
	DECLARE @retVal INTEGER = 0
	-- Variable used for getting & setting the Current Date Time Stamp
	DECLARE @nowTime INTEGER
	SET		@nowTime = dbo.GetUnixTime(GetUTCdate())
	DECLARE @latestDDBBackupJobId INT = 0
	-- Variables to hold the Error Number & Error Message
	DECLARE @ErrorNumber INTEGER = 0
	DECLARE @ErrorMessage NVARCHAR(MAX) = ''
	-- perform all the parameter validations here
	IF (@i_storeId <= 0) OR (@i_subStoreId <= 0)
	BEGIN
		SET @ErrorMessage = N'Incorrect parameters. Store / SubStore supplied is invalid. '
		SET @ErrorNumber = 1
		GOTO	PROC_ERROR
	END
	-- additional parameter validation
	IF NOT EXISTS (SELECT 1 FROM IdxSIDBStore WITH (NOLOCK) WHERE SIDBStoreId = @i_storeId)
	BEGIN
			SET @ErrorMessage = N'Store is invalid.'
			SET @ErrorNumber = 2
			GOTO	PROC_ERROR
	END
	IF NOT EXISTS (SELECT 1 FROM IdxSIDBSubStore WITH (NOLOCK) WHERE SIDBStoreId = @i_storeId AND SubStoreId = @i_subStoreId)
	BEGIN
			SET @ErrorMessage = N'SubStore is invalid.'
			SET @ErrorNumber = 3
			GOTO	PROC_ERROR
	END
	IF NOT EXISTS (SELECT 1 FROM IdxSIDBSubStoreBackupInfo WITH (NOLOCK) WHERE SIDBStoreId = @i_storeId AND SubStoreId = @i_subStoreId)
	BEGIN
		SET @ErrorMessage = N'DDB Backup job does not exists for the store/substore. Unable to proceed with setting.'
		SET @ErrorNumber = 4
		GOTO PROC_ERROR
	END
	-- Promote the previous latest DDB backup
	BEGIN
		SET @latestDDBBackupJobId = (SELECT TOP(1)LastSnapJobId FROM IdxSIDBSubStoreBackupInfo WITH (NOLOCK) WHERE SIDBStoreId = @i_storeId AND SubStoreId = @i_subStoreId ORDER BY LastSnapJobId Desc)
		BEGIN TRAN
			UPDATE S
			SET LastSnapJobId = I.LastSnapJobId,
			LastSnapTime = I.LastSnapTime,
			SIDBSnapPath = I.SIDBSnapPath,
			DDBBackupCSGUID = I.DDBBackupCSGUID,
			SnapLogSequence = I.SnapLogSequence
			FROM IdxSIDBSubStore S
				INNER JOIN IdxSIDBSubStoreBackupInfo I WITH (READUNCOMMITTED) ON S.SIDBStoreId = I.SIDBStoreId AND S.SubStoreId = I.SubStoreId
			WHERE S.SIDBStoreId = @i_StoreId
			AND S.SubStoreId = @i_subStoreId
			AND (I.LastSnapJobId = @latestDDBBackupJobId)
			SET @retVal = @@ERROR
			IF (@retVal <> 0)
			BEGIN
				SET @ErrorMessage = N'Unable to update IdxSIDBSubStore table due to database error.'
				SET @ErrorNumber = 5
				ROLLBACK TRAN
				GOTO PROC_ERROR
			END
			DELETE FROM IdxSIDBSubStoreBackupInfo
			WHERE SIDBStoreId = @i_storeId AND SubStoreId = @i_subStoreId
				AND (LastSnapJobId = @latestDDBBackupJobId)
			SET @retVal = @@ERROR
			IF (@retVal <> 0)
			BEGIN
				SET @ErrorMessage = N'Unable to update IdxSIDBSubStoreBackupInfo table due to database error.'
				SET @ErrorNumber = 6
				ROLLBACK TRAN
				GOTO PROC_ERROR
			END
		COMMIT TRAN
	END
PROC_ERROR:
SELECT @ErrorNumber, @ErrorMessage
GO

IF EXISTS (select * from GxQscripts where name = 'MMPromotePreviousDDBBackup')
	delete from GxQscripts where name = 'MMPromotePreviousDDBBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMPromotePreviousDDBBackup')
	delete from GXDBVersions where aliasname = 'MMPromotePreviousDDBBackup'
GO

insert into GXDBVersions values(2, 'MMPromotePreviousDDBBackup',  '00010001000200010000', 'MMPromotePreviousDDBBackup', '00010001000200010000')
GO

