

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMProcessVolSizeUpdateRsp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: anarulkar
--	Date:   05/22/2014
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMProcessVolSizeUpdateRsp.sp,v $ $Id: MMProcessVolSizeUpdateRsp.sp,v 1.1.2.6 2020/10/07 13:24:26 anarulkar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMProcessVolSizeUpdateRsp')
BEGIN
	print '>>> Drop Stored Procedure: MMProcessVolSizeUpdateRsp <<<'
	drop procedure MMProcessVolSizeUpdateRsp
END
IF EXISTS (select * from GxQscripts where name='MMProcessVolSizeUpdateRsp')
	delete from GxQscripts where name = 'MMProcessVolSizeUpdateRsp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMProcessVolSizeUpdateRsp')
	delete from GXDBVersions where aliasname = 'MMProcessVolSizeUpdateRsp'
GO
print '... Creating Procedure: MMProcessVolSizeUpdateRsp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMProcessVolSizeUpdateRsp
  @i_rspXml xml
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @ErrVal INTEGER = 0
DECLARE @RowCount INTEGER = 0
DECLARE @ErrorMessage     NVARCHAR(MAX)
SET           @ErrorMessage   = ''
DECLARE @ErrorSeverity INTEGER
SET         @ErrorSeverity = 0
DECLARE @ErrorState INTEGER
SET           @ErrorState = 0
DECLARE @now INT = dbo.GetUnixTime(GetUTCDate())
if object_id('tempdb.dbo.#tempVolSizeUpdateRsp') is not null DROP TABLE #tempVolSizeUpdateRsp
CREATE TABLE #tempVolSizeUpdateRsp (volId int, sizeInMB int, refreshTime int, RMSpareStatusUpdateTime int, libId int, dataWritten int, dataFreed int)
CREATE INDEX tempVolSizeUpdateRsp_Idx1 ON #tempVolSizeUpdateRsp (volId)
if object_id('tempdb.dbo.#tempVol') is not null DROP TABLE #tempVol
CREATE TABLE #tempVol (VolId int, sizeInMB int, refreshTime int, RMSpareStatusUpdateTime int)
CREATE CLUSTERED INDEX tempVol_Idx1 ON #tempVol (VolId)
INSERT	INTO #tempVolSizeUpdateRsp
SELECT	T.c.value('@volId', 'int'), T.c.value('@size', 'int'), T.c.value('@refTime', 'int'), 0, 0, 0, 0
FROM	@i_rspXml.nodes('/r/h') T(c)
-- Clean up volumes which does not have valid size or valid flag sent (in sizeInMB value)
DELETE #tempVolSizeUpdateRsp
WHERE sizeInMB < -5 -- this is the least value expected
-- Set valid refreshTime for volumes which got the size correctly.
UPDATE #tempVolSizeUpdateRsp
SET RMSpareStatusUpdateTime = refreshTime
WHERE sizeInMB > 0
-- Set refreshTime for volumes which failed to get size due to below errors. The refresh time has to be delayed from now time.
UPDATE #tempVolSizeUpdateRsp
SET RMSpareStatusUpdateTime = @now + refreshTime
WHERE sizeInMB IN (-3, -2, -5, -1)
AND refreshTime > 0
-- Set refreshTime and volume attributes for volume which have been reported as deleted
UPDATE #tempVolSizeUpdateRsp
SET RMSpareStatusUpdateTime = 0
WHERE sizeInMB IN (-4)
-- Update other values which will be used to update MMLibraryHistory
UPDATE T
SET libId = M.LibraryId,
dataWritten = (CASE WHEN (T.sizeInMB - V.PhysicalBytesMB) > 0 THEN (T.sizeInMB - V.PhysicalBytesMB) ELSE 0 END),
dataFreed = (CASE WHEN (V.PhysicalBytesMB - T.sizeInMB) > 0 THEN (V.PhysicalBytesMB - T.sizeInMB) ELSE 0 END)
FROM #tempVolSizeUpdateRsp T
	INNER JOIN MMVolume V WITH (READUNCOMMITTED) ON T.volId = V.VolumeId
	INNER JOIN MMMedia M WITH (READUNCOMMITTED) ON V.MediaId = M.MediaId
WHERE T.sizeInMB >= 0
BEGIN TRY
INSERT INTO #tempVol
SELECT T.volId, T.sizeInMB, T.refreshTime, T.RMSpareStatusUpdateTime
FROM MMVolume V WITH (XLOCK)
	INNER JOIN #tempVolSizeUpdateRsp T ON V.VolumeId = T.volId
--If the response says that volume is deleted and the attribute MMS2_VOLUME_PHYSICALLY_DELETED exists, then cleanup the volume
--since this indicates that it was a 2nd attempt on this volume.
-- Do not cleanup vols which are not volFlags = 6 indicating no chunks
DELETE VOL
FROM MMVolume VOL, #tempVol T
WHERE VOL.VolumeId = T.volId
AND T.sizeInMB = -4
AND (VOL.Attributes & 512) = 512
AND VOL.VolumeFlags = 6
-- update on Volume
UPDATE VOL
SET PhysicalBytesMB = (CASE WHEN T.sizeInMB >= 0 THEN T.sizeInMB WHEN T.sizeInMB = -4 THEN 0 ELSE VOL.PhysicalBytesMB END),
RMSpareStatusUpdateTime = (CASE WHEN T.sizeInMB = -1 AND VOL.RMSpareStatusUpdateTime <= 0 AND T.refreshTime > 0  THEN T.RMSpareStatusUpdateTime
WHEN ((T.sizeInMB = -1) AND (VOL.RMSpareStatusUpdateTime > 0)) THEN VOL.RMSpareStatusUpdateTime ELSE  T.RMSpareStatusUpdateTime END),
FailureErrorCode = (CASE WHEN T.sizeInMB = -4 THEN 0 ELSE VOL.FailureErrorCode END),
Attributes = (CASE WHEN T.sizeInMB = -4 AND VOL.VolumeFlags = 6 THEN VOL.Attributes | 512 ELSE VOL.Attributes END),
LastSizeUpdateTime = (CASE WHEN T.sizeInMB >= 0 THEN @now WHEN T.sizeInMB = -4 THEN @now ELSE VOL.LastSizeUpdateTime END)
FROM MMVolume VOL, #tempVol T
WHERE VOL.VolumeId = T.volId
SET @ErrVal = @@ERROR
IF @ErrVal != 0
	GOTO CX_EXIT
-- Update MMLibraryHistory for the datawritten and capacityFreed
INSERT INTO MMLibraryHistory (LibraryId, HistoryType, TimeStart,
                                 NumberOfSoftErrors, NumberOfHardErrors, NumberOfMediaUsed, NumberOfMediaFreed,
                                 DataWritten, DataRead, NumberOfBackups, NumberOfRestores, CapacityFreedMB,
                                 Modified, Version)
SELECT T.libId, 1, 0,
	 0, 0, 0, 0,
	 SUM(dataWritten), 0, 0, 0, SUM(dataFreed),
	 0, 0
FROM #tempVolSizeUpdateRsp T
GROUP BY T.libId
SET @ErrVal = @@ERROR
IF @ErrVal != 0
	GOTO CX_EXIT
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
SET @ErrVal = ERROR_NUMBER()
SET @ErrorSeverity = ERROR_SEVERITY()
SET @ErrorState = ERROR_STATE()
SET @ErrorMessage = 'Procedure [' + ERROR_PROCEDURE() + '] Error Number [' + CONVERT(NVARCHAR(15), @ErrVal) + '] Error Line [' + CONVERT(NVARCHAR(15), ERROR_LINE()) + ']. ' + ERROR_MESSAGE()
RAISERROR (@ErrorMessage, @ErrorSeverity, @ErrorState)
END CATCH
CX_EXIT:
SELECT	@ErrVal
if object_id('tempdb.dbo.#tempVolSizeUpdateRsp') is not null DROP TABLE #tempVolSizeUpdateRsp
if object_id('tempdb.dbo.#tempVol') is not null DROP TABLE #tempVol
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMProcessVolSizeUpdateRsp')
	delete from GxQscripts where name = 'MMProcessVolSizeUpdateRsp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMProcessVolSizeUpdateRsp')
	delete from GXDBVersions where aliasname = 'MMProcessVolSizeUpdateRsp'
GO

insert into GXDBVersions values(2, 'MMProcessVolSizeUpdateRsp',  '00010001000200060000', 'MMProcessVolSizeUpdateRsp', '00010001000200060000')
GO

