

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMProcessPruneRsp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: anarulkar
--	Date:   05/22/2014
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMProcessPruneRsp.sp,v $ $Id: MMProcessPruneRsp.sp,v 1.7.2.14 2019/12/31 06:03:05 anarulkar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMProcessPruneRsp')
BEGIN
	print '>>> Drop Stored Procedure: MMProcessPruneRsp <<<'
	drop procedure MMProcessPruneRsp
END
IF EXISTS (select * from GxQscripts where name='MMProcessPruneRsp')
	delete from GxQscripts where name = 'MMProcessPruneRsp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMProcessPruneRsp')
	delete from GXDBVersions where aliasname = 'MMProcessPruneRsp'
GO
print '... Creating Procedure: MMProcessPruneRsp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMProcessPruneRsp
  @i_isReconPrn integer,
  @i_rspXml xml
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @reconEnabledStore int = 0
DECLARE @SIDBStoreId int = 0
DECLARE @ErrVal INTEGER = 0
DECLARE @RowCount INTEGER = 0
DECLARE @ErrorMessage     NVARCHAR(MAX)
SET           @ErrorMessage   = ''
DECLARE @ErrorSeverity INTEGER
SET         @ErrorSeverity = 0
DECLARE @ErrorState INTEGER
SET           @ErrorState = 0
DECLARE @retryCount INTEGER
SET @retryCount = ISNULL((SELECT value FROM MMConfigs WHERE name = 'MMS2_CONFIG_DELETED_ARCHFILE_TRACKING_RETRYCOUNT'), 2)
if object_id('tempdb.dbo.#tempPruneRsp') is not null DROP TABLE #tempPruneRsp
CREATE TABLE #tempPruneRsp (archFileId int, chunkId bigint, volId int, MMError int, subStoreBitField int, sidbPruningFlag int, avcType int, mpId int, storeId int)
CREATE INDEX tempPruneRsp_Idx1 ON #tempPruneRsp (archFileId, chunkId, volId)
if object_id('tempdb.dbo.#tempMPInfo') is not null DROP TABLE #tempMPInfo
CREATE TABLE #tempMPInfo (mpId int, freeSpaceMB bigint, Err int)
if object_id('tempdb.dbo.#tempRemovableMedia') is not null DROP TABLE #tempRemovableMedia
CREATE TABLE #tempRemovableMedia (volId int)
if object_id('tempdb.dbo.#tempDelMMDAF') is not null DROP TABLE #tempDelMMDAF
CREATE TABLE #tempDelMMDAF (storeId int, mpId int, volId int, chunkId bigint, archFileId int)
CREATE CLUSTERED INDEX tempDelMMDAF_Idx1 ON #tempDelMMDAF (storeId, mpId, volId, chunkId, archFileId)
INSERT	INTO #tempPruneRsp
SELECT	T.c.value('@afId', 'int'), T.c.value('@chk', 'bigint'), T.c.value('@Vol', 'int'), T.c.value('@Err', 'int'), T.c.value('@bits', 'int'), T.c.value('@prnFlag', 'int'),  T.c.value('@avcType', 'int'),  T.c.value('@mpId', 'int'), T.c.value('@ddb', 'int')
FROM	@i_rspXml.nodes('/r/h') T(c)
INSERT INTO #tempMPInfo
SELECT T.c.value('@mpId', 'int'), T.c.value('@freeSpaceMB', 'bigint'), T.c.value('@Err', 'int')
FROM @i_rspXml.nodes('/r/m') T(c)
SET @SIDBStoreId = ISNULL((SELECT TOP 1 storeId FROM #tempPruneRsp WHERE storeId > 0) ,0)
--if we are not able to find storeId (not sent in pruning response) then fallback to old method.
IF @SIDBStoreId = 0
BEGIN
	SELECT @SIDBStoreId = V.SIDBStoreId
	FROM MMVolume V WITH (NOLOCK)
	WHERE V.VolumeId = (SELECT Top 1 volId FROM #tempPruneRsp WHERE volId > 0)
	IF @SIDBStoreId > 0
	BEGIN
		UPDATE #tempPruneRsp
		SET storeId = @SIDBStoreId
	END
END
-- We do not track anything against chunkMap trailers so cleanup those rows.
DELETE FROM #tempPruneRsp
WHERE avcType = 4  -- CHHUNK_TRAILER
IF ((SELECT Version FROM IdxSIDBStore WITH (NOLOCK) WHERE SIDBStoreId = @SIDBStoreId) < 2)
BEGIN
    SET @reconEnabledStore = 0
END
ELSE
BEGIN
SELECT @reconEnabledStore = (case when AGC.dedupeFlags & 33554432 > 0 then 1 else 0 end)
    FROM archGroupCopy AGC WITH (NOLOCK), archCopySIDBStore COPYSTORE WITH (NOLOCK)
    WHERE COPYSTORE.SIDBStoreId = @SIDBStoreId
    AND COPYSTORE.copyId = AGC.id
END
BEGIN TRY
IF (@i_isReconPrn = 0)
BEGIN
	INSERT INTO #tempDelMMDAF
	SELECT DAF.SIDBStoreId, DAF.mountPathId, DAF.VolumeId, DAF.archChunkId, DAF.archFileId
	FROM MMDeletedAF DAF WITH (XLOCK) INNER JOIN #tempPruneRsp T ON
		DAF.archFileId = T.archFileId
		AND DAF.VolumeId = T.volId
		AND DAF.ArchChunkId = T.chunkId AND (DAF.VolumeId > 0 OR (DAF.SIDBStoreId = T.storeId AND T.storeId > 0))
	WHERE T.MMError = 0
    -- If recon is enabled then move all the records to MMTempDeletedAF table.
    IF (@reconEnabledStore = 1) AND (1 = 0)
    BEGIN
        INSERT INTO MMTempDeletedAF(archFileId, VolumeId, Status, Retry, copyId, cclip, capacityFreedBytes, ArchChunkId, MountPathId, SIDBStoreId, CommCellId, DeletedTime, AdminJobId, PruneStatus, CreatedTime, subStoreBitField, sidbPruningFlag, appSizeFreedBytes, reserveInt, chunkCommCellId)
SELECT  distinct DAF.archFileId, DAF.VolumeId, DAF.Status, DAF.Retry, DAF.copyId, DAF.cclip, DAF.capacityfreedbytes, DAF.archChunkId, DAF.mountPathId, DAF.sidbStoreId, DAF.commCellId, DAF.deletedTime, 0, 0, dbo.getUnixTime(GETUTCDATE()), T.subStoreBitField, T.sidbPruningFlag, DAF.appSizeFreedBytes, 0, DAF.chunkCommCellId
        FROM MMDeletedAF DAF WITH (NOLOCK), #tempPruneRsp T
        WHERE DAF.archFileId = T.archFileId
        AND DAF.ArchChunkId = T.chunkId
        AND DAF.VolumeId = T.volId
        AND T.MMError = 0
		SET @ErrVal = @@ERROR
		IF @ErrVal != 0
			GOTO CX_EXIT
    END
	/* We do not need the below processing since we now move rows from new table to MMDAF.
		All processing is done from MMDAF only. 5/3/2018
    -- Cleanup records from MMDeletedArchFileTracking which has chunkId=0 and does not exists in MMDeletedAF and retryCount > 2
	IF EXISTS (SELECT 1 FROM MMDeletedArchFileTracking WITH (READUNCOMMITTED))
	BEGIN
		WHILE (1=1)
		BEGIN
			DELETE DAFT
			FROM MMDeletedArchFileTracking DAFT
				INNER JOIN #tempPruneRsp T ON DAFT.archFileId = T.archFileId AND DAFT.SIDBStoreId = T.storeId AND T.chunkId = 0
			WHERE T.MMError = 0
			AND DAFT.retryCount >= @retryCount
			SELECT @ErrVal = @@ERROR,  @RowCount = @@ROWCOUNT
			IF @ErrVal <> 0
		        BEGIN
	        	     GOTO CX_EXIT
		        END
			IF @RowCount = 0
	        	     BREAK
		END
		-- Update retry Count of other rows which do not exists in MMDAF and retry count
		UPDATE MMDeletedArchFileTracking
		SET retryCount = retryCount + 1,
		FailureErrorCode = 0,
		SubStoreBitField = T.subStoreBitField
		FROM MMDeletedArchFileTracking DAFT
			INNER JOIN #tempPruneRsp T ON DAFT.archFileId = T.archFileId AND DAFT.SIDBStoreId = T.storeId AND T.chunkId = 0
		WHERE T.MMError = 0
		SET @ErrVal = @@ERROR
		IF @ErrVal != 0
			GOTO CX_EXIT
	END
	*/
    -- cleanup records which have prune Response as success from MMDeletedAF (DELETE FROM MMDeletedAF)
	DELETE DAF
		FROM MMDeletedAF DAF INNER JOIN #tempDelMMDAF T ON
				T.storeId = DAF.SIDBStoreId
				AND T.mpId = DAF.MountPathId
				AND T.volId = DAF.VolumeId
				AND T.chunkId = DAF.ArchChunkId AND
				T.archFileId = DAF.archFileId
	SELECT @ErrVal = @@ERROR
	IF @ErrVal <> 0
    BEGIN
         GOTO CX_EXIT
    END
    -- handle rows with volId/chunkId = 0 and T.storeId = 0 . Delete those rows which exists only once, i.e. there are no duplicates. We can then delete them safely, else hold on to such rows.
    -- caveat is if there are multiple such rows (same AF for different copies) then auxcopy will not happen for the jobs corresponding to such AFs. This needs to be handled manually by updating volId of such rows in MMDAF table.
    -- DELETE FROM MMDeletedAF
	DELETE DAF
   	FROM MMDeletedAF DAF WITH (ROWLOCK),
		(SELECT D.archFileId, D.commCellId
	 	FROM MMDeletedAF D, #tempPruneRsp T
 	WHERE D.archFileId = T.archFileId AND D.VolumeId = T.volId AND D.ArchChunkId = T.chunkId AND D.ArchChunkId = 0 AND D.VolumeId = 0 AND T.MMError = 0
		 	AND T.storeId = 0
		 	GROUP BY D.archFileId, D.commCellId
		 	HAVING COUNT(*) = 1) TRsp
    		WHERE DAF.archFileId = TRsp.archFileId
	AND DAF.commCellId = TRsp.commCellId
	AND DAF.VolumeId = 0
	AND DAF.ArchChunkId = 0
	AND DAF.SIDBStoreId > 0
	SELECT @ErrVal = @@ERROR
	IF @ErrVal <> 0
    BEGIN
         GOTO CX_EXIT
    END
	/*
    -- Update errorCode for AF pruning
    UPDATE DAFT
    SET DAFT.FailureErrorCode = T.MMError,
    DAFT.subStoreBitField = T.subStoreBitField,
    DAFT.retryCount = 0
    FROM MMDeletedArchFileTracking DAFT
	INNER JOIN #tempPruneRsp T ON DAFT.archFileId = T.archFileId AND DAFT.SIDBStoreId = T.storeId
    WHERE T.chunkId = 0
    AND T.MMError <> 0
	*/
    -- update errorcode returned on Volume/mountpath
    UPDATE VOL
    SET FailureErrorCode = T.MMError
    FROM MMVolume VOL, #tempPruneRsp T
    WHERE VOL.VolumeId = T.volId
    AND T.avcType = 1 -- VOLUME_ID
AND T.MMError <> 993
	SET @ErrVal = @@ERROR
	IF @ErrVal != 0
		GOTO CX_EXIT
    -- update all those records for which the pruning was not success and we have some error code.
    -- Updating only those rows where storeId was sent in response (v11 MAs)
    UPDATE DAF
    SET DAF.FailureErrorCode = T.MMError,
    DAF.subStoreBitField = T.subStoreBitField,
    DAF.sidbPruningFlag = T.sidbPruningFlag
    FROM MMDeletedAF DAF, #tempPruneRsp T
    WHERE DAF.archFileId = T.archFileId
    AND DAF.ArchChunkId = T.chunkId
    AND DAF.VolumeId = T.volId
    AND (DAF.VolumeId > 0 OR (DAF.SIDBStoreId = T.storeId AND T.storeId > 0))
    AND T.MMError <> 0
	SET @ErrVal = @@ERROR
	IF @ErrVal != 0
		GOTO CX_EXIT
    -- Update rows where storeId was not sent in response (pre v11 MAs)
    UPDATE DAF
    SET DAF.FailureErrorCode = T.MMError,
    DAF.subStoreBitField = T.subStoreBitField,
    DAF.sidbPruningFlag = T.sidbPruningFlag
    FROM MMDeletedAF DAF, #tempPruneRsp T,
		(SELECT D.archFileId, D.commCellId
		 FROM MMDeletedAF D, #tempPruneRsp T
		 WHERE D.archFileId = T.archFileId AND D.VolumeId = T.volId AND D.ArchChunkId = T.chunkId AND D.ArchChunkId = 0 AND D.VolumeId = 0 AND T.MMError = 0
		 AND T.storeId = 0 AND T.MMError <> 0
		 GROUP BY D.archFileId, D.commCellId
		 HAVING COUNT(*) = 1) TRsp
    WHERE (DAF.VolumeId = 0 AND DAF.archFileId = TRsp.archFileId AND DAF.commCellId = TRsp.commCellId)
	AND T.archFileId = TRsp.archFileId
    AND DAF.SIDBStoreId > 0
	SET @ErrVal = @@ERROR
	IF @ErrVal != 0
		GOTO CX_EXIT
    -- Update Volumes which have been sent for Volume Pruning.
    UPDATE VOL
SET Attributes = Attributes | 4
    FROM MMVolume VOL, #tempPruneRsp T
    WHERE T.archFileId = 0
    AND T.chunkId = 0
    AND VOL.VolumeId = T.volId
    AND VOL.SIDBStoreId > 0
	AND T.MMError = 0
	SET @ErrVal = @@ERROR
	IF @ErrVal != 0
		GOTO CX_EXIT
    -- Update MediaSide for the freespace
    UPDATE MMS
    SET FreeBytesMB = T.freeSpaceMB
    FROM MMMediaSide MMS, MMMountPath MP WITH (NOLOCK), #tempMPInfo T
    WHERE MMS.MediaSideId = MP.MediaSideId
    AND MP.MountPathId = T.mpId
    AND T.freeSpaceMB > 0
	SET @ErrVal = @@ERROR
	IF @ErrVal != 0
		GOTO CX_EXIT
    IF EXISTS (SELECT 1 FROM MMConfigs WITH (READUNCOMMITTED) WHERE (name = 'MMS2_CONFIG_ENABLE_REMOVABLE_MEDIA_PRUNING') AND value > 0)
    BEGIN
		INSERT INTO #tempRemovableMedia
		SELECT distinct volId
		FROM #tempPruneRsp T, MMVolume V WITH (READUNCOMMITTED), MMMedia M WITH (READUNCOMMITTED)
		WHERE T.volId = V.VolumeId
		AND M.MediaId = V.MediaId
AND ((M.MediaTypeId > 11001) AND (M.MediaTypeId < 11999))
		AND V.VolumeFlags = 2 /*VOL_FULL*/
		AND T.chunkId > 0	-- We should have atleast 1 successfully pruned chunk
		AND T.MMError = 0
		IF EXISTS (SELECT 1 FROM #tempRemovableMedia)
		BEGIN
			-- Any pruning on removable media and if the media is full, then mark the media as appendable.
			UPDATE VOL
			SET VOL.VolumeFlags = 7 /*VOL_ACTIVE_APPEND*/
			FROM MMVolume VOL, #tempRemovableMedia T
			WHERE VOL.VolumeId = T.VolId
		END
    END
END
ELSE
BEGIN
    UPDATE TDAF
SET TDAF.pruneStatus = (CASE WHEN T.MMError = 0 THEN 2 WHEN T.MMError = 53032 THEN 4 ELSE 3 END),
    TDAF.subStoreBitField = T.subStoreBitField,
    TDAF.sidbPruningFlag = T.sidbPruningFlag
    FROM MMTempDeletedAF TDAF, #tempPruneRsp T
    WHERE TDAF.archFileId = T.archFileId
    AND TDAF.ArchChunkId = T.chunkId
    AND TDAF.VolumeId = T.volId
	SET @ErrVal = @@ERROR
	IF @ErrVal != 0
		GOTO CX_EXIT
END
--clean up archFileSubStore table which does not have entry in MMDAF after all processing.
DELETE AFSS
FROM archFileSubStore AFSS
		INNER JOIN #tempPruneRsp T ON AFSS.archFileId = T.archFileId AND AFSS.SIDBStoreId = @SIDBStoreId
		LEFT OUTER JOIN MMDeletedAF DAF WITH (NOLOCK) ON DAF.archFileId = T.archFileId AND DAF.SIDBStoreId = @SIDBStoreId
WHERE DAF.archFileId IS NULL
SELECT @ErrVal = @@ERROR
	IF @ErrVal <> 0
    BEGIN
         GOTO CX_EXIT
    END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
SET @ErrVal = ERROR_NUMBER()
SET @ErrorSeverity = ERROR_SEVERITY()
SET @ErrorState = ERROR_STATE()
SET @ErrorMessage = 'Procedure [' + ERROR_PROCEDURE() + '] Error Number [' + CONVERT(NVARCHAR(15), @ErrVal) + '] Error Line [' + CONVERT(NVARCHAR(15), ERROR_LINE()) + ']. ' + ERROR_MESSAGE()
RAISERROR (@ErrorMessage, @ErrorSeverity, @ErrorState)
END CATCH
CX_EXIT:
SELECT	@ErrVal
if object_id('tempdb.dbo.#tempPruneRsp') is not null DROP TABLE #tempPruneRsp
if object_id('tempdb.dbo.#tempMPInfo') is not null DROP TABLE #tempMPInfo
if object_id('tempdb.dbo.#tempRemovableMedia') is not null DROP TABLE #tempRemovableMedia
if object_id('tempdb.dbo.#tempDelMMDAF') is not null DROP TABLE #tempDelMMDAF
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMProcessPruneRsp')
	delete from GxQscripts where name = 'MMProcessPruneRsp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMProcessPruneRsp')
	delete from GXDBVersions where aliasname = 'MMProcessPruneRsp'
GO

insert into GXDBVersions values(2, 'MMProcessPruneRsp',  '00010007000200140000', 'MMProcessPruneRsp', '00010007000200140000')
GO

